/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscAccountDistributionPageListQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountDistributionBO;
import com.tydic.fsc.common.ability.bo.FscAccountDistributionPageListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountDistributionPageListQryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountDistributionMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountDistributionPO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountDistributionPageListQryAbilityService"})
public class FscAccountDistributionPageListQryAbilityServiceImpl
implements FscAccountDistributionPageListQryAbilityService {
    @Autowired
    private FscAccountDistributionMapper fscAccountDistributionMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @PostMapping(value={"qryAccountDistributionPageList"})
    public FscAccountDistributionPageListQryAbilityRspBO qryAccountDistributionPageList(@RequestBody FscAccountDistributionPageListQryAbilityReqBO reqBO) {
        if (reqBO.getAccountId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u8d26\u6237id[accountId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscAccountDistributionPO queryVo = new FscAccountDistributionPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryVo);
        FscAccountPO accountQueryVo = new FscAccountPO();
        accountQueryVo.setId(reqBO.getAccountId());
        FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(accountQueryVo);
        if (fscAccountPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u5173\u4fe1\u606f");
        }
        BigDecimal overdraftAmount = BigDecimal.ZERO;
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(this.operationOrgId);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE);
        fscMerchantPo.setPayBusiSceneRangeLike("1");
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (null != fscMerchantPo) {
            FscMerchantPO merchant = new FscMerchantPO();
            merchant.setPayBusiSceneRangeLike("1");
            merchant.setParentId(fscMerchantPo.getMerchantId());
            merchant.setDelFlag(FscConstants.DicDelFlag.NO);
            merchant.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE);
            merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            merchant.setPayObjId(fscAccountPo.getOrgId());
            merchant = this.fscMerchantMapper.getModelBy(merchant);
            if (null != merchant) {
                BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
            }
            overdraftAmount = fscMerchantPo.getOverdraft();
        }
        List distributionPoList = this.fscAccountDistributionMapper.selectPageList(queryVo, page);
        FscAccountDistributionPageListQryAbilityRspBO rspBO = new FscAccountDistributionPageListQryAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)distributionPoList)) {
            rspBO.setRows(null);
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<FscAccountDistributionBO> rows = new ArrayList<FscAccountDistributionBO>();
        for (FscAccountDistributionPO fscAccountDistributionPo : distributionPoList) {
            FscAccountDistributionBO distributionBo = new FscAccountDistributionBO();
            distributionBo.setAvailableAdvanceAmount(fscAccountPo.getAdvanceAmount().subtract(fscAccountPo.getFreezeAmount()).subtract(fscAccountPo.getUseAmount()).subtract(fscAccountPo.getDistributeAdvanceAmount()));
            distributionBo.setAvailableOverdraftAmount(overdraftAmount.subtract(fscAccountPo.getOverdraftAmount()));
            BeanUtils.copyProperties((Object)fscAccountDistributionPo, (Object)distributionBo);
            rows.add(distributionBo);
        }
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

