/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.FscPayProBillParaDataBo;
import com.tydic.fsc.bo.FscPayProParaDataBO;
import com.tydic.fsc.bo.FscPayProPayMethodDataBO;
import com.tydic.fsc.bo.FscPayProPaymentInsDataBO;
import com.tydic.fsc.common.ability.api.FscCashierQryPaymentInsDetailAbilityService;
import com.tydic.fsc.common.ability.bo.FscCashierQryPaymentInsDetailAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCashierQryPaymentInsDetailAbilityRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.payment.pay.atom.PCodeListAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayRuleParaAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.dao.PRelPaymentBillParaMapper;
import com.tydic.payment.pay.dao.po.PCodeListPO;
import com.tydic.payment.pay.dao.po.PRelPaymentBillParaPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PayRuleParaPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCashierQryPaymentInsDetailAbilityService"})
public class FscCashierQryPaymentInsDetailAbilityServiceImpl
implements FscCashierQryPaymentInsDetailAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCashierQryPaymentInsDetailAbilityServiceImpl.class);
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private PayRuleParaAtomService payRuleParaAtomService;
    @Autowired
    private PRelPaymentBillParaMapper relPaymentBillParaMapper;
    @Autowired
    private PCodeListAtomService pCodeListAtomService;

    @PostMapping(value={"queryPaymentDetail"})
    public FscCashierQryPaymentInsDetailAbilityRspBO queryPaymentDetail(@RequestBody FscCashierQryPaymentInsDetailAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("=========\u652f\u4ed8\u673a\u6784\u8be6\u60c5\u67e5\u8be2API\uff0c\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        FscCashierQryPaymentInsDetailAbilityRspBO retBo = (FscCashierQryPaymentInsDetailAbilityRspBO)FscRspUtil.getSuccessRspBo(FscCashierQryPaymentInsDetailAbilityRspBO.class);
        if (null == reqBO.getPaymentInsId()) {
            throw new FscBusinessException("191000", "\u652f\u4ed8\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscPayProPaymentInsDataBO baseInfo = new FscPayProPaymentInsDataBO();
        ArrayList<Long> paymentInsIds = new ArrayList<Long>();
        paymentInsIds.add(reqBO.getPaymentInsId());
        List insPos = this.paymentInsAtomService.queryPaymentInfByInss(paymentInsIds);
        if (CollectionUtils.isEmpty((Collection)insPos)) {
            throw new FscBusinessException("191118", "\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u673a\u6784[" + reqBO.getPaymentInsId() + "]\u7684\u4fe1\u606f");
        }
        PaymentInsPo insPo = (PaymentInsPo)insPos.get(0);
        BeanUtils.copyProperties((Object)insPo, (Object)baseInfo);
        retBo.setBaseInfo(baseInfo);
        ArrayList<FscPayProPayMethodDataBO> payMethods = new ArrayList<FscPayProPayMethodDataBO>();
        retBo.setPayMethods(payMethods);
        PayMethodPo methodPo = new PayMethodPo();
        methodPo.setPaymentInsId(reqBO.getPaymentInsId());
        List methodPos = this.payMethodAtomService.queryPayMethod(methodPo);
        if (!CollectionUtils.isEmpty((Collection)methodPos)) {
            for (PayMethodPo po : methodPos) {
                FscPayProPayMethodDataBO methodDataBO = new FscPayProPayMethodDataBO();
                BeanUtils.copyProperties((Object)po, (Object)methodDataBO);
                payMethods.add(methodDataBO);
            }
        }
        ArrayList<FscPayProParaDataBO> payParas = new ArrayList<FscPayProParaDataBO>();
        retBo.setPayParas(payParas);
        PayRuleParaPo ruleParaPo = new PayRuleParaPo();
        ruleParaPo.setPaymentInsId(reqBO.getPaymentInsId());
        List ruleParaPos = this.payRuleParaAtomService.queryPayRuleParaByCondition(ruleParaPo);
        if (!CollectionUtils.isEmpty((Collection)ruleParaPos)) {
            Map<String, Map<String, String>> dicMap = this.getDicMap();
            for (PayRuleParaPo paraPo : ruleParaPos) {
                FscPayProParaDataBO paraDataBO = new FscPayProParaDataBO();
                BeanUtils.copyProperties((Object)paraPo, (Object)paraDataBO);
                paraDataBO.setStoreTypeDesc(dicMap.get("PAY_PARA_STORE_TYPE").get(paraDataBO.getStoreType()));
                if (null != paraDataBO.getNoNeedInput()) {
                    paraDataBO.setNoNeedInputDesc(dicMap.get("NO_NEED_INPUT_FLAG").get(paraDataBO.getNoNeedInput().toString()));
                }
                payParas.add(paraDataBO);
            }
        }
        ArrayList<FscPayProBillParaDataBo> billParas = new ArrayList<FscPayProBillParaDataBo>();
        retBo.setBillParas(billParas);
        PRelPaymentBillParaPo billParaPo = new PRelPaymentBillParaPo();
        billParaPo.setPaymentInsId(reqBO.getPaymentInsId());
        List billParaPos = this.relPaymentBillParaMapper.selectListByCondition(billParaPo);
        if (!CollectionUtils.isEmpty((Collection)billParaPos)) {
            for (PRelPaymentBillParaPo paraPo : billParaPos) {
                FscPayProBillParaDataBo billParaDataBo = new FscPayProBillParaDataBo();
                BeanUtils.copyProperties((Object)paraPo, (Object)billParaDataBo);
                billParas.add(billParaDataBo);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("=========\u652f\u4ed8\u673a\u6784\u8be6\u60c5\u67e5\u8be2API\uff0c\u7ed3\u675f\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(1);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("PAY_PARA_STORE_TYPE");
        codes.add("NO_NEED_INPUT_FLAG");
        PCodeListPO dicPo = new PCodeListPO();
        for (String code : codes) {
            dicPo.setTypeCode(code);
            List codePos = this.pCodeListAtomService.queryPCodeListByCondition(dicPo);
            if (CollectionUtils.isEmpty((Collection)codePos)) continue;
            Map<String, String> codeMap = codePos.stream().collect(Collectors.toMap(PCodeListPO::getCodeValue, PCodeListPO::getCodeName));
            dicMap.put(code, codeMap);
        }
        return dicMap;
    }
}

