/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAccountChargeApprovalBusiServiceImpl
implements FscAccountChargeApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountChargeApprovalBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;

    @Override
    public FscAccountChargeApprovalBusiRspBO dealAccountChargeApproval(FscAccountChargeApprovalBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getChargeId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u5145\u503c\u5355id[chargeId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAuditResult())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u5ba1\u6279\u7ed3\u679c[auditResult]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAuditRemark())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u5ba1\u6279\u610f\u89c1[auditRemark]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountChargePO fscAccountChargePo = this.fscAccountChargeMapper.queryById(reqBO.getChargeId());
        if (fscAccountChargePo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5145\u503c\u4fe1\u606f\uff01");
        }
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getChargeId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.ACCOUNT_CHARGE_APPROVAL;
        String stepId = this.fscAccountChargeMapper.selectStepId(reqBO.getChargeId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        auditReqBO.setStepId(stepId);
        auditReqBO.setVariables(paramMap);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditRemark())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditRemark());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        UacNoneInstanceBO noneInstanceBO = auditRspBO.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        FscAccountChargePO updateVo = new FscAccountChargePO();
        updateVo.setChargeId(reqBO.getChargeId());
        updateVo.setAuditRemark(reqBO.getAuditRemark());
        updateVo.setAuditTime(new Date());
        updateVo.setAuditUserId(reqBO.getUserId());
        updateVo.setAuditUserName(reqBO.getName());
        if (finish.booleanValue() && auditResult.equals(FscConstants.AuditResultFlagKey.PASS.toString())) {
            updateVo.setAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
        } else if (finish.booleanValue() && auditResult.equals(FscConstants.AuditResultFlagKey.REFUSE.toString())) {
            updateVo.setAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
        }
        FscTaskCandidatePO fscTaskCandidateQueryVo = new FscTaskCandidatePO();
        fscTaskCandidateQueryVo.setFscOrderId(fscAccountChargePo.getChargeId());
        List auditedList = this.fscTaskCandidateMapper.getAuditedPostIdAndOperIdList(fscTaskCandidateQueryVo);
        List auditedIdList = auditedList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
        String auditedIds = String.join((CharSequence)",", auditedIdList);
        updateVo.setAuditOperId(auditedIds);
        this.fscAccountChargeMapper.update(updateVo);
        if (!finish.booleanValue()) {
            FscTaskCandidatePO fscTaskCandidatePO = new FscTaskCandidatePO();
            fscTaskCandidatePO.setFscOrderId(fscAccountChargePo.getChargeId());
            List auditedPostIdAndOperIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(fscTaskCandidatePO);
            if (!CollectionUtils.isEmpty((Collection)auditedPostIdAndOperIdList)) {
                StringBuilder auditedPostIds = new StringBuilder();
                for (FscApprovalTaskQueryBO fscApprovalTaskQueryBO : auditedPostIdAndOperIdList) {
                    auditedPostIds.append(fscApprovalTaskQueryBO.getTaskOperId() + ",");
                }
                fscAccountChargePo.setTaskOperId(auditedPostIds.toString());
                this.fscAccountChargeMapper.updateTaskOperById(fscAccountChargePo);
            }
        } else {
            this.fscAccountChargeMapper.updateTaskOperById(fscAccountChargePo);
        }
        FscAccountChargeApprovalBusiRspBO rspBO = new FscAccountChargeApprovalBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

