/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscClaimSendYcCancelReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscClaimSendYcCancelRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscClaimSendYcCancelService;
import com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRecvClaimConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscRecvClaimConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimConfirmBusiRspBO;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService"})
public class FscRecvClaimConfirmAbilityServiceImpl
implements FscRecvClaimConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimConfirmAbilityServiceImpl.class);
    @Autowired
    private FscRecvClaimConfirmBusiService fscRecvClaimConfirmBusiService;
    @Autowired
    private FscClaimSendYcCancelService fscClaimSendYcCancelService;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;

    @FscDuplicateCommitLimit
    @PostMapping(value={"recvClaimConfirm"})
    public FscRecvClaimConfirmAbilityRspBO recvClaimConfirm(@RequestBody FscRecvClaimConfirmAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        List cancelList = reqBO.getClaimDetailList().stream().filter(item -> !StringUtils.isEmpty((Object)item.getStatus()) && item.getStatus().equals("0")).collect(Collectors.toList());
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (cancelList.size() > 0 && fscRecvClaimPo.getStatus() != null && fscRecvClaimPo.getStatus().equals(1)) {
            FscClaimSendYcCancelReqBO cancelReqBO = new FscClaimSendYcCancelReqBO();
            cancelReqBO.setTESCO_ID(reqBO.getClaimId());
            cancelReqBO.setUserId(reqBO.getUserId());
            FscClaimSendYcCancelRspBO cancelRspBO = this.fscClaimSendYcCancelService.cancelClaim(cancelReqBO);
            if (!cancelRspBO.equals((Object)"0000")) {
                throw new FscBusinessException(cancelRspBO.getRespCode(), cancelRspBO.getRespDesc());
            }
        }
        FscRecvClaimConfirmBusiReqBO busiReqBO = (FscRecvClaimConfirmBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscRecvClaimConfirmBusiReqBO.class));
        FscRecvClaimConfirmBusiRspBO busiRspBO = this.fscRecvClaimConfirmBusiService.recvClaimConfirm(busiReqBO);
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        return (FscRecvClaimConfirmAbilityRspBO)JSONObject.parseObject((String)respString, FscRecvClaimConfirmAbilityRspBO.class);
    }

    private void valid(FscRecvClaimConfirmAbilityReqBO reqBO) {
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[claimId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRecvAmt() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u6536\u6b3e\u91d1\u989d[recvAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getNoClaimAmt() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u672a\u8ba4\u9886\u91d1\u989d[noClaimAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getClaimDetailList())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u8ba4\u9886\u4fe1\u606f[claimDetailList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getNoClaimAmt().compareTo(reqBO.getRecvAmt()) > 0) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u672a\u8ba4\u9886\u91d1\u989d[noClaimAmt]\u4e0d\u80fd\u5927\u4e8e\u6536\u6b3e\u91d1\u989d[recvAmt]\uff01");
        }
        if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) < 0) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u672a\u8ba4\u9886\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u96f6\uff01");
        }
    }
}

