/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscOrderInvoiceItemAddAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceItemAddAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceItemAddAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscOrderInvoiceItemAddBusiService;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceItemAddBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceItemAddBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderInvoiceItemAddAbilityService"})
public class FscOrderInvoiceItemAddAbilityServiceImpl
implements FscOrderInvoiceItemAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderInvoiceItemAddAbilityServiceImpl.class);
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscOrderInvoiceItemAddBusiService fscOrderInvoiceItemAddBusiService;

    @PostMapping(value={"addOrderInvoiceItem"})
    public FscOrderInvoiceItemAddAbilityRspBO addOrderInvoiceItem(@RequestBody FscOrderInvoiceItemAddAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPo = this.fscOrderMapper.getModelBy(orderPO);
        if (fscOrderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (!fscOrderPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.ROLL_BACK)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        reqBO.setMakeType(fscOrderPo.getMakeType());
        reqBO.setReceiveType(fscOrderPo.getReceiveType());
        ArrayList<Long> inspectionVoucherIdList = new ArrayList<Long>();
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            if (null == splitOrderBO.getAmount()) {
                throw new FscBusinessException("191014", "\u62c6\u5206\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
            }
            if (BigDecimal.ZERO.compareTo(splitOrderBO.getAmount()) >= 0) {
                throw new FscBusinessException("191014", "\u62c6\u5206\u8ba2\u5355\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            splitOrderBO.getRelOrderList().forEach(relOrderBO -> {
                if (null == relOrderBO.getAcceptOrderId()) {
                    throw new FscBusinessException("191014", "\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
                }
                inspectionVoucherIdList.add(relOrderBO.getAcceptOrderId());
            });
        }
        this.checkOrderBillStatus(fscOrderPo.getMakeType(), fscOrderPo.getReceiveType(), inspectionVoucherIdList);
        ArrayList<FscShouldPayPO> fscShouldPayPOS = new ArrayList();
        if (fscOrderPo.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE)) {
            fscShouldPayPOS = this.checkPrePayBill(inspectionVoucherIdList);
        }
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(inspectionVoucherIdList);
        fscAcceptOrderListQueryAtomReqBO.setReceiveType(fscOrderPo.getReceiveType());
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPo.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPo.getMakeType())) {
            fscAcceptOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        }
        fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPo.getReceiveType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPo.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPo.getMakeType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
        }
        fscAcceptOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
        if (null == fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
            throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.checkOrderParam(fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap(), reqBO);
        if ("2".equals(fscOrderPo.getOrderSource().toString())) {
            this.checkResult(fscOrderPo, inspectionVoucherIdList);
        }
        FscOrderInvoiceItemAddBusiReqBO busiReqBO = (FscOrderInvoiceItemAddBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderInvoiceItemAddBusiReqBO.class));
        busiReqBO.setFscShouldPayPOS(fscShouldPayPOS);
        busiReqBO.setFscOrderInfoBoMap(fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap());
        FscOrderInvoiceItemAddBusiRspBO busiRspBO = this.fscOrderInvoiceItemAddBusiService.addOrderInvoiceItem(busiReqBO);
        return (FscOrderInvoiceItemAddAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscOrderInvoiceItemAddAbilityRspBO.class);
    }

    private void valid(FscOrderInvoiceItemAddAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkOrderBillStatus(Integer makeType, Integer receiveType, List<Long> inspectionVoucherIdList) {
        List fscOrderIds;
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setAcceptOrderIds(inspectionVoucherIdList);
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS) && !CollectionUtils.isEmpty(fscOrderIds = fscOrderRelationPOS.stream().map(FscOrderRelationPO::getFscOrderId).collect(Collectors.toList()))) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(fscOrderIds);
            fscOrderPO.setRemoveState(FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
            fscOrderPO.setRejectState(FscBillStatus.MAIN_ORDER_ECOM_REJECT.getCode());
            fscOrderPO.setDelState(FscBillStatus.MAIN_ORDER_DEL.getCode());
            List fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
                fscOrderPOS.forEach(fscOrder -> {
                    if (receiveType.equals(fscOrder.getReceiveType()) && makeType.equals(fscOrder.getMakeType())) {
                        throw new FscBusinessException("191014", "\u5b58\u5728\u8ba2\u5355\u5df2\u53d1\u8d77\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77\u8ba2\u5355\u7ed3\u7b97");
                    }
                });
            }
        }
    }

    public List<FscShouldPayPO> checkPrePayBill(List<Long> inspectionIdList) {
        ArrayList<FscShouldPayPO> updateList = new ArrayList<FscShouldPayPO>();
        if (!CollectionUtils.isEmpty(inspectionIdList)) {
            FscShouldPayPO queryVo = new FscShouldPayPO();
            queryVo.setInspectionIdList(inspectionIdList);
            ArrayList<Integer> shouldPayTypes = new ArrayList<Integer>(2);
            shouldPayTypes.add(FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY);
            shouldPayTypes.add(FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY);
            shouldPayTypes.add(FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY);
            queryVo.setPayeeId(this.operationOrgId);
            queryVo.setShouldPayTypes(shouldPayTypes);
            List list = this.fscShouldPayMapper.getList(queryVo);
            for (FscShouldPayPO fscShouldPayPO : list) {
                if (fscShouldPayPO.getPayingAmount().compareTo(BigDecimal.ZERO) > 0) {
                    throw new FscBusinessException("190000", "\u9884\u4ed8\u6b3e\u5355\u636e[" + fscShouldPayPO.getShouldPayNo() + "]\u6b63\u5728\u4ed8\u6b3e\u4e2d,\u4e0d\u80fd\u53d1\u8d77\u5bf9\u8d26\u7533\u8bf7\uff01");
                }
                if (fscShouldPayPO.getPayingAmount().compareTo(BigDecimal.ZERO) != 0 || !fscShouldPayPO.getShouldPayStatus().equals(FscConstants.ShouldPayStatus.TO_PAY)) continue;
                fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_FREEZE);
                updateList.add(fscShouldPayPO);
            }
        }
        return updateList;
    }

    private void checkOrderParam(Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, FscOrderInvoiceItemAddAbilityReqBO reqBO) {
        FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.get(((RelOrderBO)((SplitOrderBO)reqBO.getSplitOrderList().get(0)).getRelOrderList().get(0)).getAcceptOrderId());
        if (null == fscOrderInfoBO) {
            throw new FscBusinessException("191014", "\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + ((RelOrderBO)((SplitOrderBO)reqBO.getSplitOrderList().get(0)).getRelOrderList().get(0)).getAcceptOrderId() + "]\u4fe1\u606f\u4e3a\u7a7a");
        }
        BigDecimal[] totalCharge = new BigDecimal[]{BigDecimal.ZERO};
        fscOrderInfoBoMap.forEach((acceptOrderId, fscOrderInfo) -> {
            if (BigDecimal.ZERO.compareTo(fscOrderInfo.getInspTotalMoney()) >= 0) {
                throw new FscBusinessException("191014", "\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + fscOrderInfo.getAcceptOrderNo() + "]\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u7ed3\u7b97");
            }
            totalCharge[0] = totalCharge[0].add(fscOrderInfo.getInspTotalMoney());
            if (!fscOrderInfoBO.getPayType().equals(fscOrderInfo.getPayType())) {
                throw new FscBusinessException("191014", "\u8ba2\u5355\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
            }
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderInfo.getPayType())) {
                if (null == fscOrderInfoBO.getPayRule() || null == fscOrderInfo.getPayType()) {
                    throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u8fd4\u56de\u4e3a\u7a7a");
                }
                if (!fscOrderInfoBO.getPayRule().equals(fscOrderInfo.getPayRule())) {
                    throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                }
                if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
                    if (null == fscOrderInfoBO.getPayNodeRule() || null == fscOrderInfo.getPayNodeRule()) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u4e3a\u7a7a");
                    }
                    if (!fscOrderInfoBO.getPayNodeRule().equals(fscOrderInfo.getPayNodeRule())) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                    if (null == fscOrderInfoBO.getPayNodeAccountDays() || null == fscOrderInfo.getPayNodeAccountDays()) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
                    }
                    if (!fscOrderInfoBO.getPayNodeAccountDays().equals(fscOrderInfo.getPayNodeAccountDays())) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                } else if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
                    if (null == fscOrderInfoBO.getPayAccountDayRule() || null == fscOrderInfo.getPayAccountDayRule()) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\u4e3a\u7a7a");
                    }
                    if (!fscOrderInfoBO.getPayAccountDayRule().equals(fscOrderInfo.getPayAccountDayRule())) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                    if (null == fscOrderInfoBO.getPayAccountDay() || null == fscOrderInfo.getPayAccountDay()) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
                    }
                    if (!fscOrderInfoBO.getPayAccountDay().equals(fscOrderInfo.getPayAccountDay())) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                } else {
                    String orderNo = fscOrderInfo.getPurchaseOrderNo();
                    if (FscConstants.FscBusiModel.MATCHING.equals(fscOrderInfo.getTradeMode())) {
                        orderNo = fscOrderInfo.getSaleOrderNo();
                    }
                    throw new FscBusinessException("191014", "\u8ba2\u5355\u3010" + orderNo + "\u3011\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u3010" + fscOrderInfoBO.getPayRule() + "\u3011\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968");
                }
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                if (!fscOrderInfoBO.getCompanyId().equals(fscOrderInfo.getCompanyId())) {
                    throw new FscBusinessException("191014", "\u6536\u7968\u65b9\u4e3a\u91c7\u8d2d\u5355\u4f4d\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u91c7\u8d2d\u5355\u4f4d\u7684\u8ba2\u5355");
                }
                if (null != fscOrderInfoBO.getAccountSetId() && !fscOrderInfoBO.getAccountSetId().equals(fscOrderInfo.getAccountSetId())) {
                    throw new FscBusinessException("191014", "\u6536\u7968\u65b9\u4e3a\u91c7\u8d2d\u5355\u4f4d\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u8d26\u5957\u7684\u8ba2\u5355");
                }
            }
        });
        reqBO.getSplitOrderList().forEach(splitOrderBO -> {
            BigDecimal[] amount = new BigDecimal[]{BigDecimal.ZERO};
            splitOrderBO.getRelOrderList().forEach(relOrderBO -> {
                amount[0] = FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType()) ? amount[0].add(((FscOrderInfoBO)fscOrderInfoBoMap.get(relOrderBO.getAcceptOrderId())).getInspTotalPurchaseMoney()) : amount[0].add(((FscOrderInfoBO)fscOrderInfoBoMap.get(relOrderBO.getAcceptOrderId())).getInspTotalMoney());
            });
            if (amount[0].setScale(2, 4).compareTo(splitOrderBO.getAmount().setScale(2, 4)) != 0) {
                throw new FscBusinessException("191014", "\u63d0\u4ea4\u8ba2\u5355\u91d1\u989d\u4e0e\u540e\u7aef\u4e0d\u4e00\u81f4");
            }
        });
    }

    private void checkResult(FscOrderPO fscOrderPO, List<Long> inspectionVoucherIdList) {
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) || FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
            FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
            fscCheckResultPO.setAcceptOrderIds(inspectionVoucherIdList);
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType())) {
                fscCheckResultPO.setStatus(FscConstants.BillCheck.EQUALS);
            }
            if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                fscCheckResultPO.setStatus(FscConstants.BillCheck.EQUALS);
            }
            Integer checkCount = this.fscCheckResultMapper.getCheckBy(fscCheckResultPO);
            log.info("\u5bf9\u8d26\u4e00\u81f4\u6570\u91cf:{}", (Object)checkCount);
            if (!checkCount.equals(inspectionVoucherIdList.size())) {
                throw new FscBusinessException("191014", "\u5bf9\u8d26\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5f00\u7968");
            }
        }
    }
}

