/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.common.ability.api.FscAccountChargeAbilityService;
import com.tydic.fsc.common.ability.api.FscAccountChargeClaimAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeBatchAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscUseAccountBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeProBusiService;
import com.tydic.fsc.common.busi.api.FscAccountChargePurBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountChargeAbilityService"})
public class FscAccountChargeAbilityServiceImpl
implements FscAccountChargeAbilityService {
    @Autowired
    private FscAccountChargePurBusiService fscAccountChargePurBusiService;
    @Autowired
    private FscAccountChargeProBusiService fscAccountChargeProBusiService;
    @Autowired
    private FscAccountChargeClaimAbilityService fscAccountChargeClaimAbilityService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealAccountCharge"})
    public FscAccountChargeAbilityRspBO dealAccountCharge(@RequestBody FscAccountChargeAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getChargeAmount())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u91d1\u989d[chargeAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountChargeBusiReqBO busiReqBO = new FscAccountChargeBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscAccountChargeBusiRspBO busiRspBO = null;
        busiRspBO = reqBO.getWebSource() == null || reqBO.getWebSource() == 2 ? this.fscAccountChargePurBusiService.dealAccountCharge(busiReqBO) : this.fscAccountChargeProBusiService.dealAccountCharge(busiReqBO);
        if (busiRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty(busiRspBO.getPushDetailBOList())) {
            this.dealPushYc(busiRspBO);
        }
        FscAccountChargeAbilityRspBO rspBO = new FscAccountChargeAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void dealPushYc(FscAccountChargeBusiRspBO busiRspBO) {
        FscPushYcRecvClaimBillAbilityReqBO abilityReqBO = new FscPushYcRecvClaimBillAbilityReqBO();
        abilityReqBO.setClaimId(busiRspBO.getClaimId());
        abilityReqBO.setClaimList(busiRspBO.getPushDetailBOList());
        FscPushYcRecvClaimBillAbilityRspBO abilityRspBO = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
    }

    @PostMapping(value={"dealAccountChargeBatch"})
    public FscAccountChargeAbilityRspBO dealAccountChargeBatch(@RequestBody FscAccountChargeBatchAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getChargeAmount())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u91d1\u989d[chargeAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4f7f\u7528\u5355\u4f4d\u96c6\u5408[useAccountBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BigDecimal totalAmount = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!reqBO.getChargeAmount().equals(totalAmount)) {
            throw new FscBusinessException("198888", "\u591a\u4e2a\u5355\u4f4d/\u90e8\u95e8\u8d26\u6237\u5206\u914d\u7684\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u5145\u503c\u91d1\u989d\uff01");
        }
        List uniqueAccountList = reqBO.getUseAccountBOList().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FscUseAccountBO>(Comparator.comparing(FscUseAccountBO::getUseDeptId))), ArrayList::new));
        if (uniqueAccountList.size() != reqBO.getUseAccountBOList().size()) {
            throw new FscBusinessException("198888", "\u5206\u914d\u8d26\u6237\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        FscAccountChargeBatchBusiReqBO busiReqBO = new FscAccountChargeBatchBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscAccountChargeBatchBusiRspBO fscAccountChargeBatchBusiRspBO = this.fscAccountChargePurBusiService.dealAccountChargeBatch(busiReqBO);
        FscAccountChargeAbilityRspBO rspBO = new FscAccountChargeAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)fscAccountChargeBatchBusiRspBO), (Object)rspBO);
        return rspBO;
    }
}

