/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountChargePageListQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountChargeBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargePageListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargePageListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscUseAccountRspBO;
import com.tydic.fsc.common.atom.api.FscGetStateListOfConfTabAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.ConfTabStatePO;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.umc.general.ability.api.UmcEntityAccountOrgQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcPurChargeEntityIdQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcPurChargeEntityIdQueryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountChargePageListQryAbilityService"})
public class FscAccountChargePageListQryAbilityServiceImpl
implements FscAccountChargePageListQryAbilityService {
    @Autowired
    FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscGetStateListOfConfTabAtomService fscGetStateListOfConfTabAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private UmcEntityAccountOrgQryAbilityService umcEntityAccountOrgQryAbilityService;

    @PostMapping(value={"qryAccountChargePageList"})
    public FscAccountChargePageListQryAbilityRspBO qryAccountChargePageList(@RequestBody FscAccountChargePageListQryAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscAccountChargePO queryVo = new FscAccountChargePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryVo);
        List<String> tabIdList = reqBO.getTabIdList().stream().map(String::valueOf).collect(Collectors.toList());
        Map<String, ConfTabStatePO> stateMap = this.fscGetStateListOfConfTabAtomService.getStateList(tabIdList);
        ConfTabStatePO confTabStatePo = stateMap.get(reqBO.getTabId().toString());
        if (confTabStatePo == null) {
            throw new FscBusinessException("198888", "\u9875\u7b7e\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a\uff01\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e\uff01");
        }
        List<String> statusList = new ArrayList<String>();
        if (confTabStatePo.getStatusCode().contains(",")) {
            statusList = Arrays.asList(confTabStatePo.getStatusCode().split(","));
        } else {
            statusList.add(confTabStatePo.getStatusCode());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getWebSource()) && reqBO.getWebSource() == 2) {
            queryVo.setAuditStatus(Integer.valueOf(2));
            queryVo.setChargeStatusList(statusList);
        } else {
            queryVo.setAuditStatusList(statusList);
        }
        if (reqBO.getTabId().equals(3002)) {
            queryVo.setAuditOperIdList(reqBO.getTaskOperIdList());
            queryVo.setTaskOperIdList(null);
        }
        if (!(StringUtils.isEmpty((Object)reqBO.getWebSource()) || reqBO.getWebSource() != 1 && reqBO.getWebSource() != 3)) {
            UmcPurChargeEntityIdQueryAbilityReqBO abilityReqBO = new UmcPurChargeEntityIdQueryAbilityReqBO();
            abilityReqBO.setPurId(reqBO.getOrgId());
            UmcPurChargeEntityIdQueryAbilityRspBO abilityRspBO = this.umcEntityAccountOrgQryAbilityService.qryPurChargeEntityList(abilityReqBO);
            if (abilityRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Collection)abilityRspBO.getPurIdList())) {
                queryVo.setQueryDeptIdList(abilityRspBO.getPurIdList());
            } else {
                queryVo.setQueryDeptId(reqBO.getOrgId());
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getWebSource()) && reqBO.getWebSource() == 4) {
            queryVo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_PASS);
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        queryVo.setUserId(null);
        queryVo.setUserName(reqBO.getCreateUserName());
        List fscAccountChargePoList = this.fscAccountChargeMapper.selectWithDetailPageList(queryVo, page);
        FscAccountChargePageListQryAbilityRspBO rspBO = new FscAccountChargePageListQryAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)fscAccountChargePoList)) {
            rspBO.setTotalAvailableAmt(BigDecimal.ZERO);
            rspBO.setRows(null);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<FscAccountChargeBO> rows = new ArrayList<FscAccountChargeBO>(fscAccountChargePoList.size());
        Map busTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
        Map auditStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_AUDIT_STATUS");
        Map chargeStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CHARGE_STATUS");
        for (FscAccountChargePO fscAccountChargePo : fscAccountChargePoList) {
            FscAccountChargeBO chargeBo = new FscAccountChargeBO();
            BeanUtils.copyProperties((Object)fscAccountChargePo, (Object)chargeBo);
            if (chargeBo.getBusiType() != null) {
                chargeBo.setBusiTypeStr((String)busTypeMap.get(chargeBo.getBusiType().toString()));
            }
            if (chargeBo.getAuditStatus() != null) {
                chargeBo.setAuditStatusStr((String)auditStatusMap.get(chargeBo.getAuditStatus().toString()));
            }
            if (chargeBo.getChargeStatus() != null) {
                chargeBo.setChargeStatusStr((String)chargeStatusMap.get(chargeBo.getChargeStatus().toString()));
            }
            fscAccountChargePo.setAccountId(reqBO.getAccountId());
            List detailPOList = this.fscAccountChargeDetailMapper.queryDetail(fscAccountChargePo);
            if (!CollectionUtils.isEmpty((Collection)detailPOList)) {
                String useDeptName = detailPOList.stream().map(FscAccountChargeDetailPO::getUseDeptName).collect(Collectors.joining(","));
                chargeBo.setUseDeptName(useDeptName);
                ArrayList accountBOList = new ArrayList();
                detailPOList.forEach(e -> {
                    FscUseAccountRspBO fscUseAccountRspBO = new FscUseAccountRspBO();
                    BeanUtils.copyProperties((Object)e, (Object)fscUseAccountRspBO);
                    accountBOList.add(fscUseAccountRspBO);
                });
                chargeBo.setUseAccountBOList(accountBOList);
                if (Objects.nonNull(reqBO.getAccountId())) {
                    chargeBo.setCurrOrgChargeAmount(((FscAccountChargeDetailPO)detailPOList.get(0)).getChargeAmount());
                }
            } else {
                chargeBo.setCurrOrgChargeAmount(fscAccountChargePo.getChargeAmount());
            }
            rows.add(chargeBo);
        }
        if (reqBO.getWebSource() != null && reqBO.getWebSource() == 4) {
            FscAccountPO querVo = new FscAccountPO();
            querVo.setId(reqBO.getAccountId());
            FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(querVo);
            if (fscAccountPo == null) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
            }
            rspBO.setTotalAvailableAmt(fscAccountPo.getAdvanceAmount().subtract(fscAccountPo.getFreezeAmount()).subtract(fscAccountPo.getUseAmount()));
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscAccountChargePageListQryAbilityReqBO reqBO) {
        if (reqBO.getTabId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u9875\u7b7eid[tabId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getTabIdList())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u9875\u7b7e\u96c6\u5408[tabIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getWebSource() != null && reqBO.getWebSource() == 4 && reqBO.getAccountId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u8d26\u6237id[accountId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

