/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscAccountCreateAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountCreateAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountCreateAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscAccountCreateBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountCreateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountCreateBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountCreateAbilityService"})
public class FscAccountCreateAbilityServiceImpl
implements FscAccountCreateAbilityService {
    @Autowired
    private FscAccountCreateBusiService fscAccountCreateBusiService;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @PostMapping(value={"dealCreate"})
    public FscAccountCreateAbilityRspBO dealCreate(@RequestBody FscAccountCreateAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getAccountCategory()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[AccountCategory]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAccountName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[AccountName]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMechanismOrgId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[OrgId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getMechanismOrgName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[OrgName]\u4e3a\u7a7a");
        }
        if (null == reqBO.getBusiType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[busiType]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBankAccount())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[bankAccount]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBankName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[bankName]\u4e3a\u7a7a");
        }
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setOrgId(reqBO.getMechanismOrgId());
        fscAccountPO.setBusiType(reqBO.getBusiType());
        fscAccountPO.setStatus(FscConstants.AccountStatus.VALID);
        List fscAccountPOList = this.fscAccountMapper.getList(fscAccountPO);
        if (!CollectionUtils.isEmpty((Collection)fscAccountPOList)) {
            throw new FscBusinessException("191101", "\u5df2\u5b58\u5728\u76f8\u540c\u4e1a\u52a1\u7c7b\u578b\u7684\u8d26\u6237");
        }
        String jsonString = JSON.toJSONString((Object)reqBO);
        FscAccountCreateBusiReqBO fscAccountCreateBusiReqBO = (FscAccountCreateBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscAccountCreateBusiReqBO.class));
        fscAccountCreateBusiReqBO.setCreateMethod(FscConstants.AccountOpenMethod.MANUALLY);
        FscAccountCreateBusiRspBO fscAccountCreateBusiRspBO = this.fscAccountCreateBusiService.dealCreate(fscAccountCreateBusiReqBO);
        if (!"0000".equals(fscAccountCreateBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191101", fscAccountCreateBusiRspBO.getRespDesc());
        }
        FscAccountCreateAbilityRspBO fscAccountCreateAbilityRspBO = new FscAccountCreateAbilityRspBO();
        fscAccountCreateAbilityRspBO.setId(fscAccountCreateBusiRspBO.getId());
        return fscAccountCreateAbilityRspBO;
    }
}

