/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComPayLogBo;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountPayDetailListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountPayDetailListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountPayDetailListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.enums.FscModelEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountPayDetailListQueryAbilityService"})
public class FscAccountPayDetailListQueryAbilityServiceImpl
implements FscAccountPayDetailListQueryAbilityService {
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryAccountPayDetailList"})
    public FscAccountPayDetailListQueryAbilityRspBO qryAccountPayDetailList(@RequestBody FscAccountPayDetailListQueryAbilityReqBO reqBO) {
        this.val(reqBO);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setBusiCategory(reqBO.getBusiCategory());
        fscPayLogPO.setBusiOrderNo(reqBO.getBusiOrderNo());
        fscPayLogPO.setIsCredit(reqBO.getIsCredit());
        fscPayLogPO.setBusiTimeStart(reqBO.getBusiTimeBegin());
        fscPayLogPO.setBusiTimeEnd(reqBO.getBusiTimeEnd());
        fscPayLogPO.setAccountId(reqBO.getAccountId());
        fscPayLogPO.setCompanyIdWeb(reqBO.getOrgIdWeb());
        fscPayLogPO.setIds(reqBO.getPayLogIds());
        fscPayLogPO.setPurAccountId(reqBO.getPurAccountId());
        fscPayLogPO.setUserName(reqBO.getUserNameWeb());
        if (reqBO.getBusiType() != null) {
            if (reqBO.getBusiType() == 3 || reqBO.getBusiType() == 7) {
                fscPayLogPO.setOrderType(reqBO.getBusiType());
            } else {
                fscPayLogPO.setPayBusiness(reqBO.getBusiType().toString());
            }
        }
        fscPayLogPO.setOrderBy("busi_time desc");
        List fscPayLogPOList = this.fscPayLogMapper.getListPage(fscPayLogPO, page);
        if (CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
            return new FscAccountPayDetailListQueryAbilityRspBO();
        }
        Map fscBusiCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("PAY_LOG_BUSI_CATEGORY");
        Map fscIsCreditMap = this.fscDictionaryBusiService.queryBypCodeBackMap("PAY_LOG_IS_CREDIT");
        Map fscBusiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_ORDER_TYPE");
        List fscComPayLogBos = JSON.parseArray((String)JSON.toJSONString((Object)fscPayLogPOList), FscComPayLogBo.class);
        for (FscComPayLogBo fscComPayLogBo : fscComPayLogBos) {
            fscComPayLogBo.setBusiCategoryStr((String)fscBusiCategoryMap.get(fscComPayLogBo.getBusiCategory().toString()));
            fscComPayLogBo.setIsCreaditStr((String)fscIsCreditMap.get(fscComPayLogBo.getIsCredit().toString()));
            if (fscComPayLogBo.getPayBusiness().equals("3") && fscComPayLogBo.getOrderType() != null) {
                fscComPayLogBo.setBusiTypeStr((String)fscBusiTypeMap.get(fscComPayLogBo.getOrderType().toString()));
            }
            fscComPayLogBo.setBusiTypeStr((String)fscBusiTypeMap.get(fscComPayLogBo.getPayBusiness()));
            BigDecimal claimAmt = BigDecimal.ZERO;
            String claimNo = "";
            List claimDetailPOList = this.fscClaimDetailMapper.getListByOrderCode(fscComPayLogBo.getBusiOrderNo());
            if (!CollectionUtils.isEmpty((Collection)claimDetailPOList)) {
                for (FscClaimDetailPO fscClaimDetailPO : claimDetailPOList) {
                    claimAmt = claimAmt.add(fscClaimDetailPO.getClaimAmt());
                    claimNo = claimNo.replace(fscClaimDetailPO.getClaimNo() + ",", "");
                    claimNo = claimNo + fscClaimDetailPO.getClaimNo() + ",";
                }
                if (claimNo.endsWith(",")) {
                    claimNo = claimNo.substring(0, claimNo.length() - 1);
                }
                if (BigDecimal.ZERO.equals(fscComPayLogBo.getNotBackAmt())) {
                    fscComPayLogBo.setClaimDate(((FscClaimDetailPO)claimDetailPOList.get(0)).getClaimDate());
                }
            }
            if (FscConstants.FscBusiCategory.ORDER_PAY.equals(fscComPayLogBo.getBusiCategory())) {
                fscComPayLogBo.setNotBackAmt(fscComPayLogBo.getBusiAmount().subtract(claimAmt));
                fscComPayLogBo.setFscModel(FscModelEnum.PAYMENT_DAYS.getCode());
                fscComPayLogBo.setFscModelStr(FscModelEnum.PAYMENT_DAYS.getCodeDesc());
            } else if (FscConstants.FscBusiCategory.ADVANCE_PAY.equals(fscComPayLogBo.getBusiCategory())) {
                if (fscComPayLogBo.getOverdraftBeforeAmount() != null && fscComPayLogBo.getOverdraftAfterAmount() != null && fscComPayLogBo.getOverdraftBeforeAmount().equals(fscComPayLogBo.getOverdraftAfterAmount())) {
                    fscComPayLogBo.setFscModel(FscModelEnum.ADVANCE_PAYMENT_DEPOSIT.getCode());
                    fscComPayLogBo.setFscModelStr(FscModelEnum.ADVANCE_PAYMENT_DEPOSIT.getCodeDesc());
                    fscComPayLogBo.setNotBackAmt(BigDecimal.ZERO);
                } else if (fscComPayLogBo.getAdvanceBeforeAmount() != null && fscComPayLogBo.getAdvanceAfterAmount() != null && !fscComPayLogBo.getAdvanceBeforeAmount().equals(fscComPayLogBo.getAdvanceAfterAmount())) {
                    fscComPayLogBo.setFscModel(FscModelEnum.OVERDRAFT.getCode());
                    fscComPayLogBo.setFscModelStr(FscModelEnum.OVERDRAFT.getCodeDesc());
                    fscComPayLogBo.setNotBackAmt(fscComPayLogBo.getOverdraftBeforeAmount().subtract(fscComPayLogBo.getOverdraftAfterAmount()).subtract(claimAmt));
                } else {
                    fscComPayLogBo.setFscModel(FscModelEnum.ADVANCE_PAYMENT_DEPOSIT_OVERDRAFT.getCode());
                    fscComPayLogBo.setFscModelStr(FscModelEnum.ADVANCE_PAYMENT_DEPOSIT_OVERDRAFT.getCodeDesc());
                    if (fscComPayLogBo.getOverdraftBeforeAmount() != null && fscComPayLogBo.getOverdraftAfterAmount() != null) {
                        fscComPayLogBo.setNotBackAmt(fscComPayLogBo.getOverdraftBeforeAmount().subtract(fscComPayLogBo.getOverdraftAfterAmount()).subtract(claimAmt));
                    } else {
                        fscComPayLogBo.setNotBackAmt(BigDecimal.ZERO);
                    }
                }
            }
            fscComPayLogBo.setClaimNo(claimNo);
            if (BigDecimal.ZERO.equals(fscComPayLogBo.getNotBackAmt())) {
                fscComPayLogBo.setIsBack("\u662f");
                if (fscComPayLogBo.getClaimDate() != null) continue;
                fscComPayLogBo.setClaimDate(fscComPayLogBo.getBusiTime());
                continue;
            }
            fscComPayLogBo.setIsBack("\u5426");
        }
        FscAccountPayDetailListQueryAbilityRspBO rspBO = new FscAccountPayDetailListQueryAbilityRspBO();
        rspBO.setRows(fscComPayLogBos);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void val(FscAccountPayDetailListQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrgIdWeb()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orgIdWeb]\u4e3a\u7a7a");
        }
    }
}

