/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.ability.api.CfcUniteParamQryAutoBillEnableDetailAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryAutoBillEnableDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryAutoBillEnableDetailAbilityRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscNoticeEcomCancelInvoiceAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderInvoiceBackAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscNoticeEcomCancelInvoiceAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscNoticeEcomCancelInvoiceAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceBackAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceBackAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscComOrderCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService"})
public class FscComOrderCancelAbilityServiceImpl
implements FscComOrderCancelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderCancelAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderCancelBusiService fscComOrderCancelBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscNoticeEcomCancelInvoiceAbilityService fscNoticeEcomCancelInvoiceAbilityService;
    @Autowired
    private CfcUniteParamQryAutoBillEnableDetailAbilityService cfcUniteParamQryAutoBillEnableDetailAbilityService;
    @Autowired
    private FscOrderInvoiceBackAbilityService fscOrderInvoiceBackAbilityService;

    @PostMapping(value={"dealOrderCancel"})
    public FscComOrderCancelAbilityRspBO dealOrderCancel(@RequestBody FscComOrderCancelAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if ("2".equals(reqBO.getIsprofess())) {
            throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u7528\u6237\u4e0d\u80fd\u53d6\u6d88\u7ed3\u7b97\u5355");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191125", "\u67e5\u8be2\u7ed3\u7b97\u5355\u4e3a\u7a7a");
        }
        if (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType()) && !FscBillStatus.TO_BE_RECONCILED.getCode().equals(fscOrderPO.getOrderState()) && !FscBillStatus.TO_BE_INVOICED.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u4fa7\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u6216\u5df2\u786e\u8ba4\u72b6\u6001");
        }
        if (!(!FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) || FscBillStatus.PENDING_FEEDBACK.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.TO_BE_INVOICED.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_AUDIT_REJECT.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_TO_BE_CONFIRM.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_RJECT.getCode().equals(fscOrderPO.getOrderState()))) {
            throw new FscBusinessException("191125", "\u8d38\u6613\u6a21\u5f0f\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u6216\u5f85\u786e\u8ba4\u72b6\u6001");
        }
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && !FscBillStatus.INVOICING_SUBMISSION.getCode().equals(fscOrderPO.getOrderState()) && !FscBillStatus.INVOICING_DEALLING.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191125", "\u7535\u5546\u4fa7\u7ed3\u7b97\u5355\u53d6\u6d88\uff0c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\uff0c\u540e\u7eed\u72b6\u6001\u5f85\u4e0e\u7535\u5546\u5bf9\u63a5\u53d6\u6d88\u53d1\u7968\u63a5\u53e3\u540e\u542f\u7528");
        }
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && FscBillStatus.INVOICING_DEALLING.getCode().equals(fscOrderPO.getOrderState())) {
            FscNoticeEcomCancelInvoiceAbilityReqBO abilityReqBO = new FscNoticeEcomCancelInvoiceAbilityReqBO();
            abilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            FscNoticeEcomCancelInvoiceAbilityRspBO abilityRspBO = this.fscNoticeEcomCancelInvoiceAbilityService.cancelInvoice(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
            }
        }
        Boolean autoBillEnable = true;
        if (reqBO.getIsprofess().equals("0") && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && fscOrderPO.getOrderType().equals(FscOrderTypeEnum.ELECTRONIC.getCode())) {
            autoBillEnable = this.queryAutoBillEnableConfig(fscOrderPO.getOrderType(), fscOrderPO.getPayerId());
        }
        if (autoBillEnable.booleanValue()) {
            reqBO.setOrderState(fscOrderPO.getOrderState());
            String jsonString = JSON.toJSONString((Object)reqBO);
            FscComOrderCancelBusiReqBO busiReqBO = (FscComOrderCancelBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscComOrderCancelBusiReqBO.class));
            busiReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
            FscComOrderCancelBusiRspBO fscComOrderCancelBusiRspBO = this.fscComOrderCancelBusiService.dealOrderCancel(busiReqBO);
            if (!"0000".equals(fscComOrderCancelBusiRspBO.getRespCode())) {
                throw new FscBusinessException("191125", fscComOrderCancelBusiRspBO.getRespDesc());
            }
        } else {
            FscOrderInvoiceBackAbilityReqBO abilityReqBO = new FscOrderInvoiceBackAbilityReqBO();
            abilityReqBO.setFscOrderIds(Collections.singletonList(reqBO.getOrderId()));
            FscOrderInvoiceBackAbilityRspBO abilityRspBO = this.fscOrderInvoiceBackAbilityService.dealOrderInvoiceBack(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
            }
        }
        this.sendMq(reqBO);
        return new FscComOrderCancelAbilityRspBO();
    }

    private void sendMq(FscComOrderCancelAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    public Boolean queryAutoBillEnableConfig(Integer orderType, Long orgId) {
        CfcUniteParamQryAutoBillEnableDetailAbilityReqBO abilityReqBO = new CfcUniteParamQryAutoBillEnableDetailAbilityReqBO();
        abilityReqBO.setGroupCode("AOTU_BILL_ENABLE");
        abilityReqBO.setCenter("FSC");
        abilityReqBO.setBusiType(orderType.toString());
        abilityReqBO.setOrgIgWeb(orgId);
        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u662f\u5426\u5e26\u52a8\u4e0a\u6e38\u914d\u7f6e\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityReqBO));
        CfcUniteParamQryAutoBillEnableDetailAbilityRspBO abilityRspBO = this.cfcUniteParamQryAutoBillEnableDetailAbilityService.qryAutoBillEnableDetail(abilityReqBO);
        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u662f\u5426\u5e26\u52a8\u4e0a\u6e38\u914d\u7f6e\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u662f\u5426\u5e26\u52a8\u4e0a\u6e38\u5931\u8d25\uff01" + abilityRspBO.getRespDesc());
        }
        return abilityRspBO.getAutoBillEnable();
    }
}

