/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscDealOrderSettleStatusAbilityService;
import com.tydic.fsc.common.ability.bo.FscDealOrderSettleStatusAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscDealOrderSettleStatusAbilityRspBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscDealOrderSettleStatusAbilityService"})
public class FscDealOrderSettleStatusAbilityServiceImpl
implements FscDealOrderSettleStatusAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private PebUpdateOrderAbilityService pebUpdateOrderAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;

    @PostMapping(value={"dealOrderSettleStatus"})
    public FscDealOrderSettleStatusAbilityRspBO dealOrderSettleStatus(@RequestBody FscDealOrderSettleStatusAbilityReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO querVo = new FscOrderPO();
        querVo.setOrderId(reqBO.getOrderId());
        querVo.setPayeeId(this.operationOrgId);
        BigDecimal invoiceAmt = this.fscOrderMapper.getInvoiceStatisticalByOrderId(reqBO.getOrderId(), this.operationOrgId);
        BigDecimal payAmt = this.fscOrderMapper.getPayStatisticalInfoByOrderId(reqBO.getOrderId(), this.operationOrgId);
        BigDecimal orderAmt = BigDecimal.ZERO;
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBO.setOrderId(reqBO.getOrderId());
        uocInspectionDetailsListPageQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
        uocInspectionDetailsListPageQueryReqBO.setTabId(Integer.valueOf(80013));
        uocInspectionDetailsListPageQueryReqBO.setPageSize(1000000);
        uocInspectionDetailsListPageQueryReqBO.setIsChange("0");
        uocInspectionDetailsListPageQueryReqBO.setIsFscQuery("0");
        UocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
        if (!inspectionDetailsList.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        for (UocInspectionDetailsListBO row : inspectionDetailsList.getRows()) {
            orderAmt = orderAmt.add(row.getInspTotalSaleMoney());
        }
        if (((UocInspectionDetailsListBO)inspectionDetailsList.getRows().get(0)).getPayType() != null && ((UocInspectionDetailsListBO)inspectionDetailsList.getRows().get(0)).getPayType() == 3) {
            payAmt = orderAmt;
        }
        if (invoiceAmt.compareTo(BigDecimal.ZERO) == 0 && payAmt.compareTo(BigDecimal.ZERO) == 0) {
            return new FscDealOrderSettleStatusAbilityRspBO();
        }
        String statusType = "";
        if (invoiceAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0) {
            statusType = "5";
            if (payAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0) {
                statusType = "6";
            } else if (payAmt.compareTo(orderAmt) >= 0) {
                statusType = "7";
            }
        } else if (invoiceAmt.compareTo(orderAmt) >= 0) {
            statusType = "8";
            if (payAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0) {
                statusType = "9";
            } else if (payAmt.compareTo(orderAmt) >= 0) {
                statusType = "10";
            }
        } else if (payAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0 && payAmt.compareTo(orderAmt) < 0) {
            statusType = "3";
        } else if (payAmt.compareTo(orderAmt) >= 0) {
            statusType = "4";
        }
        if (!StringUtils.isEmpty((Object)statusType)) {
            PebUpdateOrderReqBO orderReqBO = new PebUpdateOrderReqBO();
            orderReqBO.setOrderId(reqBO.getOrderId());
            Map stateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_STATUS");
            orderReqBO.setFscStatus((String)stateMap.get(statusType));
            orderReqBO.setFscStatusType(statusType);
            PebUpdateOrderRspBO pebUpdateOrderRspBO = this.pebUpdateOrderAbilityService.updateFscStatus(orderReqBO);
            if (!pebUpdateOrderRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(pebUpdateOrderRspBO.getRespCode(), pebUpdateOrderRspBO.getRespDesc());
            }
        }
        FscDealOrderSettleStatusAbilityRspBO rspBO = new FscDealOrderSettleStatusAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

