/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.ability.api.CfcUniteParamQryListDetailAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityRspBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.esb.FscClaimSendYcCancelService;
import com.tydic.fsc.common.ability.api.FscClaimSendYcCancelAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService;
import com.tydic.fsc.common.ability.api.FscRecvClaimCreditDeductAbilityService;
import com.tydic.fsc.common.ability.bo.FscCfcUniteParamQryListDetailRspBO;
import com.tydic.fsc.common.ability.bo.FscClaimSendYcCancelAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimCreditDeductAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscRecvClaimConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscRecvClaimConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimConfirmBusiRspBO;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService"})
public class FscRecvClaimConfirmAbilityServiceImpl
implements FscRecvClaimConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimConfirmAbilityServiceImpl.class);
    @Autowired
    private FscRecvClaimConfirmBusiService fscRecvClaimConfirmBusiService;
    @Autowired
    private FscClaimSendYcCancelService fscClaimSendYcCancelService;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private CfcUniteParamQryListDetailAbilityService cfcUniteParamQryListDetailAbilityService;
    @Autowired
    private FscClaimSendYcCancelAbilityService fscClaimSendYcCancelAbilityService;
    @Autowired
    private FscRecvClaimCreditDeductAbilityService fscRecvClaimCreditDeductAbilityService;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"recvClaimConfirm"})
    public FscRecvClaimConfirmAbilityRspBO recvClaimConfirm(@RequestBody FscRecvClaimConfirmAbilityReqBO reqBO) {
        FscRecvClaimConfirmBusiRspBO busiRspBO;
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscRecvClaimConfirmBusiReqBO busiReqBO = (FscRecvClaimConfirmBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscRecvClaimConfirmBusiReqBO.class));
        if (!CollectionUtils.isEmpty((Collection)reqBO.getClaimDetailList()) && reqBO.getClaimDetailList().size() > 1 && !StringUtils.isEmpty((Object)((FscClaimDetailBO)reqBO.getClaimDetailList().get(0)).getFscOrderNo())) {
            List inspectionVoucherCodeList = reqBO.getClaimDetailList().stream().map(FscClaimDetailBO::getObjectNo).collect(Collectors.toList());
            UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
            uocInspectionDetailsListPageQueryReqBO.setInspectionVoucherCodeList(inspectionVoucherCodeList);
            UocInspectionDetailsListPageQueryRspBO uocInspectionDetailsListPageQueryRspBO = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
            if (Objects.nonNull(uocInspectionDetailsListPageQueryRspBO) && !CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryRspBO.getRows())) {
                log.info("\u67e5\u8be2\u9a8c\u6536\u5355\u6570\u636e\u4e0d\u4e3a\u7a7a\uff01");
                Map<String, String> inspectionTimeMap = uocInspectionDetailsListPageQueryRspBO.getRows().stream().collect(Collectors.toMap(UocInspectionDetailsListBO::getInspectionVoucherCode, UocInspectionDetailsListBO::getInspectionTime, (k1, k2) -> k1));
                reqBO.getClaimDetailList().forEach(e -> e.setInspectionTime(DateUtil.strToDate((String)((String)inspectionTimeMap.get(e.getObjectNo())), (String)"yyyy-MM-dd HH:mm:ss")));
                reqBO.setClaimDetailList(reqBO.getClaimDetailList().stream().sorted(Comparator.comparing(FscClaimDetailBO::getBillTime).thenComparing(FscClaimDetailBO::getInspectionTime)).collect(Collectors.toList()));
                log.info("\u8ba4\u9886\u660e\u7ec6\u96c6\u5408\uff1a" + reqBO.getClaimDetailList());
            }
        }
        if ((busiRspBO = this.fscRecvClaimConfirmBusiService.recvClaimConfirm(busiReqBO)).getRespCode().equals("0000")) {
            if (!CollectionUtils.isEmpty(busiRspBO.getPushDetailBOList())) {
                this.dealPushYc(reqBO.getClaimId(), reqBO.getOrgId(), busiRspBO.getPushDetailBOList());
            }
            if (!CollectionUtils.isEmpty(busiRspBO.getCancelList())) {
                FscClaimSendYcCancelAbilityReqBO abilityReqBO = new FscClaimSendYcCancelAbilityReqBO();
                abilityReqBO.setCancelList(busiRspBO.getCancelList());
                this.fscClaimSendYcCancelAbilityService.dealSendYcCancel(abilityReqBO);
            }
        }
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        return (FscRecvClaimConfirmAbilityRspBO)JSONObject.parseObject((String)respString, FscRecvClaimConfirmAbilityRspBO.class);
    }

    private void valid(FscRecvClaimConfirmAbilityReqBO reqBO) {
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[claimId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRecvAmt() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u6536\u6b3e\u91d1\u989d[recvAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getNoClaimAmt() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u672a\u8ba4\u9886\u91d1\u989d[noClaimAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getClaimDetailList())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u8ba4\u9886\u4fe1\u606f[claimDetailList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getNoClaimAmt().compareTo(reqBO.getRecvAmt()) > 0) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u672a\u8ba4\u9886\u91d1\u989d[noClaimAmt]\u4e0d\u80fd\u5927\u4e8e\u6536\u6b3e\u91d1\u989d[recvAmt]\uff01");
        }
        if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) < 0) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u672a\u8ba4\u9886\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u96f6\uff01");
        }
    }

    private void dealPushYc(Long claimId, Long orgId, List<FscClaimDetailBO> detailList) {
        FscCfcUniteParamQryListDetailRspBO rspBO = this.queryConfig(orgId);
        if (rspBO != null && "1".equals(rspBO.getAllowSettle())) {
            FscPushYcRecvClaimBillAbilityReqBO abilityReqBO = new FscPushYcRecvClaimBillAbilityReqBO();
            abilityReqBO.setClaimId(claimId);
            abilityReqBO.setClaimList(detailList);
            FscPushYcRecvClaimBillAbilityRspBO fscPushYcRecvClaimBillAbilityRspBO = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
        }
        ArrayList<Long> detailIdList = new ArrayList<Long>();
        for (FscClaimDetailBO detailBO : detailList) {
            if (StringUtils.isEmpty((Object)detailBO.getClaimType()) || !detailBO.getClaimType().equals(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode())) continue;
            detailIdList.add(detailBO.getClaimDetailId());
        }
        if (!CollectionUtils.isEmpty(detailIdList)) {
            FscRecvClaimCreditDeductAbilityReqBO abilityReqBO = new FscRecvClaimCreditDeductAbilityReqBO();
            abilityReqBO.setDetailIdList(detailIdList);
            this.fscRecvClaimCreditDeductAbilityService.dealClaimCreditDeduct(abilityReqBO);
        }
    }

    private FscCfcUniteParamQryListDetailRspBO queryConfig(Long orgId) {
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u5165\u53c2");
        CfcUniteParamQryListDetailAbilityReqBO cfcUniteParamQryListDetailAbilityReqBO = new CfcUniteParamQryListDetailAbilityReqBO();
        cfcUniteParamQryListDetailAbilityReqBO.setParamCode("IS_CONFIRM_AGAIN_AFTER_CLAIM");
        cfcUniteParamQryListDetailAbilityReqBO.setCenter("FSC");
        CfcUniteParamQryListDetailAbilityRspBO cfcUniteParamQryListDetailAbilityRspBO = this.cfcUniteParamQryListDetailAbilityService.qryListDetail(cfcUniteParamQryListDetailAbilityReqBO);
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u51fa\u53c2:" + JSONObject.toJSONString((Object)cfcUniteParamQryListDetailAbilityRspBO));
        if (null == cfcUniteParamQryListDetailAbilityRspBO || null == cfcUniteParamQryListDetailAbilityRspBO.getJsonObject() || cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().isEmpty()) {
            return null;
        }
        return (FscCfcUniteParamQryListDetailRspBO)JSON.parseObject((String)cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().toJSONString(), FscCfcUniteParamQryListDetailRspBO.class);
    }
}

