/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimBillService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.busi.api.FscAccountChargeProBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMainMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountMainPO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.umc.general.ability.api.UmcBuyerCustomerQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAccountChargeProBusiServiceImpl
implements FscAccountChargeProBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountChargeProBusiServiceImpl.class);
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountMainMapper fscAccountMainMapper;
    @Autowired
    private FscPushYcRecvClaimBillService fscPushYcRecvClaimBillService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Value(value="${OPER_ORG_CODE:101123}")
    private String operationOrgCode;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private UmcBuyerCustomerQueryAbilityService umcBuyerCustomerQueryAbilityService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;

    @Override
    public FscAccountChargeBusiRspBO dealAccountCharge(FscAccountChargeBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getAccountId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8d26\u6237id[accountId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getClaimNo())) {
            throw new FscBusinessException("190000", "\u5165\u53c2claimNo\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryByClaimNo(reqBO.getClaimNo());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u76f8\u5173\u4fe1\u606f!");
        }
        if (fscRecvClaimPo.getClaimStatus().equals(FscClaimStatusEnum.CLAIM.getCode())) {
            throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u5df2\u5b8c\u6210\u8ba4\u9886!");
        }
        if (reqBO.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) != 0) {
            throw new FscBusinessException("190000", "\u9884\u5b58\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u672a\u8ba4\u9886\u91d1\u989d\uff01");
        }
        FscAccountMainPO mainQueryVo = new FscAccountMainPO();
        mainQueryVo.setBusiType("1");
        mainQueryVo.setOrgCode(this.operationOrgCode);
        FscAccountMainPO fscAccountMainPo = this.fscAccountMainMapper.getModelBy(mainQueryVo);
        if (fscAccountMainPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u5f00\u53d1\u516c\u53f8\u4e3b\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAccountId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8d26\u6237id[accountId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountPO queryVo = new FscAccountPO();
        queryVo.setId(reqBO.getAccountId());
        FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
        if (fscAccountPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscAccountChargeBusiRspBO rspBO = new FscAccountChargeBusiRspBO();
        rspBO.setClaimId(fscRecvClaimPo.getClaimId());
        FscAccountChargePO fscAccountChargePo = new FscAccountChargePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscAccountChargePo);
        fscAccountChargePo.setBusiType(Integer.valueOf("1"));
        fscAccountChargePo.setUseDeptCode(fscAccountPo.getOrgCode());
        fscAccountChargePo.setUseDeptId(fscAccountPo.getOrgId());
        fscAccountChargePo.setUseDeptName(fscAccountPo.getOrgName());
        fscAccountChargePo.setChargeDeptCode(fscAccountMainPo.getOrgCode());
        fscAccountChargePo.setChargeDeptId(Long.valueOf(fscAccountMainPo.getOrgId()));
        fscAccountChargePo.setChargeDeptName(fscAccountMainPo.getOrgName());
        fscAccountChargePo.setRecvBankAccount(fscAccountMainPo.getBankAccount());
        fscAccountChargePo.setRecvDeptName(fscAccountMainPo.getOrgName());
        fscAccountChargePo.setRecvDeptCode(fscAccountMainPo.getOrgCode());
        fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_PASS);
        fscAccountChargePo.setPayTime(new Date());
        fscAccountChargePo.setPayDeptName(fscAccountPo.getOrgName());
        fscAccountChargePo.setPayBankAccountName(fscAccountPo.getBankAccount());
        fscAccountChargePo.setPayBankName(fscAccountPo.getBankName());
        fscAccountChargePo.setUserId(reqBO.getUserId());
        fscAccountChargePo.setUserName(reqBO.getName());
        fscAccountChargePo.setCreateTime(new Date());
        fscAccountChargePo.setClaimNo(reqBO.getClaimNo());
        fscAccountChargePo.setChargeId(Long.valueOf(Sequence.getInstance().nextId()));
        fscAccountChargePo.setAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
        ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>(reqBO.getAttachmentList().size());
        for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPo);
            fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPo.setObjId(fscAccountChargePo.getChargeId());
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAY_EVIDENCE);
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentObjType.PAY_EVIDENCE);
            attachmentList.add(fscAttachmentPo);
        }
        if (!CollectionUtils.isEmpty(attachmentList)) {
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        FscAccountSerialPO serialPo = new FscAccountSerialPO();
        serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
        serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
        Integer serialNumber = 0;
        if (serialPo != null) {
            serialNumber = serialPo.getSerialNumber();
        }
        ArrayList<FscClaimDetailPO> detailPOList = new ArrayList<FscClaimDetailPO>();
        ArrayList<FscClaimDetailBO> pushDetailList = new ArrayList<FscClaimDetailBO>();
        Object[] objectArray = new Object[1];
        serialNumber = serialNumber + 1;
        objectArray[0] = serialNumber;
        String detailNo = fscRecvClaimPo.getClaimNo() + "-" + String.format("%02d", objectArray);
        FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
        fscClaimDetailPo.setDetailNo(detailNo);
        fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
        fscClaimDetailPo.setClaimAmt(fscAccountChargePo.getChargeAmount());
        fscClaimDetailPo.setClaimDate(new Date());
        fscClaimDetailPo.setClaimId(fscRecvClaimPo.getClaimId());
        fscClaimDetailPo.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode());
        fscClaimDetailPo.setCustomerNo(Long.valueOf(fscAccountPo.getOrgCode()));
        fscClaimDetailPo.setCustomerName(fscAccountPo.getOrgName());
        fscClaimDetailPo.setHandleDeptId(reqBO.getDeptId());
        fscClaimDetailPo.setHandleDeptName(reqBO.getDeptName());
        fscClaimDetailPo.setHandleUserId(reqBO.getUserId());
        fscClaimDetailPo.setHandleUserName(reqBO.getName());
        fscClaimDetailPo.setStatus("1");
        fscClaimDetailPo.setObjectId(fscAccountChargePo.getChargeId());
        fscClaimDetailPo.setObjectNo(fscAccountChargePo.getChargeId().toString());
        fscClaimDetailPo.setSysSource(Integer.valueOf(1));
        fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
        detailPOList.add(fscClaimDetailPo);
        FscClaimDetailBO detailBO = new FscClaimDetailBO();
        BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)detailBO);
        pushDetailList.add(detailBO);
        rspBO.setPushDetailBOList(pushDetailList);
        int count = this.fscClaimDetailMapper.insertBatch(detailPOList);
        if (count < 0) {
            throw new FscBusinessException("190000", "\u9884\u5b58\u8ba4\u9886\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        fscAccountChargePo.setClaimDetailId(fscClaimDetailPo.getClaimDetailId());
        int insert = this.fscAccountChargeMapper.insert(fscAccountChargePo);
        if (insert < 0) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u8d26\u6237\u5145\u503c\u5931\u8d25\uff01");
        }
        if (serialPo == null) {
            serialPo = new FscAccountSerialPO();
            serialPo.setSerialNumber(serialNumber);
            serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
            serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
            this.fscAccountSerialMapper.insert(serialPo);
        } else {
            serialPo.setSerialNumber(serialNumber);
            this.fscAccountSerialMapper.update(serialPo);
        }
        fscRecvClaimPo.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
        fscRecvClaimPo.setNoClaimAmt(BigDecimal.ZERO);
        fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
        this.fscRecvClaimMapper.update(fscRecvClaimPo);
        fscAccountPo.setAdvanceAmount(fscAccountPo.getAdvanceAmount().add(fscAccountChargePo.getChargeAmount()));
        BigDecimal returnedAmount = BigDecimal.ZERO;
        if (fscAccountPo.getOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
            returnedAmount = fscAccountPo.getOverdraftAmount();
            fscAccountPo.setOverdraftAmount(fscAccountPo.getOverdraftAmount().compareTo(fscAccountChargePo.getChargeAmount()) > 0 ? fscAccountPo.getOverdraftAmount().subtract(fscAccountChargePo.getChargeAmount()) : BigDecimal.ZERO);
            returnedAmount = returnedAmount.subtract(fscAccountPo.getOverdraftAmount());
        }
        fscAccountPo.setReturnedAmount(returnedAmount);
        this.fscAccountMapper.updateAmountByCharge(fscAccountPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

