/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.busibase.atom.api.FscCreditDeductAtomService;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomRspBO;
import com.tydic.fsc.common.busi.api.FscRecvClaimCreditDeductBusiService;
import com.tydic.fsc.common.busi.bo.FscRecvClaimCreditDeductBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimCreditDeductBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocProOrderZqPaymentCallbackAbilityService;
import com.tydic.uoc.common.ability.bo.UocProOrderZqPaymentCallbackAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocProOrderZqPaymentCallbackAbilityRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscRecvClaimCreditDeductBusiServiceImpl
implements FscRecvClaimCreditDeductBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimCreditDeductBusiServiceImpl.class);
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscCreditDeductAtomService fscCreditDeductAtomService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private UocProOrderZqPaymentCallbackAbilityService uocProOrderZqPaymentCallbackAbilityService;

    @Override
    public FscRecvClaimCreditDeductBusiRspBO dealClaimCreditDeduct(FscRecvClaimCreditDeductBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getDetailIdList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba4\u9886\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscPayLogPO payLogPo = new FscPayLogPO();
        payLogPo.setObjIds(reqBO.getDetailIdList());
        payLogPo.setBusiCategory(FscConstants.FscBusiCategory.PERIOD_PAY);
        List objIds = this.fscPayLogMapper.getPaidObjIds(payLogPo);
        reqBO.getDetailIdList().removeAll(objIds);
        if (CollectionUtils.isEmpty(reqBO.getDetailIdList())) {
            return new FscRecvClaimCreditDeductBusiRspBO();
        }
        FscClaimDetailPO detailPO = new FscClaimDetailPO();
        detailPO.setDetailIdList(reqBO.getDetailIdList());
        List list = this.fscClaimDetailMapper.getCreditDeductList(detailPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u76f8\u5173\u4fe1\u606f\uff01");
        }
        HashMap<String, List<FscCreditDeductAtomBO>> deductMap = new HashMap<String, List<FscCreditDeductAtomBO>>();
        for (FscClaimDetailPO claimDetailPO : list) {
            FscCreditDeductAtomBO atomBO = new FscCreditDeductAtomBO();
            atomBO.setAmount(claimDetailPO.getClaimAmt().negate());
            atomBO.setOrderNo(claimDetailPO.getOrderCode());
            atomBO.setObjId(claimDetailPO.getClaimDetailId());
            if (deductMap.get(claimDetailPO.getBuyerNo()) == null) {
                deductMap.put(claimDetailPO.getBuyerNo(), Collections.singletonList(atomBO));
                continue;
            }
            List atomBOS = (List)deductMap.get(claimDetailPO.getBuyerNo());
            atomBOS.add(atomBO);
            deductMap.put(claimDetailPO.getBuyerNo(), atomBOS);
        }
        this.dealDeduct(deductMap);
        FscRecvClaimCreditDeductBusiRspBO rspBO = new FscRecvClaimCreditDeductBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealDeduct(Map<String, List<FscCreditDeductAtomBO>> deductMap) {
        Set<String> keys = deductMap.keySet();
        for (String key : keys) {
            UmcEnterpriseOrgQryDetailAbilityReqBO abilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            abilityReqBO.setOrgCode(key);
            UmcEnterpriseOrgQryDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(abilityRspBO.getRespCode(), "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5931\u8d25\uff01" + abilityRspBO.getRespDesc());
            }
            if (abilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
                throw new FscBusinessException("198888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            FscCreditDeductAtomReqBO atomReqBO = new FscCreditDeductAtomReqBO();
            atomReqBO.setCreditOrgId(abilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgId());
            atomReqBO.setCreditOrgCode(key);
            atomReqBO.setBusiCategory(FscConstants.FscBusiCategory.PERIOD_PAY);
            atomReqBO.setPayBusiness("1");
            List<FscCreditDeductAtomBO> atomBOS = deductMap.get(key);
            atomReqBO.setFscCreditDeductAtomBOS(atomBOS);
            atomReqBO.setSupId(this.operationOrgId);
            FscCreditDeductAtomRspBO atomRspBO = this.fscCreditDeductAtomService.dealAccountDeduct(atomReqBO);
            if (!atomRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
            this.noticeOrderPay(atomBOS);
        }
    }

    private void noticeOrderPay(List<FscCreditDeductAtomBO> atomBOS) {
        for (FscCreditDeductAtomBO atomBO : atomBOS) {
            BigDecimal paidAmt = this.fscClaimDetailMapper.getClaimAmtByOrderCode(atomBO.getOrderNo());
            if (paidAmt == null) continue;
            UocProOrderZqPaymentCallbackAbilityReqBO abilityReqBO = new UocProOrderZqPaymentCallbackAbilityReqBO();
            abilityReqBO.setOrderCode(atomBO.getOrderNo());
            abilityReqBO.setPayFlag(Boolean.valueOf(true));
            abilityReqBO.setTotalPaidAmt(paidAmt.multiply(new BigDecimal(10000)));
            log.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityReqBO));
            UocProOrderZqPaymentCallbackAbilityRspBO abilityRspBO = this.uocProOrderZqPaymentCallbackAbilityService.dealZqPaymentCallBack(abilityReqBO);
            log.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
            if (abilityRspBO.getRespCode().equals("0000")) continue;
            throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
    }
}

