/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.bo.FscComOrderItemListBO;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscDealOrderSettleStatusAbilityService;
import com.tydic.fsc.common.ability.bo.FscDealOrderSettleStatusAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscEsSyncComOrderItemListBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderItemListEsSyncReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderItemListEsSyncRspBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.uoc.common.ability.api.PebExtOrdIdxSyncAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FscEsSyncOrderDetailServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscEsSyncOrderDetailServiceConsumer.class);
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscEsSyncComOrderItemListBusiService fscEsSyncComOrderItemListBusiService;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private PebExtOrdIdxSyncAbilityService pebExtOrdIdxSyncAbilityService;
    @Autowired
    private FscDealOrderSettleStatusAbilityService fscDealOrderSettleStatusAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            log.debug("---------------ES\u540c\u6b65\u7ed3\u7b97\u5355\u660e\u7ec6\u7d22\u5f15\u6d88\u8d39\u8005\u5f00\u59cb---------------");
            FscSyncReqBO fscSyncReqBO = (FscSyncReqBO)JSON.parseObject((String)proxyMessage.getContent(), (TypeReference)new TypeReference<FscSyncReqBO>(){}, (Feature[])new Feature[0]);
            log.debug("ES\u7ed3\u7b97\u5355\u660e\u7ec6\u4fe1\u606f\u7d22\u5f15\u540c\u6b65\u8f6c\u6362\u540e\u5f97\u5230\u7684\u6d88\u8d39\u8005\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)fscSyncReqBO));
            if (fscSyncReqBO.getFscOrderId() == null) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if (fscSyncReqBO.getFscOrderId() == 0L) {
                log.error("ES\u7ed3\u7b97\u5355\u4fe1\u606f\u7d22\u5f15\u540c\u6b65\u5931\u8d25\uff01fscOrderId\u4e3a\u96f6,\u53c2\u6570\u4e3a\uff1a{}", (Object)fscSyncReqBO.getFscOrderId());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            FscComOrderListPageQueryBusiReqBO reqBO = new FscComOrderListPageQueryBusiReqBO();
            reqBO.setFscOrderId(fscSyncReqBO.getFscOrderId());
            FscComOrderListPageQueryBusiRspBO orderListPageQueryBusiRspBO = this.fscEsQryComOrderListBusiService.esQryComOrderList(reqBO);
            if (Objects.isNull(orderListPageQueryBusiRspBO) || CollectionUtils.isEmpty((Collection)orderListPageQueryBusiRspBO.getRows()) || orderListPageQueryBusiRspBO.getTotal() != 1) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            FscComOrderListBO fscComOrderListBO = (FscComOrderListBO)orderListPageQueryBusiRspBO.getRows().get(0);
            FscComOrderItemListEsSyncReqBO fscComOrderItemListEsSyncReqBO = (FscComOrderItemListEsSyncReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscComOrderListBO), FscComOrderItemListEsSyncReqBO.class);
            fscComOrderItemListEsSyncReqBO.setFscComOrderListBO(fscComOrderListBO);
            log.debug("---------------ES\u540c\u6b65\u7ed3\u7b97\u5355\u660e\u7ec6\u5f00\u59cb---------------");
            FscComOrderItemListEsSyncRspBO fscComOrderItemListEsSyncRspBO = this.fscEsSyncComOrderItemListBusiService.esSyncComOrderItemList(fscComOrderItemListEsSyncReqBO);
            if (!"0000".equals(fscComOrderItemListEsSyncRspBO.getRespCode())) {
                this.writeFailLog(fscSyncReqBO.getFscOrderId(), fscComOrderItemListEsSyncRspBO, FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_ITEM_SYNC_ES);
            }
            log.debug("---------------ES\u540c\u6b65\u7ed3\u7b97\u5355\u660e\u7ec6\u7ed3\u675f---------------");
            this.sendMq(fscComOrderListBO.getOrderItemList());
            if (!CollectionUtils.isEmpty((Collection)fscComOrderListBO.getOrderIdList())) {
                for (Long orderId : fscComOrderListBO.getOrderIdList()) {
                    FscDealOrderSettleStatusAbilityReqBO abilityReqBO = new FscDealOrderSettleStatusAbilityReqBO();
                    abilityReqBO.setOrderId(orderId);
                    this.fscDealOrderSettleStatusAbilityService.dealOrderSettleStatus(abilityReqBO);
                }
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void writeFailLog(Long fscOrderId, FscRspBaseBO rspBO, Integer busiType) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(fscOrderId);
        if (null != rspBO) {
            fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(rspBO.getRespDesc());
        }
        fscOrderFailLogUpdateBusiReqBO.setBusiType(busiType);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    private FscDicDictionaryPO getDicMap() {
        FscDicDictionaryPO isItemEs = new FscDicDictionaryPO();
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setPCode("FSC_ORDER_ITEM_ES");
        List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
        if (CollectionUtils.isNotEmpty((Collection)dicDictionaryPos)) {
            isItemEs = (FscDicDictionaryPO)dicDictionaryPos.get(0);
        }
        return isItemEs;
    }

    private void sendMq(List<FscComOrderItemListBO> orderItemList) {
        UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        uocPebOrdIdxSyncReqBO.setObjType(Integer.valueOf(4));
        uocPebOrdIdxSyncReqBO.setIsThreads(Boolean.valueOf(false));
        uocPebOrdIdxSyncReqBO.setIsAll(Boolean.valueOf(false));
        HashSet<String> itemInfo = new HashSet<String>();
        for (FscComOrderItemListBO fscComOrderItemListBO : orderItemList) {
            int size = itemInfo.size();
            String item = "" + fscComOrderItemListBO.getOrderId() + fscComOrderItemListBO.getAcceptOrderId();
            itemInfo.add(item);
            if (itemInfo.size() <= size) continue;
            uocPebOrdIdxSyncReqBO.setOrderId(fscComOrderItemListBO.getOrderId());
            uocPebOrdIdxSyncReqBO.setObjId(fscComOrderItemListBO.getAcceptOrderId());
            log.error("---------------ES\u540c\u6b65\u9a8c\u6536\u5355---------------:" + JSONObject.toJSONString((Object)uocPebOrdIdxSyncReqBO));
            this.pebExtOrdIdxSyncAbilityService.dealOrdIdxSync(uocPebOrdIdxSyncReqBO);
        }
    }
}

