/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.base.FscReqBaseBO;
import com.tydic.fsc.bill.busi.api.FscCheckOneThreadBusiService;
import com.tydic.fsc.bill.busi.bo.FscAccountSerialReqBo;
import com.tydic.fsc.common.ability.api.FscAccountChargeAbilityService;
import com.tydic.fsc.common.ability.api.FscAccountChargeClaimAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeBatchAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscUseAccountBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeProBusiService;
import com.tydic.fsc.common.busi.api.FscAccountChargeProWelfareBusiService;
import com.tydic.fsc.common.busi.api.FscAccountChargePurBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiRspBO;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountChargeAbilityService"})
public class FscAccountChargeAbilityServiceImpl
implements FscAccountChargeAbilityService {
    @Autowired
    private FscAccountChargePurBusiService fscAccountChargePurBusiService;
    @Autowired
    private FscAccountChargeProBusiService fscAccountChargeProBusiService;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountChargeProWelfareBusiService fscAccountChargeProWelfareBusiService;
    @Autowired
    private FscCheckOneThreadBusiService fscCheckOneThreadBusiService;
    @Autowired
    private FscAccountChargeClaimAbilityService fscAccountChargeClaimAbilityService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    private static final Integer CHARGE_FLAGE = 444;

    /*
     * Enabled aggressive block sorting
     */
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealAccountCharge"})
    public FscAccountChargeAbilityRspBO dealAccountCharge(@RequestBody FscAccountChargeAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getChargeAmount())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u91d1\u989d[chargeAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAccountId()) && !CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            FscAccountPO queryVo = new FscAccountPO();
            queryVo.setId(reqBO.getAccountId());
            this.checkInvoiceTitle(queryVo, reqBO.getUseAccountBOList());
        }
        FscAccountChargeBusiReqBO busiReqBO = new FscAccountChargeBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscAccountChargeBusiRspBO busiRspBO = null;
        if (reqBO.getWebSource() == null || reqBO.getWebSource() == 2) {
            busiRspBO = this.fscAccountChargePurBusiService.dealAccountCharge(busiReqBO);
        } else if ("1".equals(reqBO.getEmployeeChargeFlag())) {
            List collect = reqBO.getUseAccountBOList().stream().map(FscReqBaseBO::getOrgId).collect(Collectors.toList());
            FscAccountSerialReqBo fscAccountSerialReqBo = new FscAccountSerialReqBo();
            fscAccountSerialReqBo.setOrgIds(collect);
            fscAccountSerialReqBo.setSerialNumber(CHARGE_FLAGE);
            List list = this.fscCheckOneThreadBusiService.getList(fscAccountSerialReqBo);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                FscAccountChargeAbilityRspBO fscAccountChargeAbilityRspBO = new FscAccountChargeAbilityRspBO();
                fscAccountChargeAbilityRspBO.setRespCode("7777");
                fscAccountChargeAbilityRspBO.setRespDesc("\u5f53\u524d\u673a\u6784\u6b63\u5728\u5145\u503c\u8bf7\u7a0d\u540e");
                return fscAccountChargeAbilityRspBO;
            }
            ArrayList<FscAccountSerialReqBo> addBos = new ArrayList<FscAccountSerialReqBo>();
            for (Long orgId : collect) {
                FscAccountSerialReqBo fscAccountSerial = new FscAccountSerialReqBo();
                Long serialId = Sequence.getInstance().nextId();
                fscAccountSerial.setSerialId(serialId);
                fscAccountSerial.setOrgId(orgId);
                fscAccountSerial.setSerialNumber(CHARGE_FLAGE);
                addBos.add(fscAccountSerial);
            }
            this.fscCheckOneThreadBusiService.add(addBos);
            busiRspBO = this.fscAccountChargeProWelfareBusiService.dealAccountCharge(busiReqBO);
            List serialIds = addBos.stream().map(FscAccountSerialReqBo::getSerialId).collect(Collectors.toList());
            FscAccountSerialReqBo delete = new FscAccountSerialReqBo();
            delete.setSerialIds(serialIds);
            this.fscCheckOneThreadBusiService.delete(delete);
        } else {
            busiRspBO = this.fscAccountChargeProBusiService.dealAccountCharge(busiReqBO);
        }
        if (busiRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty(busiRspBO.getPushDetailBOList())) {
            this.dealPushYc(busiRspBO);
        }
        FscAccountChargeAbilityRspBO rspBO = new FscAccountChargeAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void dealPushYc(FscAccountChargeBusiRspBO busiRspBO) {
        FscPushYcRecvClaimBillAbilityReqBO abilityReqBO = new FscPushYcRecvClaimBillAbilityReqBO();
        abilityReqBO.setClaimId(busiRspBO.getClaimId());
        abilityReqBO.setClaimList(busiRspBO.getPushDetailBOList());
        this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
    }

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealAccountChargeBatch"})
    public FscAccountChargeAbilityRspBO dealAccountChargeBatch(@RequestBody FscAccountChargeBatchAbilityReqBO reqBO) {
        List uniqueAccountList;
        if (StringUtils.isEmpty((Object)reqBO.getChargeAmount())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u5145\u503c\u91d1\u989d[chargeAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4f7f\u7528\u5355\u4f4d\u96c6\u5408[useAccountBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getChargeDeptId()) && !CollectionUtils.isEmpty((Collection)reqBO.getUseAccountBOList())) {
            FscAccountPO queryVo = new FscAccountPO();
            queryVo.setOrgId(reqBO.getChargeDeptId());
            this.checkInvoiceTitle(queryVo, reqBO.getUseAccountBOList());
        }
        if ("1".equals(reqBO.getEmployeeChargeFlag())) {
            BigDecimal totalAmountCompany = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getCompanyChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmountUnion = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getUnionChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmount = totalAmountCompany.add(totalAmountUnion);
            if (reqBO.getChargeAmount().compareTo(totalAmount) != 0) {
                throw new FscBusinessException("198888", "\u591a\u4e2a\u5355\u4f4d/\u90e8\u95e8\u8d26\u6237\u5206\u914d\u7684\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u5145\u503c\u91d1\u989d\uff01");
            }
        } else {
            BigDecimal totalAmount = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getChargeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (reqBO.getChargeAmount().compareTo(totalAmount) != 0) {
                throw new FscBusinessException("198888", "\u591a\u4e2a\u5355\u4f4d/\u90e8\u95e8\u8d26\u6237\u5206\u914d\u7684\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u5145\u503c\u91d1\u989d\uff01");
            }
        }
        if ((uniqueAccountList = (List)reqBO.getUseAccountBOList().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FscUseAccountBO>(Comparator.comparing(FscUseAccountBO::getUseDeptId))), ArrayList::new))).size() != reqBO.getUseAccountBOList().size()) {
            throw new FscBusinessException("198888", "\u5206\u914d\u8d26\u6237\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        FscAccountChargeBatchBusiReqBO busiReqBO = new FscAccountChargeBatchBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscAccountChargeBatchBusiRspBO fscAccountChargeBatchBusiRspBO = this.fscAccountChargePurBusiService.dealAccountChargeBatch(busiReqBO);
        FscAccountChargeAbilityRspBO rspBO = new FscAccountChargeAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)fscAccountChargeBatchBusiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void checkInvoiceTitle(FscAccountPO queryVo, List<FscUseAccountBO> useAccountBOList) {
        FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
        FscAccountPO queryUseVo = new FscAccountPO();
        List collect = useAccountBOList.stream().map(FscUseAccountBO::getUseDeptId).collect(Collectors.toList());
        queryUseVo.setOrgIds(collect);
        List list = this.fscAccountMapper.getList(queryUseVo);
        if (!CollectionUtils.isEmpty((Collection)list) && null != fscAccountPo && null != fscAccountPo.getInvoiceTitle()) {
            for (FscAccountPO po : list) {
                if (fscAccountPo.getInvoiceTitle().equals(po.getInvoiceTitle())) continue;
                throw new FscBusinessException("198888", "\u5145\u503c\u5355\u4f4d\u540d\u79f0\u4e0e\u4ed8\u6b3e\u65b9\u540d\u79f0\u4e0d\u7b26");
            }
        }
    }
}

