/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComPayLogBo;
import com.tydic.fsc.busibase.atom.api.FscSupMerchantQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSupMerchantQryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSupMerchantQryAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountPayDetailListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountPayDetailListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountPayDetailListQueryAbilityRspBO;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.enums.AdvancePayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountPayDetailListQueryAbilityService"})
public class FscAccountPayDetailListQueryAbilityServiceImpl
implements FscAccountPayDetailListQueryAbilityService {
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscSupMerchantQryAtomService fscSupMerchantQryAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryAccountPayDetailList"})
    public FscAccountPayDetailListQueryAbilityRspBO qryAccountPayDetailList(@RequestBody FscAccountPayDetailListQueryAbilityReqBO reqBO) {
        this.val(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setBusiCategory(reqBO.getBusiCategory());
        fscPayLogPO.setBusiOrderNo(reqBO.getBusiOrderNo());
        fscPayLogPO.setIsCredit(reqBO.getIsCredit());
        fscPayLogPO.setBusiTimeStart(reqBO.getBusiTimeBegin());
        fscPayLogPO.setBusiTimeEnd(reqBO.getBusiTimeEnd());
        fscPayLogPO.setAccountId(reqBO.getAccountId());
        fscPayLogPO.setCompanyIdWeb(reqBO.getOrgIdWeb());
        fscPayLogPO.setIds(reqBO.getPayLogIds());
        fscPayLogPO.setPurAccountId(reqBO.getPurAccountId());
        fscPayLogPO.setUserName(reqBO.getUserNameWeb());
        fscPayLogPO.setPayeeId(reqBO.getSupplierId());
        fscPayLogPO.setAdvancePayType(reqBO.getFscModel());
        fscPayLogPO.setAccountType(reqBO.getAccountType());
        fscPayLogPO.setDealType(reqBO.getDealType());
        if (reqBO.getBusiType() != null) {
            if (reqBO.getBusiType() == 3 || reqBO.getBusiType() == 7) {
                fscPayLogPO.setOrderType(reqBO.getBusiType());
            } else {
                fscPayLogPO.setPayBusiness(reqBO.getBusiType().toString());
            }
        }
        if (reqBO.getBusiTypeWeb() != null) {
            if ("1".equals(reqBO.getBusiTypeWeb().toString())) {
                fscPayLogPO.setPayBusiness(reqBO.getBusiTypeWeb().toString());
            } else if ("2".equals(reqBO.getBusiTypeWeb().toString())) {
                fscPayLogPO.setPayBusiness(reqBO.getBusiTypeWeb().toString());
                fscPayLogPO.setPayeeId(this.operationOrgId);
            } else if ("4".equals(reqBO.getBusiTypeWeb().toString())) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("4");
                list.add("5");
                fscPayLogPO.setPayBusinessList(list);
            }
        }
        fscPayLogPO.setOrderBy("busi_time desc");
        List fscPayLogPOList = this.fscPayLogMapper.getListPage(fscPayLogPO, page);
        if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
            this.getAmount(reqBO, fscPayLogPOList);
        }
        if (CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
            return new FscAccountPayDetailListQueryAbilityRspBO();
        }
        Map fscBusiCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("PAY_LOG_BUSI_CATEGORY");
        Map fscIsCreditMap = this.fscDictionaryBusiService.queryBypCodeBackMap("PAY_LOG_IS_CREDIT");
        Map fscBusiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_ORDER_TYPE");
        Map accountTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_WELFARE_ACCOUNT_TYPE");
        Map dealTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_WELFARE_DEAL_TYPE");
        List fscComPayLogBos = JSON.parseArray((String)JSON.toJSONString((Object)fscPayLogPOList), FscComPayLogBo.class);
        for (FscComPayLogBo fscComPayLogBo : fscComPayLogBos) {
            fscComPayLogBo.setBusiCategoryStr((String)fscBusiCategoryMap.get(fscComPayLogBo.getBusiCategory().toString()));
            fscComPayLogBo.setIsCreaditStr((String)fscIsCreditMap.get(fscComPayLogBo.getIsCredit().toString()));
            if (fscComPayLogBo.getPayBusiness().equals("3") && fscComPayLogBo.getOrderType() != null) {
                fscComPayLogBo.setBusiTypeStr((String)fscBusiTypeMap.get(fscComPayLogBo.getOrderType().toString()));
            }
            fscComPayLogBo.setBusiTypeStr((String)fscBusiTypeMap.get(fscComPayLogBo.getPayBusiness()));
            if (fscComPayLogBo.getAdvancePayType() != null) {
                fscComPayLogBo.setAdvancePayTypeStr(Objects.requireNonNull(AdvancePayTypeEnum.getInstance((Integer)fscComPayLogBo.getAdvancePayType())).getCodeDesc());
                fscComPayLogBo.setFscModel(fscComPayLogBo.getAdvancePayType());
                fscComPayLogBo.setFscModelStr(fscComPayLogBo.getAdvancePayTypeStr());
            }
            if (fscComPayLogBo.getAccountType() != null) {
                fscComPayLogBo.setAccountTypeStr((String)accountTypeMap.get(fscComPayLogBo.getAccountType() + ""));
            }
            if (fscComPayLogBo.getDealType() == null) continue;
            fscComPayLogBo.setDealTypeStr((String)dealTypeMap.get(fscComPayLogBo.getDealType() + ""));
        }
        FscAccountPayDetailListQueryAbilityRspBO rspBO = new FscAccountPayDetailListQueryAbilityRspBO();
        rspBO.setRows(fscComPayLogBos);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void getAmount(FscAccountPayDetailListQueryAbilityReqBO reqBO, List<FscPayLogPO> fscPayLogPOList) {
        FscSupMerchantQryAtomReqBO fscSupMerchantQryAtomReqBO = new FscSupMerchantQryAtomReqBO();
        fscSupMerchantQryAtomReqBO.setSupId(this.operationOrgId);
        fscSupMerchantQryAtomReqBO.setPayBusiness("4");
        fscSupMerchantQryAtomReqBO.setPurId(reqBO.getOrgIdWeb());
        fscSupMerchantQryAtomReqBO.setPayType(Integer.valueOf(2));
        FscSupMerchantQryAtomRspBO creditMerchant = this.fscSupMerchantQryAtomService.qrySupMerchant(fscSupMerchantQryAtomReqBO);
        fscSupMerchantQryAtomReqBO.setPayType(Integer.valueOf(3));
        FscSupMerchantQryAtomRspBO overdraftMerchant = this.fscSupMerchantQryAtomService.qrySupMerchant(fscSupMerchantQryAtomReqBO);
        for (FscPayLogPO po : fscPayLogPOList) {
            if (null == creditMerchant) {
                po.setBusiAfterAmount(BigDecimal.ZERO);
                po.setBusiBeforeAmount(BigDecimal.ZERO);
            }
            if (null == overdraftMerchant) {
                po.setOverdraftBeforeAmount(BigDecimal.ZERO);
                po.setOverdraftAfterAmount(BigDecimal.ZERO);
            }
            po.setAdvanceAfterAmount(po.getAdvanceAfterAmount().compareTo(BigDecimal.ZERO) > 0 ? po.getAdvanceAfterAmount() : BigDecimal.ZERO);
            po.setAdvanceBeforeAmount(po.getAdvanceBeforeAmount().compareTo(BigDecimal.ZERO) > 0 ? po.getAdvanceBeforeAmount() : BigDecimal.ZERO);
        }
    }

    private void val(FscAccountPayDetailListQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrgIdWeb()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orgIdWeb]\u4e3a\u7a7a");
        }
    }
}

