/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscAccountBillListBo;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.esb.FscClaimSendYcCancelService;
import com.tydic.fsc.common.ability.api.FscAccountBillListQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountBillListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountBillListQueryAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeClaimBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeClaimBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeClaimBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAccountChargeClaimBusiServiceImpl
implements FscAccountChargeClaimBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountChargeClaimBusiServiceImpl.class);
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private FscClaimSendYcCancelService fscClaimSendYcCancelService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAccountBillListQueryAbilityService fscAccountBillListQueryAbilityService;
    private static final Integer TAB_ID = 60001;

    @Override
    @FscDuplicateCommitLimit
    public FscAccountChargeClaimBusiRspBO dealAccountChargeClaim(FscAccountChargeClaimBusiReqBO reqBO) {
        FscRecvClaimPO fscRecvClaimPo;
        Map<Long, BigDecimal> chargeDetailMap;
        FscAccountChargePO fscAccountChargePo = this.fscAccountChargeMapper.queryById(reqBO.getChargeId());
        if (fscAccountChargePo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5145\u503c\u76f8\u5173\u4fe1\u606f!");
        }
        List<Object> accountIdList = new ArrayList<Long>();
        if (reqBO.getOperationType() != 2) {
            if (Objects.isNull(fscAccountChargePo.getAccountId())) {
                List chargeDetailList = this.fscAccountChargeDetailMapper.queryByChargeId(reqBO.getChargeId());
                accountIdList = chargeDetailList.stream().map(FscAccountChargeDetailPO::getAccountId).collect(Collectors.toList());
                chargeDetailMap = chargeDetailList.stream().collect(Collectors.toMap(FscAccountChargeDetailPO::getAccountId, FscAccountChargeDetailPO::getChargeAmount, (k1, k2) -> k1));
            } else {
                accountIdList.add(fscAccountChargePo.getAccountId());
                chargeDetailMap = new HashMap<Long, BigDecimal>();
                chargeDetailMap.put(fscAccountChargePo.getAccountId(), fscAccountChargePo.getChargeAmount());
            }
            if (CollectionUtils.isEmpty(accountIdList)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5145\u503c\u8d26\u6237\u4fe1\u606f!");
            }
            if (StringUtils.isEmpty((Object)reqBO.getClaimNo())) {
                throw new FscBusinessException("190000", "\u5165\u53c2claimNo\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            fscRecvClaimPo = this.fscRecvClaimMapper.queryByClaimNo(reqBO.getClaimNo());
            if (fscRecvClaimPo == null) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u76f8\u5173\u4fe1\u606f!");
            }
            if (fscRecvClaimPo.getClaimStatus().equals(FscClaimStatusEnum.CLAIM.getCode())) {
                throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u5df2\u5b8c\u6210\u8ba4\u9886\uff01");
            }
            if (fscAccountChargePo.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) > 0) {
                throw new FscBusinessException("190000", "\u672a\u8ba4\u9886\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u9884\u5b58\u91d1\u989d\uff01");
            }
        } else {
            fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_REJECT);
            fscAccountChargePo.setAuditStatus(FscConstants.AuditStatus.SAVE);
            fscAccountChargePo.setReturnReason(reqBO.getReturnReason());
            this.fscAccountChargeMapper.update(fscAccountChargePo);
            FscAccountChargeClaimBusiRspBO busiRspBO = new FscAccountChargeClaimBusiRspBO();
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u6210\u529f");
            return busiRspBO;
        }
        ArrayList<FscClaimDetailBO> pushDetailList = new ArrayList<FscClaimDetailBO>();
        accountIdList.forEach(e -> {
            FscAccountPO queryVo = new FscAccountPO();
            queryVo.setId(e);
            FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
            BigDecimal overdraftAmout = fscAccountPo.getAdvanceAmount().subtract(fscAccountPo.getFreezeAmount()).subtract(fscAccountPo.getUseAmount()).subtract(fscAccountPo.getDistributeAdvanceAmount());
            BigDecimal chargeAmount = (BigDecimal)chargeDetailMap.get(e);
            FscAccountSerialPO serialPo = new FscAccountSerialPO();
            serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
            serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
            Integer serialNumber = 0;
            if (serialPo != null) {
                serialNumber = serialPo.getSerialNumber();
            }
            Object[] objectArray = new Object[1];
            serialNumber = serialNumber + 1;
            objectArray[0] = serialNumber;
            String detailNo = fscRecvClaimPo.getClaimNo() + "-" + String.format("%02d", objectArray);
            FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
            fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            fscClaimDetailPo.setDetailNo(detailNo);
            fscClaimDetailPo.setClaimAmt(chargeAmount);
            fscClaimDetailPo.setClaimDate(new Date());
            fscClaimDetailPo.setClaimId(fscRecvClaimPo.getClaimId());
            fscClaimDetailPo.setClaimType(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode());
            fscClaimDetailPo.setCustomerNo(Long.valueOf(fscAccountPo.getOrgCode()));
            fscClaimDetailPo.setCustomerName(fscAccountPo.getOrgName());
            fscClaimDetailPo.setHandleDeptId(reqBO.getYcDeptId());
            fscClaimDetailPo.setHandleDeptName(reqBO.getYcDeptName());
            fscClaimDetailPo.setHandleUserId(reqBO.getYcUserId());
            fscClaimDetailPo.setHandleUserName(reqBO.getYcUserName());
            fscClaimDetailPo.setStatus("1");
            fscClaimDetailPo.setObjectId(fscAccountChargePo.getChargeId());
            fscClaimDetailPo.setSysSource(Integer.valueOf(1));
            fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
            fscClaimDetailPo.setObjectNo(fscAccountChargePo.getChargeId().toString());
            FscClaimDetailBO detailBO = new FscClaimDetailBO();
            BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)detailBO);
            pushDetailList.add(detailBO);
            int insert = this.fscClaimDetailMapper.insert(fscClaimDetailPo);
            if (insert < 0) {
                throw new FscBusinessException("190000", "\u9884\u5b58\u8ba4\u9886\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            if (serialPo == null) {
                serialPo = new FscAccountSerialPO();
                serialPo.setSerialNumber(serialNumber);
                serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
                serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
                this.fscAccountSerialMapper.insert(serialPo);
            } else {
                serialPo.setSerialNumber(serialNumber);
                this.fscAccountSerialMapper.update(serialPo);
            }
            FscAccountChargeDetailPO chargeDetailPO = new FscAccountChargeDetailPO();
            chargeDetailPO.setChargeId(reqBO.getChargeId());
            chargeDetailPO.setAccountId(e);
            chargeDetailPO.setClaimDetailId(fscClaimDetailPo.getClaimDetailId());
            chargeDetailPO.setUpdateId(reqBO.getUserId());
            chargeDetailPO.setUpdateTime(new Date());
            int updateCount = this.fscAccountChargeDetailMapper.updateByAccountId(chargeDetailPO);
            if (updateCount < 1) {
                throw new FscBusinessException("190000", "\u9884\u5b58\u660e\u7ec6\u8ba4\u9886\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            fscAccountPo.setAdvanceAmount(fscAccountPo.getAdvanceAmount().add((BigDecimal)chargeDetailMap.get(e)));
            BigDecimal returnedAmount = BigDecimal.ZERO;
            if (fscAccountPo.getOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
                returnedAmount = fscAccountPo.getOverdraftAmount();
                fscAccountPo.setOverdraftAmount(fscAccountPo.getOverdraftAmount().compareTo((BigDecimal)chargeDetailMap.get(e)) > 0 ? fscAccountPo.getOverdraftAmount().subtract((BigDecimal)chargeDetailMap.get(e)) : BigDecimal.ZERO);
                returnedAmount = returnedAmount.subtract(fscAccountPo.getOverdraftAmount());
            }
            fscAccountPo.setReturnedAmount(returnedAmount);
            if (overdraftAmout.compareTo(BigDecimal.ZERO) < 0) {
                FscAccountBillListQueryAbilityReqBO fscAccountBillListQueryAbilityReqBO = new FscAccountBillListQueryAbilityReqBO();
                fscAccountBillListQueryAbilityReqBO.setAccountId(e);
                fscAccountBillListQueryAbilityReqBO.setIsOverPay(Integer.valueOf(0));
                fscAccountBillListQueryAbilityReqBO.setPageNo(Integer.valueOf(-1));
                fscAccountBillListQueryAbilityReqBO.setPageSize(Integer.valueOf(-1));
                ArrayList<Integer> tabIdList = new ArrayList<Integer>();
                tabIdList.add(TAB_ID);
                fscAccountBillListQueryAbilityReqBO.setTabIdList(tabIdList);
                fscAccountBillListQueryAbilityReqBO.setTabId(TAB_ID);
                FscAccountBillListQueryAbilityRspBO fscAccountBillListQueryAbilityRspBO = this.fscAccountBillListQueryAbilityService.qryAccountBillList(fscAccountBillListQueryAbilityReqBO);
                if (!"0000".equals(fscAccountBillListQueryAbilityRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", "\u67e5\u8be2\u900f\u652f\u5f85\u8fd8\u8d26\u5355\u5f02\u5e38\uff01");
                }
                if (!CollectionUtils.isEmpty((Collection)fscAccountBillListQueryAbilityRspBO.getRows())) {
                    ArrayList<FscPayLogPO> backList = new ArrayList<FscPayLogPO>();
                    for (FscAccountBillListBo fscAccountBillListBo : fscAccountBillListQueryAbilityRspBO.getRows()) {
                        if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                        FscPayLogPO fscPayLogPO = new FscPayLogPO();
                        fscPayLogPO.setAccountId(e);
                        fscPayLogPO.setBusiOrderNo(fscAccountBillListBo.getBusiOrderNo());
                        ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
                        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
                        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
                        fscPayLogPO.setBusiCategoryList(busiCategoryList);
                        fscPayLogPO.setIsOverPay(Integer.valueOf(0));
                        fscPayLogPO.setOrderBy("overdraft_amt asc");
                        List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
                        if (CollectionUtils.isEmpty((Collection)fscPayLogPOList)) continue;
                        Date reimbursementDate = new Date();
                        for (FscPayLogPO po : fscPayLogPOList) {
                            if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                            FscPayLogPO backPayLog = new FscPayLogPO();
                            backPayLog.setId(po.getId());
                            backPayLog.setBusiOrderId(po.getBusiOrderId());
                            backPayLog.setBusiOrderNo(po.getBusiOrderNo());
                            BigDecimal notBackAmt = po.getOverdraftAmt().subtract(po.getReimbursementAmount());
                            if (chargeAmount.compareTo(notBackAmt) >= 0) {
                                backPayLog.setReimbursementAmount(notBackAmt);
                                chargeAmount = chargeAmount.subtract(notBackAmt);
                                backPayLog.setReimbursementDate(reimbursementDate);
                            } else {
                                backPayLog.setReimbursementAmount(chargeAmount);
                                chargeAmount = BigDecimal.ZERO;
                            }
                            backList.add(backPayLog);
                        }
                    }
                    if (!CollectionUtils.isEmpty(backList)) {
                        this.fscPayLogMapper.updateBack(backList);
                    }
                }
            }
            this.fscAccountMapper.updateAmountByCharge(fscAccountPo);
        });
        if (fscAccountChargePo.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) == 0) {
            fscRecvClaimPo.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
            fscRecvClaimPo.setNoClaimAmt(BigDecimal.ZERO);
            fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
        } else {
            fscRecvClaimPo.setNoClaimAmt(fscRecvClaimPo.getNoClaimAmt().subtract(fscAccountChargePo.getChargeAmount()));
            fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        }
        fscRecvClaimPo.setUpdateTime(new Date());
        this.fscRecvClaimMapper.update(fscRecvClaimPo);
        fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_PASS);
        fscAccountChargePo.setClaimNo(fscRecvClaimPo.getClaimNo());
        this.fscAccountChargeMapper.update(fscAccountChargePo);
        FscAccountChargeClaimBusiRspBO busiRspBO = new FscAccountChargeClaimBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        busiRspBO.setClaimId(fscRecvClaimPo.getClaimId());
        busiRspBO.setPushDetailBOList(pushDetailList);
        return busiRspBO;
    }

    @Override
    public FscAccountChargeClaimBusiRspBO dealAccountChargeClaimed(FscAccountChargeClaimBusiReqBO reqBO) {
        BigDecimal chargeAmount = reqBO.getChargeAmount();
        FscAccountBillListQueryAbilityReqBO fscAccountBillListQueryAbilityReqBO = new FscAccountBillListQueryAbilityReqBO();
        fscAccountBillListQueryAbilityReqBO.setOrgIdWeb(reqBO.getOrgIdWeb());
        fscAccountBillListQueryAbilityReqBO.setIsOverPay(Integer.valueOf(0));
        fscAccountBillListQueryAbilityReqBO.setPageNo(Integer.valueOf(-1));
        fscAccountBillListQueryAbilityReqBO.setPageSize(Integer.valueOf(-1));
        ArrayList<Integer> tabIdList = new ArrayList<Integer>();
        tabIdList.add(TAB_ID);
        fscAccountBillListQueryAbilityReqBO.setTabIdList(tabIdList);
        fscAccountBillListQueryAbilityReqBO.setTabId(TAB_ID);
        FscAccountBillListQueryAbilityRspBO fscAccountBillListQueryAbilityRspBO = this.fscAccountBillListQueryAbilityService.qryAccountBillList(fscAccountBillListQueryAbilityReqBO);
        if (!"0000".equals(fscAccountBillListQueryAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u900f\u652f\u5f85\u8fd8\u8d26\u5355\u5f02\u5e38\uff01");
        }
        ArrayList<Long> isBackOrderIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)fscAccountBillListQueryAbilityRspBO.getRows())) {
            ArrayList<FscPayLogPO> backList = new ArrayList<FscPayLogPO>();
            for (FscAccountBillListBo fscAccountBillListBo : fscAccountBillListQueryAbilityRspBO.getRows()) {
                if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                FscPayLogPO fscPayLogPO = new FscPayLogPO();
                fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
                fscPayLogPO.setBusiOrderNo(fscAccountBillListBo.getBusiOrderNo());
                ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
                busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
                busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
                fscPayLogPO.setBusiCategoryList(busiCategoryList);
                fscPayLogPO.setIsOverPay(Integer.valueOf(0));
                fscPayLogPO.setOrderBy("overdraft_amt asc");
                List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
                if (CollectionUtils.isEmpty((Collection)fscPayLogPOList)) continue;
                Date reimbursementDate = new Date();
                for (FscPayLogPO po : fscPayLogPOList) {
                    if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    FscPayLogPO backPayLog = new FscPayLogPO();
                    backPayLog.setId(po.getId());
                    backPayLog.setBusiOrderId(po.getBusiOrderId());
                    backPayLog.setBusiOrderNo(po.getBusiOrderNo());
                    BigDecimal notBackAmt = po.getOverdraftAmt().subtract(po.getReimbursementAmount());
                    if (chargeAmount.compareTo(notBackAmt) >= 0) {
                        backPayLog.setReimbursementAmount(notBackAmt);
                        chargeAmount = chargeAmount.subtract(notBackAmt);
                        backPayLog.setReimbursementDate(reimbursementDate);
                        if (!isBackOrderIds.contains(po.getBusiOrderId())) {
                            isBackOrderIds.add(po.getBusiOrderId());
                        }
                    } else {
                        backPayLog.setReimbursementAmount(chargeAmount);
                        chargeAmount = BigDecimal.ZERO;
                    }
                    backList.add(backPayLog);
                }
            }
            if (!CollectionUtils.isEmpty(backList)) {
                this.fscPayLogMapper.updateBack(backList);
            }
        }
        FscAccountChargeClaimBusiRspBO busiRspBO = new FscAccountChargeClaimBusiRspBO();
        if (!CollectionUtils.isEmpty(isBackOrderIds)) {
            busiRspBO.setOrderIds(isBackOrderIds);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }
}

