/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscSupMerchantQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSupMerchantQryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSupMerchantQryAtomRspBO;
import com.tydic.fsc.common.busi.api.FscAccountDealWelfareDeductBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountDealWelfareDeductBusiReqBO;
import com.tydic.fsc.common.busi.impl.FscAccountDealWelfareDeductBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscWelfareChargeConsumerMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscWelfareChargeConsumerPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscAccountDealWelfareDeductBusiServiceImpl
implements FscAccountDealWelfareDeductBusiService {
    @Autowired
    private FscSupMerchantQryAtomService fscSupMerchantQryAtomService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscWelfareChargeConsumerMapper fscWelfareChargeConsumerMapper;

    @Override
    public FscAccountDealWelfareDeductBusiRspBO dealWelfareDeduct(FscAccountDealWelfareDeductBusiReqBO reqBO) {
        this.dealCheck(reqBO);
        FscSupMerchantQryAtomReqBO atomReqBO = new FscSupMerchantQryAtomReqBO();
        atomReqBO.setPayType(reqBO.getPayType());
        atomReqBO.setSupId(reqBO.getSupId());
        atomReqBO.setPayBusiness("4");
        atomReqBO.setPurId(reqBO.getCreditOrgId());
        FscSupMerchantQryAtomRspBO atomRspBO = this.fscSupMerchantQryAtomService.qrySupMerchant(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        FscAccountPO accountPo = this.qryAccount(reqBO);
        FscAccountDealWelfareDeductBusiRspBO rspBO = new FscAccountDealWelfareDeductBusiRspBO();
        if (reqBO.getOperationType() == 0) {
            reqBO.setWelfareChargeCode(reqBO.getOrderNo());
            FscPayLogPO payLog = new FscPayLogPO();
            payLog.setWelfareChargeCode(reqBO.getWelfareChargeCode());
            ArrayList<Integer> categoryList = new ArrayList<Integer>();
            categoryList.add(FscConstants.FscBusiCategory.COMPANY_WELFARE_CHARGE);
            categoryList.add(FscConstants.FscBusiCategory.UNION_WELFARE_CHARGE);
            payLog.setBusiCategoryList(categoryList);
            payLog = this.fscPayLogMapper.getLastLog(payLog);
            if (payLog == null) {
                rspBO = this.dealWelfareCharge(accountPo, atomRspBO, reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            this.dealMoreRefund(reqBO, payLog, atomRspBO);
            accountPo = this.qryAccount(reqBO);
            rspBO = this.dealWelfareCharge(accountPo, atomRspBO, reqBO);
        } else if (reqBO.getOperationType() == 1) {
            this.dealWelfareRefund(accountPo, atomRspBO, reqBO, true, null);
        } else if (reqBO.getOperationType() == 2) {
            this.dealOrderPay(accountPo, atomRspBO, reqBO);
        } else {
            this.dealOrderRefund(accountPo, atomRspBO, reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscAccountPO qryAccount(FscAccountDealWelfareDeductBusiReqBO reqBO) {
        FscAccountPO accountPo = new FscAccountPO();
        accountPo.setOrgId(reqBO.getCreditOrgId());
        accountPo.setBusiType("4");
        accountPo = this.fscAccountMapper.getModelBy(accountPo);
        if (accountPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237\u4fe1\u606f\uff01\u8bf7\u5148\u7ef4\u62a4\u8d26\u6237\u4fe1\u606f\u6216\u5c06\u8d26\u6237\u7c7b\u578b\u589e\u52a0\u5458\u5de5\u8d85\u5e02\u3002");
        }
        return accountPo;
    }

    private void dealMoreRefund(FscAccountDealWelfareDeductBusiReqBO reqBO, FscPayLogPO payLog, FscSupMerchantQryAtomRspBO atomRspBO) {
        FscAccountDealWelfareDeductBusiReqBO refundReqBO = (FscAccountDealWelfareDeductBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscAccountDealWelfareDeductBusiReqBO.class));
        refundReqBO.setTotalAmount(payLog.getBusiAmount().abs().negate());
        refundReqBO.setCreditOrgId(payLog.getOrgId());
        refundReqBO.setWelfareType(payLog.getAccountType());
        refundReqBO.setPayType(payLog.getAdvancePayType().equals(FscConstants.AdvancePayType.CREDIT_PAY) ? 2 : 3);
        FscAccountPO refundAccount = new FscAccountPO();
        refundAccount.setOrgId(payLog.getOrgId());
        refundAccount.setBusiType("4");
        refundAccount = this.fscAccountMapper.getModelBy(refundAccount);
        if (reqBO.getCreditOrgId().equals(payLog.getOrgId()) && reqBO.getWelfareType().equals(payLog.getAccountType()) && reqBO.getPayType().equals(refundReqBO.getPayType())) {
            this.dealWelfareRefund(refundAccount, atomRspBO, refundReqBO, false, payLog.getId());
        } else {
            this.dealWelfareRefund(refundAccount, atomRspBO, refundReqBO, true, null);
        }
    }

    private FscAccountDealWelfareDeductBusiRspBO dealWelfareCharge(FscAccountPO accountPo, FscSupMerchantQryAtomRspBO atomRspBO, FscAccountDealWelfareDeductBusiReqBO reqBO) {
        BigDecimal totalAvailableCreditAmt = BigDecimal.ZERO;
        BigDecimal totalAvailableAdvanceAmt = BigDecimal.ZERO;
        accountPo.setOrderAmount(reqBO.getTotalAmount());
        accountPo.setCompanyCreditAmount(atomRspBO.getCompanyCreditAmount() == null ? BigDecimal.ZERO : atomRspBO.getCompanyCreditAmount());
        accountPo.setUnionCreditAmount(atomRspBO.getUnionCreditAmount() == null ? BigDecimal.ZERO : atomRspBO.getUnionCreditAmount());
        accountPo.setCompanyOverdraft(atomRspBO.getCompanyOverdraft() == null ? BigDecimal.ZERO : atomRspBO.getCompanyOverdraft());
        accountPo.setUnionOverdraft(atomRspBO.getUnionOverdraft() == null ? BigDecimal.ZERO : atomRspBO.getUnionOverdraft());
        FscPayLogPO payLogPo = new FscPayLogPO();
        payLogPo.setAccountId(accountPo.getId());
        payLogPo.setBusiOrderType(Integer.valueOf(3));
        payLogPo.setDealType(FscConstants.WelfareDealType.ACCOUNT_FREEZE);
        payLogPo.setWelfareChargeCode(reqBO.getOrderNo());
        payLogPo.setBusiOrderId(reqBO.getOrderId());
        payLogPo.setOrgId(reqBO.getCreditOrgId());
        FscAccountDealWelfareDeductBusiRspBO rspBO = new FscAccountDealWelfareDeductBusiRspBO();
        if (reqBO.getPayType().equals(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD)) {
            payLogPo.setIsCredit(Integer.valueOf(1));
            payLogPo.setOverdraftAmt(reqBO.getTotalAmount());
            if (reqBO.getWelfareType() == 1) {
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.COMPANY_WELFARE_CHARGE);
                payLogPo.setAccountType(FscConstants.WelfareAccountType.COMPANY);
                totalAvailableCreditAmt = accountPo.getCompanyCreditAmount().subtract(accountPo.getCompanyCreditUseAmount());
                if (totalAvailableCreditAmt.compareTo(reqBO.getTotalAmount()) < 0) {
                    throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u5458\u5de5\u8d85\u5e02\u516c\u53f8\u6388\u4fe1\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff01\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8c03\u6574\u6388\u4fe1\u989d\u5ea6\u3002");
                }
                accountPo.setUnionCreditAmount(null);
            } else {
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.UNION_WELFARE_CHARGE);
                payLogPo.setAccountType(FscConstants.WelfareAccountType.UNION);
                totalAvailableCreditAmt = accountPo.getUnionCreditAmount().subtract(accountPo.getUnionUseAmount());
                if (totalAvailableCreditAmt.compareTo(reqBO.getTotalAmount()) < 0) {
                    throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u5458\u5de5\u8d85\u5e02\u5de5\u4f1a\u6388\u4fe1\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff01\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8c03\u6574\u6388\u4fe1\u989d\u5ea6\u3002");
                }
                accountPo.setCompanyCreditAmount(null);
            }
            int count = this.fscAccountMapper.updateWelfareCredit(accountPo);
            if (count < 1) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u6570\u636e\u5904\u7406\u7e41\u5fd9\uff01\u8bf7\u7a0d\u540e\u91cd\u65b0\u64cd\u4f5c");
            }
            payLogPo.setBusiBeforeAmount(totalAvailableCreditAmt);
            payLogPo.setBusiAfterAmount(totalAvailableCreditAmt.subtract(reqBO.getTotalAmount()));
            payLogPo.setAdvancePayType(FscConstants.AdvancePayType.CREDIT_PAY);
        } else {
            payLogPo.setIsCredit(Integer.valueOf(0));
            if (reqBO.getWelfareType() == 1) {
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.COMPANY_WELFARE_CHARGE);
                payLogPo.setAccountType(FscConstants.WelfareAccountType.COMPANY);
                totalAvailableAdvanceAmt = accountPo.getCompanyAdvanceAmount().subtract(accountPo.getCompanyFreezeAmount()).subtract(accountPo.getCompanyUseAmount());
                if (totalAvailableAdvanceAmt.compareTo(BigDecimal.ZERO) > 0) {
                    if (totalAvailableAdvanceAmt.compareTo(reqBO.getTotalAmount()) >= 0) {
                        payLogPo.setAdvanceBeforeAmount(totalAvailableAdvanceAmt);
                        payLogPo.setAdvanceAfterAmount(totalAvailableAdvanceAmt.subtract(reqBO.getTotalAmount()));
                        payLogPo.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_PAY);
                        payLogPo.setAdvanceAmt(reqBO.getTotalAmount());
                        rspBO.setAdvanceUseAmt(reqBO.getTotalAmount());
                        rspBO.setOverdraftUseAmt(BigDecimal.ZERO);
                    } else {
                        payLogPo.setAdvanceBeforeAmount(totalAvailableAdvanceAmt);
                        payLogPo.setAdvanceAfterAmount(BigDecimal.ZERO);
                        rspBO.setAdvanceUseAmt(totalAvailableAdvanceAmt);
                        payLogPo.setAdvanceAmt(totalAvailableAdvanceAmt);
                        totalAvailableAdvanceAmt = totalAvailableAdvanceAmt.add(accountPo.getCompanyOverdraft());
                        if (totalAvailableAdvanceAmt.compareTo(BigDecimal.ZERO) < 0 || totalAvailableAdvanceAmt.compareTo(reqBO.getTotalAmount()) < 0) {
                            throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u5458\u5de5\u8d85\u5e02\u516c\u53f8\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff01\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8c03\u6574\u989d\u5ea6\u3002");
                        }
                        payLogPo.setOverdraftBeforeAmount(accountPo.getCompanyOverdraft());
                        payLogPo.setOverdraftAfterAmount(totalAvailableAdvanceAmt.subtract(reqBO.getTotalAmount()));
                        payLogPo.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_OVERDRAFT_PAY);
                        payLogPo.setOverdraftAmt(payLogPo.getOverdraftBeforeAmount().subtract(payLogPo.getOverdraftAfterAmount()));
                        rspBO.setOverdraftUseAmt(payLogPo.getOverdraftBeforeAmount().subtract(payLogPo.getOverdraftAfterAmount()));
                    }
                } else {
                    totalAvailableAdvanceAmt = totalAvailableCreditAmt.add(accountPo.getCompanyOverdraft());
                    if (totalAvailableAdvanceAmt.compareTo(BigDecimal.ZERO) < 0 || totalAvailableAdvanceAmt.compareTo(reqBO.getTotalAmount()) < 0) {
                        throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u5458\u5de5\u8d85\u5e02\u516c\u53f8\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff01\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8c03\u6574\u989d\u5ea6\u3002");
                    }
                    payLogPo.setOverdraftBeforeAmount(totalAvailableAdvanceAmt);
                    payLogPo.setOverdraftAfterAmount(totalAvailableAdvanceAmt.subtract(reqBO.getTotalAmount()));
                    payLogPo.setAdvancePayType(FscConstants.AdvancePayType.OVERDRAFT_PAY);
                    payLogPo.setOverdraftAmt(reqBO.getTotalAmount());
                    rspBO.setAdvanceUseAmt(BigDecimal.ZERO);
                    rspBO.setOverdraftUseAmt(reqBO.getTotalAmount());
                }
                if (payLogPo.getOverdraftAfterAmount() != null) {
                    accountPo.setCompanyOverdraftAmount(accountPo.getCompanyOverdraft().subtract(payLogPo.getOverdraftAfterAmount()).abs());
                } else {
                    accountPo.setCompanyOverdraftAmount(BigDecimal.ZERO);
                }
                accountPo.setOverdraftAmount(rspBO.getOverdraftUseAmt());
                int count = this.fscAccountMapper.updateCompanyFreezeAmount(accountPo);
                if (count < 1) {
                    throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u6570\u636e\u5904\u7406\u7e41\u5fd9\uff01\u8bf7\u7a0d\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
                }
                this.inertWelfareCharge(payLogPo);
            } else {
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.UNION_WELFARE_CHARGE);
                payLogPo.setAccountType(FscConstants.WelfareAccountType.UNION);
                totalAvailableAdvanceAmt = accountPo.getUnionAdvanceAmount().subtract(accountPo.getUnionFreezeAmount()).subtract(accountPo.getUnionUseAmount());
                if (totalAvailableAdvanceAmt.compareTo(BigDecimal.ZERO) > 0) {
                    if (totalAvailableAdvanceAmt.compareTo(reqBO.getTotalAmount()) >= 0) {
                        payLogPo.setAdvanceBeforeAmount(totalAvailableAdvanceAmt);
                        payLogPo.setAdvanceAfterAmount(totalAvailableAdvanceAmt.subtract(reqBO.getTotalAmount()));
                        payLogPo.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_PAY);
                        payLogPo.setAdvanceAmt(reqBO.getTotalAmount());
                        rspBO.setAdvanceUseAmt(reqBO.getTotalAmount());
                        rspBO.setOverdraftUseAmt(BigDecimal.ZERO);
                    } else {
                        payLogPo.setAdvanceBeforeAmount(totalAvailableAdvanceAmt);
                        payLogPo.setAdvanceAfterAmount(BigDecimal.ZERO);
                        rspBO.setAdvanceUseAmt(totalAvailableAdvanceAmt);
                        payLogPo.setAdvanceAmt(totalAvailableAdvanceAmt);
                        totalAvailableAdvanceAmt = totalAvailableAdvanceAmt.add(accountPo.getUnionOverdraft());
                        if (totalAvailableAdvanceAmt.compareTo(BigDecimal.ZERO) < 0 || totalAvailableAdvanceAmt.compareTo(reqBO.getTotalAmount()) < 0) {
                            throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u5458\u5de5\u8d85\u5e02\u5de5\u4f1a\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff01\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8c03\u6574\u989d\u5ea6\u3002");
                        }
                        payLogPo.setOverdraftBeforeAmount(accountPo.getUnionOverdraft());
                        payLogPo.setOverdraftAfterAmount(totalAvailableAdvanceAmt.subtract(reqBO.getTotalAmount()));
                        payLogPo.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_OVERDRAFT_PAY);
                        payLogPo.setOverdraftAmt(payLogPo.getOverdraftBeforeAmount().subtract(payLogPo.getOverdraftAfterAmount()));
                        rspBO.setOverdraftUseAmt(payLogPo.getOverdraftBeforeAmount().subtract(payLogPo.getOverdraftAfterAmount()));
                    }
                } else {
                    totalAvailableAdvanceAmt = totalAvailableCreditAmt.add(accountPo.getUnionOverdraft());
                    if (totalAvailableAdvanceAmt.compareTo(BigDecimal.ZERO) < 0 || totalAvailableAdvanceAmt.compareTo(reqBO.getTotalAmount()) < 0) {
                        throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u5458\u5de5\u8d85\u5e02\u5de5\u4f1a\u900f\u652f\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff01\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8c03\u6574\u900f\u652f\u989d\u5ea6\u3002");
                    }
                    payLogPo.setOverdraftAmt(reqBO.getTotalAmount());
                    payLogPo.setOverdraftBeforeAmount(totalAvailableAdvanceAmt);
                    payLogPo.setOverdraftAfterAmount(totalAvailableAdvanceAmt.subtract(reqBO.getTotalAmount()));
                    payLogPo.setAdvancePayType(FscConstants.AdvancePayType.OVERDRAFT_PAY);
                    rspBO.setAdvanceUseAmt(BigDecimal.ZERO);
                    rspBO.setOverdraftUseAmt(reqBO.getTotalAmount());
                }
                if (payLogPo.getOverdraftAfterAmount() != null) {
                    accountPo.setUnionOverdraftAmount(accountPo.getUnionOverdraft().subtract(payLogPo.getOverdraftAfterAmount()).abs());
                } else {
                    accountPo.setUnionOverdraftAmount(BigDecimal.ZERO);
                }
                accountPo.setOverdraftAmount(rspBO.getOverdraftUseAmt());
                int count = this.fscAccountMapper.updateUnionFreezeAmount(accountPo);
                if (count < 1) {
                    throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u6570\u636e\u5904\u7406\u7e41\u5fd9\uff01\u8bf7\u7a0d\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
                }
            }
            this.inertWelfareCharge(payLogPo);
        }
        this.insertPayLog(payLogPo, reqBO);
        return rspBO;
    }

    private void dealWelfareRefund(FscAccountPO accountPo, FscSupMerchantQryAtomRspBO atomRspBO, FscAccountDealWelfareDeductBusiReqBO reqBO, Boolean needPayLog, Long payLogId) {
        int count;
        accountPo.setOrderAmount(reqBO.getTotalAmount());
        FscPayLogPO payLogPo = new FscPayLogPO();
        payLogPo.setAccountId(accountPo.getId());
        payLogPo.setBusiOrderType(Integer.valueOf(3));
        payLogPo.setDealType(FscConstants.WelfareDealType.ACCOUNT_UN_FREEZE);
        payLogPo.setWelfareChargeCode(reqBO.getOrderNo());
        payLogPo.setOverdraftAmt(BigDecimal.ZERO);
        BigDecimal totalAvailableCreditAmount = BigDecimal.ZERO;
        BigDecimal totalAvailableAdvanceAmt = BigDecimal.ZERO;
        if (reqBO.getPayType().equals(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD)) {
            payLogPo.setIsCredit(Integer.valueOf(1));
            if (reqBO.getWelfareType() == 1) {
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.COMPANY_WELFARE_REFUND);
                payLogPo.setAccountType(FscConstants.WelfareAccountType.COMPANY);
                totalAvailableCreditAmount = accountPo.getCompanyCreditAmount().subtract(accountPo.getCompanyCreditUseAmount());
                payLogPo.setBusiBeforeAmount(totalAvailableCreditAmount);
                payLogPo.setBusiAfterAmount(totalAvailableCreditAmount.subtract(reqBO.getTotalAmount()));
                payLogPo.setAdvancePayType(FscConstants.AdvancePayType.CREDIT_PAY);
                accountPo.setUnionCreditAmount(null);
            } else {
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.UNION_WELFARE_REFUND);
                payLogPo.setAccountType(FscConstants.WelfareAccountType.UNION);
                totalAvailableCreditAmount = accountPo.getUnionCreditAmount().subtract(accountPo.getUnionCreditUseAmount());
                payLogPo.setBusiBeforeAmount(totalAvailableCreditAmount);
                payLogPo.setBusiAfterAmount(totalAvailableCreditAmount.subtract(reqBO.getTotalAmount()));
                payLogPo.setAdvancePayType(FscConstants.AdvancePayType.CREDIT_PAY);
                accountPo.setCompanyCreditAmount(null);
            }
            int count2 = this.fscAccountMapper.updateWelfareCredit(accountPo);
            if (count2 < 1) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u6570\u636e\u5904\u7406\u7e41\u5fd9\uff01\u8bf7\u7a0d\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
            }
        } else {
            payLogPo.setIsCredit(Integer.valueOf(0));
            BigDecimal refundAmt = reqBO.getTotalAmount().abs();
            if (reqBO.getWelfareType() == 1) {
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.COMPANY_WELFARE_REFUND);
                payLogPo.setAccountType(FscConstants.WelfareAccountType.COMPANY);
                totalAvailableAdvanceAmt = accountPo.getCompanyAdvanceAmount().subtract(accountPo.getCompanyFreezeAmount()).subtract(accountPo.getCompanyUseAmount());
                if (totalAvailableAdvanceAmt.compareTo(BigDecimal.ZERO) > 0) {
                    payLogPo.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_PAY);
                    payLogPo.setAdvanceBeforeAmount(totalAvailableAdvanceAmt);
                    payLogPo.setAdvanceAfterAmount(totalAvailableAdvanceAmt.add(refundAmt));
                    payLogPo.setAdvanceAmt(refundAmt);
                } else if (totalAvailableAdvanceAmt.add(refundAmt).compareTo(BigDecimal.ZERO) > 0) {
                    payLogPo.setOverdraftBeforeAmount(totalAvailableAdvanceAmt.add(accountPo.getCompanyOverdraft()));
                    payLogPo.setOverdraftAfterAmount(accountPo.getCompanyOverdraft());
                    payLogPo.setAdvanceBeforeAmount(BigDecimal.ZERO);
                    payLogPo.setAdvanceAfterAmount(totalAvailableAdvanceAmt.add(refundAmt));
                    payLogPo.setOverdraftAmt(payLogPo.getOverdraftAfterAmount().subtract(payLogPo.getOverdraftBeforeAmount()));
                    payLogPo.setAdvanceAmt(totalAvailableAdvanceAmt.add(refundAmt));
                } else {
                    totalAvailableAdvanceAmt = totalAvailableAdvanceAmt.add(accountPo.getCompanyOverdraft());
                    payLogPo.setOverdraftBeforeAmount(totalAvailableAdvanceAmt);
                    payLogPo.setOverdraftAfterAmount(totalAvailableAdvanceAmt.add(refundAmt));
                    payLogPo.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_OVERDRAFT_PAY);
                    payLogPo.setOverdraftAmt(refundAmt);
                }
                accountPo.setOverdraftAmount(payLogPo.getOverdraftAmt().negate());
                if (payLogPo.getOverdraftAfterAmount() != null) {
                    accountPo.setCompanyOverdraftAmount(accountPo.getCompanyOverdraft().subtract(payLogPo.getOverdraftAfterAmount()).abs());
                } else {
                    accountPo.setCompanyOverdraftAmount(BigDecimal.ZERO);
                }
                count = this.fscAccountMapper.updateCompanyFreezeAmount(accountPo);
                if (count < 1) {
                    throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u6570\u636e\u5904\u7406\u7e41\u5fd9\uff01\u8bf7\u7a0d\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
                }
            } else {
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.UNION_WELFARE_REFUND);
                payLogPo.setAccountType(FscConstants.WelfareAccountType.UNION);
                totalAvailableAdvanceAmt = accountPo.getUnionAdvanceAmount().subtract(accountPo.getUnionFreezeAmount()).subtract(accountPo.getUnionUseAmount());
                if (totalAvailableAdvanceAmt.compareTo(BigDecimal.ZERO) > 0) {
                    payLogPo.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_PAY);
                    payLogPo.setAdvanceBeforeAmount(totalAvailableAdvanceAmt);
                    payLogPo.setAdvanceAfterAmount(totalAvailableAdvanceAmt.add(refundAmt));
                    payLogPo.setAdvanceAmt(refundAmt);
                } else if (totalAvailableAdvanceAmt.add(refundAmt).compareTo(BigDecimal.ZERO) > 0) {
                    payLogPo.setOverdraftBeforeAmount(totalAvailableAdvanceAmt.add(accountPo.getUnionOverdraft()));
                    payLogPo.setOverdraftAfterAmount(accountPo.getCompanyOverdraft());
                    payLogPo.setAdvanceBeforeAmount(BigDecimal.ZERO);
                    payLogPo.setAdvanceAfterAmount(totalAvailableAdvanceAmt.add(refundAmt));
                    payLogPo.setOverdraftAmt(totalAvailableAdvanceAmt.add(accountPo.getUnionOverdraft()));
                    payLogPo.setAdvanceAmt(totalAvailableAdvanceAmt.add(refundAmt));
                    payLogPo.setAdvancePayType(FscConstants.AdvancePayType.OVERDRAFT_PAY);
                } else {
                    totalAvailableAdvanceAmt = totalAvailableAdvanceAmt.add(accountPo.getCompanyOverdraft());
                    payLogPo.setOverdraftBeforeAmount(totalAvailableAdvanceAmt);
                    payLogPo.setOverdraftAfterAmount(totalAvailableAdvanceAmt.add(refundAmt));
                    payLogPo.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_OVERDRAFT_PAY);
                    payLogPo.setOverdraftAmt(refundAmt);
                }
                if (payLogPo.getOverdraftAfterAmount() != null) {
                    accountPo.setUnionOverdraftAmount(accountPo.getUnionOverdraft().subtract(payLogPo.getOverdraftAfterAmount()).abs());
                } else {
                    accountPo.setUnionOverdraftAmount(BigDecimal.ZERO);
                }
                accountPo.setOverdraftAmount(payLogPo.getOverdraftAmt().negate());
                count = this.fscAccountMapper.updateUnionFreezeAmount(accountPo);
                if (count < 1) {
                    throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "\u6570\u636e\u5904\u7406\u7e41\u5fd9\uff01\u8bf7\u7a0d\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
                }
            }
            this.dealWelfareChargeRefund(payLogPo);
        }
        if (needPayLog.booleanValue()) {
            this.insertPayLog(payLogPo, reqBO);
        } else {
            FscPayLogPO logPo = new FscPayLogPO();
            logPo.setBusiCategory(FscConstants.FscBusiCategory.COMPANY_WELFARE_CHARGE);
            logPo.setWelfareChargeCode(reqBO.getOrderNo());
            logPo.setOrgId(reqBO.getCreditOrgId());
            logPo.setId(payLogId);
            count = this.fscPayLogMapper.deleteChargeLog(logPo);
            if (count != 1) {
                throw new FscBusinessException("198888", "\u5220\u9664\u4ea4\u6613\u8bb0\u5f55\u6d41\u6c34\u5931\u8d25\uff01");
            }
        }
    }

    private void dealOrderPay(FscAccountPO accountPo, FscSupMerchantQryAtomRspBO atomRspBO, FscAccountDealWelfareDeductBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getWelfareChargeCode())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u798f\u70b9\u53d1\u653e\u7f16\u7801[welfarePointCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscPayLogPO payLogPo = this.selectChargeLog(reqBO);
        payLogPo.setDealType(FscConstants.WelfareDealType.ORDER_INSPECTION);
        payLogPo.setBusiOrderNo(reqBO.getOrderNo());
        payLogPo.setWelfarePointName(reqBO.getWelfarePointName());
        payLogPo.setWelfarePointCode(reqBO.getWelfarePointCode());
        payLogPo.setWelfareChargeCode(reqBO.getWelfareChargeCode());
        payLogPo.setBusiAmount(reqBO.getTotalAmount());
        payLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_WELFARE_PAY);
        accountPo.setOrderAmount(reqBO.getTotalAmount());
        if (reqBO.getPayType().equals(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE)) {
            int count;
            if (reqBO.getWelfareType() == 1 ? (count = this.fscAccountMapper.updateCompanyUseAmount(accountPo)) != 1 : (count = this.fscAccountMapper.updateUnionUseAmount(accountPo)) != 1) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u6570\u636e\u5f02\u5e38\uff01\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002");
            }
            this.dealOrderPayLog(payLogPo);
        }
        this.insertPayLog(payLogPo, reqBO);
    }

    private void dealOrderRefund(FscAccountPO accountPo, FscSupMerchantQryAtomRspBO atomRspBO, FscAccountDealWelfareDeductBusiReqBO reqBO) {
        int count;
        FscPayLogPO payLogPo = new FscPayLogPO();
        payLogPo.setBusiOrderNo(reqBO.getOrderNo());
        payLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_WELFARE_PAY);
        payLogPo = this.fscPayLogMapper.getModelBy(payLogPo);
        if (payLogPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u9a8c\u6536\u6263\u6b3e\u4fe1\u606f\uff01");
        }
        payLogPo.setDealType(FscConstants.WelfareDealType.ACCOUNT_RETURN);
        payLogPo.setBusiOrderNo(reqBO.getOrderNo());
        accountPo.setOrderAmount(reqBO.getTotalAmount());
        if (payLogPo.getAccountType() == 1 ? (count = this.fscAccountMapper.updateCompanyUseAmount(accountPo)) != 1 : (count = this.fscAccountMapper.updateUnionUseAmount(accountPo)) != 1) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u8d26\u6237[" + accountPo.getAccountNo() + "]\u6570\u636e\u5f02\u5e38\uff01\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002");
        }
        this.insertPayLog(payLogPo, reqBO);
    }

    private void dealCheck(FscAccountDealWelfareDeductBusiReqBO reqBO) {
        if (reqBO.getObjId() != null) {
            FscPayLogPO payLogPo = new FscPayLogPO();
            payLogPo.setBusiOrderId(reqBO.getOrderId());
            payLogPo.setObjId(reqBO.getObjId());
            int count = this.fscPayLogMapper.getCheckBy(payLogPo);
            if (count > 0) {
                throw new FscBusinessException("198888", "\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u9000\u6b3e\uff01");
            }
        }
    }

    private void insertPayLog(FscPayLogPO payLogPo, FscAccountDealWelfareDeductBusiReqBO reqBO) {
        Date now = new Date();
        long nextId = Sequence.getInstance().nextId();
        payLogPo.setId(Long.valueOf(nextId));
        payLogPo.setOrgId(reqBO.getCreditOrgId());
        payLogPo.setUserName(reqBO.getName());
        payLogPo.setBusiTime(now);
        payLogPo.setPayeeId(reqBO.getSupId());
        payLogPo.setBusiOrderType(reqBO.getBusiOrderType());
        payLogPo.setBusiOrderId(reqBO.getOrderId());
        payLogPo.setOrderType(reqBO.getOrderType());
        payLogPo.setBusiAmount(reqBO.getTotalAmount().negate());
        payLogPo.setPayBusiness("4");
        payLogPo.setObjId(reqBO.getObjId());
        payLogPo.setCreateTime(now);
        payLogPo.setAccountType(reqBO.getWelfareType());
        payLogPo.setWelfarePointCode(reqBO.getWelfarePointCode());
        payLogPo.setWelfarePointName(reqBO.getWelfarePointName());
        this.fscPayLogMapper.insertOne(payLogPo);
    }

    private void dealOrderPayLog(FscPayLogPO payLogPo) {
        FscWelfareChargeConsumerPO consumerPo = new FscWelfareChargeConsumerPO();
        consumerPo.setWelfareChargeCode(payLogPo.getWelfareChargeCode());
        consumerPo = this.fscWelfareChargeConsumerMapper.getModelBy(consumerPo);
        if (consumerPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u798f\u70b9\u5145\u503c\u8bb0\u5f55");
        }
        payLogPo.setOverdraftAmt(BigDecimal.ZERO);
        payLogPo.setAdvanceAmt(BigDecimal.ZERO);
        if (consumerPo.getAdvanceAmount().compareTo(BigDecimal.ZERO) == 0) {
            payLogPo.setOverdraftAmt(payLogPo.getBusiAmount().abs());
        } else if (consumerPo.getOverdraftAmount().compareTo(BigDecimal.ZERO) == 0) {
            payLogPo.setAdvanceAmt(payLogPo.getBusiAmount().abs());
        } else {
            BigDecimal advanceAmt = consumerPo.getAdvanceAmount().subtract(consumerPo.getAdvanceUseAmount());
            if (payLogPo.getBusiAmount().compareTo(advanceAmt) <= 0) {
                payLogPo.setAdvanceAmt(payLogPo.getBusiAmount());
            } else {
                payLogPo.setAdvanceAmt(advanceAmt);
                payLogPo.setOverdraftAmt(payLogPo.getBusiAmount().subtract(advanceAmt));
            }
        }
        consumerPo.setOverdraftUseAmount(payLogPo.getOverdraftAmt());
        consumerPo.setAdvanceUseAmount(payLogPo.getAdvanceAmt());
        int count = this.fscWelfareChargeConsumerMapper.updateUseAmount(consumerPo);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
    }

    private void inertWelfareCharge(FscPayLogPO payLogPo) {
        FscWelfareChargeConsumerPO consumerPo = new FscWelfareChargeConsumerPO();
        consumerPo.setWelfareChargeCode(payLogPo.getWelfareChargeCode());
        consumerPo = this.fscWelfareChargeConsumerMapper.getModelBy(consumerPo);
        if (consumerPo == null) {
            consumerPo = new FscWelfareChargeConsumerPO();
            consumerPo.setId(payLogPo.getBusiOrderId());
            consumerPo.setWelfareChargeCode(payLogPo.getWelfareChargeCode());
            consumerPo.setAdvanceAmount(payLogPo.getAdvanceAmt() == null ? BigDecimal.ZERO : payLogPo.getAdvanceAmt());
            consumerPo.setOverdraftAmount(payLogPo.getOverdraftAmt() == null ? BigDecimal.ZERO : payLogPo.getOverdraftAmt());
            consumerPo.setAdvanceUseAmount(BigDecimal.ZERO);
            consumerPo.setOverdraftUseAmount(BigDecimal.ZERO);
            consumerPo.setOrgId(payLogPo.getOrgId());
            consumerPo.setWelfareType(payLogPo.getAccountType());
            this.fscWelfareChargeConsumerMapper.insert(consumerPo);
        } else {
            consumerPo.setAdvanceAmount(payLogPo.getAdvanceAmt());
            consumerPo.setOverdraftAmount(payLogPo.getOverdraftAmt());
            consumerPo.setAdvanceUseAmount(BigDecimal.ZERO);
            consumerPo.setOverdraftUseAmount(BigDecimal.ZERO);
            consumerPo.setOrgId(payLogPo.getOrgId());
            consumerPo.setWelfareType(payLogPo.getAccountType());
            this.fscWelfareChargeConsumerMapper.update(consumerPo);
        }
    }

    private void dealWelfareChargeRefund(FscPayLogPO payLogPo) {
        BigDecimal advanceAmt;
        FscWelfareChargeConsumerPO consumerPo = new FscWelfareChargeConsumerPO();
        consumerPo.setWelfareChargeCode(payLogPo.getWelfareChargeCode());
        consumerPo = this.fscWelfareChargeConsumerMapper.getModelBy(consumerPo);
        if (consumerPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u798f\u70b9\u5145\u503c\u8bb0\u5f55\uff01");
        }
        BigDecimal overdraftAmt = payLogPo.getOverdraftAmt() == null ? BigDecimal.ZERO : payLogPo.getOverdraftAmt();
        BigDecimal bigDecimal = advanceAmt = payLogPo.getAdvanceAmt() == null ? BigDecimal.ZERO : payLogPo.getAdvanceAmt();
        if (consumerPo.getAdvanceAmount().equals(advanceAmt) && consumerPo.getOverdraftAmount().equals(overdraftAmt)) {
            return;
        }
        consumerPo.setOverdraftAmount(overdraftAmt);
        consumerPo.setAdvanceAmount(advanceAmt);
        int count = this.fscWelfareChargeConsumerMapper.updateByRefund(consumerPo);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u6570\u636e\u5904\u7406\u7e41\u5fd9,\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01");
        }
    }

    private FscPayLogPO selectChargeLog(FscAccountDealWelfareDeductBusiReqBO reqBO) {
        FscPayLogPO payLog = new FscPayLogPO();
        payLog.setWelfareChargeCode(reqBO.getWelfareChargeCode());
        ArrayList<Integer> categoryList = new ArrayList<Integer>();
        categoryList.add(FscConstants.FscBusiCategory.COMPANY_WELFARE_CHARGE);
        categoryList.add(FscConstants.FscBusiCategory.UNION_WELFARE_CHARGE);
        payLog.setBusiCategoryList(categoryList);
        payLog = this.fscPayLogMapper.getLastLog(payLog);
        if (payLog == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u798f\u70b9\u5145\u503c\u8bb0\u5f55\uff01");
        }
        return payLog;
    }
}

