/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.common.busi.api.FscAdvanceBillCreatePayBusiService;
import com.tydic.fsc.common.busi.bo.FscAdvanceBillCreatePayBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAdvanceBillCreatePayBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.enums.AdvancePayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayShouldPayCreateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayShouldPayCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayShouldPayCreateAbilityRspBO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAdvanceBillCreatePayBusiServiceImpl
implements FscAdvanceBillCreatePayBusiService {
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    @Value(value="${acceptOrderTabId:80013}")
    private Integer TAB_ID;
    @Autowired
    private FscPayShouldPayCreateAbilityService fscPayShouldPayCreateAbilityService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @Override
    public FscAdvanceBillCreatePayBusiRspBO createAdvancePayBill(FscAdvanceBillCreatePayBusiReqBO reqBO) {
        if (reqBO.getOrderNo() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2oderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UocInspectionDetailsListPageQueryReqBO queryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        queryReqBO.setSaleVoucherNo(reqBO.getOrderNo());
        queryReqBO.setTabId(this.TAB_ID);
        queryReqBO.setIsAfterSales(Boolean.valueOf(false));
        queryReqBO.setIsChange("0");
        queryReqBO.setIsFscQuery("0");
        UocInspectionDetailsListPageQueryRspBO queryRspBO = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(queryReqBO);
        if (!queryRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(queryRspBO.getRespCode(), queryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)queryRspBO.getRows())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9a8c\u6536\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        ArrayList<FscShouldPayBO> shouldPayList = new ArrayList<FscShouldPayBO>();
        BigDecimal shouldPayAmount = BigDecimal.ZERO;
        for (UocInspectionDetailsListBO row : queryRspBO.getRows()) {
            shouldPayAmount = shouldPayAmount.add(row.getInspTotalSaleMoney());
        }
        UocInspectionDetailsListBO row = (UocInspectionDetailsListBO)queryRspBO.getRows().get(0);
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setAcceptOrderCode(row.getInspectionVoucherCode());
        fscShouldPayBO.setAcceptOrderId(Long.valueOf(row.getInspectionVoucherId()));
        fscShouldPayBO.setBuyerName(row.getBuynerName());
        fscShouldPayBO.setBuyerNo(row.getBuynerNo());
        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SALE_ORDER);
        fscShouldPayBO.setOrderId(Long.valueOf(row.getOrderId()));
        fscShouldPayBO.setObjectId(Long.valueOf(row.getOrderId()));
        fscShouldPayBO.setObjectNo(row.getSaleVoucherNo());
        fscShouldPayBO.setOrderType(row.getOrderType());
        fscShouldPayBO.setOrderSource(Integer.valueOf(row.getOrderSource()));
        fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_ADVANCE_PAY);
        fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE);
        fscShouldPayBO.setPenaltyRatio(BigDecimal.ZERO);
        fscShouldPayBO.setShouldPayAmount(shouldPayAmount);
        fscShouldPayBO.setTradeMode(row.getTradeMode());
        fscShouldPayBO.setPayerId(Long.valueOf(row.getBuynerId()));
        fscShouldPayBO.setPayerName(row.getPurName());
        fscShouldPayBO.setPayeeId(Long.valueOf(row.getProNo()));
        fscShouldPayBO.setPayeeName(row.getProName());
        shouldPayList.add(fscShouldPayBO);
        FscPayShouldPayCreateAbilityReqBO abilityReqBO = new FscPayShouldPayCreateAbilityReqBO();
        abilityReqBO.setFscShouldPayBOS(shouldPayList);
        FscAccountPO accountVo = new FscAccountPO();
        accountVo.setOrgCode(row.getBuynerNo());
        accountVo.setBusiType("1");
        FscAccountPO fscAccountPO = this.fscAccountMapper.getModelBy(accountVo);
        if (fscAccountPO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u4e92\u4fe1\u606f\uff01");
        }
        FscPayShouldPayCreateAbilityRspBO abilityRspBO = this.fscPayShouldPayCreateAbilityService.dealShouldPayCreate(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
        fscAccountPO.setUseAmount(shouldPayAmount);
        int count = this.fscAccountMapper.addUseAmount(fscAccountPO);
        if (count < 0) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.writeAdviceLog(fscShouldPayBO, fscAccountPO, row.getInspectionOper());
        String respString = JSONObject.toJSONString((Object)abilityRspBO);
        return (FscAdvanceBillCreatePayBusiRspBO)((Object)JSONObject.parseObject((String)respString, FscAdvanceBillCreatePayBusiRspBO.class));
    }

    private void writeAdviceLog(FscShouldPayBO fscShouldPayBO, FscAccountPO fscAccountPO, String name) {
        Date now = new Date();
        FscPayLogPO fscPayLogPo = new FscPayLogPO();
        fscPayLogPo.setBusiOrderNo(fscShouldPayBO.getObjectNo());
        fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
        FscPayLogPO freezePo = this.fscPayLogMapper.getModelBy(fscPayLogPo);
        if (freezePo == null) {
            throw new FscBusinessException("194304", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u51bb\u7ed3\u8bb0\u5f55");
        }
        long nextId = Sequence.getInstance().nextId();
        fscPayLogPo.setId(Long.valueOf(nextId));
        fscPayLogPo.setOrgId(fscShouldPayBO.getPayerId());
        fscPayLogPo.setUserName(name);
        fscPayLogPo.setBusiTime(now);
        fscPayLogPo.setPayeeId(fscShouldPayBO.getPayeeId());
        fscPayLogPo.setBusiOrderType(Integer.valueOf(2));
        fscPayLogPo.setOrderType(fscShouldPayBO.getOrderType());
        fscPayLogPo.setTradeMode(fscShouldPayBO.getTradeMode());
        fscPayLogPo.setBusiAmount(fscShouldPayBO.getShouldPayAmount());
        fscPayLogPo.setPayBusiness("1");
        fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_PAY);
        fscPayLogPo.setOrgCode(fscShouldPayBO.getBuyerNo());
        fscPayLogPo.setAccountId(fscAccountPO.getId());
        fscPayLogPo.setIsCredit(Integer.valueOf(1));
        fscPayLogPo.setCreateTime(now);
        fscPayLogPo.setCreateOperId("\u7cfb\u7edf");
        fscPayLogPo.setOverdraftBeforeAmount(freezePo.getOverdraftBeforeAmount() == null ? BigDecimal.ZERO : freezePo.getOverdraftBeforeAmount());
        fscPayLogPo.setOverdraftAfterAmount(freezePo.getOverdraftAfterAmount() == null ? BigDecimal.ZERO : freezePo.getOverdraftAfterAmount());
        fscPayLogPo.setAdvanceBeforeAmount(freezePo.getAdvanceBeforeAmount() == null ? BigDecimal.ZERO : freezePo.getAdvanceBeforeAmount());
        fscPayLogPo.setAdvanceAfterAmount(freezePo.getAdvanceAfterAmount() == null ? BigDecimal.ZERO : freezePo.getAdvanceAfterAmount());
        fscPayLogPo.setAdvanceAmt(fscPayLogPo.getAdvanceBeforeAmount().subtract(fscPayLogPo.getAdvanceAfterAmount()));
        fscPayLogPo.setOverdraftAmt(fscPayLogPo.getOverdraftBeforeAmount().subtract(fscPayLogPo.getOverdraftAfterAmount()));
        fscPayLogPo.setReimbursementAmount(BigDecimal.ZERO);
        if (fscPayLogPo.getOverdraftAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT.getCode());
        } else if (fscPayLogPo.getAdvanceAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.OVERDRAFT.getCode());
        } else {
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT_DEPOSIT.getCode());
        }
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBO.setTabId(this.TAB_ID);
        uocInspectionDetailsListPageQueryReqBO.setSaleVoucherNo(fscPayLogPo.getBusiOrderNo());
        uocInspectionDetailsListPageQueryReqBO.setPageSize(1);
        uocInspectionDetailsListPageQueryReqBO.setPageNo(1);
        UocInspectionDetailsListPageQueryRspBO uocInspectionDetailsListPageQueryRspBO = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
        if ("0000".equals(uocInspectionDetailsListPageQueryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryRspBO.getRows())) {
            UocInspectionDetailsListBO uocInspectionDetailsListBO = (UocInspectionDetailsListBO)uocInspectionDetailsListPageQueryRspBO.getRows().get(0);
            fscPayLogPo.setBusiOrderId(Long.valueOf(Long.parseLong(uocInspectionDetailsListBO.getOrderId())));
            fscPayLogPo.setAcceptId(uocInspectionDetailsListBO.getInspectionVoucherId());
            fscPayLogPo.setAcceptCode(uocInspectionDetailsListBO.getInspectionVoucherCode());
            fscPayLogPo.setErpAcceptCode(uocInspectionDetailsListBO.getErpInspectionVoucherCode());
        }
        this.fscPayLogMapper.insert(fscPayLogPo);
    }
}

