/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.esb.FscClaimSendYcCancelService;
import com.tydic.fsc.common.ability.api.FscAccountBillListQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.busi.api.FscEmployeeAccountChargeClaimWelfareBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountAmountBo;
import com.tydic.fsc.common.busi.bo.FscAccountChargeClaimBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeClaimBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscWelfareChargeConsumerMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.po.FscWelfareChargeConsumerPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscEmployeeAccountChargeClaimWelfareBusiServiceImpl
implements FscEmployeeAccountChargeClaimWelfareBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEmployeeAccountChargeClaimWelfareBusiServiceImpl.class);
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private FscClaimSendYcCancelService fscClaimSendYcCancelService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAccountBillListQueryAbilityService fscAccountBillListQueryAbilityService;
    @Autowired
    private FscWelfareChargeConsumerMapper fscWelfareChargeConsumerMapper;
    private static final Integer TAB_ID = 60001;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @Override
    @FscDuplicateCommitLimit
    public FscAccountChargeClaimBusiRspBO dealAccountChargeClaim(FscAccountChargeClaimBusiReqBO reqBO) {
        FscRecvClaimPO fscRecvClaimPo;
        Map<Long, Object> chargeDetailMap;
        FscAccountChargePO fscAccountChargePo = this.fscAccountChargeMapper.queryById(reqBO.getChargeId());
        if (fscAccountChargePo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5145\u503c\u76f8\u5173\u4fe1\u606f!");
        }
        List<Object> accountIdList = new ArrayList<Long>();
        if (reqBO.getOperationType() != 2) {
            List chargeDetailList = this.fscAccountChargeDetailMapper.queryByChargeId(reqBO.getChargeId());
            if (Objects.isNull(fscAccountChargePo.getAccountId())) {
                accountIdList = chargeDetailList.stream().map(FscAccountChargeDetailPO::getAccountId).collect(Collectors.toList());
                chargeDetailMap = chargeDetailList.stream().collect(Collectors.toMap(FscAccountChargeDetailPO::getAccountId, Function.identity(), (k1, k2) -> k1));
            } else {
                accountIdList.add(fscAccountChargePo.getAccountId());
                chargeDetailMap = new HashMap();
                chargeDetailMap.put(fscAccountChargePo.getAccountId(), chargeDetailList.get(0));
            }
            if (CollectionUtils.isEmpty(accountIdList)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5145\u503c\u8d26\u6237\u4fe1\u606f!");
            }
            if (StringUtils.isEmpty((Object)reqBO.getClaimNo())) {
                throw new FscBusinessException("190000", "\u5165\u53c2claimNo\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            fscRecvClaimPo = this.fscRecvClaimMapper.queryByClaimNo(reqBO.getClaimNo());
            if (fscRecvClaimPo == null) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u76f8\u5173\u4fe1\u606f!");
            }
            if (fscRecvClaimPo.getClaimStatus().equals(FscClaimStatusEnum.CLAIM.getCode())) {
                throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u5df2\u5b8c\u6210\u8ba4\u9886\uff01");
            }
            if (fscAccountChargePo.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) > 0) {
                throw new FscBusinessException("190000", "\u672a\u8ba4\u9886\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u9884\u5b58\u91d1\u989d\uff01");
            }
        } else {
            fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_REJECT);
            fscAccountChargePo.setAuditStatus(FscConstants.AuditStatus.SAVE);
            fscAccountChargePo.setReturnReason(reqBO.getReturnReason());
            this.fscAccountChargeMapper.update(fscAccountChargePo);
            FscAccountChargeClaimBusiRspBO busiRspBO = new FscAccountChargeClaimBusiRspBO();
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u6210\u529f");
            return busiRspBO;
        }
        ArrayList<FscClaimDetailBO> pushDetailList = new ArrayList<FscClaimDetailBO>();
        accountIdList.forEach(e -> {
            int insertPayLog;
            FscAccountPO queryVo = new FscAccountPO();
            queryVo.setId(e);
            FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
            FscAccountAmountBo befoer = this.getAmount(fscAccountPo);
            BigDecimal chargeAmountCompany = ((FscAccountChargeDetailPO)chargeDetailMap.get(e)).getCompanyAmount() == null ? BigDecimal.ZERO : ((FscAccountChargeDetailPO)chargeDetailMap.get(e)).getCompanyAmount();
            BigDecimal chargeAmountUnion = ((FscAccountChargeDetailPO)chargeDetailMap.get(e)).getUnionAmount() == null ? BigDecimal.ZERO : ((FscAccountChargeDetailPO)chargeDetailMap.get(e)).getUnionAmount();
            BigDecimal chargeAmount = chargeAmountUnion.add(chargeAmountCompany);
            FscAccountSerialPO serialPo = new FscAccountSerialPO();
            serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
            serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
            Integer serialNumber = 0;
            if (serialPo != null) {
                serialNumber = serialPo.getSerialNumber();
            }
            Object[] objectArray = new Object[1];
            serialNumber = serialNumber + 1;
            objectArray[0] = serialNumber;
            String detailNo = fscRecvClaimPo.getClaimNo() + "-" + String.format("%02d", objectArray);
            FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
            fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            fscClaimDetailPo.setDetailNo(detailNo);
            fscClaimDetailPo.setClaimAmt(chargeAmount);
            fscClaimDetailPo.setClaimDate(new Date());
            fscClaimDetailPo.setClaimId(fscRecvClaimPo.getClaimId());
            fscClaimDetailPo.setClaimType(FscClaimTypeEnum.EMPLOYEE_WELFARE_RECV_CLAIM.getCode());
            fscClaimDetailPo.setCustomerNo(Long.valueOf(fscAccountPo.getOrgCode()));
            fscClaimDetailPo.setCustomerName(fscAccountPo.getOrgName());
            fscClaimDetailPo.setHandleDeptId(reqBO.getYcDeptId());
            fscClaimDetailPo.setHandleDeptName(reqBO.getYcDeptName());
            fscClaimDetailPo.setHandleUserId(reqBO.getYcUserId());
            fscClaimDetailPo.setHandleUserName(reqBO.getYcUserName());
            fscClaimDetailPo.setStatus("1");
            fscClaimDetailPo.setObjectId(fscAccountChargePo.getChargeId());
            fscClaimDetailPo.setSysSource(Integer.valueOf(1));
            fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
            fscClaimDetailPo.setObjectNo(fscAccountChargePo.getAdvanceDepositNo());
            FscClaimDetailBO detailBO = new FscClaimDetailBO();
            BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)detailBO);
            pushDetailList.add(detailBO);
            int insert = this.fscClaimDetailMapper.insert(fscClaimDetailPo);
            if (insert < 0) {
                throw new FscBusinessException("190000", "\u9884\u5b58\u8ba4\u9886\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            if (serialPo == null) {
                serialPo = new FscAccountSerialPO();
                serialPo.setSerialNumber(serialNumber);
                serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
                serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
                this.fscAccountSerialMapper.insert(serialPo);
            } else {
                serialPo.setSerialNumber(serialNumber);
                this.fscAccountSerialMapper.update(serialPo);
            }
            FscAccountChargeDetailPO chargeDetailPO = new FscAccountChargeDetailPO();
            chargeDetailPO.setChargeId(reqBO.getChargeId());
            chargeDetailPO.setAccountId(e);
            chargeDetailPO.setClaimDetailId(fscClaimDetailPo.getClaimDetailId());
            chargeDetailPO.setUpdateId(reqBO.getUserId());
            chargeDetailPO.setUpdateTime(new Date());
            int updateCount = this.fscAccountChargeDetailMapper.updateByAccountId(chargeDetailPO);
            if (updateCount < 1) {
                throw new FscBusinessException("190000", "\u9884\u5b58\u660e\u7ec6\u8ba4\u9886\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            BigDecimal returnedAmount = BigDecimal.ZERO;
            if (chargeAmountCompany.compareTo(BigDecimal.ZERO) > 0) {
                this.payBill((Long)e, chargeAmountCompany, fscAccountPo.getCompanyOverdraftAmount(), 1, fscAccountPo.getOrgId());
                fscAccountPo.setCompanyAdvanceAmount(fscAccountPo.getCompanyAdvanceAmount().add(chargeAmountCompany));
                if (fscAccountPo.getCompanyOverdraft().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal CompanyReturnedAmount = fscAccountPo.getCompanyOverdraftAmount().compareTo(chargeAmountCompany) > 0 ? chargeAmountCompany : fscAccountPo.getCompanyOverdraftAmount();
                    fscAccountPo.setCompanyOverdraftAmount(fscAccountPo.getCompanyOverdraftAmount().compareTo(chargeAmountCompany) > 0 ? fscAccountPo.getCompanyOverdraftAmount().subtract(chargeAmountCompany) : BigDecimal.ZERO);
                    returnedAmount = returnedAmount.add(CompanyReturnedAmount);
                }
            }
            if (chargeAmountUnion.compareTo(BigDecimal.ZERO) > 0) {
                this.payBill((Long)e, chargeAmountUnion, fscAccountPo.getUnionOverdraftAmount(), 2, fscAccountPo.getOrgId());
                fscAccountPo.setUnionAdvanceAmount(fscAccountPo.getUnionAdvanceAmount().add(chargeAmountUnion));
                if (fscAccountPo.getUnionOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal UnionReturnedAmount = fscAccountPo.getUnionOverdraftAmount().compareTo(chargeAmountUnion) > 0 ? chargeAmountUnion : fscAccountPo.getUnionOverdraftAmount();
                    fscAccountPo.setUnionOverdraftAmount(fscAccountPo.getUnionOverdraftAmount().compareTo(chargeAmountUnion) > 0 ? fscAccountPo.getUnionOverdraftAmount().subtract(chargeAmountCompany) : BigDecimal.ZERO);
                    returnedAmount = returnedAmount.add(UnionReturnedAmount);
                }
            }
            fscAccountPo.setEmployeeReturnAmount(returnedAmount);
            this.fscAccountMapper.updateAmountByCharge(fscAccountPo);
            FscAccountAmountBo after = this.getAmount(fscAccountPo);
            FscPayLogPO fscPayLogPO = new FscPayLogPO();
            fscPayLogPO.setAccountId(fscAccountPo.getId());
            fscPayLogPO.setOrgId(fscAccountPo.getOrgId());
            fscPayLogPO.setPayeeId(this.operationOrgId);
            fscPayLogPO.setUserName(fscAccountChargePo.getUserName());
            fscPayLogPO.setBusiTime(new Date());
            fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.WELFARE_ACCOUNT_CHARGE);
            fscPayLogPO.setBusiOrderType(Integer.valueOf(3));
            fscPayLogPO.setCreateTime(new Date());
            fscPayLogPO.setCreateOperId(reqBO.getUserId().toString());
            fscPayLogPO.setBusiOrderId(fscAccountChargePo.getChargeId());
            fscPayLogPO.setPayBusiness("4");
            fscPayLogPO.setIsCredit(Integer.valueOf(0));
            fscPayLogPO.setDealType(Integer.valueOf(4));
            if (chargeAmountCompany.compareTo(BigDecimal.ZERO) > 0) {
                fscPayLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayLogPO.setBusiAmount(chargeAmountCompany);
                fscPayLogPO.setAccountType(Integer.valueOf(1));
                fscPayLogPO.setOverdraftBeforeAmount(befoer.getCompanyBeforeOverDraft());
                fscPayLogPO.setOverdraftAfterAmount(after.getCompanyBeforeOverDraft());
                fscPayLogPO.setAdvanceBeforeAmount(befoer.getCompanyBeforeAmount());
                fscPayLogPO.setAdvanceAfterAmount(after.getCompanyBeforeAmount());
                insertPayLog = this.fscPayLogMapper.insert(fscPayLogPO);
                if (insertPayLog < 1) {
                    throw new FscBusinessException("190000", "\u65b0\u589e\u516c\u53f8\u652f\u4ed8\u8bb0\u5f55\u64cd\u4f5c\u5931\u8d25\uff01");
                }
            }
            if (chargeAmountUnion.compareTo(BigDecimal.ZERO) > 0) {
                fscPayLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayLogPO.setAccountType(Integer.valueOf(2));
                fscPayLogPO.setBusiAmount(chargeAmountUnion);
                fscPayLogPO.setOverdraftBeforeAmount(befoer.getUnionBeforeOverDraft());
                fscPayLogPO.setOverdraftAfterAmount(after.getUnionBeforeOverDraft());
                fscPayLogPO.setAdvanceBeforeAmount(befoer.getUnionBeforeAmount());
                fscPayLogPO.setAdvanceAfterAmount(after.getUnionBeforeAmount());
                insertPayLog = this.fscPayLogMapper.insert(fscPayLogPO);
                if (insertPayLog < 1) {
                    throw new FscBusinessException("190000", "\u65b0\u589e\u5de5\u4f1a\u652f\u4ed8\u8bb0\u5f55\u64cd\u4f5c\u5931\u8d25\uff01");
                }
            }
        });
        if (fscAccountChargePo.getChargeAmount().compareTo(fscRecvClaimPo.getNoClaimAmt()) == 0) {
            fscRecvClaimPo.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
            fscRecvClaimPo.setNoClaimAmt(BigDecimal.ZERO);
            fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
        } else {
            fscRecvClaimPo.setNoClaimAmt(fscRecvClaimPo.getNoClaimAmt().subtract(fscAccountChargePo.getChargeAmount()));
            fscRecvClaimPo.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        }
        fscRecvClaimPo.setUpdateTime(new Date());
        this.fscRecvClaimMapper.update(fscRecvClaimPo);
        fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDIT_PASS);
        fscAccountChargePo.setClaimNo(fscRecvClaimPo.getClaimNo());
        this.fscAccountChargeMapper.update(fscAccountChargePo);
        FscAccountChargeClaimBusiRspBO busiRspBO = new FscAccountChargeClaimBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        busiRspBO.setClaimId(fscRecvClaimPo.getClaimId());
        busiRspBO.setPushDetailBOList(pushDetailList);
        return busiRspBO;
    }

    private FscAccountAmountBo getAmount(FscAccountPO fscAccountPo) {
        if (null == fscAccountPo.getCompanyOverdraft()) {
            fscAccountPo.setCompanyOverdraft(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getCompanyOverdraftAmount()) {
            fscAccountPo.setCompanyOverdraftAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionOverdraft()) {
            fscAccountPo.setUnionOverdraft(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionOverdraftAmount()) {
            fscAccountPo.setUnionOverdraftAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getCompanyAdvanceAmount()) {
            fscAccountPo.setCompanyAdvanceAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getCompanyFreezeAmount()) {
            fscAccountPo.setCompanyFreezeAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getCompanyUseAmount()) {
            fscAccountPo.setCompanyUseAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionAdvanceAmount()) {
            fscAccountPo.setUnionAdvanceAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionFreezeAmount()) {
            fscAccountPo.setUnionFreezeAmount(BigDecimal.ZERO);
        }
        if (null == fscAccountPo.getUnionUseAmount()) {
            fscAccountPo.setUnionUseAmount(BigDecimal.ZERO);
        }
        FscAccountAmountBo fscAccountAmountBo = new FscAccountAmountBo();
        fscAccountAmountBo.setCompanyBeforeOverDraft(fscAccountPo.getCompanyOverdraft().subtract(fscAccountPo.getCompanyOverdraftAmount()));
        fscAccountAmountBo.setUnionBeforeOverDraft(fscAccountPo.getUnionOverdraft().subtract(fscAccountPo.getUnionOverdraftAmount()));
        fscAccountAmountBo.setCompanyBeforeAmount(fscAccountPo.getCompanyAdvanceAmount().subtract(fscAccountPo.getCompanyFreezeAmount()).subtract(fscAccountPo.getCompanyUseAmount()));
        fscAccountAmountBo.setUnionBeforeAmount(fscAccountPo.getUnionAdvanceAmount().subtract(fscAccountPo.getUnionFreezeAmount()).subtract(fscAccountPo.getUnionUseAmount()));
        return fscAccountAmountBo;
    }

    private void payBill(Long e, BigDecimal chargeAmount, BigDecimal overdraftAmount, Integer accountType, Long orgId) {
        Date reimbursementDate = new Date();
        ArrayList<FscWelfareChargeConsumerPO> updateChargeConsumer = new ArrayList<FscWelfareChargeConsumerPO>();
        ArrayList updateChargeConsumerAfter = new ArrayList();
        FscWelfareChargeConsumerPO fscWelfareChargeConsumerPO = new FscWelfareChargeConsumerPO();
        fscWelfareChargeConsumerPO.setOrgId(orgId);
        fscWelfareChargeConsumerPO.setWelfareType(accountType);
        Page page = new Page();
        page.setPageSize(-1);
        List fscWelfareChargeConsumerPOS = this.fscWelfareChargeConsumerMapper.queryAllByLimitPage(fscWelfareChargeConsumerPO, page);
        Map fscWelfareChargeConsumerPOSMap = fscWelfareChargeConsumerPOS.stream().collect(Collectors.toMap(FscWelfareChargeConsumerPO::getWelfareChargeCode, Function.identity(), (e1, e2) -> e2));
        ArrayList<FscPayLogPO> backList = new ArrayList<FscPayLogPO>();
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setAccountId(e);
        ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
        busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_WELFARE_PAY);
        fscPayLogPO.setBusiCategoryList(busiCategoryList);
        fscPayLogPO.setIsOverPay(Integer.valueOf(0));
        fscPayLogPO.setAccountType(accountType);
        fscPayLogPO.setIsBack(Integer.valueOf(0));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2);
        list.add(3);
        fscPayLogPO.setAdvancePayTypeList(list);
        List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
        if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
            Map<String, List<FscPayLogPO>> fscPayLogPOListGroup = fscPayLogPOList.stream().collect(Collectors.groupingBy(FscPayLogPO::getWelfareChargeCode));
            ArrayList<String> fscPayLogPOListGroupList = new ArrayList<String>(fscPayLogPOListGroup.keySet());
            if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                for (String welfareChargeCode : fscPayLogPOListGroupList) {
                    BigDecimal returnAmt = BigDecimal.ZERO;
                    List<FscPayLogPO> fscPayLogPOS = fscPayLogPOListGroup.get(welfareChargeCode);
                    for (FscPayLogPO po : fscPayLogPOS) {
                        if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                        FscPayLogPO backPayLog = new FscPayLogPO();
                        backPayLog.setId(po.getId());
                        backPayLog.setBusiOrderId(po.getBusiOrderId());
                        backPayLog.setBusiOrderNo(po.getBusiOrderNo());
                        BigDecimal notBackAmt = po.getOverdraftAmt().subtract(po.getReimbursementAmount());
                        if (chargeAmount.compareTo(notBackAmt) >= 0) {
                            backPayLog.setReimbursementAmount(notBackAmt);
                            chargeAmount = chargeAmount.subtract(notBackAmt);
                            backPayLog.setReimbursementDate(reimbursementDate);
                        } else {
                            backPayLog.setReimbursementAmount(chargeAmount);
                            chargeAmount = BigDecimal.ZERO;
                        }
                        returnAmt = returnAmt.add(backPayLog.getReimbursementAmount());
                        backList.add(backPayLog);
                    }
                    if (null == fscWelfareChargeConsumerPOSMap.get(welfareChargeCode)) continue;
                    FscWelfareChargeConsumerPO welfareChargeConsumerPO = (FscWelfareChargeConsumerPO)fscWelfareChargeConsumerPOSMap.get(welfareChargeCode);
                    if (welfareChargeConsumerPO.getOverdraftUseAmount().compareTo(returnAmt) > 0) {
                        welfareChargeConsumerPO.setOverdraftAmount(welfareChargeConsumerPO.getOverdraftAmount().subtract(returnAmt));
                        welfareChargeConsumerPO.setAdvanceAmount(welfareChargeConsumerPO.getAdvanceAmount().add(returnAmt));
                        welfareChargeConsumerPO.setOverdraftUseAmount(welfareChargeConsumerPO.getOverdraftUseAmount().subtract(returnAmt));
                        welfareChargeConsumerPO.setAdvanceUseAmount(welfareChargeConsumerPO.getAdvanceUseAmount().add(returnAmt));
                    } else {
                        welfareChargeConsumerPO.setAdvanceAmount(welfareChargeConsumerPO.getAdvanceAmount().add(welfareChargeConsumerPO.getOverdraftUseAmount()));
                        welfareChargeConsumerPO.setOverdraftAmount(welfareChargeConsumerPO.getOverdraftAmount().subtract(welfareChargeConsumerPO.getOverdraftUseAmount()));
                        welfareChargeConsumerPO.setAdvanceUseAmount(welfareChargeConsumerPO.getAdvanceUseAmount().add(welfareChargeConsumerPO.getOverdraftUseAmount()));
                        welfareChargeConsumerPO.setOverdraftUseAmount(BigDecimal.ZERO);
                    }
                    updateChargeConsumer.add(welfareChargeConsumerPO);
                }
                if (!CollectionUtils.isEmpty(backList)) {
                    this.fscPayLogMapper.updateBack(backList);
                }
            }
        }
        Collection New = null;
        if (!CollectionUtils.isEmpty(updateChargeConsumer)) {
            Map collect = updateChargeConsumer.stream().collect(Collectors.toMap(FscWelfareChargeConsumerPO::getId, Function.identity(), (e1, e2) -> e2));
            Map collect1 = fscWelfareChargeConsumerPOS.stream().collect(Collectors.toMap(FscWelfareChargeConsumerPO::getId, Function.identity(), (e1, e2) -> e2));
            collect.forEach(collect1::put);
            New = collect1.values();
            fscWelfareChargeConsumerPOS = JSON.parseArray((String)JSON.toJSONString(New), FscWelfareChargeConsumerPO.class);
        }
        if (chargeAmount.compareTo(BigDecimal.ZERO) > 0 && !CollectionUtils.isEmpty((Collection)fscWelfareChargeConsumerPOS)) {
            for (FscWelfareChargeConsumerPO po : fscWelfareChargeConsumerPOS) {
                if (chargeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                if (null == po.getOverdraftAmount() || po.getOverdraftAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                if (po.getOverdraftAmount().compareTo(chargeAmount) > 0) {
                    po.setOverdraftAmount(po.getOverdraftAmount().subtract(chargeAmount));
                    po.setAdvanceAmount(chargeAmount.add(po.getAdvanceAmount()));
                    chargeAmount = BigDecimal.ZERO;
                    continue;
                }
                chargeAmount = chargeAmount.subtract(po.getOverdraftAmount());
                po.setAdvanceAmount(po.getAdvanceAmount().add(po.getOverdraftAmount()));
                po.setOverdraftAmount(BigDecimal.ZERO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)fscWelfareChargeConsumerPOS)) {
            this.fscWelfareChargeConsumerMapper.updateBack(fscWelfareChargeConsumerPOS);
        }
    }
}

