/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.bill.ability.api.FscBillGetYcPersonInfoAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillGetYcPersonInfoAbilityBO;
import com.tydic.fsc.bill.ability.bo.FscBillGetYcPersonInfoAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillGetYcPersonInfoAbilityRspBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscMemFeeClaimByFscOrderBusiService;
import com.tydic.fsc.common.busi.bo.FscMemFeeClaimByFscOrderBusiServiceReqBO;
import com.tydic.fsc.common.busi.bo.FscMemFeeClaimByFscOrderBusiServiceRspBO;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscMemFeeClaimByFscOrderBusiServiceImpl
implements FscMemFeeClaimByFscOrderBusiService {
    @Value(value="${memfee.recv.claimUserName:10228059}")
    private String claimUserName;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscBillGetYcPersonInfoAbilityService fscBillGetYcPersonInfoAbilityService;
    @Autowired
    private FscRecvClaimConfirmAbilityService fscRecvClaimConfirmAbilityService;
    private static final String MEM_FEE_CLAIM = "13";

    @Override
    public FscMemFeeClaimByFscOrderBusiServiceRspBO memFeeClaimByFscOrder(FscMemFeeClaimByFscOrderBusiServiceReqBO reqBO) {
        FscMemFeeClaimByFscOrderBusiServiceRspBO rspBO = new FscMemFeeClaimByFscOrderBusiServiceRspBO();
        List fscOrderPOS = this.fscShouldPayMapper.getInfoForMemRecvClaim(reqBO.getFscOrderIds());
        if (CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u4fe1\u606f");
            return rspBO;
        }
        List fscRecvClaimPOS = this.fscClaimDetailMapper.queryClaimIdByFscOrderId(reqBO.getFscOrderIds());
        if (CollectionUtils.isEmpty((Collection)fscRecvClaimPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba4\u9886\u5355\u4fe1\u606f");
            return rspBO;
        }
        FscBillGetYcPersonInfoAbilityReqBO personInfoAbilityReqBO = new FscBillGetYcPersonInfoAbilityReqBO();
        personInfoAbilityReqBO.setUserName(this.claimUserName);
        FscBillGetYcPersonInfoAbilityRspBO personInfo = this.fscBillGetYcPersonInfoAbilityService.getPersonInfo(personInfoAbilityReqBO);
        Map collect = fscRecvClaimPOS.stream().collect(Collectors.toMap(e -> e.getFscOrderId(), Function.identity(), (e1, e2) -> e2));
        ArrayList<Long> success = new ArrayList<Long>();
        for (FscOrderPO po : fscOrderPOS) {
            if (!collect.containsKey(po.getFscOrderId())) continue;
            FscRecvClaimPO claimPO = (FscRecvClaimPO)collect.get(po.getFscOrderId());
            FscRecvClaimConfirmAbilityReqBO recvClaimConfirmAbilityReqBO = new FscRecvClaimConfirmAbilityReqBO();
            recvClaimConfirmAbilityReqBO.setNoClaimAmt(BigDecimal.ZERO);
            recvClaimConfirmAbilityReqBO.setClaimId(claimPO.getClaimId());
            recvClaimConfirmAbilityReqBO.setRecvAmt(claimPO.getRecvAmt());
            ArrayList<FscClaimDetailBO> claimDetailList = new ArrayList<FscClaimDetailBO>();
            FscClaimDetailBO claimDetailBO = new FscClaimDetailBO();
            claimDetailBO.setClaimAmt(claimPO.getRecvAmt());
            claimDetailBO.setClaimDate(new Date());
            claimDetailBO.setClaimType(MEM_FEE_CLAIM);
            claimDetailBO.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)MEM_FEE_CLAIM));
            if (!CollectionUtils.isEmpty((Collection)personInfo.getRows())) {
                claimDetailBO.setHandleDeptId(((FscBillGetYcPersonInfoAbilityBO)personInfo.getRows().get(0)).getDeptId());
                claimDetailBO.setHandleDeptName(((FscBillGetYcPersonInfoAbilityBO)personInfo.getRows().get(0)).getDeptName());
                claimDetailBO.setHandleUserId(((FscBillGetYcPersonInfoAbilityBO)personInfo.getRows().get(0)).getUserId());
                claimDetailBO.setHandleUserName(((FscBillGetYcPersonInfoAbilityBO)personInfo.getRows().get(0)).getPersonName());
                claimDetailBO.setPersonNum(((FscBillGetYcPersonInfoAbilityBO)personInfo.getRows().get(0)).getPersonNum());
            }
            claimDetailBO.setNoClaimAmt(BigDecimal.ZERO);
            claimDetailBO.setObjectId(po.getShouldPayId());
            claimDetailBO.setObjectNo(po.getShouldPayNo());
            claimDetailBO.setOperationName(po.getOperationName());
            claimDetailBO.setOperationType(Integer.valueOf(1));
            claimDetailBO.setSysSource(Integer.valueOf(1));
            claimDetailBO.setOrderId(po.getFscOrderId());
            claimDetailList.add(claimDetailBO);
            recvClaimConfirmAbilityReqBO.setClaimDetailList(claimDetailList);
            FscRecvClaimConfirmAbilityRspBO fscRecvClaimConfirmAbilityRspBO = this.fscRecvClaimConfirmAbilityService.recvClaimConfirm(recvClaimConfirmAbilityReqBO);
            if (!"0000".equals(fscRecvClaimConfirmAbilityRspBO.getRespCode())) {
                rspBO.setRespCode("8888");
                rspBO.setSuccess(success);
                rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355ID\uff1a" + po.getFscOrderId() + "\u8ba4\u9886\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + fscRecvClaimConfirmAbilityRspBO.getRespDesc());
                return rspBO;
            }
            success.add(po.getFscOrderId());
        }
        rspBO.setSuccess(success);
        return rspBO;
    }
}

