/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.atom.api.FscBillOrderSettleCheckAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderSettleCheckAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderSettleCheckAtomRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderInvoiceItemAddAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceItemAddAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceItemAddAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscOrderInvoiceItemAddBusiService;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceItemAddBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceItemAddBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscInvoiceCheckMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayForOrderClaimMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscInvoiceCheckPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.MD5Util;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderInvoiceItemAddAbilityService"})
public class FscOrderInvoiceItemAddAbilityServiceImpl
implements FscOrderInvoiceItemAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderInvoiceItemAddAbilityServiceImpl.class);
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscOrderInvoiceItemAddBusiService fscOrderInvoiceItemAddBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscInvoiceCheckMapper fscInvoiceCheckMapper;
    @Autowired
    private PebExtOrderSettleTypeUpdateAbilityService pebExtOrderSettleTypeUpdateAbilityService;
    @Autowired
    private FscBillOrderSettleCheckAtomService fscBillOrderSettleCheckAtomService;
    @Autowired
    private FscShouldPayForOrderClaimMapper fscShouldPayForOrderClaimMapper;

    @PostMapping(value={"addOrderInvoiceItem"})
    public FscOrderInvoiceItemAddAbilityRspBO addOrderInvoiceItem(@RequestBody FscOrderInvoiceItemAddAbilityReqBO reqBO) {
        String taxRateRes;
        FscOrderInvoiceItemAddAbilityRspBO rspBO = new FscOrderInvoiceItemAddAbilityRspBO();
        this.valid(reqBO);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPo = this.fscOrderMapper.getModelBy(orderPO);
        if (fscOrderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (!FscConstants.FscInvoiceOrderState.DRAFT.equals(fscOrderPo.getOrderState())) {
            if ("1".equals(reqBO.getIsprofess()) && !fscOrderPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.ROLL_BACK)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
            }
            if ("0".equals(reqBO.getIsprofess()) && !fscOrderPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.APPROVAL_REJECT)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
            }
        }
        reqBO.setMakeType(fscOrderPo.getMakeType());
        reqBO.setReceiveType(fscOrderPo.getReceiveType());
        ArrayList<Long> inspectionVoucherIdList = new ArrayList<Long>();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            if (null == splitOrderBO.getAmount()) {
                throw new FscBusinessException("191014", "\u62c6\u5206\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
            }
            if (BigDecimal.ZERO.compareTo(splitOrderBO.getAmount()) >= 0) {
                throw new FscBusinessException("191014", "\u62c6\u5206\u8ba2\u5355\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            splitOrderBO.getRelOrderList().forEach(relOrderBO -> {
                if (null == relOrderBO.getAcceptOrderId()) {
                    throw new FscBusinessException("191014", "\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
                }
                if (null == relOrderBO.getOrderId()) {
                    throw new FscBusinessException("191014", "\u8ba2\u5355ID\u4e3a\u7a7a");
                }
                inspectionVoucherIdList.add(relOrderBO.getAcceptOrderId());
                orderIds.add(relOrderBO.getOrderId());
            });
        }
        this.checkPrePayBill(orderIds, orderPO.getPayeeId());
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(reqBO.getFscOrderId());
        relationPO.setAcceptOrderIds(inspectionVoucherIdList);
        int num = this.fscOrderRelationMapper.getCheckBy(relationPO);
        if (num > 0) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u8ba2\u5355\u5df2\u6dfb\u52a0\u81f3\u5f53\u524d\u7ed3\u7b97\u5355,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        FscBillOrderSettleCheckAtomReqBO checkAtomReqBO = new FscBillOrderSettleCheckAtomReqBO();
        checkAtomReqBO.setOrderIds(orderIds);
        checkAtomReqBO.setSettleType(fscOrderPo.getSettleType());
        checkAtomReqBO.setUserType(reqBO.getReceiveType());
        FscBillOrderSettleCheckAtomRspBO atomRspBO = this.fscBillOrderSettleCheckAtomService.dealOrderSettleCheck(checkAtomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap(inspectionVoucherIdList.size());
        if (reqBO.getOrderType() != null && reqBO.getOrderType() == 1) {
            FscSaleOrderListQueryAtomReqBO fscSaleOrderListQueryAtomReqBO = new FscSaleOrderListQueryAtomReqBO();
            fscSaleOrderListQueryAtomReqBO.setOrderIds(orderIds);
            fscSaleOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                fscSaleOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
            }
            fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
            }
            if (FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.INDIVIDUAL_TYPE);
            }
            fscSaleOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = new FscSaleOrderListQueryAtomRspBO();
            fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(fscSaleOrderListQueryAtomReqBO);
            if (null == fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
                throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
        } else {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(inspectionVoucherIdList);
            fscAcceptOrderListQueryAtomReqBO.setReceiveType(fscOrderPo.getReceiveType());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPo.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPo.getMakeType())) {
                fscAcceptOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
            }
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPo.getReceiveType())) {
                fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPo.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPo.getMakeType())) {
                fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
            }
            fscAcceptOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (null == fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
                throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
        }
        if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && StringUtils.isNotEmpty((CharSequence)(taxRateRes = this.valTaxRate(inspectionVoucherIdList, fscOrderInfoBoMap, reqBO.getFscOrderId())))) {
            rspBO.setRespDesc(taxRateRes);
        }
        this.checkOrderParam(fscOrderInfoBoMap, reqBO, fscOrderPo.getTotalCharge(), fscOrderPo.getPayType());
        if ("2".equals(fscOrderPo.getOrderSource().toString()) && reqBO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            this.checkResult(fscOrderPo, inspectionVoucherIdList);
        }
        FscOrderInvoiceItemAddBusiReqBO busiReqBO = (FscOrderInvoiceItemAddBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderInvoiceItemAddBusiReqBO.class));
        busiReqBO.setFscOrderInfoBoMap(fscOrderInfoBoMap);
        String invoiceOrderId = MD5Util.MD5Encode((String)JSONObject.toJSONString(orderIds), null);
        try {
            FscInvoiceCheckPO invoiceCheckPO = new FscInvoiceCheckPO();
            invoiceCheckPO.setOrderId(invoiceOrderId);
            invoiceCheckPO.setReceiveType(reqBO.getReceiveType());
            invoiceCheckPO.setCreateTime(new Date());
            invoiceCheckPO.setCreateUserId(reqBO.getUserId());
            int count = this.fscInvoiceCheckMapper.insert(invoiceCheckPO);
            if (count <= 0) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("198888", "\u5f53\u524d\u7cfb\u7edf\u5904\u7406\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        FscOrderInvoiceItemAddBusiRspBO busiRspBO = this.fscOrderInvoiceItemAddBusiService.addOrderInvoiceItem(busiReqBO);
        this.fscInvoiceCheckMapper.deleteByIdAndType(invoiceOrderId, reqBO.getReceiveType());
        this.sendMq(reqBO, orderIds);
        return (FscOrderInvoiceItemAddAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscOrderInvoiceItemAddAbilityRspBO.class);
    }

    private void valid(FscOrderInvoiceItemAddAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkOrderBillStatus(Integer makeType, Integer receiveType, List<Long> orderIds, FscOrderInvoiceItemAddAbilityReqBO reqBO, Integer settleType) {
        List fscOrderIds;
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setOrderIds(orderIds);
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS) && !CollectionUtils.isEmpty(fscOrderIds = fscOrderRelationPOS.stream().map(FscOrderRelationPO::getFscOrderId).collect(Collectors.toList()))) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(fscOrderIds);
            fscOrderPO.setRemoveState(FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
            fscOrderPO.setRejectState(FscBillStatus.MAIN_ORDER_ECOM_REJECT.getCode());
            fscOrderPO.setDelState(FscBillStatus.MAIN_ORDER_DEL.getCode());
            if (settleType == null) {
                fscOrderPO.setSettleType(FscConstants.SettleType.INSPECTION);
            } else {
                fscOrderPO.setSettleType(settleType);
            }
            List fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
                fscOrderPOS.forEach(fscOrder -> {
                    if (receiveType.equals(fscOrder.getReceiveType()) && makeType.equals(fscOrder.getMakeType())) {
                        throw new FscBusinessException("191014", "\u5b58\u5728\u8ba2\u5355\u5df2\u53d1\u8d77\u5176\u5b83\u7c7b\u578b\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u53d1\u8d77\u4e0d\u901a\u7c7b\u578b\u8ba2\u5355\u7ed3\u7b97");
                    }
                });
            }
        }
    }

    public List<FscShouldPayPO> checkPrePayBill(List<Long> inspectionIdList) {
        ArrayList<FscShouldPayPO> updateList = new ArrayList<FscShouldPayPO>();
        if (!CollectionUtils.isEmpty(inspectionIdList)) {
            FscShouldPayPO queryVo = new FscShouldPayPO();
            queryVo.setInspectionIdList(inspectionIdList);
            ArrayList<Integer> shouldPayTypes = new ArrayList<Integer>(2);
            shouldPayTypes.add(FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY);
            shouldPayTypes.add(FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY);
            shouldPayTypes.add(FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY);
            queryVo.setPayeeId(this.operationOrgId);
            queryVo.setShouldPayTypes(shouldPayTypes);
            List list = this.fscShouldPayMapper.getList(queryVo);
            for (FscShouldPayPO fscShouldPayPO : list) {
                if (fscShouldPayPO.getPayingAmount().compareTo(BigDecimal.ZERO) > 0) {
                    throw new FscBusinessException("190000", "\u9884\u4ed8\u6b3e\u5355\u636e[" + fscShouldPayPO.getShouldPayNo() + "]\u6b63\u5728\u4ed8\u6b3e\u4e2d,\u4e0d\u80fd\u53d1\u8d77\u5bf9\u8d26\u7533\u8bf7\uff01");
                }
                if (fscShouldPayPO.getPayingAmount().compareTo(BigDecimal.ZERO) != 0 || !fscShouldPayPO.getShouldPayStatus().equals(FscConstants.ShouldPayStatus.TO_PAY)) continue;
                fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_FREEZE);
                updateList.add(fscShouldPayPO);
            }
        }
        return updateList;
    }

    private void checkOrderParam(Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, FscOrderInvoiceItemAddAbilityReqBO reqBO, BigDecimal totalAmount, Integer payType) {
        FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.get(((RelOrderBO)((SplitOrderBO)reqBO.getSplitOrderList().get(0)).getRelOrderList().get(0)).getAcceptOrderId());
        if (null == fscOrderInfoBO) {
            throw new FscBusinessException("191014", "\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + ((RelOrderBO)((SplitOrderBO)reqBO.getSplitOrderList().get(0)).getRelOrderList().get(0)).getAcceptOrderId() + "]\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (reqBO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            fscOrderInfoBO.setPayType(fscOrderInfoBO.getProPayType());
            fscOrderInfoBO.setPayRule(fscOrderInfoBO.getProPayRule());
            fscOrderInfoBO.setPayAccountDayRule(fscOrderInfoBO.getProPayAccountDayRule());
            fscOrderInfoBO.setPayNodeRule(fscOrderInfoBO.getProPayNodeRule());
            fscOrderInfoBO.setPayNodeAccountDays(fscOrderInfoBO.getProPaymentDays());
            fscOrderInfoBO.setPayAccountDay(fscOrderInfoBO.getProPayAccountDay());
        }
        BigDecimal[] totalCharge = new BigDecimal[]{BigDecimal.ZERO};
        fscOrderInfoBoMap.forEach((acceptOrderId, fscOrderInfo) -> {
            if (BigDecimal.ZERO.compareTo(fscOrderInfo.getInspTotalMoney()) >= 0) {
                throw new FscBusinessException("191014", "\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + fscOrderInfo.getAcceptOrderNo() + "]\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u7ed3\u7b97");
            }
            totalCharge[0] = totalCharge[0].add(fscOrderInfo.getInspTotalMoney());
            if (!payType.equals(fscOrderInfo.getPayType())) {
                throw new FscBusinessException("191014", "\u8ba2\u5355\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
            }
            if (reqBO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfo.setPayType(fscOrderInfoBO.getProPayType());
                fscOrderInfo.setPayRule(fscOrderInfoBO.getProPayRule());
                fscOrderInfo.setPayAccountDayRule(fscOrderInfoBO.getProPayAccountDayRule());
                fscOrderInfo.setPayNodeRule(fscOrderInfoBO.getProPayNodeRule());
                fscOrderInfo.setPayNodeAccountDays(fscOrderInfoBO.getProPaymentDays());
                fscOrderInfo.setPayAccountDay(fscOrderInfoBO.getProPayAccountDay());
            }
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderInfo.getPayType())) {
                if (null == fscOrderInfoBO.getPayRule() || null == fscOrderInfo.getPayType()) {
                    throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u8fd4\u56de\u4e3a\u7a7a");
                }
                if (!fscOrderInfoBO.getPayRule().equals(fscOrderInfo.getPayRule())) {
                    throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                }
                if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
                    if (null == fscOrderInfoBO.getPayNodeRule() || null == fscOrderInfo.getPayNodeRule()) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u4e3a\u7a7a");
                    }
                    if (!fscOrderInfoBO.getPayNodeRule().equals(fscOrderInfo.getPayNodeRule())) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                    if (null == fscOrderInfoBO.getPayNodeAccountDays() || null == fscOrderInfo.getPayNodeAccountDays()) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
                    }
                    if (!fscOrderInfoBO.getPayNodeAccountDays().equals(fscOrderInfo.getPayNodeAccountDays())) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                } else if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
                    if (null == fscOrderInfoBO.getPayAccountDayRule() || null == fscOrderInfo.getPayAccountDayRule()) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\u4e3a\u7a7a");
                    }
                    if (!fscOrderInfoBO.getPayAccountDayRule().equals(fscOrderInfo.getPayAccountDayRule())) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                    if (null == fscOrderInfoBO.getPayAccountDay() || null == fscOrderInfo.getPayAccountDay()) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
                    }
                    if (!fscOrderInfoBO.getPayAccountDay().equals(fscOrderInfo.getPayAccountDay())) {
                        throw new FscBusinessException("191014", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                } else {
                    String orderNo = fscOrderInfo.getPurchaseOrderNo();
                    if (FscConstants.FscBusiModel.MATCHING.equals(fscOrderInfo.getTradeMode())) {
                        orderNo = fscOrderInfo.getSaleOrderNo();
                    }
                    throw new FscBusinessException("191014", "\u8ba2\u5355\u3010" + orderNo + "\u3011\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u3010" + fscOrderInfoBO.getPayRule() + "\u3011\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968");
                }
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                if (!fscOrderInfoBO.getBuynerNo().equals(fscOrderInfo.getBuynerNo())) {
                    throw new FscBusinessException("191014", "\u6536\u7968\u65b9\u4e3a\u91c7\u8d2d\u5355\u4f4d\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u91c7\u8d2d\u5355\u4f4d\u7684\u8ba2\u5355");
                }
                if (null != fscOrderInfoBO.getAccountSetId() && !fscOrderInfoBO.getAccountSetId().equals(fscOrderInfo.getAccountSetId())) {
                    throw new FscBusinessException("191014", "\u6536\u7968\u65b9\u4e3a\u91c7\u8d2d\u5355\u4f4d\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u8d26\u5957\u7684\u8ba2\u5355");
                }
            }
        });
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            BigDecimal splitAmount = totalAmount;
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                BigDecimal amount = BigDecimal.ZERO;
                amount = FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType()) ? amount.add(fscOrderInfoBoMap.get(relOrderBO.getAcceptOrderId()).getInspTotalPurchaseMoney()) : amount.add(fscOrderInfoBoMap.get(relOrderBO.getAcceptOrderId()).getInspTotalMoney());
                if (amount.setScale(2, 4).compareTo(relOrderBO.getAmount().setScale(2, 4)) != 0) {
                    throw new FscBusinessException("191014", "\u63d0\u4ea4\u8ba2\u5355[" + relOrderBO.getOrderId() + "]\u91d1\u989d\u4e0e\u540e\u7aef\u4e0d\u4e00\u81f4");
                }
                splitAmount = splitAmount.add(amount);
            }
            if (splitAmount.setScale(2, 4).compareTo(splitOrderBO.getAmount().setScale(2, 4)) == 0) continue;
            throw new FscBusinessException("191014", "\u63d0\u4ea4\u8ba2\u5355\u603b\u91d1\u989d\u4e0e\u540e\u7aef\u4e0d\u4e00\u81f4");
        }
    }

    private void checkResult(FscOrderPO fscOrderPO, List<Long> inspectionVoucherIdList) {
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) || FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
            FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
            fscCheckResultPO.setAcceptOrderIds(inspectionVoucherIdList);
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType())) {
                fscCheckResultPO.setStatus(FscConstants.BillCheck.EQUALS);
            }
            if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                fscCheckResultPO.setStatus(FscConstants.BillCheck.EQUALS);
            }
            Integer checkCount = this.fscCheckResultMapper.getCheckBy(fscCheckResultPO);
            log.info("\u5bf9\u8d26\u4e00\u81f4\u6570\u91cf:{}", (Object)checkCount);
            if (!checkCount.equals(inspectionVoucherIdList.size())) {
                throw new FscBusinessException("191014", "\u5bf9\u8d26\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5f00\u7968");
            }
        }
    }

    private void sendMq(FscOrderInvoiceItemAddAbilityReqBO reqBO, List<Long> orderIds) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        PebExtOrderSettleTypeUpdateAbilityReqBO settleReqBO = new PebExtOrderSettleTypeUpdateAbilityReqBO();
        settleReqBO.setUserType(reqBO.getReceiveType());
        settleReqBO.setSettleType(FscConstants.SettleType.INSPECTION);
        settleReqBO.setOrderIds(orderIds);
        this.pebExtOrderSettleTypeUpdateAbilityService.dealOrderSettleType(settleReqBO);
    }

    public String valTaxRate(List<Long> inspectionVoucherIdList, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, Long fscOrderId) {
        if (fscOrderInfoBoMap.get(inspectionVoucherIdList.get(0)) == null) {
            throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
        }
        BigDecimal firstTaxRate = ((FscOrderItemBO)fscOrderInfoBoMap.get(inspectionVoucherIdList.get(0)).getFscOrderItemBOS().get(0)).getTaxRate();
        for (Long inspectionVoucherId : inspectionVoucherIdList) {
            FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.get(inspectionVoucherId);
            if (fscOrderInfoBO == null) {
                throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
            }
            for (FscOrderItemBO item : fscOrderInfoBO.getFscOrderItemBOS()) {
                if (BigDecimal.ONE.equals(firstTaxRate.add(BigDecimal.ONE).divide(item.getTaxRate().add(BigDecimal.ONE)))) continue;
                throw new FscBusinessException("193008", "\u591a\u4e2a\u9a8c\u6536\u5355\u7684\u660e\u7ec6\u7a0e\u7387\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968");
            }
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderId);
        List itemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)itemPOList)) {
            for (FscOrderItemPO item : itemPOList) {
                if (BigDecimal.ONE.equals(firstTaxRate.add(BigDecimal.ONE).divide(item.getTaxRate().add(BigDecimal.ONE)))) continue;
                throw new FscBusinessException("193008", "\u591a\u4e2a\u9a8c\u6536\u5355\u7684\u660e\u7ec6\u7a0e\u7387\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968");
            }
        }
        return "";
    }

    public void checkPrePayBill(List<Long> orderIdList, Long payeeId) {
        if (!CollectionUtils.isEmpty(orderIdList)) {
            FscShouldPayPO queryVo = new FscShouldPayPO();
            queryVo.setOrderIds(orderIdList);
            queryVo.setPayeeId(payeeId);
            queryVo.setShouldPayMethod(FscPayTypeEnum.ADVANCE_PAY.getCode());
            List list = this.fscShouldPayMapper.getAdvanceList(queryVo);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                list.forEach(e -> {
                    String orderNo = Objects.isNull(e.getOrderCodeStr()) ? e.getObjectNo() : e.getOrderCodeStr();
                    throw new FscBusinessException("190000", "[" + orderNo + "]\u8ba2\u5355\u5b58\u5728\u9884\u4ed8\u6b3e\u7533\u8bf7\uff0c\u8bf7\u5c06\u4ed8\u6b3e\u7533\u8bf7\u6d41\u7a0b\u8d70\u5b8c\u540e\uff0c\u91cd\u65b0\u53d1\u8d77\u7ed3\u7b97\uff01");
                });
            }
        }
    }
}

