/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillLineBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimBillService;
import com.tydic.fsc.common.busi.api.FscPushYcRecvClaimBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimBillBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPushYcRecvClaimBillBusiServiceImpl
implements FscPushYcRecvClaimBillBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushYcRecvClaimBillBusiServiceImpl.class);
    @Autowired
    private FscPushYcRecvClaimBillService fscPushYcRecvClaimBillService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;

    @Override
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public FscPushYcRecvClaimBillBusiRspBO pushYcRecvClaim(FscPushYcRecvClaimBillBusiReqBO reqBO) {
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba4\u9886\u5355\u4fe1\u606f\uff01" + reqBO.getClaimId());
        }
        List<Object> claimDetailList = new ArrayList();
        if (!CollectionUtils.isEmpty(reqBO.getClaimList())) {
            claimDetailList = reqBO.getClaimList();
        } else if (!CollectionUtils.isEmpty(reqBO.getDetailIdList())) {
            claimDetailList = this.fscClaimDetailMapper.selectClaimInfoListByDetailIds(reqBO.getDetailIdList());
            for (FscClaimDetailBO fscClaimDetailBO : claimDetailList) {
                if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getPushStatus()) && !fscClaimDetailBO.getPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) continue;
                throw new FscBusinessException("190000", "\u53ea\u6709\u63a8\u9001\u5931\u8d25\u7684\u6570\u636e\u53ef\u4ee5\u91cd\u65b0\u63a8\u9001\uff01");
            }
        }
        if (CollectionUtils.isEmpty(claimDetailList) && !StringUtils.isEmpty((Object)fscRecvClaimPo.getStatus()) && fscRecvClaimPo.getStatus() == 0) {
            claimDetailList = this.fscClaimDetailMapper.selectClaimInfoListByCliaimId(reqBO.getClaimId());
        }
        if (CollectionUtils.isEmpty(claimDetailList) && fscRecvClaimPo.getNoClaimAmt().compareTo(fscRecvClaimPo.getRecvAmt()) != 0) {
            throw new FscBusinessException("190000", "\u8ba4\u9886\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscPushYcRecvClaimBillBusiRspBO rspBO = new FscPushYcRecvClaimBillBusiRspBO();
        FscPushYcRecvClaimBillReqBO fscPushYcRecvClaimBillReqBO = new FscPushYcRecvClaimBillReqBO();
        ArrayList<Long> detailIdList = new ArrayList<Long>();
        try {
            FscGetErpCustInfoReqBO custInfoReqBO = new FscGetErpCustInfoReqBO();
            custInfoReqBO.setCustomerName(fscRecvClaimPo.getCustomerName());
            FscGetErpCustInfoRspBO custInfoRspBO = this.fscGetErpCustInfoService.getErpCustInfo(custInfoReqBO);
            if (!custInfoRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(custInfoRspBO.getRespCode(), custInfoRspBO.getRespDesc());
            }
            FscPushYcRecvClaimBillBO claimBillBO = new FscPushYcRecvClaimBillBO();
            claimBillBO.setORG_ID(this.operationOrgId);
            claimBillBO.setORG_NAME(this.operationOrgName);
            claimBillBO.setCHARGEMAN_ID(fscRecvClaimPo.getHandleUserId().toString());
            claimBillBO.setCHARGEMAN_NAME(fscRecvClaimPo.getHandleUserName());
            claimBillBO.setDEPT_ID(fscRecvClaimPo.getHandleDeptId().toString());
            claimBillBO.setDEPT_NAME(fscRecvClaimPo.getHandleDeptName());
            claimBillBO.setRECEIVABLE_CLAIM_NUMBER(fscRecvClaimPo.getClaimNo());
            claimBillBO.setBANK_SERIAL_NUMBER(fscRecvClaimPo.getSerialNumber());
            FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
            eternalPo.setPCode("RECEIVABLES_CLAIM_TYPE");
            Map<String, String> dicMap = this.getDicMap(eternalPo);
            claimBillBO.setRECEIVABLE_CLAIM_TYPE(dicMap.get(fscRecvClaimPo.getRecvType()));
            claimBillBO.setCUSTOMER_ID(custInfoRspBO.getCustAccountId());
            claimBillBO.setCUSTOMER_NAME(fscRecvClaimPo.getCustomerName());
            claimBillBO.setCUSTOMER_SITE_ID(null);
            claimBillBO.setCUSTOMER_SITE_NAME(null);
            claimBillBO.setSUB_ACCOUNT(fscRecvClaimPo.getChildAccount());
            claimBillBO.setRECEIVABLE_AMT(fscRecvClaimPo.getRecvAmt().toString());
            claimBillBO.setRECEIVE_BANK_ID(fscRecvClaimPo.getBankId());
            claimBillBO.setRECEIVE_BANK(fscRecvClaimPo.getBankName());
            claimBillBO.setSUB_BRANCH(fscRecvClaimPo.getAccountBranch());
            claimBillBO.setBANK_ACCOUNT(fscRecvClaimPo.getBankAccount());
            claimBillBO.setRECEIVABLE_DATE(DateUtil.dateToStr((Date)fscRecvClaimPo.getRecvDate()));
            eternalPo.setPCode("FSC_CLAIM_STATUS_TYPE");
            Map<String, String> claimStatusMap = this.getDicMap(eternalPo);
            claimBillBO.setCLAIM_STATUS(claimStatusMap.get(fscRecvClaimPo.getClaimStatus()));
            claimBillBO.setREMARKS(fscRecvClaimPo.getRemark());
            claimBillBO.setTESCO_ID(fscRecvClaimPo.getClaimId());
            claimBillBO.setRECEIVABLE_CLAIM_ID("");
            claimBillBO.setUNCLAIM_AMT(fscRecvClaimPo.getNoClaimAmt());
            if (fscRecvClaimPo.getClaimStatus() != null && "3".equals(fscRecvClaimPo.getClaimStatus())) {
                claimBillBO.setCLAIM_STATUS("Y");
                claimBillBO.setUNCLAIM_AMT(BigDecimal.ZERO);
            }
            claimBillBO.setPAYEE("");
            LinkedList<FscPushYcRecvClaimBillLineBO> claimBillList = new LinkedList<FscPushYcRecvClaimBillLineBO>();
            for (FscClaimDetailBO fscClaimDetailBO : claimDetailList) {
                FscPushYcRecvClaimBillLineBO lineBO = new FscPushYcRecvClaimBillLineBO();
                detailIdList.add(fscClaimDetailBO.getClaimDetailId());
                lineBO.setCHARGEMAN_ID(fscClaimDetailBO.getHandleUserId().toString());
                lineBO.setCHARGEMAN_NAME(fscClaimDetailBO.getHandleUserName());
                lineBO.setDEPT_ID(fscClaimDetailBO.getHandleDeptId().toString());
                lineBO.setDEPT_NAME(fscClaimDetailBO.getHandleDeptName());
                FscDicDictionaryExernalPO eternal = new FscDicDictionaryExernalPO();
                eternal.setPCode("FSC_YC_CLAIM_TYPE");
                Map<String, String> dicMapE = this.getDicMap(eternal);
                lineBO.setCLAIM_TYPE(dicMapE.get(fscClaimDetailBO.getClaimType()));
                if (fscClaimDetailBO.getOrderId() != null) {
                    lineBO.setCONTRACT_ID(fscClaimDetailBO.getOrderId().toString());
                }
                lineBO.setCONTRACT_NUMBER(fscClaimDetailBO.getOrderCode());
                if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getFscOrderId())) {
                    lineBO.setBILL_ID(fscClaimDetailBO.getFscOrderId().toString());
                    lineBO.setBILL_NUMBER(fscClaimDetailBO.getFscOrderNo());
                } else {
                    lineBO.setBILL_NUMBER(fscClaimDetailBO.getDetailNo());
                    lineBO.setBILL_ID(fscClaimDetailBO.getClaimDetailId().toString());
                }
                lineBO.setCLAIM_AMT(fscClaimDetailBO.getClaimAmt());
                lineBO.setCLAIM_DATE(DateUtil.dateToStr((Date)fscClaimDetailBO.getClaimDate()));
                lineBO.setCANCEL_CLAIM_DATE(DateUtil.dateToStr((Date)fscClaimDetailBO.getCancelClaimDate()));
                lineBO.setTESCO_ID(fscClaimDetailBO.getClaimDetailId());
                if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getStatus()) && fscClaimDetailBO.getStatus().equals("1")) {
                    lineBO.setCANCEL_CLAIM_DATE(null);
                }
                claimBillList.add(lineBO);
            }
            fscPushYcRecvClaimBillReqBO.setReceivable(claimBillBO);
            fscPushYcRecvClaimBillReqBO.setReceivableClaim(claimBillList);
            FscPushYcRecvClaimBillRspBO pushRspBo = this.fscPushYcRecvClaimBillService.pushRecvClaimBill(fscPushYcRecvClaimBillReqBO);
            if (!pushRspBo.getRespCode().equals("0000")) {
                this.saveLog(fscRecvClaimPo, FscConstants.FscPushStatus.FAIL, JSONObject.toJSONString((Object)fscPushYcRecvClaimBillReqBO));
                rspBO.setRespCode(pushRspBo.getRespCode());
                rspBO.setRespDesc(pushRspBo.getRespDesc());
                this.savePushStatus(detailIdList, 0, pushRspBo.getRespDesc());
                return rspBO;
            }
            this.savePushStatus(detailIdList, 1, null);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4e1a\u8d22\u8ba4\u9886\u5355\u5931\u8d25\uff01" + e);
            this.savePushStatus(detailIdList, 0, e.getMessage());
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        this.saveLog(fscRecvClaimPo, FscConstants.FscPushStatus.SUCCESS, JSONObject.toJSONString((Object)fscPushYcRecvClaimBillReqBO));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveLog(FscRecvClaimPO fscRecvClaimPo, Integer status, String jsonStr) {
        try {
            FscPushLogPO fscPushLogPo = new FscPushLogPO();
            fscPushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPushLogPo.setObjectId(fscRecvClaimPo.getClaimId());
            fscPushLogPo.setObjectNo(fscRecvClaimPo.getClaimNo());
            fscPushLogPo.setType(FscConstants.FscPushType.CLAIM);
            fscPushLogPo.setCreateTime(new Date());
            fscPushLogPo.setStatus(status);
            fscPushLogPo.setObjData(jsonStr);
            this.fscPushLogMapper.insert(fscPushLogPo);
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }

    private void savePushStatus(List<Long> detailIdList, Integer status, String failReason) {
        if (!CollectionUtils.isEmpty(detailIdList)) {
            this.fscClaimDetailMapper.updateBtachByDetailId(detailIdList, status, failReason);
        }
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
    }
}

