/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcUniteParamQryListDetailAbilityService;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscClaimSendYcCancelBO;
import com.tydic.fsc.common.busi.api.FscRecvClaimConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscRecvClaimConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimConfirmBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscShouldPayForOrderClaimMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.AdvancePayTypeEnum;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAccountSerialPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.po.FscShouldPayForOrderClaimPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscRecvClaimConfirmBusiServiceImpl
implements FscRecvClaimConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimConfirmBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private CfcUniteParamQryListDetailAbilityService cfcUniteParamQryListDetailAbilityService;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Value(value="${acceptOrderTabId:80013}")
    private Integer TAB_ID;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    private static final Integer IS_CREDIT = 1;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private PebExtOrderSettleTypeUpdateAbilityService pebExtOrderSettleTypeUpdateAbilityService;
    @Autowired
    private FscShouldPayForOrderClaimMapper fscShouldPayForOrderClaimMapper;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @BigDecimalConvert(value=2)
    public FscRecvClaimConfirmBusiRspBO recvClaimConfirm(FscRecvClaimConfirmBusiReqBO reqBO) {
        ArrayList subList;
        ArrayList addList;
        int count;
        int count2;
        Integer operationClaimType = 2;
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("190000", "\u6536\u6b3e\u8ba4\u9886\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (fscRecvClaimPo.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            throw new FscBusinessException("190000", "\u8be5\u8ba4\u9886\u5355\u5df2\u5b8c\u6210\u8ba4\u9886\uff0c\u8bf7\u52ff\u91cd\u590d\u8ba4\u9886\uff01");
        }
        BigDecimal claimAmt = BigDecimal.ZERO;
        for (FscClaimDetailBO fscClaimDetailBO : reqBO.getClaimDetailList()) {
            if (fscClaimDetailBO.getOperationType() == 1) {
                claimAmt = claimAmt.add(fscClaimDetailBO.getClaimAmt());
            } else if (fscClaimDetailBO.getOperationType() == 2) {
                claimAmt = claimAmt.subtract(fscClaimDetailBO.getClaimAmt());
            }
            if (claimAmt.compareTo(fscRecvClaimPo.getNoClaimAmt()) <= 0) continue;
            throw new FscBusinessException("190000", "\u672c\u6b21\u8ba4\u9886\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba4\u9886\u5355\u672a\u8ba4\u9886\u91d1\u989d\uff01");
        }
        fscRecvClaimPo.setNoClaimAmt(fscRecvClaimPo.getNoClaimAmt().subtract(claimAmt));
        ArrayList<Object> settleNoList = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)fscRecvClaimPo.getSettleNo()) && fscRecvClaimPo.getSettleNo().contains(",")) {
            settleNoList = new ArrayList<String>(Arrays.asList(fscRecvClaimPo.getSettleNo().split(",")));
        } else if (!StringUtils.isEmpty((Object)fscRecvClaimPo.getSettleNo())) {
            settleNoList.add(fscRecvClaimPo.getSettleNo());
        }
        if (!CollectionUtils.isEmpty(reqBO.getClaimDetailList()) && !StringUtils.isEmpty((Object)reqBO.getClaimDetailList().get(0).getFscOrderNo())) {
            operationClaimType = 1;
        }
        FscRecvClaimConfirmBusiRspBO rspBO = new FscRecvClaimConfirmBusiRspBO();
        rspBO.setPushFlag(false);
        LinkedList<FscClaimDetailPO> addClaimDetailList = new LinkedList<FscClaimDetailPO>();
        LinkedList<FscClaimDetailPO> updateClaimDetailList = new LinkedList<FscClaimDetailPO>();
        LinkedList<FscOrderRelationPO> relationAddList = new LinkedList<FscOrderRelationPO>();
        LinkedList<FscOrderRelationPO> relationSubList = new LinkedList<FscOrderRelationPO>();
        LinkedList shouldPayAddList = new LinkedList();
        LinkedList shouldPaySubList = new LinkedList();
        HashMap<Long, FscShouldPayPO> shouldPayAddMap = new HashMap<Long, FscShouldPayPO>();
        HashMap<Long, FscShouldPayPO> shouldPaySubMap = new HashMap<Long, FscShouldPayPO>();
        LinkedList<FscOrderPO> orderPayAddList = new LinkedList<FscOrderPO>();
        LinkedList<FscOrderPO> orderPaySubList = new LinkedList<FscOrderPO>();
        LinkedList<FscClaimDetailBO> pushDetailBOList = new LinkedList<FscClaimDetailBO>();
        ArrayList<FscClaimSendYcCancelBO> cancelList = new ArrayList<FscClaimSendYcCancelBO>();
        FscAccountSerialPO serialPo = new FscAccountSerialPO();
        serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
        serialPo = this.fscAccountSerialMapper.getModelBy(serialPo);
        Integer serialNumber = 0;
        if (serialPo != null) {
            serialNumber = serialPo.getSerialNumber();
        }
        ArrayList<Long> electronicOrderIds = new ArrayList<Long>();
        ArrayList<FscClaimDetailPO> employeeSettleList = new ArrayList<FscClaimDetailPO>();
        ArrayList<Long> settleList = new ArrayList<Long>();
        ArrayList<Long> preList = new ArrayList<Long>();
        ArrayList<FscShouldPayPO> paidAmtAddList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscShouldPayPO> paidAmtSubList = new ArrayList<FscShouldPayPO>();
        ArrayList<Long> settleOrderIDs = new ArrayList<Long>();
        ArrayList<FscShouldPayForOrderClaimPO> deletePos = new ArrayList<FscShouldPayForOrderClaimPO>();
        for (FscClaimDetailBO fscClaimDetailBO : reqBO.getClaimDetailList()) {
            FscOrderPO orderPO;
            FscShouldPayPO fscShouldPayPo;
            FscOrderRelationPO relationPO;
            FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
            BeanUtils.copyProperties((Object)fscClaimDetailBO, (Object)fscClaimDetailPo);
            fscClaimDetailPo.setClaimId(reqBO.getClaimId());
            if (fscClaimDetailBO.getOperationType() == null || fscClaimDetailBO.getOperationType() == 1) {
                if (StringUtils.isEmpty((Object)fscClaimDetailPo.getClaimDetailId())) {
                    Object[] objectArray = new Object[1];
                    serialNumber = serialNumber + 1;
                    objectArray[0] = serialNumber;
                    String detailNo = fscRecvClaimPo.getClaimNo() + "-" + String.format("%02d", objectArray);
                    fscClaimDetailPo.setDetailNo(detailNo);
                    fscClaimDetailPo.setStatus("1");
                    fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscClaimDetailPo.setSysSource(Integer.valueOf(1));
                    fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
                    BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)fscClaimDetailBO);
                    pushDetailBOList.add(fscClaimDetailBO);
                    addClaimDetailList.add(fscClaimDetailPo);
                } else {
                    fscClaimDetailPo.setStatus("1");
                    pushDetailBOList.add(fscClaimDetailBO);
                    updateClaimDetailList.add(fscClaimDetailPo);
                }
                if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getFscOrderNo())) {
                    settleNoList.add(fscClaimDetailBO.getFscOrderNo());
                }
                if (operationClaimType == 1) {
                    relationPO = new FscOrderRelationPO();
                    relationPO.setAcceptOrderId(fscClaimDetailPo.getObjectId());
                    relationPO.setOperationClaimAmt(fscClaimDetailBO.getClaimAmt());
                    relationPO.setFscOrderId(fscClaimDetailBO.getFscOrderId());
                    relationPO.setId(fscClaimDetailBO.getOrderRelationId());
                    relationAddList.add(relationPO);
                    if (FscClaimTypeEnum.EMPLOYEE_WELFARE_SETTLE_CLAIM.getCode().equals(fscClaimDetailPo.getClaimType())) {
                        employeeSettleList.add(fscClaimDetailPo);
                    }
                    settleList.add(fscClaimDetailPo.getClaimDetailId());
                } else {
                    fscShouldPayPo = new FscShouldPayPO();
                    fscShouldPayPo.setShouldPayId(fscClaimDetailBO.getObjectId());
                    fscShouldPayPo.setClaimAmt(fscClaimDetailBO.getClaimAmt());
                    if (shouldPayAddMap.containsKey(fscClaimDetailBO.getObjectId())) {
                        BigDecimal add = ((FscShouldPayPO)shouldPayAddMap.get(fscClaimDetailBO.getObjectId())).getClaimAmt().add(fscClaimDetailBO.getClaimAmt());
                        ((FscShouldPayPO)shouldPayAddMap.get(fscClaimDetailBO.getObjectId())).setClaimAmt(add);
                    } else {
                        shouldPayAddMap.put(fscClaimDetailBO.getObjectId(), fscShouldPayPo);
                    }
                    if (fscClaimDetailBO.getPayOrderId() != null) {
                        orderPO = new FscOrderPO();
                        orderPO.setFscOrderId(fscClaimDetailBO.getPayOrderId());
                        orderPO.setShouldPayId(fscClaimDetailBO.getObjectId());
                        orderPO.setClaimAmount(fscClaimDetailBO.getClaimAmt());
                        orderPayAddList.add(orderPO);
                    } else {
                        FscShouldPayPO paidAmtAddPo = new FscShouldPayPO();
                        paidAmtAddPo.setShouldPayId(fscClaimDetailBO.getObjectId());
                        paidAmtAddPo.setClaimAmt(fscClaimDetailBO.getClaimAmt());
                        paidAmtAddList.add(paidAmtAddPo);
                        settleOrderIDs.add(fscClaimDetailBO.getOrderId());
                        if (fscClaimDetailBO.getOrderId() != null) {
                            FscShouldPayForOrderClaimPO deletePayPo = new FscShouldPayForOrderClaimPO();
                            deletePayPo.setOrderId(fscClaimDetailBO.getOrderId());
                            deletePos.add(deletePayPo);
                        }
                    }
                    preList.add(fscClaimDetailPo.getClaimDetailId());
                }
                if (!FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode().equals(fscClaimDetailPo.getClaimType()) || operationClaimType != 1 || fscClaimDetailPo.getClaimAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                electronicOrderIds.add(fscClaimDetailPo.getOrderId());
                continue;
            }
            if (fscClaimDetailBO.getOperationType() != 2) continue;
            if (fscClaimDetailPo.getClaimId() == null) {
                fscClaimDetailPo.setClaimId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            if (!StringUtils.isEmpty((Object)fscClaimDetailBO.getFscOrderNo()) && settleNoList.size() > 0) {
                settleNoList.remove(fscClaimDetailBO.getFscOrderNo());
            }
            fscClaimDetailPo.setStatus("0");
            fscClaimDetailPo.setClaimAmt(fscClaimDetailBO.getClaimAmt());
            fscClaimDetailPo.setCancelClaimDate(fscClaimDetailBO.getCancelClaimDate());
            fscClaimDetailPo.setSysSource(Integer.valueOf(1));
            fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
            if (!StringUtils.isEmpty((Object)fscClaimDetailPo.getClaimDetailId())) {
                FscClaimSendYcCancelBO ycCancelBO = new FscClaimSendYcCancelBO();
                ycCancelBO.setCANCEL_CLAIM_DATE(DateUtil.dateToStr((Date)fscClaimDetailPo.getCancelClaimDate()));
                ycCancelBO.setCLAIM_TESCO_ID(fscClaimDetailPo.getClaimDetailId().toString());
                cancelList.add(ycCancelBO);
            }
            updateClaimDetailList.add(fscClaimDetailPo);
            if (operationClaimType == 1 && fscClaimDetailPo.getClaimDetailId() != null) {
                relationPO = new FscOrderRelationPO();
                relationPO.setAcceptOrderId(fscClaimDetailPo.getObjectId());
                relationPO.setFscOrderId(fscClaimDetailPo.getFscOrderId());
                relationPO.setId(fscClaimDetailBO.getOrderRelationId());
                if (fscClaimDetailBO.getCancelAmt() == null) {
                    relationPO.setOperationClaimAmt(BigDecimal.ZERO);
                } else {
                    relationPO.setOperationClaimAmt(fscClaimDetailBO.getCancelAmt());
                }
                relationSubList.add(relationPO);
            } else if (fscClaimDetailPo.getClaimDetailId() != null) {
                fscShouldPayPo = new FscShouldPayPO();
                fscShouldPayPo.setShouldPayId(fscClaimDetailBO.getObjectId());
                if (fscClaimDetailBO.getCancelAmt() == null) {
                    fscShouldPayPo.setClaimAmt(BigDecimal.ZERO);
                } else {
                    fscShouldPayPo.setClaimAmt(fscClaimDetailBO.getCancelAmt());
                }
                if (shouldPaySubMap.containsKey(fscClaimDetailBO.getObjectId())) {
                    BigDecimal sub = ((FscShouldPayPO)shouldPaySubMap.get(fscClaimDetailBO.getObjectId())).getClaimAmt().add(fscShouldPayPo.getClaimAmt());
                    ((FscShouldPayPO)shouldPaySubMap.get(fscClaimDetailBO.getObjectId())).setClaimAmt(sub);
                } else {
                    shouldPaySubMap.put(fscClaimDetailBO.getObjectId(), fscShouldPayPo);
                }
                if (fscClaimDetailBO.getPayOrderId() != null) {
                    orderPO = new FscOrderPO();
                    orderPO.setFscOrderId(fscClaimDetailBO.getPayOrderId());
                    orderPO.setShouldPayId(fscClaimDetailBO.getObjectId());
                    orderPO.setClaimAmount(fscShouldPayPo.getClaimAmt());
                    orderPaySubList.add(orderPO);
                } else {
                    FscShouldPayPO paidAmtSubPo = new FscShouldPayPO();
                    paidAmtSubPo.setShouldPayId(fscClaimDetailBO.getObjectId());
                    paidAmtSubPo.setClaimAmt(fscShouldPayPo.getClaimAmt());
                    paidAmtSubList.add(paidAmtSubPo);
                }
            }
            BeanUtils.copyProperties((Object)fscClaimDetailPo, (Object)fscClaimDetailBO);
        }
        if (!CollectionUtils.isEmpty(settleOrderIDs)) {
            FscShouldPayPO fscShouldPayPOReq = new FscShouldPayPO();
            fscShouldPayPOReq.setOrderIds(settleOrderIDs);
            fscShouldPayPOReq.setPayeeId(this.operationOrgId);
            fscShouldPayPOReq.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_GRADING_PAY);
            List payPOList = this.fscShouldPayMapper.getListByOrderId(fscShouldPayPOReq);
            if (!CollectionUtils.isEmpty((Collection)payPOList)) {
                String orderNo = payPOList.stream().map(FscShouldPayPO::getOrderCodeStr).filter(orderCodeStr -> !StringUtils.isEmpty((Object)orderCodeStr)).distinct().collect(Collectors.joining(","));
                orderNo = StringUtils.isEmpty((Object)orderNo) ? "\u6240\u9009\u8ba2\u5355" : orderNo;
                throw new FscBusinessException("194203", orderNo + "\u5df2\u901a\u8fc7\u7279\u6b8a\u4ed8\u6b3e\u4e1a\u52a1\u53d1\u8d77\u4ed8\u6b3e");
            }
            PebExtOrderSettleTypeUpdateAbilityReqBO settleReqBO = new PebExtOrderSettleTypeUpdateAbilityReqBO();
            settleReqBO.setUserType(UocCoreConstant.UserType.PUR);
            settleReqBO.setSettleType(FscConstants.SettleType.INSPECTION);
            settleReqBO.setOrderIds(settleOrderIDs);
            PebExtOrderSettleTypeUpdateAbilityRspBO orderUpdateRspBO = this.pebExtOrderSettleTypeUpdateAbilityService.dealOrderSettleType(settleReqBO);
            if (!"0000".equals(orderUpdateRspBO.getRespCode())) {
                log.error("\u540c\u6b65\u8ba2\u5355\u7ed3\u7b97\u7c7b\u578b\u5931\u8d25\uff1a" + orderUpdateRspBO.getRespDesc());
            }
        }
        if (!CollectionUtils.isEmpty(addClaimDetailList)) {
            this.fscClaimDetailMapper.insertBatch(addClaimDetailList);
        }
        if (!CollectionUtils.isEmpty(updateClaimDetailList)) {
            this.fscClaimDetailMapper.updateBatch(updateClaimDetailList);
        }
        if (!CollectionUtils.isEmpty(relationAddList) && (count2 = this.fscOrderRelationMapper.updateOperationClaimAmtAddBatch(relationAddList)) != relationAddList.size()) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        if (!CollectionUtils.isEmpty(relationSubList) && (count = this.fscOrderRelationMapper.updateOperationClaimAmtSubBatch(relationSubList)) != relationSubList.size()) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        if (shouldPayAddMap.size() > 0 && (count = this.fscShouldPayMapper.updateClaimAmountAdd(addList = new ArrayList(shouldPayAddMap.values()))) != addList.size()) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        if (shouldPaySubMap.size() > 0 && (count = this.fscShouldPayMapper.updateClaimAmountSub(subList = new ArrayList(shouldPaySubMap.values()))) != subList.size()) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        if (paidAmtAddList.size() > 0 && (count = this.fscShouldPayMapper.updateClaimPaidAmountAdd(paidAmtAddList)) != paidAmtAddList.size()) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        if (paidAmtSubList.size() > 0 && (count = this.fscShouldPayMapper.updateClaimPaidAmountSub(paidAmtSubList)) != paidAmtSubList.size()) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        if (!CollectionUtils.isEmpty(orderPayAddList)) {
            count = this.fscOrderPayItemMapper.updateOperationClaimAmountAdd(orderPayAddList);
        }
        if (!CollectionUtils.isEmpty(orderPaySubList)) {
            count = this.fscOrderPayItemMapper.updateOperationClaimAmountSub(orderPaySubList);
        }
        FscRecvClaimPO fscRecvClaim = new FscRecvClaimPO();
        fscRecvClaim.setClaimId(reqBO.getClaimId());
        fscRecvClaim.setStatus(Integer.valueOf(0));
        fscRecvClaim.setNoClaimAmt(reqBO.getNoClaimAmt());
        if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.CLAIM.getCode());
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.COMPLETE.getCode());
            rspBO.setPushFlag(true);
        } else if (reqBO.getNoClaimAmt().compareTo(BigDecimal.ZERO) > 0 && reqBO.getNoClaimAmt().compareTo(fscRecvClaimPo.getRecvAmt()) != 0) {
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        } else if (reqBO.getNoClaimAmt().compareTo(fscRecvClaimPo.getRecvAmt()) == 0) {
            fscRecvClaim.setClaimStatus(FscClaimStatusEnum.NOT_CLAIM.getCode());
            fscRecvClaim.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
        }
        if (!CollectionUtils.isEmpty(settleNoList)) {
            fscRecvClaim.setSettleNo(settleNoList.stream().distinct().collect(Collectors.joining(",")));
        }
        this.fscRecvClaimMapper.update(fscRecvClaim);
        if (serialPo == null) {
            serialPo = new FscAccountSerialPO();
            serialPo.setSerialNumber(serialNumber);
            serialPo.setClaimNo(fscRecvClaimPo.getClaimNo());
            serialPo.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
            this.fscAccountSerialMapper.insert(serialPo);
        } else {
            serialPo.setSerialNumber(serialNumber);
            this.fscAccountSerialMapper.update(serialPo);
        }
        if (!CollectionUtils.isEmpty(employeeSettleList)) {
            this.dealDeduct(employeeSettleList, reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setElectronicOrderIds(electronicOrderIds);
        rspBO.setPushDetailBOList(pushDetailBOList);
        rspBO.setCancelList(cancelList);
        rspBO.setPreList(preList);
        rspBO.setSettleList(settleList);
        return rspBO;
    }

    private void dealDeduct(List<FscClaimDetailPO> employeeSettleList, FscRecvClaimConfirmBusiReqBO reqBO) {
        List detailIds = employeeSettleList.stream().map(e -> e.getClaimDetailId()).collect(Collectors.toList());
        FscPayLogPO payLogPo = new FscPayLogPO();
        payLogPo.setObjIds(detailIds);
        payLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_WELFARE_RETURN);
        List objIds = this.fscPayLogMapper.getPaidObjIds(payLogPo);
        employeeSettleList = employeeSettleList.stream().filter(e -> !objIds.contains(e.getClaimDetailId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(employeeSettleList)) {
            log.error("\u91cd\u590d\u6263\u6b3e\u6821\u9a8c\u540e\u5217\u8868\u4e3a\u7a7a");
            return;
        }
        FscOrderPO reqOrderPo = new FscOrderPO();
        List fscOrderIds = employeeSettleList.stream().map(e -> e.getFscOrderId()).collect(Collectors.toList());
        reqOrderPo.setFscOrderIds(fscOrderIds);
        List list = this.fscOrderMapper.getList(reqOrderPo);
        Map<Object, Object> fscOrderPOMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            fscOrderPOMap = list.stream().collect(Collectors.toMap(e -> e.getFscOrderId(), Function.identity(), (e1, e2) -> e2));
        }
        HashMap<String, List> deductMap = new HashMap<String, List>();
        for (FscClaimDetailPO fscClaimDetailPO : employeeSettleList) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            if (fscOrderPOMap.containsKey(fscClaimDetailPO.getFscOrderId())) {
                fscOrderPO = (FscOrderPO)fscOrderPOMap.get(fscClaimDetailPO.getFscOrderId());
            }
            FscCreditDeductAtomBO atomBO = new FscCreditDeductAtomBO();
            atomBO.setAmount(fscClaimDetailPO.getClaimAmt());
            atomBO.setOrderNo(fscClaimDetailPO.getOrderCode());
            atomBO.setObjId(fscClaimDetailPO.getClaimDetailId());
            atomBO.setAcceptOrderId(fscClaimDetailPO.getObjectId());
            atomBO.setOrderType(fscOrderPO.getOrderType());
            atomBO.setOrderId(fscClaimDetailPO.getOrderId());
            if (!StringUtils.isEmpty((Object)fscOrderPO.getBuynerNo()) && deductMap.get(fscOrderPO.getBuynerNo()) == null) {
                ArrayList<FscCreditDeductAtomBO> atomList = new ArrayList<FscCreditDeductAtomBO>();
                atomList.add(atomBO);
                deductMap.put(fscOrderPO.getBuynerNo(), atomList);
                continue;
            }
            if (StringUtils.isEmpty((Object)fscOrderPO.getBuynerNo())) continue;
            List atomBOS = (List)deductMap.get(fscOrderPO.getBuynerNo());
            atomBOS.add(atomBO);
            deductMap.put(fscOrderPO.getBuynerNo(), atomBOS);
        }
        Set keys = deductMap.keySet();
        for (String key : keys) {
            UmcEnterpriseOrgQryDetailAbilityReqBO abilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            abilityReqBO.setOrgCode(key);
            log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4e70\u53d7\u4eba\u6240\u5c5e\u673a\u6784\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityReqBO));
            UmcEnterpriseOrgQryDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(abilityReqBO);
            log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4e70\u53d7\u4eba\u6240\u5c5e\u673a\u6784\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(abilityRspBO.getRespCode(), "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5931\u8d25\uff01" + abilityRspBO.getRespDesc());
            }
            if (abilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
                throw new FscBusinessException("198888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            FscCreditDeductAtomReqBO atomReqBO = new FscCreditDeductAtomReqBO();
            atomReqBO.setCreditOrgId(abilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgId());
            atomReqBO.setCreditOrgCode(key);
            atomReqBO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_WELFARE_RETURN);
            atomReqBO.setPayBusiness("4");
            atomReqBO.setName(reqBO.getName());
            atomReqBO.setUserId(reqBO.getUserId());
            List atomBOS = (List)deductMap.get(key);
            atomReqBO.setFscCreditDeductAtomBOS(atomBOS);
            atomReqBO.setSupId(this.operationOrgId);
            this.dealAccountDeduct(atomReqBO);
        }
    }

    private void dealAccountDeduct(FscCreditDeductAtomReqBO atomReqBO) {
        FscAccountPO fscAccountPo = new FscAccountPO();
        fscAccountPo.setOrgId(atomReqBO.getCreditOrgId());
        fscAccountPo.setBusiType(atomReqBO.getPayBusiness());
        FscAccountPO modelBy = this.fscAccountMapper.getModelBy(fscAccountPo);
        if (modelBy == null) {
            log.error("orgID:" + fscAccountPo.getOrgId() + " \u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f");
            return;
        }
        if (modelBy.getCompanyCreditAmount() == null || modelBy.getUnionCreditAmount() == null) {
            log.error("\u8d26\u6237:" + modelBy.getId() + " \u6388\u4fe1\u989d\u5ea6\u914d\u7f6e\u4e3anul");
            return;
        }
        BigDecimal companyReturnAmt = BigDecimal.ZERO;
        BigDecimal unionReturnAmt = BigDecimal.ZERO;
        List acceptIds = atomReqBO.getFscCreditDeductAtomBOS().stream().map(FscCreditDeductAtomBO::getAcceptOrderId).collect(Collectors.toList());
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBO.setTabId(this.TAB_ID);
        uocInspectionDetailsListPageQueryReqBO.setInspectionVoucherIdList(acceptIds);
        uocInspectionDetailsListPageQueryReqBO.setPageSize(10000);
        uocInspectionDetailsListPageQueryReqBO.setIsChange("0");
        uocInspectionDetailsListPageQueryReqBO.setIsFscQuery("0");
        uocInspectionDetailsListPageQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uocInspectionDetailsListPageQueryReqBO));
        UocInspectionDetailsListPageQueryRspBO uocInspectionDetailsListPageQueryRspBO = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)uocInspectionDetailsListPageQueryRspBO));
        if ("0000".equals(uocInspectionDetailsListPageQueryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryRspBO.getRows())) {
            Map<String, String> acceptMap = uocInspectionDetailsListPageQueryRspBO.getRows().stream().filter(e -> !StringUtils.isEmpty((Object)e.getWelfareType())).collect(Collectors.toMap(UocInspectionDetailsListBO::getInspectionVoucherId, UocInspectionDetailsListBO::getWelfareType, (e1, e2) -> e2));
            Map<String, String> acceptCodeMap = uocInspectionDetailsListPageQueryRspBO.getRows().stream().collect(Collectors.toMap(UocInspectionDetailsListBO::getInspectionVoucherId, UocInspectionDetailsListBO::getInspectionVoucherCode, (e1, e2) -> e2));
            Map<String, String> acceptErpCodeMap = uocInspectionDetailsListPageQueryRspBO.getRows().stream().collect(Collectors.toMap(UocInspectionDetailsListBO::getInspectionVoucherId, UocInspectionDetailsListBO::getErpInspectionVoucherCode, (e1, e2) -> e2));
            for (FscCreditDeductAtomBO atomBO : atomReqBO.getFscCreditDeductAtomBOS()) {
                if (acceptMap.containsKey(atomBO.getAcceptOrderId().toString()) && FscConstants.WelfareType.COMPANY.equals(Integer.parseInt(acceptMap.get(atomBO.getAcceptOrderId().toString())))) {
                    companyReturnAmt = companyReturnAmt.add(atomBO.getAmount());
                    atomBO.setWelfareType(Integer.valueOf(Integer.parseInt(acceptMap.get(atomBO.getAcceptOrderId().toString()))));
                } else if (acceptMap.containsKey(atomBO.getAcceptOrderId().toString()) && FscConstants.WelfareType.UNION.equals(Integer.parseInt(acceptMap.get(atomBO.getAcceptOrderId().toString())))) {
                    unionReturnAmt = unionReturnAmt.add(atomBO.getAmount());
                    atomBO.setWelfareType(Integer.valueOf(Integer.parseInt(acceptMap.get(atomBO.getAcceptOrderId().toString()))));
                }
                atomBO.setAcceptCode(acceptCodeMap.get(atomBO.getAcceptOrderId().toString()));
                atomBO.setErpAcceptCode(acceptErpCodeMap.get(atomBO.getAcceptOrderId().toString()));
            }
        } else {
            if (!"0000".equals(uocInspectionDetailsListPageQueryRspBO.getRespCode())) {
                throw new FscBusinessException("194304", uocInspectionDetailsListPageQueryRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryRspBO.getRows())) {
                throw new FscBusinessException("194304", "\u672a\u67e5\u8be2\u5230\u9a8c\u6536\u5355\u4fe1\u606f");
            }
        }
        if (companyReturnAmt.compareTo(modelBy.getCompanyCreditUseAmount()) > 0) {
            throw new FscBusinessException("194304", "orgID:" + fscAccountPo.getOrgId() + " \u516c\u53f8\u8fd8\u6b3e\u91d1\u989d\u5927\u4e8e\u5df2\u7528\u6388\u4fe1\u989d\u5ea6");
        }
        if (unionReturnAmt.compareTo(modelBy.getUnionCreditUseAmount()) > 0) {
            throw new FscBusinessException("194304", "orgID:" + fscAccountPo.getOrgId() + " \u5de5\u4f1a\u8fd8\u6b3e\u91d1\u989d\u5927\u4e8e\u5df2\u7528\u6388\u4fe1\u989d\u5ea6");
        }
        if (companyReturnAmt.compareTo(BigDecimal.ZERO) <= 0 && unionReturnAmt.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (companyReturnAmt.compareTo(BigDecimal.ZERO) > 0) {
            modelBy.setCompanyCreditReturnAmount(companyReturnAmt);
        } else {
            modelBy.setCompanyCreditReturnAmount(null);
        }
        if (unionReturnAmt.compareTo(BigDecimal.ZERO) > 0) {
            modelBy.setUnionCreditReturnAmount(unionReturnAmt);
        } else {
            modelBy.setUnionCreditReturnAmount(null);
        }
        int i = this.fscAccountMapper.updateReturnAmt(modelBy);
        if (i < 0) {
            throw new FscBusinessException("194304", "\u66f4\u65b0\u8d26\u6237\u8868\u6388\u4fe1\u8fd8\u6b3e\u5931\u8d25");
        }
        this.writeLog(modelBy, atomReqBO, companyReturnAmt, unionReturnAmt);
    }

    private void writeLog(FscAccountPO modelBy, FscCreditDeductAtomReqBO atomReqBO, BigDecimal companyReturnAmt, BigDecimal unionReturnAmt) {
        Date now = new Date();
        ArrayList<FscPayLogPO> fscPayLogPos = new ArrayList<FscPayLogPO>();
        BigDecimal companyBeforeAmt = modelBy.getCompanyCreditAmount().subtract(modelBy.getCompanyCreditUseAmount() == null ? BigDecimal.ZERO : modelBy.getCompanyCreditUseAmount());
        BigDecimal unionBeforeAmtl = modelBy.getUnionCreditAmount().subtract(modelBy.getUnionCreditUseAmount() == null ? BigDecimal.ZERO : modelBy.getUnionCreditUseAmount());
        for (FscCreditDeductAtomBO fscCreditDeductAtomBO : atomReqBO.getFscCreditDeductAtomBOS()) {
            FscPayLogPO fscPayLogPo = new FscPayLogPO();
            long nextId = Sequence.getInstance().nextId();
            fscPayLogPo.setId(Long.valueOf(nextId));
            fscPayLogPo.setOrgId(atomReqBO.getCreditOrgId());
            fscPayLogPo.setAccountId(modelBy.getId());
            fscPayLogPo.setUserName(atomReqBO.getName());
            fscPayLogPo.setCreateOperId(atomReqBO.getUserId().toString());
            fscPayLogPo.setBusiTime(now);
            fscPayLogPo.setPayeeId(atomReqBO.getSupId());
            fscPayLogPo.setBusiOrderType(Integer.valueOf(2));
            fscPayLogPo.setCreateTime(now);
            fscPayLogPo.setPayBusiness(atomReqBO.getPayBusiness());
            fscPayLogPo.setOrderType(atomReqBO.getOrderType());
            fscPayLogPo.setOrgCode(atomReqBO.getCreditOrgCode());
            fscPayLogPo.setTradeMode(atomReqBO.getTradeMode());
            fscPayLogPo.setObjId(fscCreditDeductAtomBO.getObjId());
            fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_WELFARE_RETURN);
            fscPayLogPo.setBusiOrderNo(fscCreditDeductAtomBO.getOrderNo());
            fscPayLogPo.setBusiOrderId(fscCreditDeductAtomBO.getOrderId());
            fscPayLogPo.setIsCredit(IS_CREDIT);
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.PAYMENT_DAYS.getCode());
            fscPayLogPo.setIsBooked(FscConstants.IsBooked.NO);
            fscPayLogPo.setDealType(FscConstants.WelfareDealType.ACCOUNT_RETURN);
            if (fscCreditDeductAtomBO.getAcceptOrderId() != null) {
                fscPayLogPo.setAcceptId(fscCreditDeductAtomBO.getAcceptOrderId().toString());
            }
            fscPayLogPo.setAcceptCode(fscCreditDeductAtomBO.getAcceptCode());
            fscPayLogPo.setErpAcceptCode(fscCreditDeductAtomBO.getErpAcceptCode());
            if (companyReturnAmt.compareTo(BigDecimal.ZERO) > 0 && FscConstants.WelfareType.COMPANY.equals(fscCreditDeductAtomBO.getWelfareType())) {
                fscPayLogPo.setAccountType(FscConstants.WelfareType.COMPANY);
                fscPayLogPo.setBusiBeforeAmount(companyBeforeAmt);
                fscPayLogPo.setBusiAfterAmount(companyBeforeAmt.add(fscCreditDeductAtomBO.getAmount()));
                fscPayLogPo.setBusiAmount(fscCreditDeductAtomBO.getAmount());
                FscPayLogPO companyfscPayLogPo = new FscPayLogPO();
                BeanUtils.copyProperties((Object)fscPayLogPo, (Object)companyfscPayLogPo);
                fscPayLogPos.add(companyfscPayLogPo);
                companyBeforeAmt = companyBeforeAmt.add(fscCreditDeductAtomBO.getAmount());
            }
            if (unionReturnAmt.compareTo(BigDecimal.ZERO) <= 0 || !FscConstants.WelfareType.UNION.equals(fscCreditDeductAtomBO.getWelfareType())) continue;
            fscPayLogPo.setAccountType(FscConstants.WelfareType.UNION);
            fscPayLogPo.setBusiBeforeAmount(unionBeforeAmtl);
            fscPayLogPo.setBusiAfterAmount(unionBeforeAmtl.add(fscCreditDeductAtomBO.getAmount()));
            fscPayLogPo.setBusiAmount(fscCreditDeductAtomBO.getAmount());
            fscPayLogPos.add(fscPayLogPo);
            unionBeforeAmtl = unionBeforeAmtl.add(fscCreditDeductAtomBO.getAmount());
        }
        this.fscPayLogMapper.insertBatch(fscPayLogPos);
    }
}

