/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscReleaseFundPlanAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyPayBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscReleaseFundPlanAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillUpdateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillUpdateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillUpdateAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillUpdateBusiService;
import com.tydic.fsc.pay.busi.api.FscPayBillWelfareUpdateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillUpdateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillUpdateBusiRspBO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillUpdateAbilityService"})
public class FscPayBillUpdateAbilityServiceImpl
implements FscPayBillUpdateAbilityService {
    @Autowired
    private FscPayBillUpdateBusiService fscPayBillUpdateBusiService;
    @Autowired
    private FscPayBillWelfareUpdateBusiService fscPayBillWelfareUpdateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Resource(name="fscSyncPushUnifyPayMqServiceProvider")
    private ProxyMessageProducer fscSyncPushUnifyPayMqServiceProvider;
    @Value(value="${es.FSC_PUSH_UNIFY_PAY_TOPIC:FSC_PUSH_UNIFY_PAY_TOPIC}")
    private String fscPushUnifyPayTopic;
    @Value(value="${es.FSC_PUSH_UNIFY_PAY_TAG:FSC_PUSH_UNIFY_PAY_TAG}")
    private String fscPushUnifyPayTag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscReleaseFundPlanAbilityService fscReleaseFundPlanAbilityService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"dealPayBillUpdate"})
    public FscPayBillUpdateAbilityRspBO dealPayBillUpdate(@RequestBody FscPayBillUpdateAbilityReqBO abilityReqBO) {
        if (abilityReqBO.getFscOrderId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2fscOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.val(abilityReqBO);
        FscPayBillUpdateBusiReqBO fscPayBillUpdateBusiReqBO = (FscPayBillUpdateBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)abilityReqBO), FscPayBillUpdateBusiReqBO.class));
        FscPayBillUpdateBusiRspBO busiRspBO = StringUtils.isBlank((String)abilityReqBO.getPayWelfareType()) ? this.fscPayBillUpdateBusiService.dealPayBillUpdate(fscPayBillUpdateBusiReqBO) : this.fscPayBillWelfareUpdateBusiService.dealPayBillWelfareUpdate(fscPayBillUpdateBusiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(abilityReqBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            if (busiRspBO.getFscOrderId() != null && StringUtils.isBlank((String)abilityReqBO.getPayWelfareType())) {
                FscPushUnifyPayBillAbilityReqBO unifyPayBillAbilityReqBO = new FscPushUnifyPayBillAbilityReqBO();
                unifyPayBillAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
                ProxySendResult proxySendResult = this.fscSyncPushUnifyPayMqServiceProvider.send(new ProxyMessage(this.fscPushUnifyPayTopic, this.fscPushUnifyPayTag, JSONObject.toJSONString((Object)unifyPayBillAbilityReqBO)));
                if (!"SEND_OK".equals(proxySendResult.getStatus())) {
                    this.writeFailLog(busiRspBO.getFscOrderId());
                }
            }
        }
        return (FscPayBillUpdateAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayBillUpdateAbilityRspBO.class);
    }

    private void writeFailLog(Long data) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjNo(String.valueOf(data));
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_PAY_BILL_CREATE_PUSH_SETTLE_PLAT_FORM_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    private void val(FscPayBillUpdateAbilityReqBO abilityReqBO) {
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getDraftList())) {
            abilityReqBO.getDraftList().forEach(x -> {
                if (x.getDraftId() == null) {
                    throw new FscBusinessException("191000", "\u6c47\u7968\u660e\u7ec6\u6c47\u7968Id\u4e3a\u7a7a\uff01");
                }
                if (x.getDraftAmount() == null) {
                    throw new FscBusinessException("191000", "\u6c47\u7968\u660e\u7ec6\u6c47\u7968\u91d1\u989d\u4e3a\u7a7a\uff01");
                }
                if (x.getDraftNumber() == null) {
                    throw new FscBusinessException("191000", "\u6c47\u7968\u660e\u7ec6\u7535\u5b50\u7968\u53f7\u4e3a\u7a7a\uff01");
                }
            });
            List draftList = abilityReqBO.getDraftList().stream().map(x -> new BigDecimal(x.getDraftAmount())).collect(Collectors.toList());
            BigDecimal draftSum = draftList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmountSum = abilityReqBO.getFscOrderPayItemBOS().stream().map(x -> x.getPayAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (draftSum.compareTo(payAmountSum) != 0) {
                throw new FscBusinessException("198888", "\u6c47\u7968\u91d1\u989d\u548c\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
            }
        }
    }

    private void occupyFundsPlan(FscPayBillUpdateBusiReqBO fscPayBillCreateBusiReqBO, Long fscOrderId) {
        if (!CollectionUtils.isEmpty(fscPayBillCreateBusiReqBO.getFscOrderPayItemBOS())) {
            FscReleaseFundPlanAbilityReqBO fundPlanAbilityReqBO = new FscReleaseFundPlanAbilityReqBO();
            fundPlanAbilityReqBO.setFscOrderId(fscOrderId);
            fundPlanAbilityReqBO.setAgentAccount(fscPayBillCreateBusiReqBO.getAgentAccount());
            fundPlanAbilityReqBO.setType(Integer.valueOf(0));
            this.fscReleaseFundPlanAbilityService.releasePlan(fundPlanAbilityReqBO);
        }
    }
}

