/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscAccountChargeBankStatementDetailQryAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscAccountChargeBankStatementDetailQryReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscAccountChargeBankStatementDetailQryRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscAccountChargeBankStatementDetailQryRspBOFinanceBankStatementList;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscAccountChargeBankStatementDetailQryAbilityService"})
public class FscAccountChargeBankStatementDetailQryAbilityServiceImpl
implements FscAccountChargeBankStatementDetailQryAbilityService {
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryAccountChargeBankStatementDetail"})
    public FscAccountChargeBankStatementDetailQryRspBO qryAccountChargeBankStatementDetail(@RequestBody FscAccountChargeBankStatementDetailQryReqBO reqBo) {
        FscAccountChargeBankStatementDetailQryRspBO rspBo = new FscAccountChargeBankStatementDetailQryRspBO();
        this.valid(reqBo);
        FscFinanceBankStatementPO fscFinanceBankStatementPO = new FscFinanceBankStatementPO();
        fscFinanceBankStatementPO.setFscOrderId(reqBo.getChargeId());
        Page page = new Page();
        page.setPageNo(reqBo.getPageNo().intValue());
        page.setPageSize(reqBo.getPageSize().intValue());
        List financeBankStatementPOList = this.fscFinanceBankStatementMapper.getListPage(fscFinanceBankStatementPO, page);
        List financeBankStatementList = JSON.parseArray((String)JSON.toJSONString((Object)financeBankStatementPOList), FscAccountChargeBankStatementDetailQryRspBOFinanceBankStatementList.class);
        Map isAgentMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_IS_AGENT");
        for (FscAccountChargeBankStatementDetailQryRspBOFinanceBankStatementList bankStatement : financeBankStatementList) {
            if (bankStatement.getIsAgent() == null) continue;
            bankStatement.setIsAgentStr((String)isAgentMap.get(bankStatement.getIsAgent().toString()));
        }
        rspBo.setFinanceBankStatementList(financeBankStatementList);
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void valid(FscAccountChargeBankStatementDetailQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u94f6\u884c\u6d41\u6c34\u4fe1\u606f\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getChargeId() == null) {
            throw new FscBusinessException("191000", "\u94f6\u884c\u6d41\u6c34\u4fe1\u606f\u5165\u53c2\u5145\u503c\u4e3b\u952eid[chargeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

