/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscAccountChargePayInfoDetailQryAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscAccountChargePayInfoDetailQryReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscAccountChargePayInfoDetailQryRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscAccountChargePayInfoDetailQryRspBOFinancePayItemList;
import com.tydic.fsc.po.FscFinancePayItemPO;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscAccountChargePayInfoDetailQryAbilityService"})
public class FscAccountChargePayInfoDetailQryAbilityServiceImpl
implements FscAccountChargePayInfoDetailQryAbilityService {
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryAccountChargePayInfoDetail"})
    public FscAccountChargePayInfoDetailQryRspBO qryAccountChargePayInfoDetail(@RequestBody FscAccountChargePayInfoDetailQryReqBO reqBo) {
        FscAccountChargePayInfoDetailQryRspBO rspBo = new FscAccountChargePayInfoDetailQryRspBO();
        this.valid(reqBo);
        FscFinancePayItemPO fscFinancePayItemPO = new FscFinancePayItemPO();
        fscFinancePayItemPO.setFscOrderId(reqBo.getChargeId());
        Page page = new Page();
        page.setPageNo(reqBo.getPageNo().intValue());
        page.setPageSize(reqBo.getPageSize().intValue());
        List fscFinancePayItemPOList = this.fscFinancePayItemMapper.getListPage(fscFinancePayItemPO, page);
        List financePayItemList = JSON.parseArray((String)JSON.toJSONString((Object)fscFinancePayItemPOList), FscAccountChargePayInfoDetailQryRspBOFinancePayItemList.class);
        Map payStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_STATUS_TRANS");
        Map payMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
        for (FscAccountChargePayInfoDetailQryRspBOFinancePayItemList financePay : financePayItemList) {
            if (financePay.getPayStatus() != null) {
                financePay.setPayStatusStr((String)payStatusMap.get(financePay.getPayStatus().toString()));
            }
            if (!StringUtils.isNotBlank((CharSequence)financePay.getFinancePayMethod())) continue;
            financePay.setFinancePayMethodStr((String)payMethodMap.get(financePay.getFinancePayMethod()));
        }
        rspBo.setFinancePayItemList(financePayItemList);
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void valid(FscAccountChargePayInfoDetailQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u4fe1\u606f\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getChargeId() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u4fe1\u606f\u5165\u53c2\u5145\u503c\u4e3b\u952eid[chargeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

