/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinancePayTempQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscFinancePayBillCreateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscFinancePayBillCreateReqBO;
import com.tydic.fsc.pay.ability.bo.FscFinancePayBillCreateRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayBillCreateBusiService;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscFinancePayBillCreateAbilityService"})
public class FscFinancePayBillCreateAbilityServiceImpl
implements FscFinancePayBillCreateAbilityService {
    @Autowired
    private FscFinancePayBillCreateBusiService fscFinancePayBillCreateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscFinancePayTempQryAtomService fscFinancePayTempQryAtomService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealFinancePayBillCreate"})
    public FscFinancePayBillCreateRspBO dealFinancePayBillCreate(@RequestBody FscFinancePayBillCreateReqBO reqBO) {
        if (reqBO.getTempId() == null) {
            this.validParam(reqBO);
        } else {
            this.qryTempInfo(reqBO);
        }
        FscFinancePayBillCreateRspBO createRspBO = this.fscFinancePayBillCreateBusiService.dealFinancePayBillCreate(reqBO);
        if (createRspBO.getFscOrderId() != null) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(createRspBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        return createRspBO;
    }

    private void qryTempInfo(FscFinancePayBillCreateReqBO abilityReqBO) {
        FscFinancePayTempQryAtomReqBO atomReqBO = new FscFinancePayTempQryAtomReqBO();
        atomReqBO.setTempId(abilityReqBO.getTempId());
        atomReqBO.setPaymentType(abilityReqBO.getPaymentType());
        FscFinancePayTempQryAtomRspBO atomRspBO = this.fscFinancePayTempQryAtomService.qryPayTemp(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u67e5\u8be2\u4ed8\u6b3e\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
        abilityReqBO.setFscOrderPayItemBOS(atomRspBO.getFscOrderPayItemBOS());
    }

    private void validParam(FscFinancePayBillCreateReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getFinanceDeptId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[financeDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getFinanceDeptName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[financeDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBusinessItemCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[businessItemCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBusinessItemName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[businessItemName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getExchangeRate() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2[exchangeRate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCurrency())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[currency]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getIsAgent() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2[isAgent]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPayDate() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2[payDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getNote())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[note]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderPayItemBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscOrderPayItemBO itemBO : reqBO.getFscOrderPayItemBOS()) {
            if (itemBO.getShouldPayId() != null) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderPayItemBOS.shouldPayId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

