/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMemPayInfoMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscMemFeePayBillAtomService;
import com.tydic.fsc.pay.atom.bo.FscMemFeePayBillAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscMemFeePayBillAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscMemPayConfirmBusiService;
import com.tydic.fsc.pay.busi.bo.FscMemPayConfirmBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscMemPayConfirmBusiRspBO;
import com.tydic.fsc.po.FscMemPayInfoPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DatesUtils;
import com.tydic.umc.general.ability.api.UmcMemberConfigQryDetailSAbilityervice;
import com.tydic.umc.general.ability.api.UmcMemberFeePushAbilityService;
import com.tydic.umc.general.ability.bo.UmcMemberConfigQryDetailReqBO;
import com.tydic.umc.general.ability.bo.UmcMemberConfigQryDetailRspBO;
import com.tydic.umc.general.ability.bo.UmcMemberFeePushAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemberFeePushAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcMemberLevelPurchWayBO;
import com.tydic.umc.supplier.ability.api.UmcSupplierMemberModifyAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupplierMemberModifyAbilityReqBo;
import com.tydic.umc.supplier.ability.bo.UmcSupplierMemberModifyAbilityRspBo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscMemPayConfirmBusiServiceImpl
implements FscMemPayConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMemPayConfirmBusiServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscMemPayInfoMapper fscMemPayInfoMapper;
    @Resource
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscMemFeePayBillAtomService fscMemFeePayBillAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private UmcSupplierMemberModifyAbilityService umcSupplierMemberModifyAbilityService;
    @Autowired
    private UmcMemberFeePushAbilityService umcMemberFeePushAbilityService;
    @Autowired
    private UmcMemberConfigQryDetailSAbilityervice umcMemberConfigQryDetailSAbilityervice;

    @Override
    public FscMemPayConfirmBusiRspBO dealMemPayConfirm(FscMemPayConfirmBusiReqBO reqBO) {
        FscMemPayConfirmBusiRspBO rspBO = new FscMemPayConfirmBusiRspBO();
        FscOrderPO fscOrderPOReq = new FscOrderPO();
        fscOrderPOReq.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPOReq.setOrderFlow(FscConstants.OrderFlow.MEMBER_FEE_PAY);
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPOReq);
        if (Objects.isNull(fscOrderPO)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u4f1a\u5458\u8d39\u4ed8\u6b3e\u5355\u636e\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscOrderPayItemPO payItemPO = new FscOrderPayItemPO();
        payItemPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPayItemPO fscOrderPayItemPO = this.fscOrderPayItemMapper.getModelBy(payItemPO);
        if (fscOrderPayItemPO == null) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u5173\u8054\u8868\u91d1\u989d\u5f02\u5e38!");
        }
        FscShouldPayPO shouldPayPO = new FscShouldPayPO();
        shouldPayPO.setShouldPayId(fscOrderPayItemPO.getShouldPayId());
        shouldPayPO.setShouldPayAmount(reqBO.getPayAmount());
        shouldPayPO.setToPayAmount(reqBO.getPayAmount());
        shouldPayPO.setOriginalAmount(reqBO.getPayAmount());
        this.fscShouldPayMapper.updateShouldPayAmountById(shouldPayPO);
        fscOrderPayItemPO.setPayAmount(reqBO.getPayAmount());
        this.fscOrderPayItemMapper.updateById(fscOrderPayItemPO);
        FscMemPayInfoPO fscMemPayInfo = this.fscMemPayInfoMapper.queryByFscOrderId(reqBO.getFscOrderId());
        if (Objects.isNull(fscMemPayInfo)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u4f1a\u5458\u8d39\u4ed8\u6b3e\u4fe1\u606f\uff01");
        }
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscMemPayInfo);
        fscMemPayInfo.setEffDate(DatesUtils.getDayBeginTime((Date)new Date()));
        fscMemPayInfo.setExpDate(DatesUtils.getDayEndTime((Date)reqBO.getEffDate()));
        if (Objects.nonNull(reqBO.getPayAmount()) && Objects.nonNull(reqBO.getMemCycle())) {
            fscMemPayInfo.setPrice(reqBO.getPayAmount().divide(new BigDecimal(reqBO.getMemCycle()), 2, RoundingMode.HALF_UP));
        }
        FscOrderInvoicePO set = new FscOrderInvoicePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)set);
        if (Objects.nonNull(reqBO.getUserId())) {
            set.setBillOperId(reqBO.getUserId().toString());
        }
        set.setBillOperName(reqBO.getUserName());
        set.setBillTime(new Date());
        FscOrderInvoicePO where = new FscOrderInvoicePO();
        where.setFscOrderId(reqBO.getFscOrderId());
        int count = this.fscOrderInvoiceMapper.updateBy(set, where);
        if (count < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u53d1\u7968\u8868\u5f02\u5e38\uff01");
        }
        String url = "";
        if (reqBO.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
            FscMemFeePayBillAtomReqBO fscMemFeePayBillAtomReqBO = new FscMemFeePayBillAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)fscMemFeePayBillAtomReqBO));
            fscMemFeePayBillAtomReqBO.setOrderState(fscOrderPO.getOrderState());
            fscMemFeePayBillAtomReqBO.setTotalAmount(reqBO.getPayAmount());
            fscMemFeePayBillAtomReqBO.setDetailName("\u6613\u8d2d\u4f1a\u5458\u8d39\u7528\u652f\u4ed8");
            FscMemFeePayBillAtomRspBO payBillAtomRspBO = this.fscMemFeePayBillAtomService.dealMemFeePayBill(fscMemFeePayBillAtomReqBO);
            if (!"0000".equals(payBillAtomRspBO.getRespCode())) {
                throw new FscBusinessException("190000", payBillAtomRspBO.getRespDesc());
            }
            rspBO.setRedirectUrl(payBillAtomRspBO.getRedirectUrl());
            rspBO.setHtmlBody(payBillAtomRspBO.getHtmlBody());
            url = payBillAtomRspBO.getUrl();
        } else {
            url = reqBO.getRedirectUrl();
            this.handleNoPay(fscOrderPO, fscMemPayInfo);
        }
        count = this.fscMemPayInfoMapper.update(fscMemPayInfo);
        if (count < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u4f1a\u5458\u8d39\u4ed8\u6b3e\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscOrderPO);
        fscOrderPO.setTotalCharge(reqBO.getPayAmount());
        fscOrderPO.setPaidAmount(BigDecimal.ZERO);
        fscOrderPO.setPayingAmount(BigDecimal.ZERO);
        fscOrderPO.setToPayAmount(reqBO.getPayAmount());
        fscOrderPO.setPayConfirmId(String.valueOf(reqBO.getUserId()));
        fscOrderPO.setPayConfirmName(reqBO.getUserName());
        fscOrderPO.setPayConfirmTime(new Date());
        fscOrderPO.setUpdateOperId(Objects.isNull(reqBO.getUserId()) ? null : reqBO.getUserId().toString());
        fscOrderPO.setUpdateOperName(reqBO.getUserName());
        fscOrderPO.setUpdateTime(new Date());
        fscOrderPO.setOrderState(reqBO.getPayAmount().compareTo(BigDecimal.ZERO) > 0 ? FscConstants.FscPayOrderState.TO_PAY : FscConstants.FscPayOrderState.PAY_DEDUCT);
        count = this.fscOrderMapper.updateById(fscOrderPO);
        if (count < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u4f1a\u5458\u8d39\u7528\u5355\u636e\u5f02\u5e38\uff01");
        }
        rspBO.setUrl(url);
        rspBO.setFscPayId(fscOrderPO.getFscOrderId());
        rspBO.setFscPayNo(fscOrderPO.getOrderNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void handleNoPay(FscOrderPO fscOrderPO, FscMemPayInfoPO fscMemPayInfoPO) {
        UmcSupplierMemberModifyAbilityReqBo modifyAbilityReqBO = new UmcSupplierMemberModifyAbilityReqBo();
        modifyAbilityReqBO.setSupplierId(fscOrderPO.getSupplierId());
        modifyAbilityReqBO.setSupplierCode(fscMemPayInfoPO.getSupplierCode());
        modifyAbilityReqBO.setMemberLevel(fscMemPayInfoPO.getMemLevel());
        modifyAbilityReqBO.setMemberLevelId(fscMemPayInfoPO.getMemLevelId());
        modifyAbilityReqBO.setMemberLevelCode(fscMemPayInfoPO.getMemLevelCode());
        modifyAbilityReqBO.setMemberLevelName(fscMemPayInfoPO.getMemLevelName());
        modifyAbilityReqBO.setMemberExpTime(fscMemPayInfoPO.getEffDate());
        modifyAbilityReqBO.setMemberEffTime(fscMemPayInfoPO.getExpDate());
        log.info("\u8c03\u7528\u4f1a\u5458\u4fee\u6539\u4f1a\u5458\u7b49\u7ea7\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)modifyAbilityReqBO));
        UmcSupplierMemberModifyAbilityRspBo umcSupplierMemberModifyAbilityRspBo = this.umcSupplierMemberModifyAbilityService.modifySupplierMember(modifyAbilityReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u4fee\u6539\u4f1a\u5458\u7b49\u7ea7\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)umcSupplierMemberModifyAbilityRspBo));
        if (!"0000".equals(umcSupplierMemberModifyAbilityRspBo.getRespCode())) {
            throw new FscBusinessException("193201", umcSupplierMemberModifyAbilityRspBo.getRespDesc());
        }
        Set<Object> types = new HashSet();
        if (Objects.nonNull(fscMemPayInfoPO.getMemLevelId())) {
            UmcMemberConfigQryDetailReqBO memberConfigQryDetailReqBO = new UmcMemberConfigQryDetailReqBO();
            memberConfigQryDetailReqBO.setMemberLevelId(fscMemPayInfoPO.getMemLevelId());
            log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u4f1a\u5458\u914d\u7f6e\u8868\u8be6\u60c5\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)memberConfigQryDetailReqBO));
            UmcMemberConfigQryDetailRspBO memberConfigQryDetailRspBO = this.umcMemberConfigQryDetailSAbilityervice.qryMemberConfigDetail(memberConfigQryDetailReqBO);
            log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u4f1a\u5458\u914d\u7f6e\u8868\u8be6\u60c5\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)memberConfigQryDetailRspBO));
            if (memberConfigQryDetailRspBO != null && !CollectionUtils.isEmpty((Collection)memberConfigQryDetailRspBO.getPurchWayInfo())) {
                types = memberConfigQryDetailRspBO.getPurchWayInfo().stream().map(UmcMemberLevelPurchWayBO::getType).collect(Collectors.toSet());
            }
        }
        if (!CollectionUtils.isEmpty(types)) {
            UmcMemberFeePushAbilityReqBO pushAbilityReqBO = new UmcMemberFeePushAbilityReqBO();
            pushAbilityReqBO.setMemLevelId(fscMemPayInfoPO.getMemLevelId());
            pushAbilityReqBO.setMemberLevelCode(fscMemPayInfoPO.getMemLevelCode());
            pushAbilityReqBO.setMemberLevelName(fscMemPayInfoPO.getMemLevelName());
            pushAbilityReqBO.setSupplierId(fscOrderPO.getSupplierId());
            pushAbilityReqBO.setSupplierNo(fscMemPayInfoPO.getSupplierNo());
            pushAbilityReqBO.setTransactionId(fscMemPayInfoPO.getMemId());
            pushAbilityReqBO.setType("1");
            pushAbilityReqBO.setStartTime(fscMemPayInfoPO.getEffDate());
            pushAbilityReqBO.setEndTime(fscMemPayInfoPO.getExpDate());
            if (types.contains(2)) {
                UmcMemberFeePushAbilityRspBO pushZbRspBO = this.umcMemberFeePushAbilityService.dealPushZbMemFee(pushAbilityReqBO);
                fscMemPayInfoPO.setIsPushZb(Integer.valueOf(1));
                if (!pushZbRspBO.getRespCode().equals("0000")) {
                    fscMemPayInfoPO.setIsPushZb(Integer.valueOf(2));
                    fscMemPayInfoPO.setPushZbFailedReason(pushZbRspBO.getRespDesc());
                }
            }
            if (types.contains(1)) {
                UmcMemberFeePushAbilityRspBO pushFzRspBO = this.umcMemberFeePushAbilityService.dealPushFzMemFee(pushAbilityReqBO);
                fscMemPayInfoPO.setIsPushFz(Integer.valueOf(1));
                if (!pushFzRspBO.getRespCode().equals("0000")) {
                    fscMemPayInfoPO.setIsPushFz(Integer.valueOf(2));
                    fscMemPayInfoPO.setPushFzFailedReason(pushFzRspBO.getRespDesc());
                }
            }
        } else {
            fscMemPayInfoPO.setIsPushFz(Integer.valueOf(0));
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("payFlag", FscConstants.ProcessParam.payFlag4);
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscMemPayInfoPO.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193201", atomRspBO.getRespDesc());
        }
    }
}

