/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscDraftReleaseOccService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.dao.FscDraftInfoMapper;
import com.tydic.fsc.dao.FscMemPayInfoMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscMemFeePayBillAtomService;
import com.tydic.fsc.pay.atom.bo.FscMemFeePayBillAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscMemFeePayBillAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscMemPayCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscMemPayCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscMemPayCreateBusiRspBO;
import com.tydic.fsc.pay.config.OrderDelayTask;
import com.tydic.fsc.po.FscMemPayInfoPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DatesUtils;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.umc.general.ability.api.UmcMemberConfigQryDetailSAbilityervice;
import com.tydic.umc.general.ability.api.UmcMemberFeePushAbilityService;
import com.tydic.umc.general.ability.api.UmcQuerySupplierDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcMemberConfigQryDetailReqBO;
import com.tydic.umc.general.ability.bo.UmcMemberConfigQryDetailRspBO;
import com.tydic.umc.general.ability.bo.UmcMemberFeePushAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemberFeePushAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcMemberLevelPurchWayBO;
import com.tydic.umc.general.ability.bo.UmcQuerySupplierDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQuerySupplierDetailAbilityRspBO;
import com.tydic.umc.supplier.ability.api.UmcSupplierMemberModifyAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupplierMemberModifyAbilityReqBo;
import com.tydic.umc.supplier.ability.bo.UmcSupplierMemberModifyAbilityRspBo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscMemPayCreateBusiServiceImpl
implements FscMemPayCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMemPayCreateBusiServiceImpl.class);
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Value(value="${memFee.operation_name:\u4e2d\u7164\u80a1\u4efd\u516c\u53f8\u91c7\u8d2d\u4e2d\u5fc3\u91c7\u8d2d\u4e1a\u52a1\u4e09\u90e8(\u7535\u5b50\u5546\u52a1)}")
    private String operationName;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscMemPayInfoMapper fscMemPayInfoMapper;
    @Autowired
    private FscMemFeePayBillAtomService fscMemFeePayBillAtomService;
    @Autowired
    private DelayQueue<OrderDelayTask> orderDelayQueue;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UmcSupplierMemberModifyAbilityService umcSupplierMemberModifyAbilityService;
    @Autowired
    private UmcQuerySupplierDetailAbilityService umcQuerySupplierDetailAbilityService;
    @Autowired
    private UmcMemberFeePushAbilityService umcMemberFeePushAbilityService;
    @Autowired
    private UmcMemberConfigQryDetailSAbilityervice umcMemberConfigQryDetailSAbilityervice;
    @Autowired
    private FscDraftInfoMapper fscDraftInfoMapper;
    @Autowired
    private FscDraftReleaseOccService draftReleaseOccService;

    @Override
    public FscMemPayCreateBusiRspBO dealMemPayCreate(FscMemPayCreateBusiReqBO reqBO) {
        FscMemPayCreateBusiRspBO busiRspBO = new FscMemPayCreateBusiRspBO();
        Long fscPayId = Sequence.getInstance().nextId();
        String fscPayNo = this.insertOrder(reqBO, fscPayId);
        this.insertOrderInvoice(reqBO, fscPayId);
        FscMemPayInfoPO fscMemPayInfoPO = this.insertMemPayInfo(reqBO, fscPayId);
        String url = "";
        if (reqBO.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
            List<Object> fscOrderPayItemPOs = new ArrayList();
            fscOrderPayItemPOs = this.insertShouldPay(reqBO, fscPayId);
            this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
            url = this.dealPayBill(reqBO, fscPayId, busiRspBO);
        } else {
            url = reqBO.getRedirectUrl();
            this.handleNoPay(reqBO, fscMemPayInfoPO);
        }
        this.orderDelayQueue.add(new OrderDelayTask(fscPayId, 1800000L));
        busiRspBO.setUrl(url);
        busiRspBO.setFscPayNo(fscPayNo);
        busiRspBO.setFscPayId(fscPayId);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4f1a\u5458\u8d39\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return busiRspBO;
    }

    private String dealPayBill(FscMemPayCreateBusiReqBO reqBO, Long fscOrderId, FscMemPayCreateBusiRspBO busiRspBO) {
        FscMemFeePayBillAtomReqBO fscMemFeePayBillAtomReqBO = new FscMemFeePayBillAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)fscMemFeePayBillAtomReqBO));
        fscMemFeePayBillAtomReqBO.setFscOrderId(fscOrderId);
        fscMemFeePayBillAtomReqBO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
        fscMemFeePayBillAtomReqBO.setTotalAmount(reqBO.getPayAmount());
        fscMemFeePayBillAtomReqBO.setDetailName("\u6613\u8d2d\u4f1a\u5458\u8d39\u7528\u652f\u4ed8");
        FscMemFeePayBillAtomRspBO payBillAtomRspBO = this.fscMemFeePayBillAtomService.dealMemFeePayBill(fscMemFeePayBillAtomReqBO);
        if (!"0000".equals(payBillAtomRspBO.getRespCode())) {
            throw new FscBusinessException("190000", payBillAtomRspBO.getRespDesc());
        }
        busiRspBO.setRedirectUrl(payBillAtomRspBO.getRedirectUrl());
        busiRspBO.setHtmlBody(payBillAtomRspBO.getHtmlBody());
        return payBillAtomRspBO.getUrl();
    }

    private List<FscOrderPayItemPO> insertShouldPay(FscMemPayCreateBusiReqBO busiReqBO, Long fscOrderId) {
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        List serialNoList = null;
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("MEM_PAYMENT_REQUEST_NO");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        Long shouldPayId = Sequence.getInstance().nextId();
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setShouldPayId(shouldPayId);
        fscShouldPayPO.setCreateId(busiReqBO.getUserId());
        fscShouldPayPO.setCreateName(busiReqBO.getName());
        fscShouldPayPO.setCreateAccount(busiReqBO.getUserName());
        fscShouldPayPO.setCreateTime(new Date());
        fscShouldPayPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscShouldPayPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscShouldPayPO.setCreateOrgId(busiReqBO.getOrgId());
        fscShouldPayPO.setCreateOrgName(busiReqBO.getOrgName());
        fscShouldPayPO.setPayingAmount(new BigDecimal(0));
        fscShouldPayPO.setPaidAmount(new BigDecimal(0));
        fscShouldPayPO.setToPayAmount(busiReqBO.getPayAmount());
        fscShouldPayPO.setShouldPayAmount(busiReqBO.getPayAmount());
        fscShouldPayPO.setShouldPayNo((String)serialNoList.get(0));
        fscShouldPayPO.setPenalty(new BigDecimal(0));
        fscShouldPayPO.setOriginalAmount(busiReqBO.getPayAmount());
        fscShouldPayPO.setPayeeId(this.operationOrgId);
        fscShouldPayPO.setPayeeName(busiReqBO.getPayeeName());
        fscShouldPayPO.setPayerId(busiReqBO.getPayerId());
        fscShouldPayPO.setPayerName(busiReqBO.getPayerName());
        fscShouldPayPO.setShouldPayType(FscConstants.ShouldPayType.MEM_PAY);
        fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
        fscShouldPayPO.setOperationName(this.operationName);
        FscOrderPayItemPO po = new FscOrderPayItemPO();
        po.setFscOrderId(fscOrderId);
        po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
        po.setShouldPayId(shouldPayId);
        po.setPayAmount(fscShouldPayPO.getShouldPayAmount());
        fscOrderPayItemPOs.add(po);
        this.fscShouldPayMapper.insert(fscShouldPayPO);
        return fscOrderPayItemPOs;
    }

    private String insertOrder(FscMemPayCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.MEMBER_FEE_PAY);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("MEM_PAYMENT_REQUEST_NO");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscOrderPO.setPayerId(busiReqBO.getPayerId());
        fscOrderPO.setPayerName(busiReqBO.getPayerName());
        fscOrderPO.setPayeeId(this.operationOrgId);
        fscOrderPO.setPayeeName(busiReqBO.getPayeeName());
        if (StringUtils.isEmpty((Object)fscOrderPO.getPayeeAccountName()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankAccount()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankName())) {
            FscMerchantPayeePO fscMerchantPayeePO = new FscMerchantPayeePO();
            fscMerchantPayeePO.setSupplierId(this.operationOrgId);
            List fscMerchantPayeePOList = this.fscMerchantPayeeMapper.getList(fscMerchantPayeePO);
            if (!CollectionUtils.isEmpty((Collection)fscMerchantPayeePOList)) {
                fscMerchantPayeePO = (FscMerchantPayeePO)fscMerchantPayeePOList.get(0);
                fscOrderPO.setPayeeAccountName(fscMerchantPayeePO.getPayeeAccountName());
                fscOrderPO.setPayeeBankAccount(fscMerchantPayeePO.getPayeeBankAccount());
                fscOrderPO.setPayeeBankName(fscMerchantPayeePO.getPayeeBankName());
            } else {
                throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u672a\u914d\u7f6e\u6536\u6b3e\u8d26\u6237");
            }
        }
        fscOrderPO.setPayMethod(busiReqBO.getPayMethod());
        fscOrderPO.setShouldPayType(FscConstants.ShouldPayType.MEM_PAY);
        fscOrderPO.setPayChannel(busiReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getPayAmount());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        fscOrderPO.setPaidAmount(BigDecimal.ZERO);
        fscOrderPO.setPayingAmount(BigDecimal.ZERO);
        fscOrderPO.setToPayAmount(busiReqBO.getPayAmount());
        fscOrderPO.setOrderState(busiReqBO.getPayAmount().compareTo(BigDecimal.ZERO) > 0 ? FscConstants.FscPayOrderState.TO_PAY : FscConstants.FscPayOrderState.PAY_DEDUCT);
        fscOrderPO.setSupplierId(busiReqBO.getSupId());
        fscOrderPO.setSupplierName(busiReqBO.getSupplierName());
        fscOrderPO.setBuyName(busiReqBO.getBuyName());
        fscOrderPO.setCreateOperNo(busiReqBO.getUserName());
        fscOrderPO.setOrderFlowKey(FscOrderFlowProcKeyEnum.MEMBER_FEE_PAY.getDescr());
        this.fscOrderMapper.insert(fscOrderPO);
        return fscOrderPO.getOrderNo();
    }

    private void insertOrderInvoice(FscMemPayCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(fscOrderId);
        fscOrderInvoicePO.setBuyName(busiReqBO.getBuyName());
        fscOrderInvoicePO.setTaxNo(busiReqBO.getTaxNo());
        fscOrderInvoicePO.setInvoiceType(busiReqBO.getInvoiceType());
        fscOrderInvoicePO.setInvoiceCategory(Integer.valueOf(busiReqBO.getInvoiceCategory()));
        fscOrderInvoicePO.setBank(busiReqBO.getBank());
        fscOrderInvoicePO.setAccount(busiReqBO.getAccount());
        fscOrderInvoicePO.setAddress(busiReqBO.getAddress());
        fscOrderInvoicePO.setPhone(busiReqBO.getPhone());
        fscOrderInvoicePO.setProvince(busiReqBO.getProvince());
        fscOrderInvoicePO.setInvoiceId(busiReqBO.getInvoiceId());
        if (null != busiReqBO.getUserId()) {
            fscOrderInvoicePO.setBillOperId(busiReqBO.getUserId().toString());
        }
        fscOrderInvoicePO.setBillOperName(busiReqBO.getUserName());
        fscOrderInvoicePO.setBillTime(new Date());
        int insert = this.fscOrderInvoiceMapper.insert(fscOrderInvoicePO);
        if (insert != 1) {
            throw new FscBusinessException("193203", "\u4f1a\u5458\u8d39\u4ed8\u6b3e\u4e3b\u5355\u521b\u5efa\u9519\u8bef----\u751f\u6210\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
        }
    }

    private FscMemPayInfoPO insertMemPayInfo(FscMemPayCreateBusiReqBO busiReqBO, Long fscOrderId) {
        int count;
        FscMemPayInfoPO fscMemPayInfoPO = new FscMemPayInfoPO();
        fscMemPayInfoPO.setMemId(Long.valueOf(Sequence.getInstance().nextId()));
        fscMemPayInfoPO.setFscOrderId(fscOrderId);
        fscMemPayInfoPO.setMemLevel(busiReqBO.getMemLevel());
        fscMemPayInfoPO.setMemLevelId(busiReqBO.getMemLevelId());
        fscMemPayInfoPO.setMemLevelCode(busiReqBO.getMemLevelCode());
        fscMemPayInfoPO.setMemLevelName(busiReqBO.getMemLevelName());
        fscMemPayInfoPO.setMemType(busiReqBO.getMemType());
        fscMemPayInfoPO.setMemCycle(busiReqBO.getMemCycle());
        fscMemPayInfoPO.setEffDate(DatesUtils.getDayBeginTime((Date)new Date()));
        fscMemPayInfoPO.setExpDate(DatesUtils.getDayEndTime((Date)busiReqBO.getEffDate()));
        fscMemPayInfoPO.setIsPushFz(FscConstants.pushState.NO_PUSH);
        fscMemPayInfoPO.setIsPushZb(FscConstants.pushState.NO_PUSH);
        if (Objects.nonNull(busiReqBO.getPayAmount())) {
            fscMemPayInfoPO.setPrice(busiReqBO.getPayAmount().divide(new BigDecimal(busiReqBO.getMemCycle()), 2, RoundingMode.HALF_UP));
        }
        if (Objects.nonNull(busiReqBO.getSupId())) {
            UmcQuerySupplierDetailAbilityReqBO supplierDetailAbilityReqBO = new UmcQuerySupplierDetailAbilityReqBO();
            supplierDetailAbilityReqBO.setSupplierId(busiReqBO.getSupId());
            UmcQuerySupplierDetailAbilityRspBO supplierDetailAbilityRspBO = this.umcQuerySupplierDetailAbilityService.querySupplierDetail(supplierDetailAbilityReqBO);
            if (Objects.nonNull(supplierDetailAbilityRspBO) && Objects.nonNull(supplierDetailAbilityRspBO.getSupplierDetailBO())) {
                log.debug("\u4f9b\u5e94\u5546\u7f16\u7801\uff1a" + supplierDetailAbilityRspBO.getSupplierDetailBO().getSupplierCode());
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)supplierDetailAbilityRspBO.getSupplierDetailBO().getSupplierCode())) {
                    throw new FscBusinessException("198888", "\u67e5\u8be2\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
                }
                fscMemPayInfoPO.setSupplierNo(supplierDetailAbilityRspBO.getSupplierDetailBO().getSupplierCode());
            }
        }
        if ((count = this.fscMemPayInfoMapper.insert(fscMemPayInfoPO)) < 1) {
            throw new FscBusinessException("193203", "\u4f1a\u5458\u8d39\u4ed8\u6b3e\u4e3b\u5355\u521b\u5efa\u9519\u8bef----\u751f\u6210\u4f1a\u5458\u8d39\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25");
        }
        return fscMemPayInfoPO;
    }

    public void handleNoPay(FscMemPayCreateBusiReqBO reqBO, FscMemPayInfoPO fscMemPayInfoPO) {
        UmcSupplierMemberModifyAbilityReqBo modifyAbilityReqBO = new UmcSupplierMemberModifyAbilityReqBo();
        modifyAbilityReqBO.setSupplierId(reqBO.getSupId());
        modifyAbilityReqBO.setSupplierCode(fscMemPayInfoPO.getSupplierCode());
        modifyAbilityReqBO.setMemberLevel(fscMemPayInfoPO.getMemLevel());
        modifyAbilityReqBO.setMemberLevelId(fscMemPayInfoPO.getMemLevelId());
        modifyAbilityReqBO.setMemberLevelCode(fscMemPayInfoPO.getMemLevelCode());
        modifyAbilityReqBO.setMemberLevelName(fscMemPayInfoPO.getMemLevelName());
        modifyAbilityReqBO.setMemberExpTime(fscMemPayInfoPO.getEffDate());
        modifyAbilityReqBO.setMemberEffTime(fscMemPayInfoPO.getExpDate());
        log.info("\u8c03\u7528\u4f1a\u5458\u4fee\u6539\u4f1a\u5458\u7b49\u7ea7\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)modifyAbilityReqBO));
        UmcSupplierMemberModifyAbilityRspBo umcSupplierMemberModifyAbilityRspBo = this.umcSupplierMemberModifyAbilityService.modifySupplierMember(modifyAbilityReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u4fee\u6539\u4f1a\u5458\u7b49\u7ea7\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)umcSupplierMemberModifyAbilityRspBo));
        if (!"0000".equals(umcSupplierMemberModifyAbilityRspBo.getRespCode())) {
            throw new FscBusinessException("193201", umcSupplierMemberModifyAbilityRspBo.getRespDesc());
        }
        Set<Object> types = new HashSet();
        if (Objects.nonNull(fscMemPayInfoPO.getMemLevelId())) {
            UmcMemberConfigQryDetailReqBO memberConfigQryDetailReqBO = new UmcMemberConfigQryDetailReqBO();
            memberConfigQryDetailReqBO.setMemberLevelId(fscMemPayInfoPO.getMemLevelId());
            log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u4f1a\u5458\u914d\u7f6e\u8868\u8be6\u60c5\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)memberConfigQryDetailReqBO));
            UmcMemberConfigQryDetailRspBO memberConfigQryDetailRspBO = this.umcMemberConfigQryDetailSAbilityervice.qryMemberConfigDetail(memberConfigQryDetailReqBO);
            log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u4f1a\u5458\u914d\u7f6e\u8868\u8be6\u60c5\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)memberConfigQryDetailRspBO));
            if (memberConfigQryDetailRspBO != null && !CollectionUtils.isEmpty((Collection)memberConfigQryDetailRspBO.getPurchWayInfo())) {
                types = memberConfigQryDetailRspBO.getPurchWayInfo().stream().map(UmcMemberLevelPurchWayBO::getType).collect(Collectors.toSet());
            }
        }
        if (!CollectionUtils.isEmpty(types)) {
            UmcMemberFeePushAbilityReqBO pushAbilityReqBO = new UmcMemberFeePushAbilityReqBO();
            pushAbilityReqBO.setMemLevelId(fscMemPayInfoPO.getMemLevelId());
            pushAbilityReqBO.setMemberLevelCode(fscMemPayInfoPO.getMemLevelCode());
            pushAbilityReqBO.setMemberLevelName(fscMemPayInfoPO.getMemLevelName());
            pushAbilityReqBO.setSupplierId(reqBO.getSupId());
            pushAbilityReqBO.setSupplierNo(fscMemPayInfoPO.getSupplierNo());
            pushAbilityReqBO.setTransactionId(fscMemPayInfoPO.getMemId());
            pushAbilityReqBO.setType("1");
            pushAbilityReqBO.setStartTime(fscMemPayInfoPO.getEffDate());
            pushAbilityReqBO.setEndTime(fscMemPayInfoPO.getExpDate());
            if (types.contains(2)) {
                UmcMemberFeePushAbilityRspBO pushZbRspBO = this.umcMemberFeePushAbilityService.dealPushZbMemFee(pushAbilityReqBO);
                fscMemPayInfoPO.setIsPushZb(Integer.valueOf(1));
                if (!pushZbRspBO.getRespCode().equals("0000")) {
                    fscMemPayInfoPO.setIsPushZb(Integer.valueOf(2));
                    fscMemPayInfoPO.setPushZbFailedReason(pushZbRspBO.getRespDesc());
                }
            }
            if (types.contains(1)) {
                UmcMemberFeePushAbilityRspBO pushFzRspBO = this.umcMemberFeePushAbilityService.dealPushFzMemFee(pushAbilityReqBO);
                fscMemPayInfoPO.setIsPushFz(Integer.valueOf(1));
                if (!pushFzRspBO.getRespCode().equals("0000")) {
                    fscMemPayInfoPO.setIsPushFz(Integer.valueOf(2));
                    fscMemPayInfoPO.setPushFzFailedReason(pushFzRspBO.getRespDesc());
                }
            }
        } else {
            fscMemPayInfoPO.setIsPushFz(Integer.valueOf(0));
        }
        int count = this.fscMemPayInfoMapper.update(fscMemPayInfoPO);
        if (count < 1) {
            throw new FscBusinessException("193203", "\u4f1a\u5458\u8d39\u4ed8\u6b3e\u4e3b\u5355\u521b\u5efa\u9519\u8bef----\u66f4\u65b0\u4f1a\u5458\u8d39\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25");
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("payFlag", FscConstants.ProcessParam.payFlag4);
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscMemPayInfoPO.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193201", atomRspBO.getRespDesc());
        }
    }
}

