/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyBankBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyBankReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyDraftBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseBankReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseDraftReqBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractRelationMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.finance.FscFinanceDealPayAuditBusiService;
import com.tydic.fsc.pay.busi.bo.finance.FscFinanceDealPayAuditBusiReqBO;
import com.tydic.fsc.pay.busi.bo.finance.FscFinanceDealPayAuditBusiRspBO;
import com.tydic.fsc.pay.task.bo.TodoFscWaitAbilityReqBO;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinancePayReducePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscFinanceDealPayAuditBusiServiceImpl
implements FscFinanceDealPayAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceDealPayAuditBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscContractRelationMapper fscContractRelationMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    public static final String PASS = "0";
    public static final String BUSI_NAME = "\u4e3b\u5355\u5ba1\u6279";
    public static final String BUSI_CODE = "1009";

    @Override
    public FscFinanceDealPayAuditBusiRspBO dealFinancePayAudit(FscFinanceDealPayAuditBusiReqBO reqBO) {
        UocApprovalLogPO uocApprovalLogPO = null;
        try {
            uocApprovalLogPO = this.taskTodoWaitService.listApproval(reqBO.getOrderId());
        }
        catch (Exception e) {
            log.error("dealOrderApproval get stationId error:{}", (Throwable)e);
        }
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBO);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        this.dealFinanceInfo(reqBO);
        if (finish.booleanValue()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            if (PASS.equals(auditResult)) {
                if (null != reqBO.getActualAmount() && BigDecimal.ZERO.compareTo(reqBO.getActualAmount()) == 0) {
                    paramMap.put("orderFinish", "1");
                } else {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
                }
            } else {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
            }
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(reqBO.getOrderId());
            flowAtomReqBO.setCurStatus(reqBO.getOrderState());
            flowAtomReqBO.setBusiName(BUSI_NAME);
            flowAtomReqBO.setBusiCode(BUSI_CODE);
            flowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getOrderId());
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
            String orderTypeStr = fscOrderPO.getOrderType() == 2 && fscOrderPO.getTradeMode() != null && fscOrderPO.getTradeMode() == 2 && fscOrderPO.getOrderSource() == 3 && fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(fscOrderPO.getOrderType() + "");
            if (!PASS.equals(auditResult)) {
                reqBO.setOrderState(FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + "\u4ed8\u6b3e\u7533\u8bf7\u5355_" + orderTypeStr + "_" + fscOrderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5ba1\u6279\u9a73\u56de");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355" + fscOrderPO.getOrderNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscOrderPO.getCreateOperId()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            } else {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + "\u4ed8\u6b3e\u7533\u8bf7\u5355_" + orderTypeStr + "_" + fscOrderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5ba1\u6279\u901a\u8fc7");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355" + fscOrderPO.getOrderNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscOrderPO.getCreateOperId()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        try {
            if (Objects.nonNull(uocApprovalLogPO) && Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
                todoFscWaitAbilityReqBO.setCenterCode("settle");
                todoFscWaitAbilityReqBO.setBusiCode("1012");
                todoFscWaitAbilityReqBO.setBusiName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
                todoFscWaitAbilityReqBO.setObjId(reqBO.getOrderId());
                todoFscWaitAbilityReqBO.setOperatorType("1");
                todoFscWaitAbilityReqBO.setStationId(uocApprovalLogPO.getNextStationId());
                this.taskTodoWaitService.handler(todoFscWaitAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("dealOrderApproval error:{}", (Throwable)e);
        }
        FscFinanceDealPayAuditBusiRspBO busiRspBO = new FscFinanceDealPayAuditBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        busiRspBO.setFinish(finish);
        return busiRspBO;
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscFinanceDealPayAuditBusiReqBO reqBO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getOrderId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.PAY_APPLY_ORDER.equals(reqBO.getOrderFlow()) ? FscConstants.AuditObjType.PAY_APPLY_ORDER : FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL;
        String stepId = this.fscOrderMapper.selectStepId(reqBO.getOrderId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        HashMap<String, Number> paramMap = new HashMap<String, Number>(4);
        paramMap.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        auditReqBO.setStepId(stepId);
        paramMap.put("payAmount", reqBO.getTotalCharge());
        auditReqBO.setVariables(paramMap);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private void dealFinanceInfo(FscFinanceDealPayAuditBusiReqBO reqBO) {
        int count;
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)financePO);
        financePO.setFscOrderId(reqBO.getOrderId());
        financePO.setUpdateTime(new Date());
        financePO.setUpdateUserId(reqBO.getUserName());
        financePO.setUpdateUserName(reqBO.getName());
        this.fscOrderFinanceMapper.updateById(financePO);
        if (!CollectionUtils.isEmpty(reqBO.getOrderPayItemIds()) && (count = this.fscOrderPayItemMapper.deleteByItemIdSets(reqBO.getOrderPayItemIds())) != reqBO.getOrderPayItemIds().size()) {
            throw new FscBusinessException("0000", "\u5220\u9664\u4ed8\u6b3e\u660e\u7ec6\u884c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(reqBO.getUpdOrderPayItemPOS())) {
            this.fscOrderPayItemMapper.updateFinanceBatch(reqBO.getUpdOrderPayItemPOS());
        }
        if (reqBO.getIsChange().booleanValue()) {
            FscFinancePayReducePO reduceQueryVo = new FscFinancePayReducePO();
            reduceQueryVo.setFscOrderId(reqBO.getOrderId());
            List reduceList = this.fscFinancePayReduceMapper.getList(reduceQueryVo);
            if (!CollectionUtils.isEmpty((Collection)reduceList)) {
                for (FscFinancePayReducePO reducePO : reduceList) {
                    reducePO.setReduceAmt(reducePO.getReduceAmt().negate());
                }
                int count2 = this.fscContractRelationMapper.updateBatchById(reduceList);
                if (count2 != reduceList.size()) {
                    throw new FscBusinessException("190000", "\u6838\u51cf\u91d1\u989d\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                }
            }
            this.fscFinanceCapitalPlanMapper.deleteByFscOrderId(reqBO.getOrderId());
            this.fscFinanceDraftInfoMapper.deleteByFscOrderId(reqBO.getOrderId());
            this.fscFinancePayReduceMapper.deleteByFscOrderId(reqBO.getOrderId());
            this.fscFinanceBankStatementMapper.deleteByFscOrderId(reqBO.getOrderId());
            this.fscFinancePayItemMapper.deleteByFscOrderId(reqBO.getOrderId());
            this.dealRelease(reqBO);
            FscFinanceCapitalInfoAtomReqBO atomReqBO = new FscFinanceCapitalInfoAtomReqBO();
            atomReqBO.setFscOrderPayItemBOS(reqBO.getFscOrderPayItemBOS());
            atomReqBO.setObjId(reqBO.getOrderId());
            atomReqBO.setObjNo(reqBO.getOrderNo());
            atomReqBO.setObjType(Integer.valueOf(1));
            atomReqBO.setOperationType(Integer.valueOf(1));
            FscFinanceCapitalInfoAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealFinanceCapitalInfo(atomReqBO);
            if (!atomRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("198888", atomRspBO.getRespDesc());
            }
        } else {
            if (!CollectionUtils.isEmpty(reqBO.getDelFinanceItemIds()) && (count = this.fscFinancePayItemMapper.deleteByIds(reqBO.getOrderId(), reqBO.getDelFinanceItemIds())) != reqBO.getDelFinanceItemIds().size()) {
                throw new FscBusinessException("190000", "\u5220\u9664\u4ed8\u6b3e\u4fe1\u606f\u884c\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(reqBO.getDelBankIds()) && (count = this.fscFinanceBankStatementMapper.deleteByIds(reqBO.getOrderId(), reqBO.getDelBankIds())) != reqBO.getDelBankIds().size()) {
                throw new FscBusinessException("190000", "\u5220\u9664\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(reqBO.getDelDraftIds()) && (count = this.fscFinanceDraftInfoMapper.deleteByIds(reqBO.getOrderId(), reqBO.getDelDraftIds())) != reqBO.getDelDraftIds().size()) {
                throw new FscBusinessException("190000", "\u5220\u9664\u7968\u636e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(reqBO.getDelReduceIds())) {
                count = this.fscFinancePayReduceMapper.deleteByIds(reqBO.getOrderId(), reqBO.getDelReduceIds());
                if (count != reqBO.getDelReduceIds().size()) {
                    throw new FscBusinessException("190000", "\u5220\u9664\u6838\u51cf\u4fe1\u606f\u5931\u8d25\uff01");
                }
                List reduceList = this.fscFinancePayReduceMapper.getListByReduceIds(reqBO.getDelReduceIds());
                for (FscFinancePayReducePO reducePO : reduceList) {
                    reducePO.setReduceAmt(reducePO.getReduceAmt().negate());
                }
                count = this.fscContractRelationMapper.updateBatchById(reduceList);
                if (count != reduceList.size()) {
                    throw new FscBusinessException("190000", "\u6838\u51cf\u91d1\u989d\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                }
            }
            this.dealRelease(reqBO);
            if (!CollectionUtils.isEmpty(reqBO.getFinanceAddList())) {
                this.fscFinancePayItemMapper.insertBatch(reqBO.getFinanceAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getFinanceUpdList())) {
                this.fscFinancePayItemMapper.updateBatch(reqBO.getFinanceUpdList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getBankAddList())) {
                this.fscFinanceBankStatementMapper.insertBatch(reqBO.getBankAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getBankUpdList())) {
                this.fscFinanceBankStatementMapper.updateBatch(reqBO.getBankUpdList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getDraftAddList())) {
                this.fscFinanceDraftInfoMapper.insertBatch(reqBO.getDraftAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getDraftUpdList())) {
                this.fscFinanceDraftInfoMapper.updateBatch(reqBO.getDraftUpdList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getPlanAddList())) {
                this.fscFinanceCapitalPlanMapper.insertBatch(reqBO.getPlanAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getPlanUpdList())) {
                this.fscFinanceCapitalPlanMapper.updateBatch(reqBO.getPlanUpdList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getReduceAddList())) {
                this.fscFinancePayReduceMapper.insertBatch(reqBO.getReduceAddList());
                count = this.fscContractRelationMapper.updateBatchById(reqBO.getReduceAddList());
                if (count != reqBO.getReduceAddList().size()) {
                    throw new FscBusinessException("190000", "\u66f4\u65b0\u6838\u51cf\u4fe1\u606f\u5931\u8d25\uff01");
                }
            }
            if (!CollectionUtils.isEmpty(reqBO.getReduceUpdList())) {
                count = this.fscFinancePayReduceMapper.updateBatch(reqBO.getReduceUpdList());
                if (count != reqBO.getReduceUpdList().size()) {
                    throw new FscBusinessException("190000", "\u66f4\u65b0\u6838\u51cf\u91d1\u989d\u5931\u8d25\uff01");
                }
                for (FscFinancePayReducePO reducePO : reqBO.getReduceUpdList()) {
                    reducePO.setReduceAmt(reducePO.getReduceChgAmt());
                }
                count = this.fscContractRelationMapper.updateBatchById(reqBO.getReduceUpdList());
                if (count != reqBO.getReduceUpdList().size()) {
                    throw new FscBusinessException("190000", "\u6838\u51cf\u91d1\u989d\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                }
            }
            if (!CollectionUtils.isEmpty(reqBO.getBankAddList()) || !CollectionUtils.isEmpty(reqBO.getBankUpdList())) {
                ArrayList<FscFinanceBankStatementPO> bankList = new ArrayList<FscFinanceBankStatementPO>();
                if (!CollectionUtils.isEmpty(reqBO.getBankAddList())) {
                    bankList.addAll(reqBO.getBankAddList());
                }
                if (!CollectionUtils.isEmpty(reqBO.getBankUpdList())) {
                    bankList.addAll(reqBO.getBankUpdList());
                }
                this.occupyBank(bankList, reqBO);
            }
            if (!CollectionUtils.isEmpty(reqBO.getDraftAddList()) || !CollectionUtils.isEmpty(reqBO.getDraftUpdList())) {
                ArrayList<FscFinanceDraftInfoPO> draftList = new ArrayList<FscFinanceDraftInfoPO>();
                if (!CollectionUtils.isEmpty(reqBO.getDraftAddList())) {
                    draftList.addAll(reqBO.getDraftAddList());
                }
                if (!CollectionUtils.isEmpty(reqBO.getDraftUpdList())) {
                    draftList.addAll(reqBO.getDraftUpdList());
                }
                this.occupyDraft(draftList, reqBO);
            }
            if (!CollectionUtils.isEmpty(reqBO.getPlanAddList()) || !CollectionUtils.isEmpty(reqBO.getPlanUpdList())) {
                ArrayList<FscFinanceCapitalPlanPO> capitalPlanList = new ArrayList<FscFinanceCapitalPlanPO>();
                if (!CollectionUtils.isEmpty(reqBO.getPlanAddList())) {
                    capitalPlanList.addAll(reqBO.getPlanAddList());
                }
                if (!CollectionUtils.isEmpty(reqBO.getPlanUpdList())) {
                    capitalPlanList.addAll(reqBO.getPlanUpdList());
                }
                this.occupyPlan(capitalPlanList, reqBO);
            }
        }
    }

    private void occupyDraft(List<FscFinanceDraftInfoPO> draftList, FscFinanceDealPayAuditBusiReqBO reqBO) {
        FscFinanceOccupyRspBO occupyRspBO;
        FscFinanceOccupyDraftReqBO draftReqBO;
        ArrayList<FscFinanceOccupyDraftBO> draftBOList = new ArrayList<FscFinanceOccupyDraftBO>();
        ArrayList<FscFinanceOccupyDraftBO> receivableBOList = new ArrayList<FscFinanceOccupyDraftBO>();
        for (FscFinanceDraftInfoPO draftInfoPO : draftList) {
            FscFinanceOccupyDraftBO draftBO = new FscFinanceOccupyDraftBO();
            draftBO.setBillCode(reqBO.getOrderNo());
            draftBO.setCreateUser(reqBO.getUserName());
            draftBO.setCreateUserName(reqBO.getName());
            draftBO.setOrgId(reqBO.getFinanceOrgId());
            draftBO.setOrgName(reqBO.getFinanceOrgName());
            draftBO.setBizClaimAmt(draftInfoPO.getOccAmt());
            draftBO.setClaimTime(DateUtil.dateToStrLong((Date)draftInfoPO.getCreateTime()));
            draftBO.setBilltypeName(draftInfoPO.getExtbilltypeName());
            draftBO.setExtBizBilltype(draftInfoPO.getExtBizBilltype());
            draftBO.setLedgerReceGuid(draftInfoPO.getGuid());
            draftBO.setHeadGuid(draftInfoPO.getFinancePayItemId() + "");
            draftBO.setBillCode(draftInfoPO.getPayItemNo());
            if (FscConstants.FinanceDraftType.DRAFT.equals(draftInfoPO.getDraftType())) {
                draftBOList.add(draftBO);
                continue;
            }
            draftBO.setClaimSource(draftInfoPO.getDraftType() + "");
            receivableBOList.add(draftBO);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(draftBOList)) {
            draftReqBO = new FscFinanceOccupyDraftReqBO();
            draftReqBO.setDraftList(draftBOList);
            draftReqBO.setDraftType(FscConstants.FinanceDraftType.DRAFT);
            occupyRspBO = this.fscFinanceOccupyOrDraftService.occupyDraft(draftReqBO);
            if (!"0000".equals(occupyRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u5360\u7528\u7968\u636e\u5931\u8d25\uff1a" + occupyRspBO.getRespDesc());
            }
            for (FscFinanceDraftInfoPO draftInfoPO : draftList) {
                draftInfoPO.setExtId((String)occupyRspBO.getData().get(draftInfoPO.getGuid() + "-" + draftInfoPO.getFinancePayItemId()));
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(receivableBOList)) {
            draftReqBO = new FscFinanceOccupyDraftReqBO();
            draftReqBO.setDraftList(receivableBOList);
            draftReqBO.setDraftType(FscConstants.FinanceDraftType.RECEIVABLE_DRAFT);
            occupyRspBO = this.fscFinanceOccupyOrDraftService.occupyDraft(draftReqBO);
            if (!"0000".equals(occupyRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u5e94\u6536\u7968\u636e\u5931\u8d25\uff1a" + occupyRspBO.getRespDesc());
            }
            for (FscFinanceDraftInfoPO draftInfoPO : draftList) {
                draftInfoPO.setExtId((String)occupyRspBO.getData().get(draftInfoPO.getGuid() + "-" + draftInfoPO.getFinancePayItemId()));
            }
        }
        this.fscFinanceDraftInfoMapper.updateExtIdBatch(draftList);
    }

    private void occupyBank(List<FscFinanceBankStatementPO> bankList, FscFinanceDealPayAuditBusiReqBO reqBO) {
        FscFinanceOccupyBankReqBO bankReqBO = new FscFinanceOccupyBankReqBO();
        ArrayList<FscFinanceOccupyBankBO> bankBOList = new ArrayList<FscFinanceOccupyBankBO>();
        for (FscFinanceBankStatementPO bankStatementPO : bankList) {
            FscFinanceOccupyBankBO bankBO = new FscFinanceOccupyBankBO();
            bankBO.setFlowGuid(bankStatementPO.getGuid());
            bankBO.setHeadGuid(bankStatementPO.getStatementId() + "");
            bankBO.setBillCode(reqBO.getOrderNo());
            bankBO.setBizClaimAmt(bankStatementPO.getOccAmt());
            bankBO.setCreateUser(reqBO.getUserName());
            bankBO.setCreateUserName(reqBO.getName());
            bankBO.setClaimTime(DateUtil.dateToStrLong((Date)bankStatementPO.getCreateTime()));
            bankBO.setOrgId(reqBO.getFinanceOrgId());
            bankBO.setOrgName(reqBO.getFinanceOrgName());
            bankBO.setBilltypeName(bankStatementPO.getBilltypeName());
            bankBO.setExtBizBilltype(bankStatementPO.getExtBizBilltype());
            bankBO.setClaimType("1");
            bankBOList.add(bankBO);
        }
        bankReqBO.setBankList(bankBOList);
        FscFinanceOccupyRspBO occupyRspBO = this.fscFinanceOccupyOrReleaseBankService.occupyBank(bankReqBO);
        if (!"0000".equals(occupyRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u5360\u7528\u94f6\u884c\u6d41\u6c34\u4fe1\u606f\u5931\u8d25:" + occupyRspBO.getRespDesc());
        }
        for (FscFinanceBankStatementPO bankStatementPO : bankList) {
            bankStatementPO.setExtId((String)occupyRspBO.getData().get(bankStatementPO.getGuid() + "-" + bankStatementPO.getStatementId()));
        }
        this.fscFinanceBankStatementMapper.updateExtIdBatch(bankList);
    }

    private void occupyPlan(List<FscFinanceCapitalPlanPO> capitalPlanList, FscFinanceDealPayAuditBusiReqBO reqBO) {
    }

    private void dealRelease(FscFinanceDealPayAuditBusiReqBO reqBO) {
        FscFinanceReleaseDraftReqBO draftReqBO;
        if (!CollectionUtils.isEmpty(reqBO.getBankExtIds())) {
            FscFinanceReleaseBankReqBO bankReqBO = new FscFinanceReleaseBankReqBO();
            bankReqBO.setGuids(reqBO.getBankExtIds());
            this.fscFinanceOccupyOrReleaseBankService.releaseBank(bankReqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getDraftExtIds())) {
            draftReqBO = new FscFinanceReleaseDraftReqBO();
            draftReqBO.setDraftType(FscConstants.FinanceDraftType.DRAFT);
            draftReqBO.setGuids(reqBO.getDraftExtIds());
            this.fscFinanceOccupyOrDraftService.releaseDraft(draftReqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getRecvDraftExtIds())) {
            draftReqBO = new FscFinanceReleaseDraftReqBO();
            draftReqBO.setDraftType(FscConstants.FinanceDraftType.RECEIVABLE_DRAFT);
            draftReqBO.setGuids(reqBO.getRecvDraftExtIds());
            this.fscFinanceOccupyOrDraftService.releaseDraft(draftReqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getPlanExtIds())) {
            // empty if block
        }
    }
}

