/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemTempMapper;
import com.tydic.fsc.dao.FscFinancePayReduceTempMapper;
import com.tydic.fsc.dao.FscOrderPayItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempCreateReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempCreateRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscOrderPayItemTempDetailBO;
import com.tydic.fsc.pay.ability.bo.finance.FscPayItemTempDetailBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayItemTempCreateService;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinancePayItemTempPO;
import com.tydic.fsc.po.FscFinancePayReduceTempPO;
import com.tydic.fsc.po.FscOrderPayItemTempPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinancePayItemTempCreateServiceImpl
implements FscFinancePayItemTempCreateService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayItemTempCreateServiceImpl.class);
    @Autowired
    private FscOrderPayItemTempMapper fscOrderPayItemTempMapper;
    @Autowired
    private FscFinancePayItemTempMapper fscFinancePayItemTempMapper;
    @Autowired
    private FscFinancePayReduceTempMapper fscFinancePayReduceTempMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;

    @Override
    public FscFinancePayItemTempCreateRspBO dealFinancePayTempCreateBatch(FscFinancePayItemTempCreateReqBO reqBO) {
        int bankStatementResult;
        log.debug("\u5e94\u4ed8\u6b3e-\u591a\u5408\u540c\u65b0\u589e\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        this.valid(reqBO);
        ArrayList fscOrderPayItemTempPOAddList = new ArrayList();
        ArrayList fscFinancePayItemTempPOAddList = new ArrayList();
        ArrayList fscFinancePayReduceTempPOAddList = new ArrayList();
        ArrayList fscFinanceCapitalPlanTempPOAddList = new ArrayList();
        ArrayList fscFinanceBankStatementTempPOAddList = new ArrayList();
        ArrayList fscFinanceDraftInfoTempPOAddList = new ArrayList();
        for (FscPayItemTempDetailBO detailBO : reqBO.getDetailBOList()) {
            String financeDraftInfoTempString;
            List financeDraftInfoTempPOList;
            String financeBankStatementTempString;
            List financeBankStatementTempPOList;
            String capitalPlanTempString;
            List fscFinanceCapitalPlanTempPOList;
            String payReduceTempString;
            List fscFinancePayReduceTempPOList;
            String orderPayItemTempString = JSONObject.toJSONString((Object)detailBO.getOrderPayItemList());
            List fscOrderPayItemTempPOList = JSONObject.parseArray((String)orderPayItemTempString, FscOrderPayItemTempPO.class);
            if (CollectionUtils.isEmpty((Collection)fscOrderPayItemTempPOList)) {
                throw new FscBusinessException("198888", "\u8f6c\u4e49\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            fscOrderPayItemTempPOList.stream().forEach(fscOrderPayItemTempPO -> {
                fscOrderPayItemTempPO.setOrderPayItemTempId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderPayItemTempPO.setContractId(detailBO.getContractId());
                fscOrderPayItemTempPO.setContractNo(detailBO.getContractNo());
                fscOrderPayItemTempPO.setContractName(detailBO.getContractName());
                fscOrderPayItemTempPO.setTempId(detailBO.getTempId());
                fscOrderPayItemTempPO.setExt1(DateUtil.dateToStrLong((Date)new Date()));
            });
            fscOrderPayItemTempPOAddList.addAll(fscOrderPayItemTempPOList);
            String payItemTempString = JSONObject.toJSONString((Object)detailBO.getFinancePayItemList());
            List fscFinancePayItemTempPOList = JSONObject.parseArray((String)payItemTempString, FscFinancePayItemTempPO.class);
            if (!CollectionUtils.isEmpty((Collection)fscFinancePayItemTempPOList)) {
                fscFinancePayItemTempPOList.stream().forEach(fscFinancePayItemTempPO -> {
                    fscFinancePayItemTempPO.setFinancePayItemTempId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscFinancePayItemTempPO.setTempId(detailBO.getTempId());
                    fscFinancePayItemTempPO.setContractId(detailBO.getContractId());
                });
                fscFinancePayItemTempPOAddList.addAll(fscFinancePayItemTempPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(fscFinancePayReduceTempPOList = JSONObject.parseArray((String)(payReduceTempString = JSONObject.toJSONString((Object)detailBO.getPayReduceTempList())), FscFinancePayReduceTempPO.class)))) {
                fscFinancePayReduceTempPOList.stream().forEach(fscFinancePayReduceTempPO -> {
                    fscFinancePayReduceTempPO.setFinancePayReduceTempId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscFinancePayReduceTempPO.setTempId(detailBO.getTempId());
                    fscFinancePayReduceTempPO.setContractNo(detailBO.getContractNo());
                    fscFinancePayReduceTempPO.setContractId(detailBO.getContractId());
                    fscFinancePayReduceTempPO.setContractName(detailBO.getContractName());
                });
                fscFinancePayReduceTempPOAddList.addAll(fscFinancePayReduceTempPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(fscFinanceCapitalPlanTempPOList = JSONObject.parseArray((String)(capitalPlanTempString = JSONObject.toJSONString((Object)detailBO.getCapitalPlanTempList())), FscFinanceCapitalPlanTempPO.class)))) {
                fscFinanceCapitalPlanTempPOList.stream().forEach(fscFinanceCapitalPlanTempPO -> {
                    fscFinanceCapitalPlanTempPO.setFinancePayItemId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscFinanceCapitalPlanTempPO.setTempId(detailBO.getTempId());
                    fscFinanceCapitalPlanTempPO.setContractNo(detailBO.getContractNo());
                    fscFinanceCapitalPlanTempPO.setContractId(detailBO.getContractId());
                    fscFinanceCapitalPlanTempPO.setContractName(detailBO.getContractName());
                });
                fscFinanceCapitalPlanTempPOAddList.addAll(fscFinanceCapitalPlanTempPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(financeBankStatementTempPOList = JSONObject.parseArray((String)(financeBankStatementTempString = JSONObject.toJSONString((Object)detailBO.getFinanceBankStatementList())), FscFinanceBankStatementTempPO.class)))) {
                financeBankStatementTempPOList.stream().forEach(fscFinanceBankStatementTempPO -> {
                    fscFinanceBankStatementTempPO.setStatementTempId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscFinanceBankStatementTempPO.setTempId(detailBO.getTempId());
                    fscFinanceBankStatementTempPO.setContractId(detailBO.getContractId());
                    fscFinanceBankStatementTempPO.setCreateTime(new Date());
                });
                fscFinanceBankStatementTempPOAddList.addAll(financeBankStatementTempPOList);
            }
            if (CollectionUtils.isEmpty((Collection)(financeDraftInfoTempPOList = JSONObject.parseArray((String)(financeDraftInfoTempString = JSONObject.toJSONString((Object)detailBO.getFinanceDraftInfoList())), FscFinanceDraftInfoTempPO.class)))) continue;
            financeDraftInfoTempPOList.stream().forEach(fscFinanceDraftInfoTempPO -> {
                fscFinanceDraftInfoTempPO.setFinanceDraftTempId(Long.valueOf(Sequence.getInstance().nextId()));
                fscFinanceDraftInfoTempPO.setTempId(detailBO.getTempId());
                fscFinanceDraftInfoTempPO.setContractId(detailBO.getContractId());
                fscFinanceDraftInfoTempPO.setCreateTime(new Date());
            });
            fscFinanceDraftInfoTempPOAddList.addAll(financeDraftInfoTempPOList);
        }
        if (!CollectionUtils.isEmpty(fscOrderPayItemTempPOAddList)) {
            log.debug("\u5e94\u4ed8\u6b3e-\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5165\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(fscOrderPayItemTempPOAddList));
            int orderPayItemTempResult = this.fscOrderPayItemTempMapper.insertBatch(fscOrderPayItemTempPOAddList);
            if (orderPayItemTempResult != fscOrderPayItemTempPOAddList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(fscFinancePayItemTempPOAddList)) {
            log.debug("\u5e94\u4ed8\u6b3e-\u4ed8\u6b3e\u4fe1\u606f\u4e34\u65f6\u4fe1\u606f\u5165\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(fscFinancePayItemTempPOAddList));
            int payItemTempResult = this.fscFinancePayItemTempMapper.insertBatch(fscFinancePayItemTempPOAddList);
            if (payItemTempResult != fscFinancePayItemTempPOAddList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u4fe1\u606f\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(fscFinancePayReduceTempPOAddList)) {
            log.debug("\u5e94\u4ed8\u6b3e-\u6838\u51cf\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5165\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(fscFinancePayReduceTempPOAddList));
            int payReduceResult = this.fscFinancePayReduceTempMapper.insertBatch(fscFinancePayReduceTempPOAddList);
            if (payReduceResult != fscFinancePayReduceTempPOAddList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u6838\u51cf\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(fscFinanceCapitalPlanTempPOAddList)) {
            log.debug("\u5e94\u4ed8\u6b3e-\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u4e34\u65f6\u4fe1\u606f\u5165\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(fscFinanceCapitalPlanTempPOAddList));
            int capitalPlanResult = this.fscFinanceCapitalPlanTempMapper.insertBatch(fscFinanceCapitalPlanTempPOAddList);
            if (capitalPlanResult != fscFinanceCapitalPlanTempPOAddList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(fscFinanceBankStatementTempPOAddList)) {
            log.debug("\u5e94\u4ed8\u6b3e-\u94f6\u884c\u6d41\u6c34\u4e34\u65f6\u4fe1\u606f\u5165\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(fscFinanceBankStatementTempPOAddList));
        }
        if ((bankStatementResult = this.fscFinanceBankStatementTempMapper.insertBatch(fscFinanceBankStatementTempPOAddList)) != fscFinanceBankStatementTempPOAddList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u94f6\u884c\u6d41\u6c34\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(fscFinanceDraftInfoTempPOAddList)) {
            log.debug("\u5e94\u4ed8\u6b3e-\u7968\u636e\u53f0\u8d26\u4e34\u65f6\u4fe1\u606f\u5165\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(fscFinanceDraftInfoTempPOAddList));
            int draftInfoResult = this.fscFinanceDraftInfoTempMapper.insertBatch(fscFinanceDraftInfoTempPOAddList);
            if (draftInfoResult != fscFinanceDraftInfoTempPOAddList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u7968\u636e\u53f0\u8d26\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscFinancePayItemTempCreateRspBO rspBO = new FscFinancePayItemTempCreateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinancePayItemTempCreateReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailBOList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u6570\u636e\u96c6\u5408[detailBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscPayItemTempDetailBO detailBO : reqBO.getDetailBOList()) {
            if (CollectionUtils.isEmpty((Collection)detailBO.getOrderPayItemList())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u96c6\u5408[orderPayItemTempList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(detailBO.getTempId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)detailBO.getContractNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u7f16\u53f7[contractNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(detailBO.getContractId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)detailBO.getContractName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u540d\u79f0[contractName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            for (FscOrderPayItemTempDetailBO item : detailBO.getOrderPayItemList()) {
                if (StringUtils.isEmpty((Object)item.getItemNo())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getShouldPayId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u5e94\u4ed8ID[shouldPayId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!Objects.isNull(item.getIsReduce())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u662f\u5426\u6838\u51cf[isReduce]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getFinancePayItemList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getFinancePayItemList()) {
                    if (StringUtils.isEmpty((Object)item.getItemNo())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtils.isEmpty((Object)item.getFinancePayMethod())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u65b9\u5f0f[financePayMethod]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Objects.isNull(item.getFinancePayAmount()) || item.getFinancePayAmount().compareTo(BigDecimal.ZERO) <= 0) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d(\u539f\u5e01)[financePayAmount]\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u5c0f\u4e8e\u7b49\u4e8e0\uff01");
                    }
                    if (StringUtils.isEmpty((Object)item.getRecvBankName())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u6536\u6b3e\u65b9\u5f00\u6237\u884c\u540d\u79f0[recvBankName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtils.isEmpty((Object)item.getRecvBankAccount())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u6536\u6b3e\u65b9\u94f6\u884c\u8d26\u53f7[recvBankAccount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!StringUtils.isEmpty((Object)item.getRecvBankAccountName())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u6536\u6b3e\u65b9\u8d26\u6237\u540d\u79f0[recvBankAccountName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getPayReduceTempList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getPayReduceTempList()) {
                    if (StringUtils.isEmpty((Object)item.getItemNo())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtils.isEmpty((Object)item.getReduceItemName())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u6838\u51cf\u9879\u540d\u79f0[reduceItemName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtils.isEmpty((Object)item.getReduceItemCode())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u6838\u51cf\u4e1a\u52a1\u4e8b\u9879\u7f16\u7801[reduceItemCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!Objects.isNull(item.getReduceAmt()) && item.getReduceAmt().compareTo(BigDecimal.ZERO) > 0) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u6838\u51cf\u91d1\u989d[reduceAmt]\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u5c0f\u4e8e\u7b49\u4e8e0\uff01");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getCapitalPlanTempList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getCapitalPlanTempList()) {
                    if (StringUtils.isEmpty((Object)item.getItemNo())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtils.isEmpty((Object)item.getPayItemNo())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u4fe1\u606f\u7f16\u53f7[payItemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Objects.isNull(item.getCapitalPlanId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u8d44\u91d1\u8ba1\u5212ID[capitalPlanId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtils.isEmpty((Object)item.getCapitalPlanName())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u8d44\u91d1\u8ba1\u5212\u540d\u79f0[capitalPlanName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!Objects.isNull(item.getOccAmount()) || item.getOccAmount().compareTo(BigDecimal.ZERO) > 0) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u672c\u6b21\u5360\u7528\u91d1\u989d[occAmount]\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u5c0f\u4e8e\u7b49\u4e8e0\uff01");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getFinanceBankStatementList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getFinanceBankStatementList()) {
                    if (Objects.isNull(item.getItemNo())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Objects.isNull(item.getFscOrderId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!Objects.isNull(item.getOrderPayItemId())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6ID[orderPayItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (CollectionUtils.isEmpty((Collection)detailBO.getFinanceDraftInfoList())) continue;
            for (FscOrderPayItemTempDetailBO item : detailBO.getFinanceDraftInfoList()) {
                if (Objects.isNull(item.getExt1())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[ext1]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getFscOrderId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)item.getPayItemNo())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u884c\u53f7[payItemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!Objects.isNull(item.getFinancePayItemId())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6ID[financePayItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

