/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemTempMapper;
import com.tydic.fsc.dao.FscFinancePayReduceTempMapper;
import com.tydic.fsc.dao.FscOrderPayItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempUpdateReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempUpdateRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscOrderPayItemTempDetailBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayItemTempUpdateService;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinancePayItemTempPO;
import com.tydic.fsc.po.FscFinancePayReduceTempPO;
import com.tydic.fsc.po.FscOrderPayItemTempPO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinancePayItemTempUpdateServiceImpl
implements FscFinancePayItemTempUpdateService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayItemTempUpdateServiceImpl.class);
    @Autowired
    private FscOrderPayItemTempMapper fscOrderPayItemTempMapper;
    @Autowired
    private FscFinancePayItemTempMapper fscFinancePayItemTempMapper;
    @Autowired
    private FscFinancePayReduceTempMapper fscFinancePayReduceTempMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;

    @Override
    public FscFinancePayItemTempUpdateRspBO dealFinancePayTempUpdateBatch(FscFinancePayItemTempUpdateReqBO reqBO) {
        String draftInfoString;
        List draftInfoTempPOList;
        String bankStatementString;
        List bankStatementTempPOList;
        String capitalPlanTempString;
        List fscFinanceCapitalPlanTempPOList;
        String payReduceTempString;
        List fscFinancePayReduceTempPOList;
        this.valid(reqBO);
        String orderPayItemTempString = JSONObject.toJSONString((Object)reqBO.getOrderPayItemList());
        List orderPayItemTempPOList = JSONObject.parseArray((String)orderPayItemTempString, FscOrderPayItemTempPO.class);
        if (CollectionUtils.isEmpty((Collection)orderPayItemTempPOList)) {
            throw new FscBusinessException("198888", "\u8f6c\u4e49\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        orderPayItemTempPOList.stream().forEach(orderPayItemTempPO -> {
            orderPayItemTempPO.setTempId(reqBO.getTempId());
            orderPayItemTempPO.setContractNo(reqBO.getContractNo());
            orderPayItemTempPO.setContractId(reqBO.getContractId());
            orderPayItemTempPO.setContractName(reqBO.getContractName());
        });
        int orderPayItemInsert = this.fscOrderPayItemTempMapper.updateBatchById(orderPayItemTempPOList);
        if (orderPayItemInsert < 1 || orderPayItemInsert != reqBO.getOrderPayItemList().size()) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
        }
        String payItemTempString = JSONObject.toJSONString((Object)reqBO.getFinancePayItemList());
        List fscFinancePayItemTempPOList = JSONObject.parseArray((String)payItemTempString, FscFinancePayItemTempPO.class);
        if (!CollectionUtils.isEmpty((Collection)fscFinancePayItemTempPOList)) {
            fscFinancePayItemTempPOList.stream().forEach(fscFinancePayItemTempPO -> {
                fscFinancePayItemTempPO.setTempId(reqBO.getTempId());
                fscFinancePayItemTempPO.setContractId(reqBO.getContractId());
            });
            int payItemTempInsert = this.fscFinancePayItemTempMapper.updateBatchById(fscFinancePayItemTempPOList);
            if (payItemTempInsert < 1 || payItemTempInsert != reqBO.getFinancePayItemList().size()) {
                throw new FscBusinessException("193101", "\u4ed8\u6b3e\u4fe1\u606f\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(fscFinancePayReduceTempPOList = JSONObject.parseArray((String)(payReduceTempString = JSONObject.toJSONString((Object)reqBO.getPayReduceTempList())), FscFinancePayReduceTempPO.class)))) {
            fscFinancePayReduceTempPOList.stream().forEach(fscFinancePayReduceTempPO -> {
                fscFinancePayReduceTempPO.setTempId(reqBO.getTempId());
                fscFinancePayReduceTempPO.setContractNo(reqBO.getContractNo());
                fscFinancePayReduceTempPO.setContractId(reqBO.getContractId());
                fscFinancePayReduceTempPO.setContractName(reqBO.getContractName());
            });
            int payReduceResult = this.fscFinancePayReduceTempMapper.updateBatchById(fscFinancePayReduceTempPOList);
            if (payReduceResult < 1 || payReduceResult != reqBO.getPayReduceTempList().size()) {
                throw new FscBusinessException("193101", "\u6838\u51cf\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(fscFinanceCapitalPlanTempPOList = JSONObject.parseArray((String)(capitalPlanTempString = JSONObject.toJSONString((Object)reqBO.getCapitalPlanTempList())), FscFinanceCapitalPlanTempPO.class)))) {
            fscFinanceCapitalPlanTempPOList.stream().forEach(fscFinanceCapitalPlanTempPO -> {
                fscFinanceCapitalPlanTempPO.setTempId(reqBO.getTempId());
                fscFinanceCapitalPlanTempPO.setContractNo(reqBO.getContractNo());
                fscFinanceCapitalPlanTempPO.setContractId(reqBO.getContractId());
                fscFinanceCapitalPlanTempPO.setContractName(reqBO.getContractName());
            });
            int capitalPlanResult = this.fscFinanceCapitalPlanTempMapper.updateBatchById(fscFinanceCapitalPlanTempPOList);
            if (capitalPlanResult < 1 || capitalPlanResult != reqBO.getCapitalPlanTempList().size()) {
                throw new FscBusinessException("193101", "\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(bankStatementTempPOList = JSONObject.parseArray((String)(bankStatementString = JSONObject.toJSONString((Object)reqBO.getFinanceBankStatementList())), FscFinanceBankStatementTempPO.class)))) {
            bankStatementTempPOList.stream().forEach(bankStatementTempPO -> {
                bankStatementTempPO.setTempId(reqBO.getTempId());
                bankStatementTempPO.setContractId(reqBO.getContractId());
            });
            int bankStatementResult = this.fscFinanceBankStatementTempMapper.updateBatchById(bankStatementTempPOList);
            if (bankStatementResult < 1 || bankStatementResult != reqBO.getFinanceBankStatementList().size()) {
                throw new FscBusinessException("193101", "\u94f6\u884c\u6d41\u6c34\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(draftInfoTempPOList = JSONObject.parseArray((String)(draftInfoString = JSONObject.toJSONString((Object)reqBO.getFinanceDraftInfoList())), FscFinanceDraftInfoTempPO.class)))) {
            draftInfoTempPOList.stream().forEach(draftInfoTempPO -> {
                draftInfoTempPO.setTempId(reqBO.getTempId());
                draftInfoTempPO.setContractId(reqBO.getContractId());
            });
            int draftInfoResult = this.fscFinanceDraftInfoTempMapper.updateBatchById(draftInfoTempPOList);
            if (draftInfoResult < 1 || draftInfoResult != reqBO.getFinanceDraftInfoList().size()) {
                throw new FscBusinessException("193101", "\u7968\u636e\u53f0\u8d26\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
            }
        }
        FscFinancePayItemTempUpdateRspBO rspBO = new FscFinancePayItemTempUpdateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinancePayItemTempUpdateReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderPayItemList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u96c6\u5408[orderPayItemList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getTempId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getContractId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getContractName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u540d\u79f0[contractName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getContractNo())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u7f16\u53f7[contractNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscOrderPayItemTempDetailBO item : reqBO.getOrderPayItemList()) {
            if (Objects.isNull(item.getOrderPayItemTempId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4e3b\u952eID[orderPayItemTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(item.getTempId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(item.getShouldPayId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5e94\u4ed8ID[shouldPayId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isEmpty((Object)item.getItemNo())) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFinancePayItemList())) {
            for (FscOrderPayItemTempDetailBO item : reqBO.getFinancePayItemList()) {
                if (Objects.isNull(item.getFinancePayItemTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u4fe1\u606f\u4e34\u65f6\u4e3b\u952eID[financePayItemTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getContractId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)item.getItemNo())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPayReduceTempList())) {
            for (FscOrderPayItemTempDetailBO item : reqBO.getPayReduceTempList()) {
                if (Objects.isNull(item.getFinancePayReduceTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u6838\u51cf\u660e\u7ec6\u4e34\u65f6\u4e3b\u952eID[financePayReduceTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)item.getItemNo())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCapitalPlanTempList())) {
            for (FscOrderPayItemTempDetailBO item : reqBO.getCapitalPlanTempList()) {
                if (Objects.isNull(item.getFinanceCapitalPlanTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u4e34\u65f6\u4e3b\u952eID[financeCapitalPlanTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)item.getItemNo())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)item.getPayItemNo())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u4fe1\u606f\u7f16\u53f7[payItemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFinanceBankStatementList())) {
            for (FscOrderPayItemTempDetailBO item : reqBO.getFinanceBankStatementList()) {
                if (Objects.isNull(item.getStatementTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u6d41\u6c34\u4e34\u65f6\u4e3b\u952eID[financeCapitalPlanTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)item.getItemNo())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getFscOrderId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!Objects.isNull(item.getOrderPayItemId())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6ID[orderPayItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFinanceDraftInfoList())) {
            for (FscOrderPayItemTempDetailBO item : reqBO.getFinanceDraftInfoList()) {
                if (Objects.isNull(item.getFinanceDraftTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7968\u636e\u4e34\u65f6\u4e3b\u952eID[financeDraftTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)item.getPayItemNo())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u884c\u53f7[payItemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getFscOrderId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!Objects.isNull(item.getContractId())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

