/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tydic.fsc.bo.FscFinanceBankSerialBO;
import com.tydic.fsc.bo.FscFinanceDraftInfoBO;
import com.tydic.fsc.bo.FscFinancePayItemBO;
import com.tydic.fsc.bo.FscFinancePayReduceBO;
import com.tydic.fsc.bo.FscFinancePlanItemBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class FscFinancePayCheckUtil {
    private static List<String> FINANCE_PAY_METHOD = Lists.newArrayList((Object[])new String[]{"FKFS0002", "FKFS0005"});

    private static Map<String, BigDecimal> checkReduce(FscOrderPayItemBO orderPayItemBO, BigDecimal exchangeRate) {
        Map<Object, Object> reduceAmtByItemNoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)orderPayItemBO.getReduceList())) {
            reduceAmtByItemNoMap = orderPayItemBO.getReduceList().stream().collect(Collectors.toMap(FscFinancePayReduceBO::getItemNo, FscFinancePayReduceBO::getReduceAmt, BigDecimal::add));
            for (FscFinancePayReduceBO reduceBO : orderPayItemBO.getReduceList()) {
                BigDecimal reduceAmt = reduceBO.getReduceAmt();
                BigDecimal reduceAmtLocal = reduceBO.getReduceAmtLocal();
                if (reduceAmt != null) {
                    if (reduceAmtLocal == null) {
                        throw new FscBusinessException("198888", String.format("%s\u6838\u51cf\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a", reduceBO.getItemNo()));
                    }
                    if (reduceAmt.multiply(exchangeRate).compareTo(reduceAmtLocal) == 0) continue;
                    throw new FscBusinessException("198888", String.format("%s\u6838\u51cf\u91d1\u989d\u4e0e\u672c\u5e01\u4f4d\u8f6c\u6362\u540e\u91d1\u989d\u4e0d\u76f8\u7b49", reduceBO.getItemNo()));
                }
                throw new FscBusinessException("198888", String.format("%s\u6838\u51cf\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", reduceBO.getItemNo()));
            }
        }
        return reduceAmtByItemNoMap;
    }

    private static void checkSerial(FscOrderPayItemBO orderPayItemBO, BigDecimal exchangeRate, Map<String, BigDecimal> reduceAmtByItemNoMap) {
        if (!CollectionUtils.isEmpty((Collection)orderPayItemBO.getSerialList())) {
            BigDecimal payAmount = orderPayItemBO.getPayAmount();
            if (exchangeRate == null) {
                throw new FscBusinessException("198888", "\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (BigDecimal.ZERO.compareTo(payAmount) >= 0) {
                throw new FscBusinessException("198888", "\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (FscFinanceBankSerialBO bankSerialBO : orderPayItemBO.getSerialList()) {
                BigDecimal amountUnclaimed = bankSerialBO.getAmountUnclaimed();
                BigDecimal amountUnclaimedLocal = bankSerialBO.getAmountUnclaimedLocal();
                BigDecimal occAmt = bankSerialBO.getOccAmt();
                BigDecimal occAmtLocal = bankSerialBO.getOccAmtLocal();
                if (amountUnclaimed != null) {
                    if (amountUnclaimedLocal == null) {
                        throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u53ef\u8ba4\u9886\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getItemNo()));
                    }
                    if (amountUnclaimed.multiply(exchangeRate).compareTo(amountUnclaimedLocal) != 0) {
                        throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u53ef\u8ba4\u9886\u91d1\u989d\u4e0e\u672c\u5e01\u4f4d\u8f6c\u6362\u540e\u91d1\u989d\u4e0d\u76f8\u7b49", bankSerialBO.getItemNo()));
                    }
                } else {
                    throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u53ef\u8ba4\u9886\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getItemNo()));
                }
                if (occAmt != null) {
                    if (occAmtLocal == null) {
                        throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u4ed8\u6b3e\u5360\u7528\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getItemNo()));
                    }
                    if (occAmt.multiply(exchangeRate).compareTo(occAmtLocal) != 0) {
                        throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u4ed8\u6b3e\u5360\u7528\u91d1\u989d\u4e0e\u672c\u5e01\u4f4d\u8f6c\u6362\u540e\u91d1\u989d\u4e0d\u76f8\u7b49", bankSerialBO.getItemNo()));
                    }
                } else {
                    throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u4ed8\u6b3e\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getItemNo()));
                }
                String itemNo = bankSerialBO.getItemNo();
                BigDecimal reduceAmtSum = BigDecimal.ZERO;
                if (orderPayItemBO.getIsReduce() != null && orderPayItemBO.getIsReduce() == 1 && reduceAmtByItemNoMap.get(itemNo) != null) {
                    reduceAmtSum = reduceAmtByItemNoMap.get(itemNo);
                }
                BigDecimal occAmountSum = reduceAmtSum;
                for (FscFinancePlanItemBO financePlanItemBO : bankSerialBO.getPlanList()) {
                    BigDecimal balAmount = financePlanItemBO.getBalAmount();
                    if (balAmount == null) {
                        throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getPayItemNo()));
                    }
                    BigDecimal occAmount = financePlanItemBO.getOccAmount();
                    if (occAmount == null) {
                        throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getPayItemNo()));
                    }
                    if (balAmount.compareTo(occAmount) < 0) {
                        throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u6b21\u5360\u7528\u91d1\u989d", bankSerialBO.getPayItemNo()));
                    }
                    occAmountSum = occAmountSum.add(financePlanItemBO.getOccAmount());
                }
                if (occAmountSum.compareTo(payAmount) == 0) continue;
                throw new FscBusinessException("198888", String.format("%s\u4ed8\u6b3e\u4fe1\u606f\u91d1\u989d\u548c\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u91d1\u989d\u4e0d\u7b49\uff01", bankSerialBO.getPayItemNo()));
            }
        }
    }

    public static void checkLocalAmount(FscOrderPayItemBO orderPayItemBO, BigDecimal exchangeRate) {
        Map<String, BigDecimal> reduceAmtByItemNoMap = FscFinancePayCheckUtil.checkReduce(orderPayItemBO, exchangeRate);
        FscFinancePayCheckUtil.checkSerial(orderPayItemBO, exchangeRate, reduceAmtByItemNoMap);
        if (orderPayItemBO.getFinanceItemList() == null || orderPayItemBO.getFinanceItemList().isEmpty()) {
            throw new FscBusinessException("198888", String.format("%s\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", orderPayItemBO.getItemNo()));
        }
        for (FscFinancePayItemBO financePayItemBO : orderPayItemBO.getFinanceItemList()) {
            BigDecimal payAmount = orderPayItemBO.getPayAmount();
            if (exchangeRate == null) {
                throw new FscBusinessException("198888", "\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (BigDecimal.ZERO.compareTo(payAmount) >= 0) {
                throw new FscBusinessException("198888", "\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String itemNo = financePayItemBO.getItemNo();
            BigDecimal reduceAmtSum = BigDecimal.ZERO;
            if (orderPayItemBO.getIsReduce() != null && orderPayItemBO.getIsReduce() == 1 && reduceAmtByItemNoMap.get(itemNo) != null) {
                reduceAmtSum = reduceAmtByItemNoMap.get(itemNo);
            }
            if (financePayItemBO.getPlanList() == null || financePayItemBO.getPlanList().isEmpty()) {
                throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
            }
            BigDecimal occAmountSum = reduceAmtSum;
            for (FscFinancePlanItemBO financePlanItemBO : financePayItemBO.getPlanList()) {
                BigDecimal balAmount = financePlanItemBO.getBalAmount();
                if (balAmount == null) {
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
                }
                BigDecimal occAmount = financePlanItemBO.getOccAmount();
                if (occAmount == null) {
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
                }
                if (balAmount.compareTo(occAmount) < 0) {
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u6b21\u5360\u7528\u91d1\u989d", financePayItemBO.getPayItemNo()));
                }
                occAmountSum = occAmountSum.add(financePlanItemBO.getOccAmount());
            }
            if (occAmountSum.compareTo(financePayItemBO.getPayAmount()) != 0) {
                throw new FscBusinessException("198888", String.format("%s\u4ed8\u6b3e\u4fe1\u606f\u91d1\u989d\u548c\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u91d1\u989d\u4e0d\u7b49\uff01", financePayItemBO.getPayItemNo()));
            }
            String financePayMethod = financePayItemBO.getFinancePayMethod();
            if (!FINANCE_PAY_METHOD.contains(financePayMethod)) continue;
            BigDecimal financePayAmount = financePayItemBO.getPayAmount();
            if (!CollectionUtils.isEmpty((Collection)financePayItemBO.getDraftList())) {
                BigDecimal occAmtSum = BigDecimal.ZERO;
                for (FscFinanceDraftInfoBO draftInfoBO : financePayItemBO.getDraftList()) {
                    BigDecimal occAmt = draftInfoBO.getOccAmt();
                    BigDecimal occAmtLocal = draftInfoBO.getOccAmtLocal();
                    if (occAmt != null && BigDecimal.ZERO.compareTo(occAmt) < 0) {
                        if (occAmtLocal == null) {
                            throw new FscBusinessException("198888", String.format("\u4ed8\u6b3e\u4fe1\u606f\u7f16\u53f7%s\u4e0b\u7968\u636e%s\u5360\u7528\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo(), draftInfoBO.getBillNo()));
                        }
                        if (occAmt.multiply(exchangeRate).compareTo(occAmtLocal) != 0) {
                            throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u7968\u636e\u5360\u7528\u91d1\u989d\u4e0e\u672c\u5e01\u4f4d\u8f6c\u6362\u540e\u91d1\u989d\u4e0d\u76f8\u7b49", financePayItemBO.getPayItemNo()));
                        }
                    } else {
                        throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u7968\u636e\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
                    }
                    occAmtSum = occAmtSum.add(draftInfoBO.getOccAmt());
                }
                if (occAmtSum.compareTo(financePayAmount) == 0) continue;
                throw new FscBusinessException("198888", String.format("%s\u7968\u636e\u5360\u7528\u91d1\u989d\u4e0e\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49", financePayItemBO.getPayItemNo()));
            }
            throw new FscBusinessException("198888", String.format("%s\u7968\u636e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
        }
    }

    public static void checkLocalAmountApply(List<FscOrderPayItemBO> fscOrderPayItemBOS, BigDecimal exchangeRate) {
        for (FscOrderPayItemBO orderPayItemBO : fscOrderPayItemBOS) {
            FscFinancePayCheckUtil.checkLocalAmountApply(orderPayItemBO, exchangeRate);
        }
    }

    public static void checkLocalAmountApply(FscOrderPayItemBO orderPayItemBO, BigDecimal exchangeRate) {
        Map<String, BigDecimal> reduceAmtByItemNoMap = FscFinancePayCheckUtil.checkReduce(orderPayItemBO, exchangeRate);
        FscFinancePayCheckUtil.checkSerial(orderPayItemBO, exchangeRate, reduceAmtByItemNoMap);
        if (orderPayItemBO.getFinanceItemList() == null || orderPayItemBO.getFinanceItemList().isEmpty()) {
            throw new FscBusinessException("198888", String.format("%s\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", orderPayItemBO.getItemNo()));
        }
        for (FscFinancePayItemBO financePayItemBO : orderPayItemBO.getFinanceItemList()) {
            BigDecimal reduceAmtSum;
            BigDecimal payAmount = orderPayItemBO.getPayAmount();
            if (exchangeRate == null) {
                throw new FscBusinessException("198888", "\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (BigDecimal.ZERO.compareTo(payAmount) >= 0) {
                throw new FscBusinessException("198888", "\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String itemNo = financePayItemBO.getItemNo();
            BigDecimal bigDecimal = reduceAmtSum = reduceAmtByItemNoMap.get(itemNo) == null ? BigDecimal.ZERO : reduceAmtByItemNoMap.get(itemNo);
            if (financePayItemBO.getPlanList() == null || financePayItemBO.getPlanList().isEmpty()) {
                throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
            }
            BigDecimal occAmountSum = reduceAmtSum;
            for (FscFinancePlanItemBO financePlanItemBO : financePayItemBO.getPlanList()) {
                BigDecimal balAmount = financePlanItemBO.getBalAmount();
                if (balAmount == null) {
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
                }
                BigDecimal occAmount = financePlanItemBO.getOccAmount();
                if (occAmount == null) {
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
                }
                if (balAmount.compareTo(occAmount) < 0) {
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u6b21\u5360\u7528\u91d1\u989d", financePayItemBO.getPayItemNo()));
                }
                occAmountSum = occAmountSum.add(financePlanItemBO.getOccAmount());
            }
            if (occAmountSum.compareTo(payAmount) != 0) {
                throw new FscBusinessException("198888", String.format("%s\u4ed8\u6b3e\u4fe1\u606f\u91d1\u989d\u548c\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u91d1\u989d\u4e0d\u7b49\uff01", financePayItemBO.getPayItemNo()));
            }
            if (CollectionUtils.isEmpty((Collection)financePayItemBO.getDraftList())) continue;
            for (FscFinanceDraftInfoBO draftInfoBO : financePayItemBO.getDraftList()) {
                BigDecimal occAmt = draftInfoBO.getOccAmt();
                BigDecimal occAmtLocal = draftInfoBO.getOccAmtLocal();
                if (occAmt != null) {
                    if (occAmtLocal == null) {
                        throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u7968\u636e\u5360\u7528\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
                    }
                    if (occAmt.multiply(exchangeRate).compareTo(occAmtLocal) == 0) continue;
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u7968\u636e\u5360\u7528\u91d1\u989d\u4e0e\u672c\u5e01\u4f4d\u8f6c\u6362\u540e\u91d1\u989d\u4e0d\u76f8\u7b49", financePayItemBO.getPayItemNo()));
                }
                throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u7968\u636e\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
            }
        }
    }
}

