/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscDealPayResultSuccessAtomService;
import com.tydic.fsc.pay.atom.api.FscPayResultConfirmDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.api.FscPayResultConfirmService;
import com.tydic.fsc.pay.atom.bo.FscDealPayResultSuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPayResultSuccessAtomRspBO;
import com.tydic.fsc.pay.atom.bo.FscPayResultConfirmReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayResultConfirmRspBO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayResultConfirmServiceImpl
implements FscPayResultConfirmService {
    private static final Logger log = LoggerFactory.getLogger(FscPayResultConfirmServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscDealPayResultSuccessAtomService fscDealPayResultSuccessAtomService;
    @Autowired
    private FscPayResultConfirmDealPaySuccessAtomService fscPayResultConfirmDealPaySuccessAtomService;

    @Override
    public FscPayResultConfirmRspBO dealPayResultConfirm(FscPayResultConfirmReqBO busiReqBO) {
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>();
        FscOrderPO set = new FscOrderPO();
        set.setPayConfirmId(busiReqBO.getUserName());
        set.setPayConfirmName(busiReqBO.getName());
        set.setPayConfirmTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(busiReqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        this.invokeFscOrderStatusFlow(busiReqBO);
        if (busiReqBO.getPayFlag().booleanValue()) {
            FscDealPayResultSuccessAtomReqBO fscDealPayResultSuccessAtomReqBO = new FscDealPayResultSuccessAtomReqBO();
            fscDealPayResultSuccessAtomReqBO.setPayFscOrderId(busiReqBO.getFscOrderIds());
            fscDealPayResultSuccessAtomReqBO.setPayTime(busiReqBO.getPayTime());
            fscDealPayResultSuccessAtomReqBO.setIsDownFlow(busiReqBO.getIsDownFlow());
            FscDealPayResultSuccessAtomRspBO atomRspBO = new FscDealPayResultSuccessAtomRspBO();
            atomRspBO = busiReqBO.getIsDownFlow() != null && busiReqBO.getIsDownFlow() == 1 ? this.fscPayResultConfirmDealPaySuccessAtomService.dealPaySuccess(fscDealPayResultSuccessAtomReqBO) : this.fscDealPayResultSuccessAtomService.dealPaySuccess(fscDealPayResultSuccessAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty(atomRspBO.getResultFscOrderIds())) {
                resultFscOrderIds.addAll(atomRspBO.getResultFscOrderIds());
            }
        }
        resultFscOrderIds.addAll(busiReqBO.getFscOrderIds());
        FscPayResultConfirmRspBO busiRspBO = new FscPayResultConfirmRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        return busiRspBO;
    }

    private void invokeFscOrderStatusFlow(FscPayResultConfirmReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (busiReqBO.getPayFlag().booleanValue()) {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag1);
        } else {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag0);
        }
        if (busiReqBO.getYcPayFlag() != null && busiReqBO.getYcPayFlag().booleanValue()) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        }
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.PAIED_TO_COMFIR);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
        });
    }
}

