/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemTempMapper;
import com.tydic.fsc.dao.FscFinancePayReduceTempMapper;
import com.tydic.fsc.dao.FscOrderPayItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempUpdateReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempUpdateRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscOrderPayItemTempDetailBO;
import com.tydic.fsc.pay.ability.bo.finance.FscPayItemTempDetailBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayItemTempUpdateService;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinancePayItemTempPO;
import com.tydic.fsc.po.FscFinancePayReduceTempPO;
import com.tydic.fsc.po.FscOrderPayItemTempPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinancePayItemTempUpdateServiceImpl
implements FscFinancePayItemTempUpdateService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayItemTempUpdateServiceImpl.class);
    @Autowired
    private FscOrderPayItemTempMapper fscOrderPayItemTempMapper;
    @Autowired
    private FscFinancePayItemTempMapper fscFinancePayItemTempMapper;
    @Autowired
    private FscFinancePayReduceTempMapper fscFinancePayReduceTempMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;

    @Override
    public FscFinancePayItemTempUpdateRspBO dealFinancePayTempUpdateBatch(FscFinancePayItemTempUpdateReqBO reqBO) {
        int draftInfoResult;
        int bankStatementResult;
        int capitalPlanResult;
        int payReduceResult;
        int payItemTempResult;
        int orderPayItemResult;
        this.valid(reqBO);
        ArrayList fscOrderPayItemTempPOUpdateList = new ArrayList();
        ArrayList fscFinancePayItemTempPOUpdateList = new ArrayList();
        ArrayList fscFinancePayReduceTempPOUpdateList = new ArrayList();
        ArrayList fscFinanceCapitalPlanTempPOUpdateList = new ArrayList();
        ArrayList fscFinanceBankStatementTempPOUpdateList = new ArrayList();
        ArrayList fscFinanceDraftInfoTempPOUpdateList = new ArrayList();
        for (FscPayItemTempDetailBO detailBO : reqBO.getDetailBOList()) {
            String draftInfoString;
            List draftInfoTempPOList;
            String bankStatementString;
            List bankStatementTempPOList;
            String capitalPlanTempString;
            List fscFinanceCapitalPlanTempPOList;
            String payReduceTempString;
            List fscFinancePayReduceTempPOList;
            String orderPayItemTempString = JSONObject.toJSONString((Object)detailBO.getOrderPayItemList());
            List orderPayItemTempPOList = JSONObject.parseArray((String)orderPayItemTempString, FscOrderPayItemTempPO.class);
            if (CollectionUtils.isEmpty((Collection)orderPayItemTempPOList)) {
                throw new FscBusinessException("198888", "\u8f6c\u4e49\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            orderPayItemTempPOList.stream().forEach(orderPayItemTempPO -> {
                orderPayItemTempPO.setTempId(detailBO.getTempId());
                orderPayItemTempPO.setContractNo(detailBO.getContractNo());
                orderPayItemTempPO.setContractId(detailBO.getContractId());
                orderPayItemTempPO.setContractName(detailBO.getContractName());
            });
            fscOrderPayItemTempPOUpdateList.addAll(orderPayItemTempPOList);
            String payItemTempString = JSONObject.toJSONString((Object)detailBO.getFinancePayItemList());
            List fscFinancePayItemTempPOList = JSONObject.parseArray((String)payItemTempString, FscFinancePayItemTempPO.class);
            if (!CollectionUtils.isEmpty((Collection)fscFinancePayItemTempPOList)) {
                fscFinancePayItemTempPOList.stream().forEach(fscFinancePayItemTempPO -> {
                    fscFinancePayItemTempPO.setTempId(detailBO.getTempId());
                    fscFinancePayItemTempPO.setContractId(detailBO.getContractId());
                });
                fscFinancePayItemTempPOUpdateList.addAll(fscFinancePayItemTempPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(fscFinancePayReduceTempPOList = JSONObject.parseArray((String)(payReduceTempString = JSONObject.toJSONString((Object)detailBO.getPayReduceTempList())), FscFinancePayReduceTempPO.class)))) {
                fscFinancePayReduceTempPOList.stream().forEach(fscFinancePayReduceTempPO -> {
                    fscFinancePayReduceTempPO.setTempId(detailBO.getTempId());
                    fscFinancePayReduceTempPO.setContractNo(detailBO.getContractNo());
                    fscFinancePayReduceTempPO.setContractId(detailBO.getContractId());
                    fscFinancePayReduceTempPO.setContractName(detailBO.getContractName());
                });
                fscFinancePayReduceTempPOList.addAll(fscFinancePayReduceTempPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(fscFinanceCapitalPlanTempPOList = JSONObject.parseArray((String)(capitalPlanTempString = JSONObject.toJSONString((Object)detailBO.getCapitalPlanTempList())), FscFinanceCapitalPlanTempPO.class)))) {
                fscFinanceCapitalPlanTempPOList.stream().forEach(fscFinanceCapitalPlanTempPO -> {
                    fscFinanceCapitalPlanTempPO.setTempId(detailBO.getTempId());
                    fscFinanceCapitalPlanTempPO.setContractNo(detailBO.getContractNo());
                    fscFinanceCapitalPlanTempPO.setContractId(detailBO.getContractId());
                    fscFinanceCapitalPlanTempPO.setContractName(detailBO.getContractName());
                });
                fscFinanceCapitalPlanTempPOUpdateList.addAll(fscFinanceCapitalPlanTempPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(bankStatementTempPOList = JSONObject.parseArray((String)(bankStatementString = JSONObject.toJSONString((Object)detailBO.getFinanceBankStatementList())), FscFinanceBankStatementTempPO.class)))) {
                bankStatementTempPOList.stream().forEach(bankStatementTempPO -> {
                    bankStatementTempPO.setTempId(detailBO.getTempId());
                    bankStatementTempPO.setContractId(detailBO.getContractId());
                });
                fscFinanceBankStatementTempPOUpdateList.addAll(bankStatementTempPOList);
            }
            if (CollectionUtils.isEmpty((Collection)(draftInfoTempPOList = JSONObject.parseArray((String)(draftInfoString = JSONObject.toJSONString((Object)detailBO.getFinanceDraftInfoList())), FscFinanceDraftInfoTempPO.class)))) continue;
            draftInfoTempPOList.stream().forEach(draftInfoTempPO -> {
                draftInfoTempPO.setTempId(detailBO.getTempId());
                draftInfoTempPO.setContractId(detailBO.getContractId());
            });
            fscFinanceDraftInfoTempPOUpdateList.addAll(draftInfoTempPOList);
        }
        if (!(CollectionUtils.isEmpty(fscOrderPayItemTempPOUpdateList) || (orderPayItemResult = this.fscOrderPayItemTempMapper.updateBatchById(fscOrderPayItemTempPOUpdateList)) >= 1 && orderPayItemResult == fscOrderPayItemTempPOUpdateList.size())) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
        }
        if (!(CollectionUtils.isEmpty(fscFinancePayItemTempPOUpdateList) || (payItemTempResult = this.fscFinancePayItemTempMapper.updateBatchById(fscFinancePayItemTempPOUpdateList)) >= 1 && payItemTempResult == fscFinancePayItemTempPOUpdateList.size())) {
            throw new FscBusinessException("193101", "\u4ed8\u6b3e\u4fe1\u606f\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
        }
        if (!(CollectionUtils.isEmpty(fscFinancePayReduceTempPOUpdateList) || (payReduceResult = this.fscFinancePayReduceTempMapper.updateBatchById(fscFinancePayReduceTempPOUpdateList)) >= 1 && payReduceResult == fscFinancePayReduceTempPOUpdateList.size())) {
            throw new FscBusinessException("193101", "\u6838\u51cf\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
        }
        if (!(CollectionUtils.isEmpty(fscFinanceCapitalPlanTempPOUpdateList) || (capitalPlanResult = this.fscFinanceCapitalPlanTempMapper.updateBatchById(fscFinanceCapitalPlanTempPOUpdateList)) >= 1 && capitalPlanResult == fscFinanceCapitalPlanTempPOUpdateList.size())) {
            throw new FscBusinessException("193101", "\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
        }
        if (!(CollectionUtils.isEmpty(fscFinanceBankStatementTempPOUpdateList) || (bankStatementResult = this.fscFinanceBankStatementTempMapper.updateBatchById(fscFinanceBankStatementTempPOUpdateList)) >= 1 && bankStatementResult == fscFinanceBankStatementTempPOUpdateList.size())) {
            throw new FscBusinessException("193101", "\u94f6\u884c\u6d41\u6c34\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
        }
        if (!(CollectionUtils.isEmpty(fscFinanceDraftInfoTempPOUpdateList) || (draftInfoResult = this.fscFinanceDraftInfoTempMapper.updateBatchById(fscFinanceDraftInfoTempPOUpdateList)) >= 1 && draftInfoResult == fscFinanceDraftInfoTempPOUpdateList.size())) {
            throw new FscBusinessException("193101", "\u7968\u636e\u53f0\u8d26\u4e34\u65f6\u4fe1\u606f\u66f4\u65b0\u5165\u8868\u5931\u8d25!");
        }
        FscFinancePayItemTempUpdateRspBO rspBO = new FscFinancePayItemTempUpdateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinancePayItemTempUpdateReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailBOList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u6570\u636e\u96c6\u5408[detailBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscPayItemTempDetailBO detailBO : reqBO.getDetailBOList()) {
            if (CollectionUtils.isEmpty((Collection)detailBO.getOrderPayItemList())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u96c6\u5408[orderPayItemTempList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(detailBO.getTempId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)detailBO.getContractNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u7f16\u53f7[contractNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(detailBO.getContractId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)detailBO.getContractName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u540d\u79f0[contractName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            for (FscOrderPayItemTempDetailBO item : detailBO.getOrderPayItemList()) {
                if (Objects.isNull(item.getOrderPayItemTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u4e3b\u952eID[orderPayItemTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)item.getItemNo())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getFinancePayItemList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getFinancePayItemList()) {
                    if (Objects.isNull(item.getFinancePayItemTempId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u4fe1\u606f\u4e3b\u952eID[financePayItemTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!StringUtils.isEmpty((Object)item.getItemNo())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getPayReduceTempList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getPayReduceTempList()) {
                    if (StringUtils.isEmpty((Object)item.getItemNo())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!Objects.isNull(item.getFinancePayReduceTempId())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u6838\u51cf\u4fe1\u606f\u4e3b\u952eID[financePayReduceTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getCapitalPlanTempList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getCapitalPlanTempList()) {
                    if (StringUtils.isEmpty((Object)item.getItemNo())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!Objects.isNull(item.getFinanceCapitalPlanTempId())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u8d44\u91d1\u8ba1\u5212\u4e3b\u952eID[financeCapitalPlanTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getFinanceBankStatementList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getFinanceBankStatementList()) {
                    if (Objects.isNull(item.getStatementTempId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u94f6\u884c\u6d41\u6c34\u4e3b\u952eID[statementTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Objects.isNull(item.getItemNo())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Objects.isNull(item.getFscOrderId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (!Objects.isNull(item.getOrderPayItemId())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6ID[orderPayItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (CollectionUtils.isEmpty((Collection)detailBO.getFinanceDraftInfoList())) continue;
            for (FscOrderPayItemTempDetailBO item : detailBO.getFinanceDraftInfoList()) {
                if (Objects.isNull(item.getFinanceDraftTempId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7968\u636e\u53f0\u8d26\u4e3b\u952eID[financeDraftTempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getExt1())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7[ext1]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.isNull(item.getFscOrderId())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)item.getPayItemNo())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u884c\u53f7[payItemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!Objects.isNull(item.getFinancePayItemId())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6ID[financePayItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

