/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemTempMapper;
import com.tydic.fsc.dao.FscFinancePayReduceTempMapper;
import com.tydic.fsc.dao.FscOrderPayItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscOrderPayItemTempDeleteReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscOrderPayItemTempDeleteRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscOrderPayItemTempDeleteService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscOrderPayItemTempDeleteServiceImpl
implements FscOrderPayItemTempDeleteService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderPayItemTempDeleteServiceImpl.class);
    @Autowired
    private FscOrderPayItemTempMapper fscOrderPayItemTempMapper;
    @Autowired
    private FscFinancePayItemTempMapper fscFinancePayItemTempMapper;
    @Autowired
    private FscFinancePayReduceTempMapper fscFinancePayReduceTempMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;

    @Override
    public FscOrderPayItemTempDeleteRspBO dealOrderPayItemTempDelete(FscOrderPayItemTempDeleteReqBO reqBo) {
        this.valid(reqBo);
        int orderPayResult = this.fscOrderPayItemTempMapper.deleteBatchById(reqBo.getOrderPayItemList());
        if (orderPayResult != reqBo.getOrderPayItemList().size() || orderPayResult < 1) {
            throw new FscBusinessException("191000", "\u6839\u636e\u4ed8\u6b3e\u660e\u7ec6ID\u5217\u8868[orderPayItemList]\u5220\u9664\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.fscFinancePayItemTempMapper.deleteBatchByItemNo(reqBo.getItemNoList());
        this.fscFinancePayReduceTempMapper.deleteBatchByItemNo(reqBo.getItemNoList());
        this.fscFinanceCapitalPlanTempMapper.deleteBatchByItemNo(reqBo.getItemNoList());
        this.fscFinanceBankStatementTempMapper.deleteBatchByItemNo(reqBo.getItemNoList());
        this.fscFinanceDraftInfoTempMapper.deleteBatchByItemNo(reqBo.getItemNoList());
        FscOrderPayItemTempDeleteRspBO rspBO = new FscOrderPayItemTempDeleteRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscOrderPayItemTempDeleteReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getItemNoList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7\u96c6\u5408[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderPayItemList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6ID\u5217\u8868[orderPayItemList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

