/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.tydic.fsc.busibase.atom.api.FscFinancePayTempQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscFinancePayBillUpdateAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayBillUpdateReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayBillUpdateRspBO;
import com.tydic.fsc.pay.atom.api.FscFinancePayCheckUtil;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayBillUpdateBusiService;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscFinancePayBillUpdateAbilityService"})
public class FscFinancePayBillUpdateAbilityServiceImpl
implements FscFinancePayBillUpdateAbilityService {
    @Autowired
    private FscFinancePayBillUpdateBusiService fscFinancePayBillUpdateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscFinancePayTempQryAtomService fscFinancePayTempQryAtomService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealFinancePayBillUpdate"})
    public FscFinancePayBillUpdateRspBO dealFinancePayBillUpdate(@RequestBody FscFinancePayBillUpdateReqBO reqBO) {
        if (reqBO.getTempId() != null) {
            this.qryTemp(reqBO);
        } else {
            this.valid(reqBO);
        }
        FscFinancePayBillUpdateRspBO rspBO = this.fscFinancePayBillUpdateBusiService.dealFinancePayBillUpdate(reqBO);
        if (rspBO.getFscOrderId() != null) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        return rspBO;
    }

    private void qryTemp(FscFinancePayBillUpdateReqBO reqBO) {
        FscFinancePayTempQryAtomReqBO atomReqBO = new FscFinancePayTempQryAtomReqBO();
        atomReqBO.setTempId(reqBO.getTempId());
        atomReqBO.setFscOrderId(reqBO.getFscOrderId());
        atomReqBO.setPaymentType(reqBO.getPaymentType());
        FscFinancePayTempQryAtomRspBO atomRspBO = this.fscFinancePayTempQryAtomService.qryPayTempUpd(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u67e5\u8be2\u4ed8\u6b3e\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
        reqBO.setFscOrderPayItemBOS(atomRspBO.getFscOrderPayItemBOS());
    }

    private void valid(FscFinancePayBillUpdateReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderPayItemBOS]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            FscFinancePayCheckUtil.checkLocalAmountApply(reqBO.getFscOrderPayItemBOS(), reqBO.getExchangeRate(), reqBO.getCurrency());
        }
    }
}

