/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleasePayInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseCapitalService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseSupplyService;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractRelationMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.finance.FscFinanceDealPayAuditBusiService;
import com.tydic.fsc.pay.busi.bo.finance.FscFinanceDealPayAuditBusiReqBO;
import com.tydic.fsc.pay.busi.bo.finance.FscFinanceDealPayAuditBusiRspBO;
import com.tydic.fsc.pay.task.bo.TodoFscWaitAbilityReqBO;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscFinanceDealPayAuditBusiServiceImpl
implements FscFinanceDealPayAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceDealPayAuditBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscContractRelationMapper fscContractRelationMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseCapitalService fscFinanceOccupyOrReleaseCapitalService;
    @Autowired
    private FscFinanceOccupyOrReleaseSupplyService fscFinanceOccupyOrReleaseSupplyService;
    @Autowired
    private FscFinanceReleasePayInfoAtomService fscFinanceReleasePayInfoAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    public static final String PASS = "0";
    public static final String BUSI_NAME = "\u4e3b\u5355\u5ba1\u6279";
    public static final String BUSI_CODE = "1009";

    @Override
    public FscFinanceDealPayAuditBusiRspBO dealFinancePayAudit(FscFinanceDealPayAuditBusiReqBO reqBO) {
        UocApprovalLogPO uocApprovalLogPO = null;
        try {
            uocApprovalLogPO = this.taskTodoWaitService.listApproval(reqBO.getOrderId());
        }
        catch (Exception e) {
            log.error("dealOrderApproval get stationId error:{}", (Throwable)e);
        }
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBO);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        this.dealFinanceInfo(reqBO);
        if (finish.booleanValue()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            if (PASS.equals(auditResult)) {
                if (null != reqBO.getActualAmount() && BigDecimal.ZERO.compareTo(reqBO.getActualAmount()) == 0) {
                    paramMap.put("orderFinish", "1");
                } else {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
                }
            } else {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
            }
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(reqBO.getOrderId());
            flowAtomReqBO.setCurStatus(reqBO.getOrderState());
            flowAtomReqBO.setBusiName(BUSI_NAME);
            flowAtomReqBO.setBusiCode(BUSI_CODE);
            flowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getOrderId());
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
            String orderTypeStr = fscOrderPO.getOrderType() == 2 && fscOrderPO.getTradeMode() != null && fscOrderPO.getTradeMode() == 2 && fscOrderPO.getOrderSource() == 3 && fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(fscOrderPO.getOrderType() + "");
            if (!PASS.equals(auditResult)) {
                reqBO.setOrderState(FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + "\u4ed8\u6b3e\u7533\u8bf7\u5355_" + orderTypeStr + "_" + fscOrderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5ba1\u6279\u9a73\u56de");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355" + fscOrderPO.getOrderNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscOrderPO.getCreateOperId()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            } else {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + "\u4ed8\u6b3e\u7533\u8bf7\u5355_" + orderTypeStr + "_" + fscOrderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5ba1\u6279\u901a\u8fc7");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355" + fscOrderPO.getOrderNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscOrderPO.getCreateOperId()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        try {
            if (Objects.nonNull(uocApprovalLogPO) && Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
                todoFscWaitAbilityReqBO.setCenterCode("settle");
                todoFscWaitAbilityReqBO.setBusiCode("1012");
                todoFscWaitAbilityReqBO.setBusiName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
                todoFscWaitAbilityReqBO.setObjId(reqBO.getOrderId());
                todoFscWaitAbilityReqBO.setOperatorType("1");
                todoFscWaitAbilityReqBO.setStationId(uocApprovalLogPO.getNextStationId());
                this.taskTodoWaitService.handler(todoFscWaitAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("dealOrderApproval error:{}", (Throwable)e);
        }
        FscFinanceDealPayAuditBusiRspBO busiRspBO = new FscFinanceDealPayAuditBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        busiRspBO.setFinish(finish);
        return busiRspBO;
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscFinanceDealPayAuditBusiReqBO reqBO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getOrderId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.PAY_APPLY_ORDER.equals(reqBO.getOrderFlow()) ? FscConstants.AuditObjType.PAY_APPLY_ORDER : FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL;
        String stepId = this.fscOrderMapper.selectStepId(reqBO.getOrderId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        HashMap<String, Number> paramMap = new HashMap<String, Number>(4);
        paramMap.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        auditReqBO.setStepId(stepId);
        paramMap.put("payAmount", reqBO.getTotalCharge());
        auditReqBO.setVariables(paramMap);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private void dealFinanceInfo(FscFinanceDealPayAuditBusiReqBO reqBO) {
        int count;
        FscOrderFinancePO financeQueryPo = new FscOrderFinancePO();
        financeQueryPo.setFscOrderId(reqBO.getOrderId());
        financeQueryPo = this.fscOrderFinanceMapper.getModelBy(financeQueryPo);
        FscOrderPO updatePO = new FscOrderPO();
        updatePO.setFscOrderId(reqBO.getOrderId());
        updatePO.setTotalCharge(reqBO.getTotalCharge());
        updatePO.setToPayAmount(reqBO.getTotalCharge());
        this.fscOrderMapper.updateById(updatePO);
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)financePO);
        financePO.setFscOrderId(reqBO.getOrderId());
        financePO.setUpdateTime(new Date());
        financePO.setUpdateUserId(reqBO.getUserName());
        financePO.setUpdateUserName(reqBO.getName());
        if (!StringUtils.isEmpty((Object)financeQueryPo.getFinanceAuditAccount())) {
            financePO.setFinanceAuditAccount(financeQueryPo.getFinanceAuditAccount() + "," + reqBO.getUserName());
            financePO.setFinanceAuditName(financeQueryPo.getFinanceAuditName() + "," + reqBO.getName());
        } else {
            financePO.setFinanceAuditAccount(reqBO.getUserName());
            financePO.setFinanceAuditName(reqBO.getName());
        }
        this.fscOrderFinanceMapper.updateById(financePO);
        if (!CollectionUtils.isEmpty(reqBO.getUpdatePayingAmtList())) {
            this.fscShouldPayMapper.updatePayingAmtBatchList(reqBO.getUpdatePayingAmtList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderPayItemIds()) && (count = this.fscOrderPayItemMapper.deleteByItemIdSets(reqBO.getOrderPayItemIds())) != reqBO.getOrderPayItemIds().size()) {
            throw new FscBusinessException("0000", "\u5220\u9664\u4ed8\u6b3e\u660e\u7ec6\u884c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(reqBO.getUpdOrderPayItemPOS())) {
            this.fscOrderPayItemMapper.updateFinanceBatch(reqBO.getUpdOrderPayItemPOS());
        }
        if (reqBO.getIsChange().booleanValue()) {
            this.dealRelease(reqBO);
            this.fscFinanceCapitalPlanMapper.deleteByFscOrderId(reqBO.getOrderId());
            this.fscFinanceDraftInfoMapper.deleteByFscOrderId(reqBO.getOrderId());
            this.fscFinancePayReduceMapper.deleteByFscOrderId(reqBO.getOrderId());
            this.fscFinanceBankStatementMapper.deleteByFscOrderId(reqBO.getOrderId());
            this.fscFinancePayItemMapper.deleteByFscOrderId(reqBO.getOrderId());
            FscFinanceCapitalInfoAtomReqBO atomReqBO = new FscFinanceCapitalInfoAtomReqBO();
            atomReqBO.setFscOrderPayItemBOS(reqBO.getFscOrderPayItemBOS());
            atomReqBO.setObjId(reqBO.getOrderId());
            atomReqBO.setObjNo(reqBO.getOrderNo());
            atomReqBO.setObjType(Integer.valueOf(1));
            atomReqBO.setOperationType(Integer.valueOf(1));
            FscFinanceCapitalInfoAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealFinanceCapitalInfo(atomReqBO);
            if (!atomRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("198888", atomRspBO.getRespDesc());
            }
        } else {
            this.dealRelease(reqBO);
            if (!CollectionUtils.isEmpty(reqBO.getDelFinanceItemIds()) && (count = this.fscFinancePayItemMapper.deleteByIds(reqBO.getOrderId(), reqBO.getDelFinanceItemIds())) != reqBO.getDelFinanceItemIds().size()) {
                throw new FscBusinessException("190000", "\u5220\u9664\u4ed8\u6b3e\u4fe1\u606f\u884c\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(reqBO.getDelBankIds()) && (count = this.fscFinanceBankStatementMapper.deleteByIds(reqBO.getOrderId(), reqBO.getDelBankIds())) != reqBO.getDelBankIds().size()) {
                throw new FscBusinessException("190000", "\u5220\u9664\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(reqBO.getDelDraftIds()) && (count = this.fscFinanceDraftInfoMapper.deleteByIds(reqBO.getOrderId(), reqBO.getDelDraftIds())) != reqBO.getDelDraftIds().size()) {
                throw new FscBusinessException("190000", "\u5220\u9664\u7968\u636e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(reqBO.getDelReduceIds()) && (count = this.fscFinancePayReduceMapper.deleteByIds(reqBO.getOrderId(), reqBO.getDelReduceIds())) != reqBO.getDelReduceIds().size()) {
                throw new FscBusinessException("190000", "\u5220\u9664\u6838\u51cf\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(reqBO.getDelPlanIds()) && (count = this.fscFinanceCapitalPlanMapper.deleteByIds(reqBO.getOrderId(), reqBO.getDelPlanIds())) != reqBO.getDelPlanIds().size()) {
                throw new FscBusinessException("190000", "\u5220\u9664\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5f02\u5e38\uff01");
            }
            if (!CollectionUtils.isEmpty(reqBO.getFinanceAddList())) {
                this.fscFinancePayItemMapper.insertBatch(reqBO.getFinanceAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getFinanceUpdList())) {
                this.fscFinancePayItemMapper.updateBatch(reqBO.getFinanceUpdList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getBankAddList())) {
                this.fscFinanceBankStatementMapper.insertBatch(reqBO.getBankAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getBankUpdList())) {
                this.fscFinanceBankStatementMapper.updateBatch(reqBO.getBankUpdList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getDraftAddList())) {
                this.fscFinanceDraftInfoMapper.insertBatch(reqBO.getDraftAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getDraftUpdList())) {
                this.fscFinanceDraftInfoMapper.updateBatch(reqBO.getDraftUpdList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getPlanAddList())) {
                this.fscFinanceCapitalPlanMapper.insertBatch(reqBO.getPlanAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getPlanUpdList())) {
                this.fscFinanceCapitalPlanMapper.updateBatch(reqBO.getPlanUpdList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getReduceAddList())) {
                this.fscFinancePayReduceMapper.insertBatch(reqBO.getReduceAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getReduceUpdList()) && (count = this.fscFinancePayReduceMapper.updateBatch(reqBO.getReduceUpdList())) != reqBO.getReduceUpdList().size()) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u6838\u51cf\u91d1\u989d\u5931\u8d25\uff01");
            }
            ArrayList<FscFinanceBankStatementPO> bankList = new ArrayList<FscFinanceBankStatementPO>();
            if (!CollectionUtils.isEmpty(reqBO.getBankAddList()) || !CollectionUtils.isEmpty(reqBO.getBankUpdList())) {
                if (!CollectionUtils.isEmpty(reqBO.getBankAddList())) {
                    bankList.addAll(reqBO.getBankAddList());
                }
                if (!CollectionUtils.isEmpty(reqBO.getBankUpdList())) {
                    bankList.addAll(reqBO.getBankUpdList());
                }
            }
            ArrayList<FscFinanceDraftInfoPO> draftList = new ArrayList<FscFinanceDraftInfoPO>();
            if (!CollectionUtils.isEmpty(reqBO.getDraftAddList()) || !CollectionUtils.isEmpty(reqBO.getDraftUpdList())) {
                if (!CollectionUtils.isEmpty(reqBO.getDraftAddList())) {
                    draftList.addAll(reqBO.getDraftAddList());
                }
                if (!CollectionUtils.isEmpty(reqBO.getDraftUpdList())) {
                    draftList.addAll(reqBO.getDraftUpdList());
                }
            }
            ArrayList<FscFinanceCapitalPlanPO> capitalPlanList = new ArrayList<FscFinanceCapitalPlanPO>();
            if (!CollectionUtils.isEmpty(reqBO.getPlanAddList()) || !CollectionUtils.isEmpty(reqBO.getPlanUpdList())) {
                if (!CollectionUtils.isEmpty(reqBO.getPlanAddList())) {
                    capitalPlanList.addAll(reqBO.getPlanAddList());
                }
                if (!CollectionUtils.isEmpty(reqBO.getPlanUpdList())) {
                    capitalPlanList.addAll(reqBO.getPlanUpdList());
                }
            }
            if (!(CollectionUtils.isEmpty(capitalPlanList) && CollectionUtils.isEmpty(draftList) && CollectionUtils.isEmpty(bankList))) {
                FscFinanceOccupyAtomReqBO atomReqBO = new FscFinanceOccupyAtomReqBO();
                atomReqBO.setCapitalList(capitalPlanList);
                atomReqBO.setDraftList(draftList);
                atomReqBO.setBankList(bankList);
                atomReqBO.setObjId(reqBO.getOrderId());
                atomReqBO.setObjNo(reqBO.getOrderNo());
                atomReqBO.setUserName(reqBO.getUserName());
                atomReqBO.setName(reqBO.getName());
                atomReqBO.setFinanceOrgId(reqBO.getFinanceOrgId());
                atomReqBO.setFinanceOrgName(reqBO.getFinanceOrgName());
                FscFinanceOccupyAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealOccupyFinanceInfo(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
                }
            }
        }
    }

    private void dealRelease(FscFinanceDealPayAuditBusiReqBO reqBO) {
        FscFinanceReleasePayInfoAtomReqBO atomReqBO = new FscFinanceReleasePayInfoAtomReqBO();
        atomReqBO.setBankExtIds(reqBO.getBankExtIds());
        atomReqBO.setReleasePlanList(reqBO.getReleasePlanList());
        atomReqBO.setSupplyExtIds(reqBO.getSupplyExtIds());
        atomReqBO.setDraftExtIds(reqBO.getDraftExtIds());
        atomReqBO.setObjId(reqBO.getOrderId());
        atomReqBO.setObjNo(reqBO.getOrderNo());
        FscFinanceReleasePayInfoAtomRspBO atomRspBO = this.fscFinanceReleasePayInfoAtomService.dealReleasePayInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }
}

