/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceTempBankStatementDeleteReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceTempBankStatementDeleteRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinanceTempBankStatementDeleteService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceTempBankStatementDeleteServiceImpl
implements FscFinanceTempBankStatementDeleteService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceTempBankStatementDeleteServiceImpl.class);
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;

    @Override
    public FscFinanceTempBankStatementDeleteRspBO dealFinanceBankStatementTempDelete(FscFinanceTempBankStatementDeleteReqBO reqBO) {
        this.valid(reqBO);
        int orderPayResult = this.fscFinanceBankStatementTempMapper.deleteBatchById(reqBO.getBankStatementIdList());
        if (orderPayResult != reqBO.getBankStatementIdList().size() || orderPayResult < 1) {
            throw new FscBusinessException("191000", "\u6839\u636e\u94f6\u884c\u6d41\u6c34ID\u5217\u8868[bankStatementIdList]\u5220\u9664\u4ed8\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.fscFinanceCapitalPlanTempMapper.deleteBatchByItemNo(reqBO.getItemNoList());
        FscFinanceTempBankStatementDeleteRspBO rspBO = new FscFinanceTempBankStatementDeleteRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceTempBankStatementDeleteReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getItemNoList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7\u96c6\u5408[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getBankStatementIdList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u94f6\u884c\u6d41\u6c34ID\u5217\u8868[orderPayItemList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

