/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscBillOrderSettleCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSettleCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSettleCheckAbilityRspBO;
import com.tydic.fsc.bo.FscContractPlanItemBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinancePayTempQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscGetContractCapitalPlanListAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListBo;
import com.tydic.fsc.common.ability.bo.FscPushUnifyPayBillAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillCreateBySaleAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityRspBO;
import com.tydic.fsc.pay.atom.api.FscFinancePayCheckUtil;
import com.tydic.fsc.pay.busi.api.FscPayBillCreateBySaleBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiRspBO;
import com.tydic.fsc.po.FscContractCapitalPlanPo;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.base.constants.UocCoreConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillCreateBySaleAbilityService"})
public class FscPayBillCreateBySaleAbilityServiceImpl
implements FscPayBillCreateBySaleAbilityService {
    @Autowired
    private FscPayBillCreateBySaleBusiService fscPayBillCreateBySaleBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillOrderSettleCheckAbilityService fscBillOrderSettleCheckAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscContractCapitalPlanMapper fscContractCapitalPlanMapper;
    @Autowired
    private FscGetContractCapitalPlanListAbilityService fscGetContractCapitalPlanListAbilityService;
    @Resource(name="fscSyncPushUnifyPayMqServiceProvider")
    private ProxyMessageProducer fscSyncPushUnifyPayMqServiceProvider;
    @Value(value="${es.FSC_PUSH_UNIFY_PAY_TOPIC:FSC_PUSH_UNIFY_PAY_TOPIC}")
    private String fscPushUnifyPayTopic;
    @Value(value="${es.FSC_PUSH_UNIFY_PAY_TAG:FSC_PUSH_UNIFY_PAY_TAG}")
    private String fscPushUnifyPayTag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Resource
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Autowired
    private FscFinancePayTempQryAtomService fscFinancePayTempQryAtomService;
    @Value(value="${fsc.finance.pay.business.code:1003000300080001}")
    private String businessCode;
    @Value(value="${fsc.finance.pay.business.name:\u5176\u4ed6\u91c7\u8d2d\u4ed8\u6b3e}")
    private String businessName;
    @Value(value="${fsc.finance.pay.biz.type.code:100300030008}")
    private String bizTypeCode;
    @Value(value="${fsc.finance.pay.biz.type.name:\u5176\u4ed6\u91c7\u8d2d\u4ed8\u6b3e}")
    private String bizTypeName;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPayBillCreateBySale"})
    public FscPayBillCreateAbilityRspBO dealPayBillCreateBySale(@RequestBody FscPayBillCreateAbilityReqBO abilityReqBO) {
        FscPayBillCreateBusiReqBO fscPayBillCreateBusiReqBO;
        FscPayBillCreateBusiRspBO busiRspBO;
        FscPayBillCreateAbilityRspBO abilityRspBO = new FscPayBillCreateAbilityRspBO();
        if (abilityReqBO.getTempId() != null) {
            // empty if block
        }
        this.validParam(abilityReqBO);
        if (!"1".equals(abilityReqBO.getSaveOrSubmit())) {
            FscFinancePayCheckUtil.checkLocalAmountApply(abilityReqBO.getFscOrderPayItemBOS(), abilityReqBO.getExchangeRate(), abilityReqBO.getCurrency());
        }
        FscBillOrderSettleCheckAbilityReqBO checkAbilityReqBO = new FscBillOrderSettleCheckAbilityReqBO();
        checkAbilityReqBO.setOrderIds(abilityReqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getOrderId).collect(Collectors.toList()));
        checkAbilityReqBO.setSettleType(abilityReqBO.getSettleType());
        checkAbilityReqBO.setUserType(!StringUtils.isEmpty((Object)abilityReqBO.getIsprofess()) && "0".equals(abilityReqBO.getIsprofess()) ? UocCoreConstant.UserType.PRO : UocCoreConstant.UserType.PUR);
        FscBillOrderSettleCheckAbilityRspBO checkAbilityRspBO = this.fscBillOrderSettleCheckAbilityService.dealOrderSettleCheck(checkAbilityReqBO);
        if (!checkAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(checkAbilityRspBO.getRespCode(), checkAbilityRspBO.getRespDesc());
        }
        if (FscPayTypeEnum.ADVANCE_PAY.getCode().equals(abilityReqBO.getShouldPayMethod())) {
            FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
            fscOrderPayDetailPO.setRelType("0".equals(abilityReqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
            fscOrderPayDetailPO.setOrderIdList(abilityReqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getOrderId).collect(Collectors.toList()));
            int count = this.fscOrderPayDetailMapper.getSettleCountByOrderIds(fscOrderPayDetailPO);
            if (count > 0) {
                throw new FscBusinessException("191000", "\u8ba2\u5355\u5df2\u53d1\u8d77\u8fc7\u5e94\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u518d\u53d1\u8d77\u9884\u4ed8\u6b3e");
            }
        }
        if (abilityReqBO.getTempId() != null) {
            this.qryTempInfo(abilityReqBO);
        }
        if ("0000".equals((busiRspBO = this.fscPayBillCreateBySaleBusiService.dealPayBillBySaleCreate(fscPayBillCreateBusiReqBO = (FscPayBillCreateBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscPayBillCreateBusiReqBO.class)))).getRespCode())) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            if (abilityReqBO.getDockPaySettlePlatFormYn() != null && abilityReqBO.getDockPaySettlePlatFormYn() == 1 && busiRspBO.getFscOrderId() != null) {
                FscPushUnifyPayBillAbilityReqBO unifyPayBillAbilityReqBO = new FscPushUnifyPayBillAbilityReqBO();
                unifyPayBillAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
                ProxySendResult proxySendResult = this.fscSyncPushUnifyPayMqServiceProvider.send(new ProxyMessage(this.fscPushUnifyPayTopic, this.fscPushUnifyPayTag, JSONObject.toJSONString((Object)unifyPayBillAbilityReqBO)));
                if (!"SEND_OK".equals(proxySendResult.getStatus())) {
                    this.writeFailLog(busiRspBO.getFscOrderId());
                }
            }
        }
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        return abilityRspBO;
    }

    private void qryTempInfo(FscPayBillCreateAbilityReqBO abilityReqBO) {
        FscFinancePayTempQryAtomReqBO atomReqBO = new FscFinancePayTempQryAtomReqBO();
        atomReqBO.setTempId(abilityReqBO.getTempId());
        atomReqBO.setPaymentType(abilityReqBO.getPaymentType());
        FscFinancePayTempQryAtomRspBO atomRspBO = this.fscFinancePayTempQryAtomService.qryPayTemp(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u67e5\u8be2\u4ed8\u6b3e\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
        abilityReqBO.setFscOrderPayItemBOS(atomRspBO.getFscOrderPayItemBOS());
    }

    private void validParam(FscPayBillCreateAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
            throw new FscBusinessException("191000", "\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getOrgId() == null) {
            throw new FscBusinessException("191000", "\u673a\u6784ID\u4e3a\u7a7a");
        }
        if (FscConstants.PaymentMethod.SHOULD_PAY.equals(abilityReqBO.getShouldPayMethod())) {
            abilityReqBO.setBusinessItemCode(this.businessCode);
            abilityReqBO.setBusinessItemName(this.businessName);
            abilityReqBO.setBizTypeCode(this.bizTypeCode);
            abilityReqBO.setBizTypeName(this.bizTypeName);
        }
        Boolean IsDock = false;
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = new UmcEnterpriseOrgQryDetailAbilityRspBO();
        if ("1".equals(abilityReqBO.getIsprofess())) {
            UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(abilityReqBO.getOrgId());
            umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
            if (!"0000".equals(umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode()) || umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
                throw new FscBusinessException("191000", "\u7528\u6237\u673a\u6784\u67e5\u8be2\u5931\u8d25");
            }
            if (umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn() != null && umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn() == 1) {
                IsDock = true;
                abilityReqBO.setDockPaySettlePlatFormYn(Integer.valueOf(1));
            }
        }
        Boolean finalIsDock = IsDock;
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
            abilityReqBO.setFscShouldPayBOS(null);
            abilityReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
                if (Objects.isNull(fscOrderPayItemBO.getOrderId())) {
                    throw new FscBusinessException("191000", "\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (fscOrderPayItemBO.getPayAmount() == null) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (fscOrderPayItemBO.getOrderId() == null) {
                    throw new FscBusinessException("191000", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (BigDecimal.ZERO.compareTo(fscOrderPayItemBO.getPayAmount()) >= 0) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8eO!");
                }
                if (finalIsDock.booleanValue()) {
                    if (CollectionUtils.isEmpty((Collection)fscOrderPayItemBO.getPlanItemBOs())) {
                        throw new FscBusinessException("191000", "\u8d44\u91d1\u8ba1\u5212\u4e3a\u7a7a");
                    }
                    for (FscContractPlanItemBO itemBO : fscOrderPayItemBO.getPlanItemBOs()) {
                        if (itemBO.getContractCapitalPlanId() == null) {
                            throw new FscBusinessException("191000", "\u8d44\u91d1\u8ba1\u5212ID\u4e3a\u7a7a");
                        }
                        if (itemBO.getOccAmount() != null) continue;
                        throw new FscBusinessException("191000", "\u8d44\u91d1\u8ba1\u5212\u5360\u7528\u91d1\u989d\u4e3a\u7a7a");
                    }
                }
            });
            if (finalIsDock.booleanValue()) {
                ArrayList contractCapitalPlanIds = new ArrayList();
                for (FscOrderPayItemBO itemBO : abilityReqBO.getFscOrderPayItemBOS()) {
                    List planIds = itemBO.getPlanItemBOs().stream().map(e -> e.getContractCapitalPlanId()).collect(Collectors.toList());
                    contractCapitalPlanIds.addAll(planIds);
                }
                FscContractCapitalPlanPo contractCapitalPlanQryPo = new FscContractCapitalPlanPo();
                contractCapitalPlanQryPo.setIds(contractCapitalPlanIds);
                List contractCapitalPlanPos = this.fscContractCapitalPlanMapper.getList(contractCapitalPlanQryPo);
                if (CollectionUtils.isEmpty((Collection)contractCapitalPlanPos)) {
                    throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u8d44\u91d1\u8ba1\u5212");
                }
                FscGetContractCapitalPlanListAbilityReqBO fscGetContractCapitalPlanListAbilityReqBO = new FscGetContractCapitalPlanListAbilityReqBO();
                fscGetContractCapitalPlanListAbilityReqBO.setContractCapitalPlanIds(contractCapitalPlanIds);
                fscGetContractCapitalPlanListAbilityReqBO.setAgentAccount(abilityReqBO.getAgentAccount());
                FscGetContractCapitalPlanListAbilityRspBO contractCapitalPlanList = this.fscGetContractCapitalPlanListAbilityService.getContractCapitalPlanList(fscGetContractCapitalPlanListAbilityReqBO);
                if (CollectionUtils.isEmpty((Collection)contractCapitalPlanList.getRows())) {
                    throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u8d44\u91d1\u8ba1\u5212");
                }
                Map capitalPlanPoMap = contractCapitalPlanList.getRows().stream().collect(Collectors.toMap(e -> e.getId(), Function.identity()));
                HashMap<Long, BigDecimal> planOccMap = new HashMap<Long, BigDecimal>();
                for (FscOrderPayItemBO itemBO : abilityReqBO.getFscOrderPayItemBOS()) {
                    for (FscContractPlanItemBO planItemBO : itemBO.getPlanItemBOs()) {
                        if (!capitalPlanPoMap.containsKey(planItemBO.getContractCapitalPlanId())) {
                            throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u8d44\u91d1\u8ba1\u5212");
                        }
                        planItemBO.setContractNum(((FscGetContractCapitalPlanListBo)capitalPlanPoMap.get(planItemBO.getContractCapitalPlanId())).getContractNum());
                        if (planOccMap.containsKey(planItemBO.getContractCapitalPlanId())) {
                            BigDecimal occAmt = (BigDecimal)planOccMap.get(planItemBO.getContractCapitalPlanId());
                            occAmt = occAmt.add(planItemBO.getOccAmount());
                            planOccMap.put(planItemBO.getContractCapitalPlanId(), occAmt);
                            continue;
                        }
                        planOccMap.put(planItemBO.getContractCapitalPlanId(), planItemBO.getOccAmount());
                    }
                }
                for (FscGetContractCapitalPlanListBo capitalPlanPo : contractCapitalPlanList.getRows()) {
                    if (!planOccMap.containsKey(capitalPlanPo.getId()) || ((BigDecimal)planOccMap.get(capitalPlanPo.getId())).compareTo(capitalPlanPo.getAmount()) <= 0) continue;
                    throw new FscBusinessException("191000", "\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u8db3");
                }
            }
            return;
        }
        if (abilityReqBO.getPayType() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getShouldPayType() == null) {
            throw new FscBusinessException("191000", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getPayeeId() == null) {
            throw new FscBusinessException("191000", "\u6536\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getPayerId() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void writeFailLog(Long data) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjNo(String.valueOf(data));
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_PAY_BILL_CREATE_PUSH_SETTLE_PLAT_FORM_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

