/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscUnifyAttachmentBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscContractCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayClaimDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPushUnifyRefundPayAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPushUnifyRefundPayAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPushUnifyRefundPayAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPushUnifyRefundPayBusiService;
import com.tydic.fsc.pay.busi.bo.FscPushUnifyRefundPayBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPushUnifyRefundPayBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscPushUnifyRefundPrePayBO;
import com.tydic.fsc.pay.busi.bo.FscPushUnifyRefundSelPayBO;
import com.tydic.fsc.pay.busi.bo.FscUnifyRefundPayBO;
import com.tydic.fsc.pay.busi.bo.FscUnifyRefundPayCapitalBO;
import com.tydic.fsc.pay.busi.bo.FscUnifyRefundPayContractBO;
import com.tydic.fsc.pay.busi.bo.FscUnifySelRefundPayBO;
import com.tydic.fsc.pay.busi.bo.FscUnifySelRefundPaySettleBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscContractCapitalPlanPo;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayClaimPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.common.ability.api.PebExtUnifyFileUploadAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.PebUocUnifyContractQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebUocUnifyContractQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebUocUnifyContractQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdContractBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPushUnifyRefundPayAbilityService"})
public class FscPushUnifyRefundPayAbilityServiceImpl
implements FscPushUnifyRefundPayAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushUnifyRefundPayAbilityServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscContractCapitalPlanMapper fscContractCapitalPlanMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscPushUnifyRefundPayBusiService fscPushUnifyRefundPayBusiService;
    @Autowired
    private PebUocUnifyContractQryAbilityService pebUocUnifyContractQryAbilityService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private PebExtUnifyFileUploadAbilityService pebExtUnifyFileUploadAbilityService;
    @Autowired
    private FscPayClaimDetailMapper fscPayClaimDetailMapper;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushUnifyRefund"})
    public FscPushUnifyRefundPayAbilityRspBO dealPushUnifyRefund(@RequestBody FscPushUnifyRefundPayAbilityReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355\u4fe1\u606f\uff01");
        }
        if (refundPO.getIsPushUnify() != null && refundPO.getIsPushUnify().equals(FscConstants.IsPushUnify.UN_PUSH)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u672a\u5bf9\u63a5\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\uff01");
        }
        if (refundPO.getPushUnifyStatus() != null && refundPO.getPushUnifyStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        FscPushUnifyRefundPayBusiReqBO busiReqBO = new FscPushUnifyRefundPayBusiReqBO();
        busiReqBO = refundPO.getRefundReasonType().equals(FscConstants.RefundType.INSPECTION) || refundPO.getRefundReasonType().equals(FscConstants.RefundType.CANCEL) || refundPO.getRefundReasonType().equals(FscConstants.RefundType.REJECTION) || refundPO.getRefundReasonType().equals(FscConstants.RefundType.RETURN_GOODS) ? this.buildPreRefundInfo(reqBO, refundPO) : this.buildSelRefundInfo(reqBO, refundPO);
        FscPushUnifyRefundPayBusiRspBO busiRspBO = this.fscPushUnifyRefundPayBusiService.dealPushUnifyRefundPay(busiReqBO);
        this.syncEs(reqBO);
        return (FscPushUnifyRefundPayAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscPushUnifyRefundPayAbilityRspBO.class);
    }

    private void syncEs(FscPushUnifyRefundPayAbilityReqBO reqBO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(reqBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private FscPushUnifyRefundPayBusiReqBO buildPreRefundInfo(FscPushUnifyRefundPayAbilityReqBO reqBO, FscOrderRefundPO refundPO) {
        List refundDetailList = this.fscPayRefundDetailMapper.queryByRefundId(refundPO.getRefundId());
        if (CollectionUtils.isEmpty((Collection)refundDetailList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u6b3e\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        FscPayShouldRefundPO shouldRefundPO = this.fscPayShouldRefundMapper.queryById(((FscPayRefundDetailPO)refundDetailList.get(0)).getRefundShouldPayId());
        if (shouldRefundPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u6b3e\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        FscUnifyRefundPayBO head = this.buildRefundPayInfo(refundPO, shouldRefundPO);
        List<FscUnifyRefundPayContractBO> conLine = this.buildContractInfo(shouldRefundPO, (FscPayRefundDetailPO)refundDetailList.get(0), head);
        List<FscUnifyRefundPayCapitalBO> celine = this.buildCapitalInfo(head);
        List<FscUnifyAttachmentBO> fileList = this.buildFileList(head);
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(refundPO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u7528\u6237[" + refundPO.getAgentAccount() + "]token\u4fe1\u606f\u5931\u8d25:" + tokenQryAbilityRspBO.getRespDesc());
        }
        ArrayList<FscPushUnifyRefundPrePayBO> prePayList = new ArrayList<FscPushUnifyRefundPrePayBO>();
        FscPushUnifyRefundPrePayBO prePayBO = new FscPushUnifyRefundPrePayBO();
        prePayBO.setHead(head);
        prePayBO.setConLine(conLine);
        prePayBO.setCeline(celine);
        prePayBO.setFileList(fileList);
        prePayList.add(prePayBO);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(JSONObject.toJSONString(prePayList));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u52a0\u5bc6\u63a5\u53e3\u5931\u8d25:" + encryptionAbilityRspBO.getRespDesc());
        }
        FscPushUnifyRefundPayBusiReqBO busiReqBO = new FscPushUnifyRefundPayBusiReqBO();
        busiReqBO.setRefundId(refundPO.getRefundId());
        busiReqBO.setRefundNo(refundPO.getRefundNo());
        busiReqBO.setPrePayList(prePayList);
        busiReqBO.setData(encryptionAbilityRspBO.getData());
        busiReqBO.setToken(tokenQryAbilityRspBO.getData());
        busiReqBO.setPushType(FscConstants.FscPurchasePushType.REFUND_PRE_PAY);
        return busiReqBO;
    }

    private FscPushUnifyRefundPayBusiReqBO buildSelRefundInfo(FscPushUnifyRefundPayAbilityReqBO reqBO, FscOrderRefundPO refundPO) {
        List refundDetailList = this.fscPayRefundDetailMapper.queryByRefundId(refundPO.getRefundId());
        if (CollectionUtils.isEmpty((Collection)refundDetailList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u6b3e\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        FscPayShouldRefundPO shouldRefundPO = this.fscPayShouldRefundMapper.queryById(((FscPayRefundDetailPO)refundDetailList.get(0)).getRefundShouldPayId());
        if (shouldRefundPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u6b3e\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        FscUnifySelRefundPayBO head = this.buildSelRefundPayInfo(refundPO, shouldRefundPO);
        List<FscUnifySelRefundPaySettleBO> conLine = this.buildSettleInfo(shouldRefundPO, (FscPayRefundDetailPO)refundDetailList.get(0), head);
        List<FscUnifyAttachmentBO> fileList = this.buildSelFileList(head);
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(refundPO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u7528\u6237[" + refundPO.getAgentAccount() + "]token\u4fe1\u606f\u5931\u8d25:" + tokenQryAbilityRspBO.getRespDesc());
        }
        ArrayList<FscPushUnifyRefundSelPayBO> selPayList = new ArrayList<FscPushUnifyRefundSelPayBO>();
        FscPushUnifyRefundSelPayBO prePayBO = new FscPushUnifyRefundSelPayBO();
        prePayBO.setHead(head);
        prePayBO.setConLine(conLine);
        prePayBO.setFileList(fileList);
        selPayList.add(prePayBO);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(JSONObject.toJSONString(selPayList));
        log.error("\u63a8\u9001\u5e94\u4ed8\u52a0\u5bc6\u524d\u6570\u636e\uff1a" + encryptionAbilityReqBO.getData());
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u52a0\u5bc6\u63a5\u53e3\u5931\u8d25:" + encryptionAbilityRspBO.getRespDesc());
        }
        FscPushUnifyRefundPayBusiReqBO busiReqBO = new FscPushUnifyRefundPayBusiReqBO();
        busiReqBO.setRefundId(refundPO.getRefundId());
        busiReqBO.setRefundNo(refundPO.getRefundNo());
        busiReqBO.setSelPayList(selPayList);
        busiReqBO.setData(encryptionAbilityRspBO.getData());
        busiReqBO.setToken(tokenQryAbilityRspBO.getData());
        busiReqBO.setPushType(FscConstants.FscPurchasePushType.REFUND_BEL_PAY);
        return busiReqBO;
    }

    private List<FscUnifyAttachmentBO> buildFileList(FscUnifyRefundPayBO head) {
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(head.getEG_HCPREPAY_ID());
        List list = this.fscAttachmentMapper.getList(fscAttachmentPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<FscUnifyAttachmentBO> fileList = new ArrayList<FscUnifyAttachmentBO>(list.size());
        for (FscAttachmentPO attachmentPO : list) {
            PebExtUnifyFileUploadAbilityReqBO uploadAbilityReqBO = new PebExtUnifyFileUploadAbilityReqBO();
            uploadAbilityReqBO.setFileUrl(attachmentPO.getAttachmentUrl());
            uploadAbilityReqBO.setFileName(attachmentPO.getAttachmentName());
            PebExtUnifyFileUploadAbilityRspBO uploadAbilityRspBO = this.pebExtUnifyFileUploadAbilityService.dealUnifyUpload(uploadAbilityReqBO);
            if (!uploadAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("198888", "\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadAbilityRspBO.getRespDesc());
            }
            FscUnifyAttachmentBO attachmentBO = new FscUnifyAttachmentBO();
            attachmentBO.setDOC_FORMAT(attachmentPO.getAttachmentName().substring(attachmentPO.getAttachmentName().lastIndexOf(".") + 1));
            attachmentBO.setDOC_NAME(uploadAbilityRspBO.getFileName());
            attachmentBO.setDOC_SIZE(uploadAbilityRspBO.getSize());
            attachmentBO.setDOC_TYPE("8036");
            attachmentBO.setEG_BILL_NUM(head.getEG_HCPREPAY_NUM());
            attachmentBO.setFILE_URL(uploadAbilityRspBO.getUrl());
            attachmentBO.setLAST_UPDATE_DATE(DateUtil.dateToStrYYYYMMdd((Date)new Date()));
            attachmentBO.setUPLOAD_TIME(DateUtil.dateToStrYYYYMMdd((Date)new Date()));
            attachmentBO.setUSER_NAME(head.getUSER_NAME());
            attachmentBO.setUUID("zjht");
            fileList.add(attachmentBO);
        }
        return fileList;
    }

    private List<FscUnifyAttachmentBO> buildSelFileList(FscUnifySelRefundPayBO head) {
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(Long.valueOf(head.getEG_PAYMENT_ID()));
        List list = this.fscAttachmentMapper.getList(fscAttachmentPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<FscUnifyAttachmentBO> fileList = new ArrayList<FscUnifyAttachmentBO>(list.size());
        for (FscAttachmentPO attachmentPO : list) {
            PebExtUnifyFileUploadAbilityReqBO uploadAbilityReqBO = new PebExtUnifyFileUploadAbilityReqBO();
            uploadAbilityReqBO.setFileUrl(attachmentPO.getAttachmentUrl());
            uploadAbilityReqBO.setFileName(attachmentPO.getAttachmentName());
            PebExtUnifyFileUploadAbilityRspBO uploadAbilityRspBO = this.pebExtUnifyFileUploadAbilityService.dealUnifyUpload(uploadAbilityReqBO);
            if (!uploadAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("198888", "\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadAbilityRspBO.getRespDesc());
            }
            FscUnifyAttachmentBO attachmentBO = new FscUnifyAttachmentBO();
            attachmentBO.setDOC_FORMAT(attachmentPO.getAttachmentName().substring(attachmentPO.getAttachmentName().lastIndexOf(".") + 1));
            attachmentBO.setDOC_NAME(uploadAbilityRspBO.getFileName());
            attachmentBO.setDOC_SIZE(uploadAbilityRspBO.getSize());
            attachmentBO.setDOC_TYPE("8019");
            attachmentBO.setEG_BILL_NUM(head.getEG_PAYMENT_NUM());
            attachmentBO.setFILE_URL(uploadAbilityRspBO.getUrl());
            attachmentBO.setUSER_NAME(head.getUSER_NAME());
            attachmentBO.setUUID("zjht");
            fileList.add(attachmentBO);
        }
        return fileList;
    }

    private List<FscUnifyRefundPayContractBO> buildContractInfo(FscPayShouldRefundPO shouldRefundPO, FscPayRefundDetailPO fscPayRefundDetailPO, FscUnifyRefundPayBO head) {
        ArrayList<FscUnifyRefundPayContractBO> contractList = new ArrayList<FscUnifyRefundPayContractBO>();
        FscUnifyRefundPayContractBO contractBO = new FscUnifyRefundPayContractBO();
        PebUocUnifyContractQryAbilityReqBO contractQryAbilityReqBO = new PebUocUnifyContractQryAbilityReqBO();
        contractQryAbilityReqBO.setOrderIdList(Collections.singletonList(shouldRefundPO.getOrderId()));
        PebUocUnifyContractQryAbilityRspBO contractQryAbilityRspBO = this.pebUocUnifyContractQryAbilityService.qryOrderContractInfo(contractQryAbilityReqBO);
        if (CollectionUtils.isEmpty((Map)contractQryAbilityRspBO.getContractMap())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u53f0\u8d26\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Map contractMap = contractQryAbilityRspBO.getContractMap();
        UocOrdContractBO uocOrdContractBO = (UocOrdContractBO)contractMap.get(shouldRefundPO.getOrderId());
        contractBO.setCONTRACT_NUM(uocOrdContractBO.getContractNo());
        contractBO.setCONTRACT_NAME(uocOrdContractBO.getContractName());
        contractBO.setEG_PREPAY_ID(head.getEG_PREPAY_ID());
        contractBO.setEG_PREPAY_NUM(head.getEG_PREPAY_NUM());
        contractBO.setTOTAL_PREPAY_AMT(BigDecimal.ZERO);
        if (uocOrdContractBO.getContractAmt() != null) {
            contractBO.setCONTRACT_AMOUNT(uocOrdContractBO.getContractAmt().setScale(2, RoundingMode.HALF_UP));
        } else {
            contractBO.setCONTRACT_AMOUNT(BigDecimal.ZERO);
        }
        contractBO.setRE_AMOUNT(fscPayRefundDetailPO.getRefundAmt());
        contractBO.setAMOUNT(head.getAMOUNT());
        contractBO.setRE_AMOUNT(shouldRefundPO.getRefundAmount());
        contractBO.setORG_ID(head.getORG_ID());
        contractBO.setORG_NAME(head.getORG_NAME());
        contractBO.setUSER_ID(head.getUSER_ID());
        contractList.add(contractBO);
        return contractList;
    }

    private List<FscUnifyRefundPayCapitalBO> buildCapitalInfo(FscUnifyRefundPayBO head) {
        List list = this.fscContractCapitalPlanMapper.getListByFscOrderId(head.getEG_PREPAY_ID());
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9884\u4ed8\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\uff01");
        }
        ArrayList<FscUnifyRefundPayCapitalBO> capitalList = new ArrayList<FscUnifyRefundPayCapitalBO>(list.size());
        for (FscContractCapitalPlanPo fscContractCapitalPlanPo : list) {
            FscUnifyRefundPayCapitalBO capitalBO = new FscUnifyRefundPayCapitalBO();
            capitalBO.setEG_CONTRACT_NUM(fscContractCapitalPlanPo.getContractNum());
            capitalBO.setEG_PREPAY_ID(head.getEG_PREPAY_ID());
            capitalBO.setEG_PREPAY_NUM(head.getEG_PREPAY_NUM());
            capitalBO.setORG_ID(head.getORG_ID());
            capitalBO.setORG_NAME(head.getORG_NAME());
            capitalBO.setUSER_ID(head.getUSER_ID());
            capitalList.add(capitalBO);
        }
        return capitalList;
    }

    private FscUnifyRefundPayBO buildRefundPayInfo(FscOrderRefundPO refundPO, FscPayShouldRefundPO shouldRefundPO) {
        FscUnifyRefundPayBO payBO = new FscUnifyRefundPayBO();
        payBO.setORG_ID(refundPO.getUnifyOrgId());
        payBO.setORG_NAME(refundPO.getUnifyOrgName());
        payBO.setUSER_ID(refundPO.getUnifyUserId());
        payBO.setUSER_NAME(refundPO.getUnifyPersonName());
        payBO.setCOM_CODE(refundPO.getUnifyComCode());
        payBO.setEG_HCPREPAY_ID(refundPO.getRefundId());
        payBO.setEG_HCPREPAY_NUM(refundPO.getRefundNo());
        payBO.setEG_PREPAY_TYPE("HC_YFK");
        payBO.setAMOUNT(refundPO.getRefundAmount());
        payBO.setPAY_DATE(DateUtil.dateToStr((Date)refundPO.getRefundDate()));
        payBO.setBILL_DATE(DateUtil.dateToStr((Date)refundPO.getCreateTime()));
        payBO.setEG_PREPAY_ID(shouldRefundPO.getPayOrderId());
        payBO.setEG_PREPAY_NUM(shouldRefundPO.getPayOrderNo());
        FscPayClaimPO fscPayClaimPO = this.fscOrderRefundMapper.getPayClaimByRefundId(refundPO.getRefundId());
        payBO.setCASH_POOL_ID(fscPayClaimPO.getClaimId());
        payBO.setCASH_POOL_NUM(fscPayClaimPO.getSerialNumber());
        payBO.setCASH_POOL_BANK_ID(fscPayClaimPO.getBankId());
        payBO.setCASH_POOL_BANK_NAME(fscPayClaimPO.getBankName());
        payBO.setCASH_POOL_BANK_NUM(fscPayClaimPO.getBankAccount());
        payBO.setCASH_POOL_AMOUNT(fscPayClaimPO.getPayAmt());
        return payBO;
    }

    private FscUnifySelRefundPayBO buildSelRefundPayInfo(FscOrderRefundPO refundPO, FscPayShouldRefundPO shouldRefundPO) {
        FscUnifySelRefundPayBO payBO = new FscUnifySelRefundPayBO();
        payBO.setORG_ID(String.valueOf(refundPO.getUnifyOrgId()));
        payBO.setORG_NAME(refundPO.getUnifyOrgName());
        payBO.setUSER_ID(String.valueOf(refundPO.getUnifyUserId()));
        payBO.setUSER_NAME(refundPO.getUnifyPersonName());
        payBO.setCOM_CODE(refundPO.getUnifyComCode());
        payBO.setEG_HCBALANCE_ID(String.valueOf(shouldRefundPO.getRefundId()));
        payBO.setEG_HCBALANCE_NUM(String.valueOf(shouldRefundPO.getRefundNo()));
        payBO.setEG_HCPAYMENT_ID(String.valueOf(shouldRefundPO.getPayOrderId()));
        payBO.setEG_HCPAYMENT_NUM(shouldRefundPO.getPayOrderNo());
        payBO.setSTATUS("Y");
        payBO.setSTATUS_DIS("\u5ba1\u6279\u901a\u8fc7");
        payBO.setEG_PAYMENT_NUM(refundPO.getRefundNo());
        payBO.setEG_PAYMENT_ID(String.valueOf(refundPO.getRefundId()));
        payBO.setBILL_DATE(DateUtil.dateToStr((Date)refundPO.getCreateTime()));
        payBO.setDESCRIPTIONS(refundPO.getRefundNote());
        FscPayClaimPO fscPayClaimPO = this.fscOrderRefundMapper.getPayClaimByRefundId(refundPO.getRefundId());
        payBO.setCASH_POOL_ID(fscPayClaimPO.getClaimId());
        payBO.setCASH_POOL_NUM(fscPayClaimPO.getSerialNumber());
        payBO.setCASH_POOL_BANK_ID(String.valueOf(fscPayClaimPO.getBankId()));
        payBO.setCASH_POOL_BANK_NAME(fscPayClaimPO.getBankName());
        payBO.setCASH_POOL_BANK_NUM(fscPayClaimPO.getBankAccount());
        payBO.setCASH_POOL_AMOUNT(String.valueOf(fscPayClaimPO.getPayAmt()));
        return payBO;
    }

    private List<FscUnifySelRefundPaySettleBO> buildSettleInfo(FscPayShouldRefundPO shouldRefundPO, FscPayRefundDetailPO fscPayRefundDetailPO, FscUnifySelRefundPayBO head) {
        ArrayList<FscUnifySelRefundPaySettleBO> settleList = new ArrayList<FscUnifySelRefundPaySettleBO>();
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setRefundId(fscPayRefundDetailPO.getRefundId());
        fscOrderRelationPO.setFscOrderId(shouldRefundPO.getFscOrderId());
        fscOrderRelationPO.setRefundFlag(FscConstants.FscRefundFlag.YES);
        List relationList = this.fscOrderRelationMapper.getRefundList(fscOrderRelationPO);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u6b3e\u5355\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        PebUocUnifyContractQryAbilityReqBO contractQryAbilityReqBO = new PebUocUnifyContractQryAbilityReqBO();
        contractQryAbilityReqBO.setOrderIdList(relationList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList()));
        PebUocUnifyContractQryAbilityRspBO contractQryAbilityRspBO = this.pebUocUnifyContractQryAbilityService.qryOrderContractInfo(contractQryAbilityReqBO);
        if (CollectionUtils.isEmpty((Map)contractQryAbilityRspBO.getContractMap())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u53f0\u8d26\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        for (FscOrderRelationPO relationPO : relationList) {
            FscUnifySelRefundPaySettleBO settleBO = new FscUnifySelRefundPaySettleBO();
            settleBO.setBALANCE_AMT(String.valueOf(relationPO.getSettleAmt()));
            settleBO.setAMOUNT(String.valueOf(relationPO.getRefundAmt()));
            Map contractMap = contractQryAbilityRspBO.getContractMap();
            UocOrdContractBO uocOrdContractBO = (UocOrdContractBO)contractMap.get(relationPO.getOrderId());
            settleBO.setCONTRACT_NUM(uocOrdContractBO.getContractNo());
            settleBO.setCONTRACT_NAME(uocOrdContractBO.getContractName());
            if (uocOrdContractBO.getContractAmt() != null) {
                settleBO.setCONTRACT_AMOUNT(String.valueOf(uocOrdContractBO.getContractAmt().setScale(2, RoundingMode.HALF_UP)));
            } else {
                settleBO.setCONTRACT_AMOUNT("0");
            }
            settleBO.setPOORDER_IDS(String.valueOf(relationPO.getErpOrderId()));
            settleBO.setPOORDER_NUM(relationPO.getOrderNo());
            settleList.add(settleBO);
        }
        return settleList;
    }
}

