/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.pay.ability.api.FscToBeSettlementListQryAbilityService;
import com.tydic.fsc.pay.ability.bo.FscToBeSettlementListQryAbilityBO;
import com.tydic.fsc.pay.ability.bo.FscToBeSettlementListQryAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscToBeSettlementListQryAbilityRspBO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscToBeSettlementListQryAbilityService"})
public class FscToBeSettlementListQryAbilityServiceImpl
implements FscToBeSettlementListQryAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;

    @PostMapping(value={"qryFscToBeSettlementList"})
    public FscToBeSettlementListQryAbilityRspBO qryFscToBeSettlementList(@RequestBody FscToBeSettlementListQryAbilityReqBO reqBO) {
        FscToBeSettlementListQryAbilityRspBO rspBO = new FscToBeSettlementListQryAbilityRspBO();
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderPO.class);
        fscOrderPO.setOrderFlow(FscOrderFlowEnum.ENGINEERING_INVOICE.getCode());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List joinListPage = this.fscOrderMapper.getJoinListPage(fscOrderPO, page);
        if (CollectionUtils.isEmpty((Collection)joinListPage)) {
            return rspBO;
        }
        List reqBOList = JSON.parseArray((String)JSON.toJSONString((Object)joinListPage), FscToBeSettlementListQryAbilityBO.class);
        List fscOrderIdList = joinListPage.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        List fscOrderFinancePOList = this.fscOrderFinanceMapper.getexchangeRateList(fscOrderIdList);
        Map<Long, BigDecimal> decimalMap = fscOrderFinancePOList.stream().collect(Collectors.toMap(FscOrderFinancePO::getFscOrderId, FscOrderFinancePO::getExchangeRate));
        for (FscToBeSettlementListQryAbilityBO fscOrderBO : reqBOList) {
            fscOrderBO.setTotalChargeBen(fscOrderBO.getTotalCharge().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            fscOrderBO.setPaidAmountBen(fscOrderBO.getPaidAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            fscOrderBO.setToPayAmountBen(fscOrderBO.getToPayAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            fscOrderBO.setPayingAmountBen(fscOrderBO.getPayingAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            fscOrderBO.setRemainPayAmount(fscOrderBO.getTotalCharge().subtract(fscOrderBO.getPaidAmount()));
            fscOrderBO.setRemainPayAmountBen(fscOrderBO.getTotalChargeBen().subtract(fscOrderBO.getPaidAmountBen()));
        }
        rspBO.setRows(reqBOList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }
}

