/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscFinanceDraftInfoBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscAccountChargePayInfoDetailQryAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscAccountChargePayInfoDetailQryReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscAccountChargePayInfoDetailQryRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscAccountChargePayInfoDetailQryRspBOFinancePayItemList;
import com.tydic.fsc.po.FscFinancePayItemPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscAccountChargePayInfoDetailQryAbilityService"})
public class FscAccountChargePayInfoDetailQryAbilityServiceImpl
implements FscAccountChargePayInfoDetailQryAbilityService {
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;

    @PostMapping(value={"qryAccountChargePayInfoDetail"})
    public FscAccountChargePayInfoDetailQryRspBO qryAccountChargePayInfoDetail(@RequestBody FscAccountChargePayInfoDetailQryReqBO reqBo) {
        FscAccountChargePayInfoDetailQryRspBO rspBo = new FscAccountChargePayInfoDetailQryRspBO();
        this.valid(reqBo);
        FscFinancePayItemPO fscFinancePayItemPO = new FscFinancePayItemPO();
        fscFinancePayItemPO.setFscOrderId(reqBo.getChargeId());
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List fscFinancePayItemPOList = this.fscFinancePayItemMapper.getListPage(fscFinancePayItemPO, page);
        List financePayItemList = JSON.parseArray((String)JSON.toJSONString((Object)fscFinancePayItemPOList), FscAccountChargePayInfoDetailQryRspBOFinancePayItemList.class);
        List financePayItemIds = fscFinancePayItemPOList.stream().map(FscFinancePayItemPO::getFinancePayItemId).collect(Collectors.toList());
        List draftInfoList = new ArrayList();
        if (!CollectionUtils.isEmpty(financePayItemIds)) {
            draftInfoList = this.fscFinanceDraftInfoMapper.getListWithPayItemIds(financePayItemIds);
        }
        List fscFinanceDraftInfoBOList = JSON.parseArray((String)JSON.toJSONString(draftInfoList), FscFinanceDraftInfoBO.class);
        Map payStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_STATUS_TRANS");
        Map payMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
        Map acceptBillOpenMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_BILL_MODE_OF_OPENING");
        Map acceptBillTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_BILL_TYPE");
        Map financePlatformMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_SUPPLY_CHAIN_FINANCE_PLATFORM");
        for (FscAccountChargePayInfoDetailQryRspBOFinancePayItemList financePay : financePayItemList) {
            if (financePay.getPayStatus() != null) {
                financePay.setPayStatusStr((String)payStatusMap.get(financePay.getPayStatus().toString()));
            }
            if (StringUtils.isNotBlank((CharSequence)financePay.getFinancePayMethod())) {
                financePay.setFinancePayMethodStr((String)payMethodMap.get(financePay.getFinancePayMethod()));
            }
            if (StringUtils.isNotBlank((CharSequence)financePay.getAcceptBillOpenCode())) {
                financePay.setAcceptBillOpenName((String)acceptBillOpenMap.get(financePay.getAcceptBillOpenCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)financePay.getAcceptBillTypeCode())) {
                financePay.setAcceptBillTypeName((String)acceptBillTypeMap.get(financePay.getAcceptBillTypeCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)financePay.getFinancePlatformCode())) {
                financePay.setFinancePlatformName((String)financePlatformMap.get(financePay.getFinancePlatformCode()));
            }
            if (CollectionUtils.isEmpty((Collection)fscFinanceDraftInfoBOList)) continue;
            financePay.setDraftInfoList(fscFinanceDraftInfoBOList.stream().filter(draftInfo -> draftInfo.getFinancePayItemId().equals(financePay.getFinancePayItemId())).collect(Collectors.toList()));
        }
        rspBo.setFinancePayItemList(financePayItemList);
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void valid(FscAccountChargePayInfoDetailQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u4fe1\u606f\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getChargeId() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u4fe1\u606f\u5165\u53c2\u5145\u503c\u4e3b\u952eid[chargeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

