/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemTempMapper;
import com.tydic.fsc.dao.FscFinancePayReduceTempMapper;
import com.tydic.fsc.dao.FscOrderPayItemTempMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscFinancePayItemTempAllQryAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllQryReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllQryRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllQryRspBOAttachmentTempList;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllQryRspBOCapitalPlanTempList;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllQryRspBODraftInfoTempList;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllQryRspBOFinanceBankStatementList;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllQryRspBOFinancePayItemList;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllQryRspBOOrderPayItemList;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllQryRspBOPayReduceTempList;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinancePayItemTempPO;
import com.tydic.fsc.po.FscFinancePayReduceTempPO;
import com.tydic.fsc.po.FscOrderPayItemTempPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscFinancePayItemTempAllQryAbilityService"})
public class FscFinancePayItemTempAllQryAbilityServiceImpl
implements FscFinancePayItemTempAllQryAbilityService {
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscFinancePayReduceTempMapper fscFinancePayReduceTempMapper;
    @Autowired
    private FscFinancePayItemTempMapper fscFinancePayItemTempMapper;
    @Autowired
    private FscOrderPayItemTempMapper fscOrderPayItemTempMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;

    @PostMapping(value={"qryFinancePayTempAllDetail"})
    public FscFinancePayItemTempAllQryRspBO qryFinancePayTempAllDetail(@RequestBody FscFinancePayItemTempAllQryReqBO reqBo) {
        FscFinancePayItemTempAllQryRspBO rspBo = new FscFinancePayItemTempAllQryRspBO();
        this.valid(reqBo);
        Long tempId = reqBo.getTempId();
        Long contractId = reqBo.getContractId();
        FscFinanceBankStatementTempPO fscFinanceBankStatementTempPO = new FscFinanceBankStatementTempPO();
        fscFinanceBankStatementTempPO.setTempId(tempId);
        fscFinanceBankStatementTempPO.setContractId(contractId);
        fscFinanceBankStatementTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List bankStatementTempList = this.fscFinanceBankStatementTempMapper.getList(fscFinanceBankStatementTempPO);
        List financeBankStatementList = JSON.parseArray((String)JSON.toJSONString((Object)bankStatementTempList), FscFinancePayItemTempAllQryRspBOFinanceBankStatementList.class);
        FscOrderPayItemTempPO fscOrderPayItemTempPO = new FscOrderPayItemTempPO();
        fscOrderPayItemTempPO.setTempId(tempId);
        fscOrderPayItemTempPO.setContractId(contractId);
        fscOrderPayItemTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List orderPayItemTempList = this.fscOrderPayItemTempMapper.getList(fscOrderPayItemTempPO);
        List orderPayItemList = JSON.parseArray((String)JSON.toJSONString((Object)orderPayItemTempList), FscFinancePayItemTempAllQryRspBOOrderPayItemList.class);
        FscFinancePayItemTempPO fscFinancePayItemTempPO = new FscFinancePayItemTempPO();
        fscFinancePayItemTempPO.setTempId(tempId);
        fscFinancePayItemTempPO.setContractId(contractId);
        fscFinancePayItemTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List payItemTempList = this.fscFinancePayItemTempMapper.getList(fscFinancePayItemTempPO);
        List financePayItemList = JSON.parseArray((String)JSON.toJSONString((Object)payItemTempList), FscFinancePayItemTempAllQryRspBOFinancePayItemList.class);
        FscFinancePayReduceTempPO fscFinancePayReduceTempPO = new FscFinancePayReduceTempPO();
        fscFinancePayReduceTempPO.setTempId(tempId);
        fscFinancePayReduceTempPO.setContractId(contractId);
        fscFinancePayReduceTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List payReduceTempPOList = this.fscFinancePayReduceTempMapper.getList(fscFinancePayReduceTempPO);
        List payReduceTempList = JSON.parseArray((String)JSON.toJSONString((Object)payReduceTempPOList), FscFinancePayItemTempAllQryRspBOPayReduceTempList.class);
        FscFinanceCapitalPlanTempPO fscFinanceCapitalPlanTempPO = new FscFinanceCapitalPlanTempPO();
        fscFinanceCapitalPlanTempPO.setTempId(tempId);
        fscFinanceCapitalPlanTempPO.setContractId(contractId);
        fscFinanceCapitalPlanTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List capitalPlanTempPOList = this.fscFinanceCapitalPlanTempMapper.getList(fscFinanceCapitalPlanTempPO);
        List capitalPlanTempList = JSON.parseArray((String)JSON.toJSONString((Object)capitalPlanTempPOList), FscFinancePayItemTempAllQryRspBOCapitalPlanTempList.class);
        FscFinanceDraftInfoTempPO fscFinanceDraftInfoTempPO = new FscFinanceDraftInfoTempPO();
        fscFinanceDraftInfoTempPO.setTempId(tempId);
        fscFinanceDraftInfoTempPO.setContractId(contractId);
        fscFinanceDraftInfoTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List draftInfoTempPOList = this.fscFinanceDraftInfoTempMapper.getList(fscFinanceDraftInfoTempPO);
        List draftInfoTempList = JSON.parseArray((String)JSON.toJSONString((Object)draftInfoTempPOList), FscFinancePayItemTempAllQryRspBODraftInfoTempList.class);
        FscAttachmentTempPO fscAttachmentTempPO = new FscAttachmentTempPO();
        fscAttachmentTempPO.setFscOrderId(tempId);
        fscAttachmentTempPO.setObjId(contractId);
        List fscAttachmentTempPOList = this.fscAttachmentTempMapper.getList(fscAttachmentTempPO);
        List attachmentTempList = JSON.parseArray((String)JSON.toJSONString((Object)fscAttachmentTempPOList), FscFinancePayItemTempAllQryRspBOAttachmentTempList.class);
        if (!CollectionUtils.isEmpty((Collection)orderPayItemList)) {
            orderPayItemList.stream().forEach(item -> item.setShouldPayMethodStr(Objects.nonNull(FscPayTypeEnum.getEnum((Integer)item.getShouldPayMethod())) ? FscPayTypeEnum.getEnum((Integer)item.getShouldPayMethod()).getDesc() : null));
        }
        if (!CollectionUtils.isEmpty((Collection)financeBankStatementList)) {
            Map isAgentMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BANK_STATEMENT_IS_AGENT");
            financeBankStatementList.stream().forEach(item -> {
                if (item.getIsAgent() != null) {
                    item.setIsAgentStr((String)isAgentMap.get(String.valueOf(item.getIsAgent())));
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)financePayItemList)) {
            Map payMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
            Map payStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_PAY_ORDER_STATUS");
            financePayItemList.stream().forEach(item -> {
                if (item.getFinancePayMethod() != null) {
                    item.setFinancePayMethodStr((String)payMethodMap.get(item.getFinancePayMethod()));
                }
                if (item.getPayStatus() != null) {
                    item.setPayStatusStr((String)payStatusMap.get(String.valueOf(item.getPayStatus())));
                }
            });
        }
        rspBo.setFinanceBankStatementList(financeBankStatementList);
        rspBo.setOrderPayItemList(orderPayItemList);
        rspBo.setFinancePayItemList(financePayItemList);
        rspBo.setPayReduceTempList(payReduceTempList);
        rspBo.setCapitalPlanTempList(capitalPlanTempList);
        rspBo.setDraftInfoTempList(draftInfoTempList);
        rspBo.setAttachmentTempList(attachmentTempList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void valid(FscFinancePayItemTempAllQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6\u6570\u636e\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getContractId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6\u6570\u636e\u8be6\u60c5\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTempId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6\u6570\u636e\u8be6\u60c5\u4e34\u65f6\u7f16\u53f7[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

