/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscDraftReleaseOccService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.common.ability.api.FscGetContractCapitalPlanListAbilityService;
import com.tydic.fsc.common.ability.api.FscReleaseFundPlanAbilityService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscContractCapitalPlanMapper;
import com.tydic.fsc.dao.FscDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPlanPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayBillUpdateReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayBillUpdateRspBO;
import com.tydic.fsc.pay.atom.api.FscPayBillDetailAssemblyAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayBillUpdateBusiService;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinancePayBillUpdateBusiServiceImpl
implements FscFinancePayBillUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayBillUpdateBusiServiceImpl.class);
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Resource
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscContractCapitalPlanMapper fscContractCapitalPlanMapper;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscGetContractCapitalPlanListAbilityService fscGetContractCapitalPlanListAbilityService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscPlanPayItemMapper fscPlanPayItemMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private FscDraftReleaseOccService draftReleaseOccService;
    @Autowired
    private FscDraftInfoMapper fscDraftInfoMapper;
    public static final String BUSI_NAME = "\u652f\u4ed8\u5355\u5220\u9664";
    public static final String BUSI_CODE = "1199";
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscReleaseFundPlanAbilityService fscReleaseFundPlanAbilityService;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private FscPayBillDetailAssemblyAtomService fscPayBillDetailAssemblyAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;

    @Override
    public FscFinancePayBillUpdateRspBO dealFinancePayBillUpdate(FscFinancePayBillUpdateReqBO reqBO) {
        FscOrderPO set = new FscOrderPO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
            BigDecimal totalAmount = this.updateShouldPay(reqBO);
            set.setTotalCharge(totalAmount);
            set.setToPayAmount(totalAmount);
        }
        set.setPayMethod(reqBO.getPayMethod());
        set.setPayChannel(reqBO.getPayChannel());
        set.setUpdateOperId(reqBO.getUserName());
        set.setUpdateOperName(reqBO.getName());
        set.setUpdateTime(new Date());
        set.setRemark(reqBO.getRemark());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(reqBO.getFscOrderId());
        ArrayList<Integer> orderStates = new ArrayList<Integer>();
        orderStates.add(FscConstants.FscPayOrderState.CANCEL);
        orderStates.add(FscConstants.FscPayOrderState.FINANCE_BACK);
        where.setOrderStates(orderStates);
        int count = this.fscOrderMapper.updateBy(set, where);
        if (count != 1) {
            throw new FscBusinessException("193204", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u662f\u8349\u7a3f\u72b6\u6001");
        }
        this.insertAttachment(reqBO.getAttachmentList(), reqBO.getFscOrderId());
        this.updateFinanceInfo(reqBO);
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            this.invokeStatusFlow(reqBO);
        }
        this.insertCapitalInfo(reqBO);
        try {
            this.taskTodoWaitService.syncNotifyPayBillWaitDone(reqBO.getFscOrderId());
        }
        catch (Exception e) {
            log.error("dealPayBillCreate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
        }
        FscFinancePayBillUpdateRspBO rspBO = new FscFinancePayBillUpdateRspBO();
        rspBO.setFscOrderId(reqBO.getFscOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return rspBO;
    }

    private void insertCapitalInfo(FscFinancePayBillUpdateReqBO reqBO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        this.fscFinanceCapitalPlanMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        this.fscFinanceDraftInfoMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        this.fscFinanceBankStatementMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        this.fscFinancePayReduceMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        this.fscFinancePayItemMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        FscFinanceCapitalInfoAtomReqBO atomReqBO = (FscFinanceCapitalInfoAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscFinanceCapitalInfoAtomReqBO.class);
        atomReqBO.setObjId(reqBO.getFscOrderId());
        atomReqBO.setObjNo(orderPO.getOrderNo());
        atomReqBO.setObjType(Integer.valueOf(1));
        atomReqBO.setFscOrderPayItemBOS(reqBO.getFscOrderPayItemBOS());
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            atomReqBO.setOperationType(Integer.valueOf(1));
        } else {
            atomReqBO.setOperationType(Integer.valueOf(0));
        }
        FscFinanceCapitalInfoAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealFinanceCapitalInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u5b58\u50a8\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
    }

    private void updateFinanceInfo(FscFinancePayBillUpdateReqBO reqBO) {
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)financePO);
        financePO.setUpdateTime(new Date());
        financePO.setUpdateUserId(reqBO.getUserId() + "");
        financePO.setFscOrderId(reqBO.getFscOrderId());
        int count = this.fscOrderFinanceMapper.updateById(financePO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u4ed8\u6b3e\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private BigDecimal updateShouldPay(FscFinancePayBillUpdateReqBO reqBO) {
        BigDecimal totalAmount = new BigDecimal(0);
        FscPayBillDetailAssemblyAtomReqBO assemblyAtomReqBO = (FscPayBillDetailAssemblyAtomReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscPayBillDetailAssemblyAtomReqBO.class));
        assemblyAtomReqBO.setPayOrderId(reqBO.getFscOrderId());
        FscPayBillDetailAssemblyAtomRspBO assemblyAtomRspBO = this.fscPayBillDetailAssemblyAtomService.dealPayBillDetailAssembly(assemblyAtomReqBO);
        if (!"0000".equals(assemblyAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194203", "\u8ba2\u5355\u4ed8\u6b3e\u660e\u7ec6\u63d2\u5165\u5931\u8d25\uff01");
        }
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        FscOrderPayItemPO orderPayItemPO = new FscOrderPayItemPO();
        orderPayItemPO.setFscOrderId(reqBO.getFscOrderId());
        List list = this.fscOrderPayItemMapper.getListWithShouldPay(orderPayItemPO);
        Map<Long, FscOrderPayItemPO> map = list.stream().collect(Collectors.toMap(FscOrderPayItemPO::getShouldPayId, fscOrderPayItemPO -> fscOrderPayItemPO));
        for (FscOrderPayItemBO fscOrderPayItemBO : reqBO.getFscOrderPayItemBOS()) {
            BigDecimal payAmountLocal;
            FscOrderPayDetailPO fscOrderPayDetailPO;
            int count1;
            BigDecimal currentPayAmount = fscOrderPayItemBO.getPayAmount();
            totalAmount = totalAmount.add(fscOrderPayItemBO.getPayAmount());
            FscOrderPayItemPO fscOrderPayItemPO2 = map.get(fscOrderPayItemBO.getShouldPayId());
            BigDecimal payAmt = fscOrderPayItemPO2.getPayAmount();
            if (fscOrderPayItemPO2.getReduceAmt() != null) {
                payAmt = payAmt.add(fscOrderPayItemPO2.getReduceAmt());
            }
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            fscShouldPayPO.setObjectId(fscOrderPayItemPO2.getObjectId());
            fscShouldPayPO.setObjectType(fscOrderPayItemPO2.getObjectType());
            if (Objects.nonNull(payAmt)) {
                fscShouldPayPO.setPayAmount(fscOrderPayItemBO.getPayAmount().subtract(payAmt));
            } else {
                fscShouldPayPO.setPayAmount(fscOrderPayItemBO.getPayAmount());
            }
            if (fscOrderPayItemBO.getReduceAmt() != null) {
                fscShouldPayPO.setPayAmount(fscShouldPayPO.getPayAmount().add(fscOrderPayItemBO.getReduceAmt()));
            }
            if ((count1 = this.fscShouldPayMapper.updateAmount(fscShouldPayPO)) != 1) {
                throw new FscBusinessException("193204", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemBO.getFscBillOrderIdList())) {
                fscOrderPayDetailPO = new FscOrderPayDetailPO();
                fscOrderPayDetailPO.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
                fscOrderPayDetailPO.setFscOrderId(reqBO.getFscOrderId());
                fscOrderPayDetailPO.setSettleType(FscConstants.SettleType.ORDER);
                List fscOrderPayDetailPOList = this.fscOrderPayDetailMapper.queryListWithSettleId(fscOrderPayDetailPO);
                if (!CollectionUtils.isEmpty((Collection)fscOrderPayDetailPOList)) {
                    fscOrderPayDetailPOList.stream().filter(e -> Objects.nonNull(e.getSettleId())).forEach(e -> {
                        FscOrderPO req = new FscOrderPO();
                        req.setFscOrderId(e.getSettleId());
                        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(req);
                        if (Objects.nonNull(fscOrderPO)) {
                            fscOrderPO.setToPayAmount(fscOrderPO.getToPayAmount().add(e.getPayAmount()));
                            fscOrderPO.setPayingAmount(fscOrderPO.getPayingAmount().subtract(e.getPayAmount()));
                            this.fscOrderMapper.updateById(fscOrderPO);
                        }
                    });
                }
            }
            fscOrderPayDetailPO = new FscOrderPayDetailPO();
            fscOrderPayDetailPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderPayDetailPO.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            this.fscOrderPayDetailMapper.deleteByFscOrderId(fscOrderPayDetailPO);
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setItemNo(fscOrderPayItemBO.getItemNo());
            po.setIsReduce(fscOrderPayItemBO.getIsReduce());
            po.setPaymentPhase(fscOrderPayItemBO.getPaymentPhase());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            po.setFscOrderId(reqBO.getFscOrderId());
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            po.setPayAmount(currentPayAmount);
            po.setShouldPayMethod(reqBO.getShouldPayMethod());
            po.setShouldPayItemNo(fscOrderPayItemBO.getShouldPayItemNo());
            po.setPaymentPhase(fscOrderPayItemBO.getPaymentPhase());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            po.setIsReduce(fscOrderPayItemBO.getIsReduce());
            po.setExt3(fscOrderPayItemBO.getExt3());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            if (po.getIsReduce() == null) {
                po.setIsReduce(FscConstants.NO);
            }
            po.setReduceAmt(fscOrderPayItemBO.getReduceAmt());
            if (po.getReduceAmt() == null) {
                po.setReduceAmt(BigDecimal.ZERO);
            }
            if ((payAmountLocal = fscOrderPayItemBO.getPayAmountLocal()) != null) {
                po.setPayAmountLocal(payAmountLocal.setScale(2, RoundingMode.HALF_UP));
            }
            po.setFscBillOrderId(fscOrderPayItemBO.getFscBillOrderId());
            po.setFscBillOrderNo(fscOrderPayItemBO.getFscBillOrderNo());
            fscOrderPayItemPOs.add(po);
        }
        FscOrderPayItemPO fscOrderPayItemPO3 = new FscOrderPayItemPO();
        fscOrderPayItemPO3.setFscOrderId(reqBO.getFscOrderId());
        this.fscOrderPayItemMapper.deleteBy(fscOrderPayItemPO3);
        if (!CollectionUtils.isEmpty(fscOrderPayItemPOs)) {
            this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        }
        return totalAmount;
    }

    public void handlePayDetail(FscShouldPayPO fscShouldPayPO, FscFinancePayBillUpdateReqBO reqBO, FscOrderPayItemBO fscOrderPayItemBO, FscOrderPayItemPO po) {
        int count;
        ArrayList<FscOrderPayDetailPO> fscOrderPayDetailPOList = new ArrayList<FscOrderPayDetailPO>();
        FscShouldPayPO shouldPay = this.fscShouldPayMapper.getModelBy(fscShouldPayPO);
        if (FscConstants.SettleType.ORDER.equals(reqBO.getSettleType()) && FscPayTypeEnum.SHOULD_PAY.getCode().equals(reqBO.getShouldPayMethod())) {
            if (!StringUtils.isEmpty((Object)fscOrderPayItemBO.getFscBillOrderId())) {
                fscOrderPayItemBO.setFscBillOrderIdList(Collections.singletonList(Long.valueOf(fscOrderPayItemBO.getFscBillOrderId())));
            }
            if (CollectionUtils.isEmpty((Collection)fscOrderPayItemBO.getFscBillOrderIdList())) {
                throw new FscBusinessException("193204", shouldPay.getOrderCodeStr() + "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u5355");
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(fscOrderPayItemBO.getFscBillOrderIdList());
            fscOrderPO.setReceiveType("0".equals(reqBO.getIsprofess()) ? FscConstants.FscOrderReceiveType.OPERATION : FscConstants.FscOrderReceiveType.PURCHASE);
            fscOrderPO.setOrderBy("create_time asc");
            List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
            List transitList = fscOrderPOList.stream().filter(item -> !FscBillStatus.SIGNED_SUCCEED.getCode().equals(item.getOrderState())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(transitList)) {
                throw new FscBusinessException("193204", shouldPay.getOrderCodeStr() + "\u8ba2\u5355\u5b58\u5728\u5f00\u7968\u7533\u8bf7\uff0c\u8bf7\u5c06\u5f00\u7968\u7533\u8bf7\u6d41\u7a0b\u5b8c\u6210\u540e\uff0c\u91cd\u65b0\u53d1\u8d77\u4ed8\u6b3e\uff01");
            }
            BigDecimal totalToPayAmount = fscOrderPOList.stream().map(FscOrderPO::getToPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (Objects.isNull(totalToPayAmount)) {
                throw new FscBusinessException("194203", "\u6240\u9009\u7ed3\u7b97\u5355\u5747\u65e0\u5f85\u652f\u4ed8\u989d\u5ea6");
            }
            BigDecimal payAmount = fscOrderPayItemBO.getPayAmount();
            if (totalToPayAmount.compareTo(payAmount) < 0) {
                throw new FscBusinessException("194203", "\u6240\u9009\u7ed3\u7b97\u5355\u5f85\u652f\u4ed8\u989d\u5ea6\u4e4b\u548c\u4e0d\u5f97\u5c0f\u4e8e\u5f53\u524d\u652f\u4ed8\u91d1\u989d");
            }
            ArrayList<String> fscOrderNoList = new ArrayList<String>();
            ArrayList<String> fscOrderIdList = new ArrayList<String>();
            for (FscOrderPO order : fscOrderPOList) {
                fscOrderNoList.add(order.getOrderNo());
                fscOrderIdList.add(String.valueOf(order.getFscOrderId()));
                FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
                fscOrderPayDetailPO.setPayDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderPayDetailPO.setOrderId(fscOrderPayItemBO.getOrderId());
                fscOrderPayDetailPO.setSettleType(reqBO.getSettleType());
                fscOrderPayDetailPO.setFscOrderId(reqBO.getFscOrderId());
                fscOrderPayDetailPO.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
                fscOrderPayDetailPO.setOrderAmount(order.getTotalCharge());
                fscOrderPayDetailPO.setBeforeLeaveAmount(order.getToPayAmount());
                fscOrderPayDetailPO.setRelType("0".equals(reqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
                fscOrderPayDetailPO.setCreateId(Objects.nonNull(reqBO.getUserId()) ? reqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setCreateTime(new Date());
                fscOrderPayDetailPO.setUpdateId(Objects.nonNull(reqBO.getUserId()) ? reqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setUpdateTime(new Date());
                fscOrderPayDetailPO.setSettleId(order.getFscOrderId());
                if (order.getToPayAmount().compareTo(payAmount) >= 0) {
                    fscOrderPayDetailPO.setPayAmount(payAmount);
                    order.setPayingAmount(order.getPayingAmount().add(payAmount));
                    order.setToPayAmount(order.getToPayAmount().subtract(payAmount));
                    this.fscOrderMapper.updateById(order);
                    fscOrderPayDetailPOList.add(fscOrderPayDetailPO);
                    break;
                }
                fscOrderPayDetailPO.setPayAmount(order.getToPayAmount());
                payAmount = payAmount.subtract(order.getToPayAmount());
                order.setPayingAmount(order.getPayingAmount().add(order.getToPayAmount()));
                order.setToPayAmount(BigDecimal.ZERO);
                this.fscOrderMapper.updateById(order);
                fscOrderPayDetailPOList.add(fscOrderPayDetailPO);
            }
            if (!CollectionUtils.isEmpty(fscOrderNoList)) {
                po.setFscBillOrderNo(String.join((CharSequence)",", fscOrderNoList));
                po.setFscBillOrderId(String.join((CharSequence)",", fscOrderIdList));
            }
        } else {
            FscOrderRelationPO fscOrderRelationPO;
            if (Objects.isNull(shouldPay.getOrderId())) {
                log.error("\u5f53\u524d\u5e94\u4ed8\u5355\u65e0\u8ba2\u5355\u53f7\u4fe1\u606f");
            }
            if (FscConstants.SettleType.ORDER.equals(reqBO.getSettleType()) && FscPayTypeEnum.ADVANCE_PAY.getCode().equals(reqBO.getShouldPayMethod()) && Objects.nonNull(fscOrderRelationPO = this.fscOrderRelationMapper.getByOrderId(shouldPay.getOrderId())) && shouldPay.getToPayAmount().subtract(fscOrderRelationPO.getSettleAmt()).compareTo(fscOrderPayItemBO.getPayAmount()) < 0) {
                throw new FscBusinessException("194203", shouldPay.getOrderNo() + "\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\uff0c\u5f53\u524d\u9009\u62e9\u9884\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\uff08\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d-\u5df2\u5f00\u7968\u91d1\u989d\uff09");
            }
            UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
            saleDetailsReqBO.setPageSize(1000);
            saleDetailsReqBO.setOrderId(shouldPay.getOrderId());
            saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
            saleDetailsReqBO.setIndividually("1");
            log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsReqBO));
            UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
            if (!saleDetailsRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
                throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
            }
            FscOrderPayDetailPO fscOrderPayDetailPOReq = new FscOrderPayDetailPO();
            fscOrderPayDetailPOReq.setOrderId(shouldPay.getOrderId());
            fscOrderPayDetailPOReq.setRelType("0".equals(reqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
            List payDetailPOList = this.fscOrderPayDetailMapper.queryList(fscOrderPayDetailPOReq);
            Map<Object, Object> payDetailMap = !CollectionUtils.isEmpty((Collection)payDetailPOList) ? payDetailPOList.stream().collect(Collectors.groupingBy(FscOrderPayDetailPO::getOrderItemId, Collectors.mapping(FscOrderPayDetailPO::getPayAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))) : new HashMap();
            shouldPay.setPayAmount(fscOrderPayItemBO.getPayAmount());
            saleDetailsRspBO.getRows().forEach(e -> ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList().forEach(item -> {
                if (shouldPay.getPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
                    return;
                }
                BigDecimal orderAmount = Objects.nonNull(reqBO.getIsprofess()) && "0".equals(reqBO.getIsprofess()) ? new BigDecimal(item.getPurchaseFeeMoney()) : new BigDecimal(item.getSaleFeeMoney());
                BigDecimal initOrderAmt = orderAmount;
                BigDecimal payOrderAmount = BigDecimal.ZERO;
                if (Objects.nonNull(payDetailMap.get(Long.valueOf(item.getOrderItemId())))) {
                    payOrderAmount = (BigDecimal)payDetailMap.get(Long.valueOf(item.getOrderItemId()));
                }
                if (BigDecimal.ZERO.compareTo(orderAmount = orderAmount.subtract(payOrderAmount)) == 0) {
                    return;
                }
                FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
                fscOrderPayDetailPO.setPayDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderPayDetailPO.setSettleType(reqBO.getSettleType());
                fscOrderPayDetailPO.setOrderId(Objects.isNull(e.getOrderId()) ? null : Long.valueOf(e.getOrderId()));
                fscOrderPayDetailPO.setOrderItemId(Objects.isNull(item.getOrderItemId()) ? null : Long.valueOf(item.getOrderItemId()));
                fscOrderPayDetailPO.setSaleVoucherId(Objects.isNull(e.getSaleVoucherId()) ? null : Long.valueOf(e.getSaleVoucherId()));
                fscOrderPayDetailPO.setFscOrderId(reqBO.getFscOrderId());
                fscOrderPayDetailPO.setShouldPayId(fscShouldPayPO.getShouldPayId());
                fscOrderPayDetailPO.setOrderAmount(initOrderAmt);
                fscOrderPayDetailPO.setBeforeLeaveAmount(orderAmount);
                fscOrderPayDetailPO.setRelType("0".equals(reqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
                fscOrderPayDetailPO.setCreateId(Objects.nonNull(reqBO.getUserId()) ? reqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setCreateTime(new Date());
                fscOrderPayDetailPO.setUpdateId(Objects.nonNull(reqBO.getUserId()) ? reqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setUpdateTime(new Date());
                if (fscShouldPayPO.getObjectType().equals(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER)) {
                    fscOrderPayDetailPO.setSettleId(fscShouldPayPO.getObjectId());
                }
                if (fscOrderPayItemBO.getPayAmount().compareTo(orderAmount) > 0) {
                    fscOrderPayDetailPO.setPayAmount(orderAmount);
                    fscOrderPayItemBO.setPayAmount(fscOrderPayItemBO.getPayAmount().subtract(orderAmount));
                } else {
                    fscOrderPayDetailPO.setPayAmount(fscOrderPayItemBO.getPayAmount());
                    fscOrderPayItemBO.setPayAmount(BigDecimal.ZERO);
                }
                fscOrderPayDetailPOList.add(fscOrderPayDetailPO);
            }));
        }
        if (!CollectionUtils.isEmpty(fscOrderPayDetailPOList) && (count = this.fscOrderPayDetailMapper.insertBatch(fscOrderPayDetailPOList)) == 0) {
            throw new FscBusinessException("194203", "\u63d2\u5165\u8ba2\u5355\u652f\u4ed8\u660e\u7ec6\u5f02\u5e38");
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        FscAttachmentPO deletPo = new FscAttachmentPO();
        deletPo.setFscOrderId(fscOrderId);
        deletPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
        ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletPo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            this.fscAttachmentMapper.deleteBy(deletPo);
        }
        if (!CollectionUtils.isEmpty(attachmentBOList)) {
            fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : attachmentBOList) {
                FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                fscAttachmentPo.setAttachmentName(attachmentBO.getAttachmentName());
                fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAYMENT);
                fscAttachmentPo.setObjId(attachmentBO.getObjId());
                fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
                fscAttachmentPo.setFscOrderId(fscOrderId);
                fscAttachmentPOS.add(fscAttachmentPo);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
    }

    private void invokeStatusFlow(FscFinancePayBillUpdateReqBO reqBO) {
        HashMap<String, Integer> paramMap;
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(reqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("fscPayApplyOrder");
        uacNoTaskAuditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getFscOrderId());
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(reqBO.getFscOrderId().toString());
        approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        BigDecimal payAmount = BigDecimal.ZERO;
        for (FscOrderPayItemBO payItem : reqBO.getFscOrderPayItemBOS()) {
            payAmount = payAmount.add(payItem.getPayAmount());
        }
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("payAmount", payAmount);
        Long shouldPayId = ((FscOrderPayItemBO)reqBO.getFscOrderPayItemBOS().get(0)).getShouldPayId();
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setShouldPayId(shouldPayId);
        FscShouldPayPO model = this.fscShouldPayMapper.getModelBy(fscShouldPayPo);
        if (model.getShouldPayType().equals(FscConstants.ShouldPayType.ADVANCE_PAY) || model.getShouldPayType().equals(FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY) || model.getShouldPayType().equals(FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY) || model.getShouldPayType().equals(FscConstants.ShouldPayType.PAYMENT_PRE_PAY)) {
            variables.put("payType", 1);
        } else {
            variables.put("payType", 2);
        }
        uacNoTaskAuditCreateReqBO.setVariables(variables);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("193204", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderStatusFlowAtomReqBO.class);
        if (!uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            paramMap = new HashMap<String, Integer>();
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        }
        if (!uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            paramMap = new HashMap();
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        }
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.CANCEL);
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getFscOrderId());
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193204", atomRspBO.getRespDesc());
        }
    }
}

