/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscToBeSettlementListQryAbilityService;
import com.tydic.fsc.pay.ability.bo.FscToBeSettlementListQryAbilityBO;
import com.tydic.fsc.pay.ability.bo.FscToBeSettlementListQryAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscToBeSettlementListQryAbilityRspBO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscToBeSettlementListQryAbilityService"})
public class FscToBeSettlementListQryAbilityServiceImpl
implements FscToBeSettlementListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscToBeSettlementListQryAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;

    @PostMapping(value={"qryFscToBeSettlementList"})
    public FscToBeSettlementListQryAbilityRspBO qryFscToBeSettlementList(@RequestBody FscToBeSettlementListQryAbilityReqBO reqBO) {
        FscToBeSettlementListQryAbilityRspBO rspBO = new FscToBeSettlementListQryAbilityRspBO();
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderPO.class);
        fscOrderPO.setOrderFlow(FscOrderFlowEnum.ENGINEERING_INVOICE.getCode());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List joinListPage = this.fscOrderMapper.getJoinListPage(fscOrderPO, page);
        log.info("\u67e5\u8be2\u7ed3\u7b97\u5355\u5217\u8868\uff1a{}", (Object)joinListPage);
        if (CollectionUtils.isEmpty((Collection)joinListPage)) {
            return rspBO;
        }
        List reqBOList = JSON.parseArray((String)JSON.toJSONString((Object)joinListPage), FscToBeSettlementListQryAbilityBO.class);
        log.info("\u8f6c\u6362\u4e3aFscToBeSettlementListQryAbilityBO\u540e\u67e5\u8be2\u7ed3\u7b97\u5355\u5217\u8868\uff1a{}", (Object)reqBOList);
        ArrayList<FscToBeSettlementListQryAbilityBO> reqBOList1 = new ArrayList<FscToBeSettlementListQryAbilityBO>();
        List fscOrderIdList = joinListPage.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        List fscOrderFinancePOList = this.fscOrderFinanceMapper.getexchangeRateList(fscOrderIdList);
        if (CollectionUtils.isEmpty((Collection)fscOrderFinancePOList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u6c47\u7387");
        }
        Map<Long, BigDecimal> decimalMap = fscOrderFinancePOList.stream().collect(Collectors.toMap(FscOrderFinancePO::getFscOrderId, FscOrderFinancePO::getExchangeRate));
        log.info("\u6c47\u7387Map\uff1a{}", decimalMap);
        for (FscToBeSettlementListQryAbilityBO fscOrderBO : reqBOList) {
            log.info("fscOrderBO\u5bf9\u8c61\uff1a{}", (Object)fscOrderBO);
            if (decimalMap.get(fscOrderBO.getFscOrderId()) == null) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230" + fscOrderBO.getFscOrderId() + "\u7ed3\u7b97\u5355\u7684\u6c47\u7387");
                return rspBO;
            }
            FscToBeSettlementListQryAbilityBO qryAbilityBO = new FscToBeSettlementListQryAbilityBO();
            BeanUtils.copyProperties((Object)fscOrderBO, (Object)qryAbilityBO);
            qryAbilityBO.setTotalChargeBen(fscOrderBO.getTotalCharge().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            log.info("TotalChargeBen:{}", (Object)fscOrderBO.getTotalCharge().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4).toString());
            if (fscOrderBO.getTotalCharge() == null) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u6570\u636e\u5e93\u6570\u636e\u6709\u8bef\uff01\u603b\u91d1\u989d\u4e3a\u7a7a");
            }
            if (qryAbilityBO.getTotalChargeBen() == null || qryAbilityBO.getTotalChargeBen().compareTo(BigDecimal.ZERO) < 0) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u6570\u636e\u6709\u8bef\uff01\u603b\u91d1\u989d(\u672c\u4f4d\u5e01)\u8ba1\u7b97\u9519\u8bef");
                return rspBO;
            }
            qryAbilityBO.setPaidAmountBen(fscOrderBO.getPaidAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            log.info("PaidAmountBen:{}", (Object)fscOrderBO.getPaidAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4).toString());
            if (fscOrderBO.getPaidAmount() == null) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u6570\u636e\u5e93\u6570\u636e\u6709\u8bef\uff01\u5df2\u4ed8\u91d1\u989d\u4e3a\u7a7a");
            }
            if (qryAbilityBO.getPaidAmountBen() == null || qryAbilityBO.getPaidAmountBen().compareTo(BigDecimal.ZERO) < 0) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u6570\u636e\u6709\u8bef\uff01\u5df2\u4ed8\u91d1\u989d(\u672c\u4f4d\u5e01)\u8ba1\u7b97\u9519\u8bef");
                return rspBO;
            }
            qryAbilityBO.setToPayAmountBen(fscOrderBO.getToPayAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            log.info("ToPayAmountBen:{}", (Object)fscOrderBO.getToPayAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4).toString());
            if (fscOrderBO.getToPayAmount() == null) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u6570\u636e\u5e93\u6570\u636e\u6709\u8bef\uff01\u5f85\u4ed8\u91d1\u989d\u4e3a\u7a7a");
            }
            if (qryAbilityBO.getToPayAmountBen() == null || qryAbilityBO.getToPayAmountBen().compareTo(BigDecimal.ZERO) < 0) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u6570\u636e\u6709\u8bef\uff01\u5f85\u4ed8\u91d1\u989d(\u672c\u4f4d\u5e01)\u8ba1\u7b97\u9519\u8bef");
                return rspBO;
            }
            qryAbilityBO.setPayingAmountBen(fscOrderBO.getPayingAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            log.info("PayingAmountBen:{}", (Object)fscOrderBO.getPayingAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4).toString());
            if (fscOrderBO.getPayingAmount() == null) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u6570\u636e\u5e93\u6570\u636e\u6709\u8bef\uff01\u4ed8\u6b3e\u4e2d\u91d1\u989d\u4e3a\u7a7a");
            }
            if (qryAbilityBO.getPayingAmountBen() == null || qryAbilityBO.getPayingAmountBen().compareTo(BigDecimal.ZERO) < 0) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u6570\u636e\u6709\u8bef\uff01\u4ed8\u6b3e\u4e2d\u91d1\u989d(\u672c\u4f4d\u5e01)\u8ba1\u7b97\u9519\u8bef");
                return rspBO;
            }
            qryAbilityBO.setRemainPayAmount(qryAbilityBO.getTotalCharge().subtract(qryAbilityBO.getPaidAmount()));
            qryAbilityBO.setRemainPayAmountBen(qryAbilityBO.getTotalChargeBen().subtract(qryAbilityBO.getPaidAmountBen()));
            reqBOList1.add(qryAbilityBO);
        }
        log.info("\u6700\u540e\u7ed3\u679c\uff1a{}", reqBOList1);
        rspBO.setRows(reqBOList1);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }
}

