/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.tydic.fsc.busibase.atom.api.FscFinancePayTempQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscFinanceEngineeringPayBillCreateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscFinanceEngineeringPayBillCreateReqBO;
import com.tydic.fsc.pay.ability.bo.FscFinanceEngineeringPayBillCreateRspBO;
import com.tydic.fsc.pay.atom.api.FscFinancePayCheckUtil;
import com.tydic.fsc.pay.busi.api.finance.FscFinanceEngineeringPayBillCreateBusiService;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscFinanceEngineeringPayBillCreateAbilityService"})
public class FscFinanceEngineeringPayBillCreateAbilityServiceImpl
implements FscFinanceEngineeringPayBillCreateAbilityService {
    @Autowired
    private FscFinanceEngineeringPayBillCreateBusiService fscFinanceEngineeringPayBillCreateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscFinancePayTempQryAtomService fscFinancePayTempQryAtomService;
    @Value(value="${fsc.finance.pay.business.code:1003000300080001}")
    private String businessCode;
    @Value(value="${fsc.finance.pay.business.name:\u5176\u4ed6\u91c7\u8d2d\u4ed8\u6b3e}")
    private String businessName;
    @Value(value="${fsc.finance.pay.biz.type.code:100300030008}")
    private String bizTypeCode;
    @Value(value="${fsc.finance.pay.biz.type.name:\u5176\u4ed6\u91c7\u8d2d\u4ed8\u6b3e}")
    private String bizTypeName;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealFinanceEngineeringPayBillCreate"})
    public FscFinanceEngineeringPayBillCreateRspBO dealFinanceEngineeringPayBillCreate(@RequestBody FscFinanceEngineeringPayBillCreateReqBO reqBO) {
        FscFinanceEngineeringPayBillCreateRspBO createRspBO;
        if (reqBO.getTempId() == null) {
            this.validParam(reqBO);
            if (!"1".equals(reqBO.getSaveOrSubmit())) {
                FscFinancePayCheckUtil.checkLocalAmountApply(reqBO.getFscOrderPayItemBOS(), reqBO.getExchangeRate(), reqBO.getCurrency());
            }
        } else {
            this.qryTempInfo(reqBO);
        }
        if ((createRspBO = this.fscFinanceEngineeringPayBillCreateBusiService.dealFinanceEngineeringPayBillCreate(reqBO)).getFscOrderId() != null) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(createRspBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        return createRspBO;
    }

    private void qryTempInfo(FscFinanceEngineeringPayBillCreateReqBO abilityReqBO) {
        FscFinancePayTempQryAtomReqBO atomReqBO = new FscFinancePayTempQryAtomReqBO();
        atomReqBO.setTempId(abilityReqBO.getTempId());
        atomReqBO.setPaymentType(abilityReqBO.getPaymentType());
        FscFinancePayTempQryAtomRspBO atomRspBO = this.fscFinancePayTempQryAtomService.qryPayTemp(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u67e5\u8be2\u4ed8\u6b3e\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
        atomRspBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
            fscOrderPayItemBO.setObjectId(fscOrderPayItemBO.getOrderId());
            fscOrderPayItemBO.setPanelPointCode(fscOrderPayItemBO.getExt4());
            fscOrderPayItemBO.setPanelPointName(fscOrderPayItemBO.getExt5());
        });
        abilityReqBO.setFscOrderPayItemBOS(atomRspBO.getFscOrderPayItemBOS());
        abilityReqBO.setAttachmentList(atomRspBO.getAttachmentList());
    }

    private void validParam(FscFinanceEngineeringPayBillCreateReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getFinanceDeptId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[financeDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getFinanceDeptName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[financeDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (FscConstants.PaymentMethod.SHOULD_PAY.equals(reqBO.getShouldPayMethod())) {
            reqBO.setBusinessItemCode(this.businessCode);
            reqBO.setBusinessItemName(this.businessName);
            reqBO.setBizTypeCode(this.bizTypeCode);
            reqBO.setBizTypeName(this.bizTypeName);
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBusinessItemCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[businessItemCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBusinessItemName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[businessItemName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getExchangeRate() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2[exchangeRate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCurrency())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[currency]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPayDate() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2[payDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getNote())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[note]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderPayItemBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

