/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscMemFeePayBillAtomService;
import com.tydic.fsc.pay.atom.bo.FscMemFeePayBillAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscMemFeePayBillAtomRspBO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayOrderPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscMemFeePayBillAtomServiceImpl
implements FscMemFeePayBillAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscMemFeePayBillAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private PayProOrderAbilityService payProOrderAbilityService;
    @Value(value="${fscPayNotifyUrl}")
    private String notifyUrl;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${pay.center.req.way:1}")
    private String reqWay;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @Override
    public FscMemFeePayBillAtomRspBO dealMemFeePayBill(FscMemFeePayBillAtomReqBO reqBO) {
        FscMemFeePayBillAtomRspBO fscMemFeePayBillAtomRspBO = new FscMemFeePayBillAtomRspBO();
        if (Objects.isNull(reqBO.getOrderState()) || !FscConstants.FscPayOrderState.TO_PAY.equals(reqBO.getOrderState())) {
            throw new FscBusinessException("194202", reqBO.getFscOrderId() + "\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001\uff01");
        }
        Long payOrderId = this.createPayOrder(reqBO);
        PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo = null;
        try {
            payProOrderAbilityServiceRspBo = this.invokePayProOrder(reqBO, payOrderId);
            if (!StringUtils.isEmpty((Object)payProOrderAbilityServiceRspBo.getBusiRspData())) {
                fscMemFeePayBillAtomRspBO = (FscMemFeePayBillAtomRspBO)((Object)JSONObject.parseObject((String)payProOrderAbilityServiceRspBo.getBusiRspData(), FscMemFeePayBillAtomRspBO.class));
            }
        }
        catch (FscBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("194202", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        String url = payProOrderAbilityServiceRspBo.getUrl();
        FscOrderPO set = new FscOrderPO();
        set.setPayOperName(reqBO.getName());
        set.setPayOperId(reqBO.getUserName());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(reqBO.getFscOrderId());
        this.fscOrderMapper.updateBy(set, where);
        fscMemFeePayBillAtomRspBO.setRespCode("0000");
        fscMemFeePayBillAtomRspBO.setRespDesc("\u652f\u4ed8\u8c03\u7528\u6210\u529f");
        fscMemFeePayBillAtomRspBO.setUrl(url);
        return fscMemFeePayBillAtomRspBO;
    }

    private Long createPayOrder(FscMemFeePayBillAtomReqBO reqBO) {
        Long payOrderId = Sequence.getInstance().nextId();
        FscPayOrderPO po = new FscPayOrderPO();
        po.setPayOrderId(payOrderId);
        po.setPayAmount(reqBO.getTotalAmount());
        po.setCreateTime(new Date());
        po.setPayStatus(FscConstants.PayOrderPayStatus.TO_PAY);
        this.fscPayOrderMapper.insert(po);
        FscPayRelationPO relationPO = new FscPayRelationPO();
        relationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        relationPO.setFscOrderId(reqBO.getFscOrderId());
        relationPO.setPayOrderId(payOrderId);
        this.fscPayRelationMapper.insert(relationPO);
        return payOrderId;
    }

    private PayProOrderAbilityServiceRspBo invokePayProOrder(FscMemFeePayBillAtomReqBO reqBO, Long payOrderId) {
        FscMerchantPO reqPO = new FscMerchantPO();
        reqPO.setOrgId(Objects.isNull(reqBO.getPayeeId()) ? this.operationOrgId : reqBO.getPayeeId());
        reqPO.setExceptionFlag(Integer.valueOf(0));
        reqPO.setDelFlag(Integer.valueOf(0));
        FscMerchantPO rspPO = this.fscMerchantMapper.getModelBy(reqPO);
        if (null == rspPO) {
            throw new FscBusinessException("194202", "\u6536\u6b3e\u65b9\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo = new PayProOrderAbilityServiceReqBo();
        payProOrderAbilityServiceReqBo.setBusiCode(this.payBusiCode);
        payProOrderAbilityServiceReqBo.setReqWay(this.reqWay);
        payProOrderAbilityServiceReqBo.setOutOrderId(payOrderId.toString());
        payProOrderAbilityServiceReqBo.setMerchantId(rspPO.getPayMerchantId());
        payProOrderAbilityServiceReqBo.setTotalFee(MoneyUtils.yuanToFenToLong((BigDecimal)reqBO.getTotalAmount()) + "");
        payProOrderAbilityServiceReqBo.setDetailName(reqBO.getDetailName());
        payProOrderAbilityServiceReqBo.setRedirectUrl(reqBO.getRedirectUrl());
        payProOrderAbilityServiceReqBo.setNotifyUrl(this.notifyUrl);
        payProOrderAbilityServiceReqBo.setCreateIpAddress(reqBO.getIp());
        payProOrderAbilityServiceReqBo.setCreateOperId(reqBO.getUserId().toString());
        payProOrderAbilityServiceReqBo.setCreateOperIdName(reqBO.getName());
        payProOrderAbilityServiceReqBo.setCreateIpAddress("127.0.0.1");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("payMethods", (Object)"171,170");
        payProOrderAbilityServiceReqBo.setBusiReqData(jsonObject.toJSONString());
        log.debug("\u4f1a\u5458\u8d39\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u4ed8\u6b3e\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo));
        PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo = this.payProOrderAbilityService.dealOrder(payProOrderAbilityServiceReqBo);
        if (!"0000".equals(payProOrderAbilityServiceRspBo.getRspCode())) {
            throw new FscBusinessException("194202", payProOrderAbilityServiceRspBo.getRespDesc());
        }
        log.debug("\u4f1a\u5458\u8d39\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u4ed8\u6b3e\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo));
        return payProOrderAbilityServiceRspBo;
    }
}

